/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm;

import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Attribute;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.ClassVisitor;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.ClassWriter;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Item;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Label;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.MethodVisitor;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.MethodWriter;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Type;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    public final int header;

    public ClassReader(byte[] b2) {
        this(b2, 0, b2.length);
    }

    public ClassReader(byte[] b2, int off, int len) {
        this.b = b2;
        this.items = new int[this.readUnsignedShort(off + 8)];
        int ll2 = this.items.length;
        this.strings = new String[ll2];
        int max = 0;
        int index = off + 10;
        for (int i2 = 1; i2 < ll2; ++i2) {
            int size;
            this.items[i2] = index + 1;
            byte tag = b2[index];
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i2;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll2 = this.items.length;
        Item[] items2 = new Item[ll2];
        for (int i2 = 1; i2 < ll2; ++i2) {
            int index = this.items[i2];
            byte tag = this.b[index - 1];
            Item item = new Item(i2);
            switch (tag) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index + 2)];
                    item.set(tag, this.readClass(index, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index)));
                    break;
                }
                case 12: {
                    item.set(tag, this.readUTF8(index, buf), this.readUTF8(index + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index));
                    ++i2;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index)));
                    ++i2;
                    break;
                }
                case 1: {
                    String s2 = this.strings[i2];
                    if (s2 == null) {
                        index = this.items[i2];
                        s2 = this.strings[i2] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
                    }
                    item.set(tag, s2, null, null);
                    break;
                }
                default: {
                    item.set(tag, this.readUTF8(index, buf), null, null);
                }
            }
            int index2 = item.hashCode % items2.length;
            item.next = items2[index2];
            items2[index2] = item;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll2);
        classWriter.index = ll2;
    }

    public ClassReader(InputStream is2) throws IOException {
        this(ClassReader.readClass(is2));
    }

    public ClassReader(String name) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is2) throws IOException {
        if (is2 == null) {
            throw new IOException("Class not found");
        }
        byte[] b2 = new byte[is2.available()];
        int len = 0;
        while (true) {
            byte[] c2;
            int n2;
            if ((n2 = is2.read(b2, len, b2.length - len)) == -1) {
                if (len < b2.length) {
                    c2 = new byte[len];
                    System.arraycopy(b2, 0, c2, 0, len);
                    b2 = c2;
                }
                return b2;
            }
            if ((len += n2) != b2.length) continue;
            c2 = new byte[b2.length + 1000];
            System.arraycopy(b2, 0, c2, 0, len);
            b2 = c2;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean skipDebug) {
        this.accept(classVisitor, new Attribute[0], skipDebug);
    }

    /*
     * Unable to fully structure code
     */
    public void accept(ClassVisitor classVisitor, Attribute[] attrs, boolean skipDebug) {
        b = this.b;
        c = new char[this.maxStringLength];
        anns = 0;
        ianns = 0;
        cattrs = null;
        u = this.header;
        access = this.readUnsignedShort(u);
        name = this.readClass(u + 2, c);
        v = this.items[this.readUnsignedShort(u + 4)];
        superClassName = v == 0 ? null : this.readUTF8(v, c);
        implementedItfs = new String[this.readUnsignedShort(u + 6)];
        w = 0;
        u += 8;
        for (i = 0; i < implementedItfs.length; ++i) {
            implementedItfs[i] = this.readClass(u, c);
            u += 2;
        }
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        signature = null;
        sourceFile = null;
        sourceDebug = null;
        enclosingOwner = null;
        enclosingName = null;
        enclosingDesc = null;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            attrName = this.readUTF8(v, c);
            if (attrName.equals("SourceFile")) {
                sourceFile = this.readUTF8(v + 6, c);
            } else if (attrName.equals("Deprecated")) {
                access |= 131072;
            } else if (attrName.equals("Synthetic")) {
                access |= 4096;
            } else if (attrName.equals("Annotation")) {
                access |= 8192;
            } else if (attrName.equals("Enum")) {
                access |= 16384;
            } else if (attrName.equals("InnerClasses")) {
                w = v + 6;
            } else if (attrName.equals("Signature")) {
                signature = this.readUTF8(v + 6, c);
            } else if (attrName.equals("SourceDebugExtension")) {
                len = this.readInt(v + 2);
                sourceDebug = this.readUTF(v + 6, len, new char[len]);
            } else if (attrName.equals("EnclosingMethod")) {
                enclosingOwner = this.readClass(v + 6, c);
                item = this.readUnsignedShort(v + 8);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c);
                    enclosingDesc = this.readUTF8(this.items[item] + 2, c);
                }
            } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                anns = v + 6;
            } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                ianns = v + 6;
            } else {
                attr = this.readAttribute(attrs, attrName, v + 6, this.readInt(v + 2), c, -1, null);
                if (attr != null) {
                    attr.next = cattrs;
                    cattrs = attr;
                }
            }
            v += 6 + this.readInt(v + 2);
            --i;
        }
        classVisitor.visit(this.readInt(4), access, name, signature, superClassName, implementedItfs);
        if (sourceFile != null || sourceDebug != null) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (enclosingOwner != null) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        for (i = 1; i >= 0; --i) {
            v0 = v = i == 0 ? ianns : anns;
            if (v == 0) continue;
            j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                desc = this.readUTF8(v, c);
                v += 2;
                v = this.readAnnotationValues(v, c, classVisitor.visitAnnotation(desc, i != 0));
                --j;
            }
        }
        while (cattrs != null) {
            attr = cattrs.next;
            cattrs.next = null;
            classVisitor.visitAttribute(cattrs);
            cattrs = attr;
        }
        if (w != 0) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                --i;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            fieldValueItem = 0;
            signature = null;
            anns = 0;
            ianns = 0;
            cattrs = null;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                if (attrName.equals("ConstantValue")) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                } else if (attrName.equals("Synthetic")) {
                    access |= 4096;
                } else if (attrName.equals("Deprecated")) {
                    access |= 131072;
                } else if (attrName.equals("Enum")) {
                    access |= 16384;
                } else if (attrName.equals("Signature")) {
                    signature = this.readUTF8(u + 6, c);
                } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                    anns = u + 6;
                } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                    ianns = u + 6;
                } else {
                    attr = this.readAttribute(attrs, attrName, u + 6, this.readInt(u + 2), c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += 6 + this.readInt(u + 2);
                --j;
            }
            value = fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c);
            fv = classVisitor.visitField(access, name, desc, signature, value);
            if (fv != null) {
                for (j = 1; j >= 0; --j) {
                    v1 = v = j == 0 ? ianns : anns;
                    if (v == 0) continue;
                    k = this.readUnsignedShort(v);
                    v += 2;
                    while (k > 0) {
                        desc = this.readUTF8(v, c);
                        v += 2;
                        v = this.readAnnotationValues(v, c, fv.visitAnnotation(desc, j != 0));
                        --k;
                    }
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    fv.visitAttribute(cattrs);
                    cattrs = attr;
                }
                fv.visitEnd();
            }
            --i;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            u0 = u + 6;
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            signature = null;
            anns = 0;
            ianns = 0;
            dann = 0;
            mpanns = 0;
            impanns = 0;
            cattrs = null;
            v = 0;
            w = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                attrSize = this.readInt(u += 2);
                u += 4;
                if (attrName.equals("Code")) {
                    v = u;
                } else if (attrName.equals("Exceptions")) {
                    w = u;
                } else if (attrName.equals("Synthetic")) {
                    access |= 4096;
                } else if (attrName.equals("Varargs")) {
                    access |= 128;
                } else if (attrName.equals("Bridge")) {
                    access |= 64;
                } else if (attrName.equals("Deprecated")) {
                    access |= 131072;
                } else if (attrName.equals("Signature")) {
                    signature = this.readUTF8(u, c);
                } else if (attrName.equals("AnnotationDefault")) {
                    dann = u;
                } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                    anns = u;
                } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                    ianns = u;
                } else if (attrName.equals("RuntimeVisibleParameterAnnotations")) {
                    mpanns = u;
                } else if (attrName.equals("RuntimeInvisibleParameterAnnotations")) {
                    impanns = u;
                } else {
                    attr = this.readAttribute(attrs, attrName, u, attrSize, c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += attrSize;
                --j;
            }
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                for (j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                }
            }
            mv = classVisitor.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null) ** GOTO lbl314
            if (!(mv instanceof MethodWriter)) ** GOTO lbl-1000
            mw = (MethodWriter)mv;
            if (mw.cw.cr != this || signature != mw.signature) ** GOTO lbl-1000
            sameExceptions = false;
            if (exceptions == null) {
                sameExceptions = mw.exceptionCount == 0;
            } else if (exceptions.length == mw.exceptionCount) {
                sameExceptions = true;
                for (j = exceptions.length - 1; j >= 0; --j) {
                    if (mw.exceptions[j] == this.readUnsignedShort(w -= 2)) continue;
                    sameExceptions = false;
                    break;
                }
            }
            if (sameExceptions) {
                mw.classReaderOffset = u0;
                mw.classReaderLength = u - u0;
            } else lbl-1000:
            // 3 sources

            {
                if (dann != 0) {
                    dv = mv.visitAnnotationDefault();
                    this.readAnnotationValue(dann, c, null, dv);
                    dv.visitEnd();
                }
                for (j = 1; j >= 0; --j) {
                    v2 = w = j == 0 ? ianns : anns;
                    if (w == 0) continue;
                    k = this.readUnsignedShort(w);
                    w += 2;
                    while (k > 0) {
                        desc = this.readUTF8(w, c);
                        w += 2;
                        w = this.readAnnotationValues(w, c, mv.visitAnnotation(desc, j != 0));
                        --k;
                    }
                }
                if (mpanns != 0) {
                    this.readParameterAnnotations(mpanns, c, true, mv);
                }
                if (impanns != 0) {
                    this.readParameterAnnotations(impanns, c, false, mv);
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    mv.visitAttribute(cattrs);
                    cattrs = attr;
                }
lbl314:
                // 2 sources

                if (mv != null && v != 0) {
                    maxStack = this.readUnsignedShort(v);
                    maxLocals = this.readUnsignedShort(v + 2);
                    codeLength = this.readInt(v + 4);
                    codeStart = v += 8;
                    codeEnd = v + codeLength;
                    mv.visitCode();
                    labels = new Label[codeLength + 1];
                    block50: while (v < codeEnd) {
                        opcode = b[v] & 255;
                        switch (ClassWriter.TYPE[opcode]) {
                            case 0: 
                            case 4: {
                                ++v;
                                continue block50;
                            }
                            case 8: {
                                label = v - codeStart + this.readShort(v + 1);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                v += 3;
                                continue block50;
                            }
                            case 9: {
                                label = v - codeStart + this.readInt(v + 1);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                v += 5;
                                continue block50;
                            }
                            case 16: {
                                opcode = b[v + 1] & 255;
                                if (opcode == 132) {
                                    v += 6;
                                    continue block50;
                                }
                                v += 4;
                                continue block50;
                            }
                            case 13: {
                                w = v - codeStart;
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                j = this.readInt(v);
                                v += 4;
                                for (j = this.readInt(v += 4) - j + 1; j > 0; --j) {
                                    label = w + this.readInt(v);
                                    v += 4;
                                    if (labels[label] != null) continue;
                                    labels[label] = new Label();
                                }
                                continue block50;
                            }
                            case 14: {
                                w = v - codeStart;
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                j = this.readInt(v);
                                v += 4;
                                while (j > 0) {
                                    label = w + this.readInt(v += 4);
                                    v += 4;
                                    if (labels[label] == null) {
                                        labels[label] = new Label();
                                    }
                                    --j;
                                }
                                continue block50;
                            }
                            case 1: 
                            case 3: 
                            case 10: {
                                v += 2;
                                continue block50;
                            }
                            case 2: 
                            case 5: 
                            case 6: 
                            case 11: 
                            case 12: {
                                v += 3;
                                continue block50;
                            }
                            case 7: {
                                v += 5;
                                continue block50;
                            }
                        }
                        v += 4;
                    }
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        label = this.readUnsignedShort(v);
                        start = labels[label];
                        if (start == null) {
                            labels[label] = start = new Label();
                        }
                        if ((end = labels[label = this.readUnsignedShort(v + 2)]) == null) {
                            labels[label] = end = new Label();
                        }
                        if ((handler = labels[label = this.readUnsignedShort(v + 4)]) == null) {
                            labels[label] = handler = new Label();
                        }
                        if ((type = this.readUnsignedShort(v + 6)) == 0) {
                            mv.visitTryCatchBlock(start, end, handler, null);
                        } else {
                            mv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                        }
                        v += 8;
                        --j;
                    }
                    varTable = 0;
                    varTypeTable = 0;
                    cattrs = null;
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        attrName = this.readUTF8(v, c);
                        if (attrName.equals("LocalVariableTable")) {
                            if (!skipDebug) {
                                varTable = v + 6;
                                w = v + 8;
                                for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                    label = this.readUnsignedShort(w);
                                    if (labels[label] == null) {
                                        labels[label] = new Label();
                                    }
                                    if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                        labels[label] = new Label();
                                    }
                                    w += 10;
                                }
                            }
                        } else if (attrName.equals("LocalVariableTypeTable")) {
                            varTypeTable = v + 6;
                        } else if (attrName.equals("LineNumberTable")) {
                            if (!skipDebug) {
                                w = v + 8;
                                for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                    label = this.readUnsignedShort(w);
                                    if (labels[label] == null) {
                                        labels[label] = new Label();
                                    }
                                    labels[label].line = this.readUnsignedShort(w + 2);
                                    w += 4;
                                }
                            }
                        } else {
                            for (k = 0; k < attrs.length; ++k) {
                                if (!attrs[k].type.equals(attrName) || (attr = attrs[k].read(this, v + 6, this.readInt(v + 2), c, codeStart - 8, labels)) == null) continue;
                                attr.next = cattrs;
                                cattrs = attr;
                            }
                        }
                        v += 6 + this.readInt(v + 2);
                        --j;
                    }
                    v = codeStart;
                    block58: while (v < codeEnd) {
                        w = v - codeStart;
                        l = labels[w];
                        if (l != null) {
                            mv.visitLabel(l);
                            if (!skipDebug && l.line > 0) {
                                mv.visitLineNumber(l.line, l);
                            }
                        }
                        opcode = b[v] & 255;
                        switch (ClassWriter.TYPE[opcode]) {
                            case 0: {
                                mv.visitInsn(opcode);
                                ++v;
                                continue block58;
                            }
                            case 4: {
                                if (opcode > 54) {
                                    mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                                } else {
                                    mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                                }
                                ++v;
                                continue block58;
                            }
                            case 8: {
                                mv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                                v += 3;
                                continue block58;
                            }
                            case 9: {
                                mv.visitJumpInsn(opcode - 33, labels[w + this.readInt(v + 1)]);
                                v += 5;
                                continue block58;
                            }
                            case 16: {
                                opcode = b[v + 1] & 255;
                                if (opcode == 132) {
                                    mv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                                    v += 6;
                                    continue block58;
                                }
                                mv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                                v += 4;
                                continue block58;
                            }
                            case 13: {
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                min = this.readInt(v += 4);
                                max = this.readInt(v += 4);
                                v += 4;
                                table = new Label[max - min + 1];
                                for (j = 0; j < table.length; ++j) {
                                    table[j] = labels[w + this.readInt(v)];
                                    v += 4;
                                }
                                mv.visitTableSwitchInsn(min, max, labels[label], table);
                                continue block58;
                            }
                            case 14: {
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                j = this.readInt(v += 4);
                                v += 4;
                                keys = new int[j];
                                values = new Label[j];
                                for (j = 0; j < keys.length; ++j) {
                                    keys[j] = this.readInt(v);
                                    values[j] = labels[w + this.readInt(v += 4)];
                                    v += 4;
                                }
                                mv.visitLookupSwitchInsn(labels[label], keys, values);
                                continue block58;
                            }
                            case 3: {
                                mv.visitVarInsn(opcode, b[v + 1] & 255);
                                v += 2;
                                continue block58;
                            }
                            case 1: {
                                mv.visitIntInsn(opcode, b[v + 1]);
                                v += 2;
                                continue block58;
                            }
                            case 2: {
                                mv.visitIntInsn(opcode, this.readShort(v + 1));
                                v += 3;
                                continue block58;
                            }
                            case 10: {
                                mv.visitLdcInsn(this.readConst(b[v + 1] & 255, c));
                                v += 2;
                                continue block58;
                            }
                            case 11: {
                                mv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                                v += 3;
                                continue block58;
                            }
                            case 6: 
                            case 7: {
                                cpIndex = this.items[this.readUnsignedShort(v + 1)];
                                iowner = this.readClass(cpIndex, c);
                                cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                                iname = this.readUTF8(cpIndex, c);
                                idesc = this.readUTF8(cpIndex + 2, c);
                                if (opcode < 182) {
                                    mv.visitFieldInsn(opcode, iowner, iname, idesc);
                                } else {
                                    mv.visitMethodInsn(opcode, iowner, iname, idesc);
                                }
                                if (opcode == 185) {
                                    v += 5;
                                    continue block58;
                                }
                                v += 3;
                                continue block58;
                            }
                            case 5: {
                                mv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                                v += 3;
                                continue block58;
                            }
                            case 12: {
                                mv.visitIincInsn(b[v + 1] & 255, b[v + 2]);
                                v += 3;
                                continue block58;
                            }
                        }
                        mv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 255);
                        v += 4;
                    }
                    l = labels[codeEnd - codeStart];
                    if (l != null) {
                        mv.visitLabel(l);
                    }
                    if (!skipDebug && varTable != 0) {
                        typeTable = null;
                        if (varTypeTable != 0) {
                            w = varTypeTable;
                            k = this.readUnsignedShort(w) * 3;
                            w += 2;
                            typeTable = new int[k];
                            while (k > 0) {
                                typeTable[--k] = w + 6;
                                typeTable[--k] = this.readUnsignedShort(w + 8);
                                typeTable[--k] = this.readUnsignedShort(w);
                                w += 10;
                            }
                        }
                        w = varTable;
                        k = this.readUnsignedShort(w);
                        w += 2;
                        while (k > 0) {
                            start = this.readUnsignedShort(w);
                            length = this.readUnsignedShort(w + 2);
                            index = this.readUnsignedShort(w + 8);
                            vsignature = null;
                            if (typeTable != null) {
                                for (a = 0; a < typeTable.length; a += 3) {
                                    if (typeTable[a] != start || typeTable[a + 1] != index) continue;
                                    vsignature = this.readUTF8(typeTable[a + 2], c);
                                    break;
                                }
                            }
                            mv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), vsignature, labels[start], labels[start + length], index);
                            w += 10;
                            --k;
                        }
                    }
                    while (cattrs != null) {
                        attr = cattrs.next;
                        cattrs.next = null;
                        mv.visitAttribute(cattrs);
                        cattrs = attr;
                    }
                    mv.visitMaxs(maxStack, maxLocals);
                }
                if (mv != null) {
                    mv.visitEnd();
                }
            }
            --i;
        }
        classVisitor.visitEnd();
    }

    private void readParameterAnnotations(int v2, char[] buf, boolean visible, MethodVisitor mv2) {
        int n2 = this.b[v2++] & 0xFF;
        for (int i2 = 0; i2 < n2; ++i2) {
            int j2 = this.readUnsignedShort(v2);
            v2 += 2;
            while (j2 > 0) {
                String desc = this.readUTF8(v2, buf);
                v2 += 2;
                AnnotationVisitor av2 = mv2.visitParameterAnnotation(i2, desc, visible);
                v2 = this.readAnnotationValues(v2, buf, av2);
                --j2;
            }
        }
    }

    private int readAnnotationValues(int v2, char[] buf, AnnotationVisitor av2) {
        int i2 = this.readUnsignedShort(v2);
        v2 += 2;
        while (i2 > 0) {
            String name = this.readUTF8(v2, buf);
            v2 += 2;
            v2 = this.readAnnotationValue(v2, buf, name, av2);
            --i2;
        }
        av2.visitEnd();
        return v2;
    }

    private int readAnnotationValue(int v2, char[] buf, String name, AnnotationVisitor av2) {
        block0 : switch (this.readByte(v2++)) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av2.visit(name, this.readConst(this.readUnsignedShort(v2), buf));
                v2 += 2;
                break;
            }
            case 66: {
                av2.visit(name, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(v2)])));
                v2 += 2;
                break;
            }
            case 90: {
                boolean b2 = this.readInt(this.items[this.readUnsignedShort(v2)]) == 0;
                av2.visit(name, b2 ? Boolean.FALSE : Boolean.TRUE);
                v2 += 2;
                break;
            }
            case 83: {
                av2.visit(name, new Short((short)this.readInt(this.items[this.readUnsignedShort(v2)])));
                v2 += 2;
                break;
            }
            case 67: {
                av2.visit(name, new Character((char)this.readInt(this.items[this.readUnsignedShort(v2)])));
                v2 += 2;
                break;
            }
            case 115: {
                av2.visit(name, this.readUTF8(v2, buf));
                v2 += 2;
                break;
            }
            case 101: {
                av2.visitEnum(name, this.readUTF8(v2, buf), this.readUTF8(v2 + 2, buf));
                v2 += 4;
                break;
            }
            case 99: {
                av2.visit(name, Type.getType(this.readUTF8(v2, buf)));
                v2 += 2;
                break;
            }
            case 64: {
                String desc = this.readUTF8(v2, buf);
                v2 += 2;
                v2 = this.readAnnotationValues(v2, buf, av2.visitAnnotation(name, desc));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v2);
                v2 += 2;
                if (size == 0) {
                    av2.visitArray(name).visitEnd();
                    return v2;
                }
                switch (this.readByte(v2++)) {
                    case 66: {
                        byte[] bv2 = new byte[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            bv2[i2] = (byte)this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                        }
                        av2.visit(name, bv2);
                        --v2;
                        break block0;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            zv[i2] = this.readInt(this.items[this.readUnsignedShort(v2)]) != 0;
                            v2 += 3;
                        }
                        av2.visit(name, zv);
                        --v2;
                        break block0;
                    }
                    case 83: {
                        short[] sv2 = new short[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            sv2[i2] = (short)this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                        }
                        av2.visit(name, sv2);
                        --v2;
                        break block0;
                    }
                    case 67: {
                        char[] cv2 = new char[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            cv2[i2] = (char)this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                        }
                        av2.visit(name, cv2);
                        --v2;
                        break block0;
                    }
                    case 73: {
                        int[] iv2 = new int[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            iv2[i2] = this.readInt(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                        }
                        av2.visit(name, iv2);
                        --v2;
                        break block0;
                    }
                    case 74: {
                        long[] lv2 = new long[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            lv2[i2] = this.readLong(this.items[this.readUnsignedShort(v2)]);
                            v2 += 3;
                        }
                        av2.visit(name, lv2);
                        --v2;
                        break block0;
                    }
                    case 70: {
                        float[] fv2 = new float[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            fv2[i2] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v2)]));
                            v2 += 3;
                        }
                        av2.visit(name, fv2);
                        --v2;
                        break block0;
                    }
                    case 68: {
                        double[] dv2 = new double[size];
                        for (int i2 = 0; i2 < size; ++i2) {
                            dv2[i2] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v2)]));
                            v2 += 3;
                        }
                        av2.visit(name, dv2);
                        --v2;
                        break block0;
                    }
                }
                --v2;
                AnnotationVisitor aav = av2.visitArray(name);
                for (int i2 = size; i2 > 0; --i2) {
                    v2 = this.readAnnotationValue(v2, buf, null, aav);
                }
                aav.visitEnd();
            }
        }
        return v2;
    }

    private Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            if (!attrs[i2].type.equals(type)) continue;
            return attrs[i2].read(this, off, len, buf, codeOff, labels);
        }
        return new Attribute(type).read(this, off, len, null, -1, null);
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int readByte(int index) {
        return this.b[index] & 0xFF;
    }

    public int readUnsignedShort(int index) {
        byte[] b2 = this.b;
        return (b2[index] & 0xFF) << 8 | b2[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        byte[] b2 = this.b;
        return (short)((b2[index] & 0xFF) << 8 | b2[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        byte[] b2 = this.b;
        return (b2[index] & 0xFF) << 24 | (b2[index + 1] & 0xFF) << 16 | (b2[index + 2] & 0xFF) << 8 | b2[index + 3] & 0xFF;
    }

    public long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s2 = this.strings[item];
        if (s2 != null) {
            return s2;
        }
        index = this.items[item];
        this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
        return this.strings[item];
    }

    private String readUTF(int index, int utfLen, char[] buf) {
        int endIndex = index + utfLen;
        byte[] b2 = this.b;
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d2;
            int c2 = b2[index++] & 0xFF;
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c2;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d2 = b2[index++];
                    buf[strLen++] = (char)((c2 & 0x1F) << 6 | d2 & 0x3F);
                    continue block4;
                }
            }
            d2 = b2[index++];
            byte e2 = b2[index++];
            buf[strLen++] = (char)((c2 & 0xF) << 12 | (d2 & 0x3F) << 6 | e2 & 0x3F);
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index = this.items[item];
        switch (this.b[index - 1]) {
            case 3: {
                return new Integer(this.readInt(index));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index)));
            }
            case 5: {
                return new Long(this.readLong(index));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index)));
            }
            case 7: {
                String s2 = this.readUTF8(index, buf);
                return Type.getType(s2.charAt(0) == '[' ? s2 : "L" + s2 + ";");
            }
        }
        return this.readUTF8(index, buf);
    }
}

