/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm;

import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.AnnotationWriter;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Attribute;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.ByteVector;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.ClassWriter;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Edge;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Handler;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Item;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Label;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.MethodVisitor;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.asm.Type;

class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    ClassWriter cw;
    private int access;
    private int name;
    private int desc;
    private String descriptor;
    int classReaderOffset;
    int classReaderLength;
    String signature;
    int exceptionCount;
    int[] exceptions;
    private ByteVector annd;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private AnnotationWriter[] panns;
    private AnnotationWriter[] ipanns;
    private Attribute attrs;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;
    private int catchCount;
    private Handler catchTable;
    private Handler lastHandler;
    private int localVarCount;
    private ByteVector localVar;
    private int localVarTypeCount;
    private ByteVector localVarType;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private Attribute cattrs;
    private boolean resize;
    private final boolean computeMaxs;
    private int stackSize;
    private int maxStackSize;
    private Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;

    MethodWriter(ClassWriter cw2, int access, String name, String desc, String signature, String[] exceptions, boolean computeMaxs) {
        if (cw2.firstMethod == null) {
            cw2.firstMethod = this;
        } else {
            cw2.lastMethod.next = this;
        }
        cw2.lastMethod = this;
        this.cw = cw2;
        this.access = access;
        this.name = cw2.newUTF8(name);
        this.desc = cw2.newUTF8(desc);
        this.descriptor = desc;
        this.signature = signature;
        if (exceptions != null && exceptions.length > 0) {
            this.exceptionCount = exceptions.length;
            this.exceptions = new int[this.exceptionCount];
            for (int i2 = 0; i2 < this.exceptionCount; ++i2) {
                this.exceptions[i2] = cw2.newClass(exceptions[i2]);
            }
        }
        this.computeMaxs = computeMaxs;
        if (computeMaxs) {
            int size = MethodWriter.getArgumentsAndReturnSizes(desc) >> 2;
            if ((access & 8) != 0) {
                --size;
            }
            this.maxLocals = size;
            this.currentBlock = new Label();
            this.currentBlock.pushed = true;
            this.blockStack = this.currentBlock;
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.annd = new ByteVector();
        return new AnnotationWriter(this.cw, false, this.annd, null, 0);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, 2);
        if (visible) {
            aw2.next = this.anns;
            this.anns = aw2;
        } else {
            aw2.next = this.ianns;
            this.ianns = aw2;
        }
        return aw2;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        ByteVector bv2 = new ByteVector();
        bv2.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw2 = new AnnotationWriter(this.cw, true, bv2, bv2, 2);
        if (visible) {
            if (this.panns == null) {
                this.panns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            aw2.next = this.panns[parameter];
            this.panns[parameter] = aw2;
        } else {
            if (this.ipanns == null) {
                this.ipanns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            aw2.next = this.ipanns[parameter];
            this.ipanns[parameter] = aw2;
        }
        return aw2;
    }

    public void visitAttribute(Attribute attr) {
        if (attr.isCodeAttribute()) {
            attr.next = this.cattrs;
            this.cattrs = attr;
        } else {
            attr.next = this.attrs;
            this.attrs = attr;
        }
    }

    public void visitCode() {
    }

    public void visitInsn(int opcode) {
        if (this.computeMaxs) {
            int size = this.stackSize + SIZE[opcode];
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
            if ((opcode >= 172 && opcode <= 177 || opcode == 191) && this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        }
        this.code.putByte(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (this.computeMaxs && opcode != 188) {
            int size = this.stackSize + 1;
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        if (opcode == 17) {
            this.code.put12(opcode, operand);
        } else {
            this.code.put11(opcode, operand);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (this.computeMaxs) {
            int n2;
            if (opcode == 169) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.currentBlock = null;
                }
            } else {
                int size = this.stackSize + SIZE[opcode];
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
            if ((n2 = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1) > this.maxLocals) {
                this.maxLocals = n2;
            }
        }
        if (var < 4 && opcode != 169) {
            int opt = opcode < 54 ? 26 + (opcode - 21 << 2) + var : 59 + (opcode - 54 << 2) + var;
            this.code.putByte(opt);
        } else if (var >= 256) {
            this.code.putByte(196).put12(opcode, var);
        } else {
            this.code.put11(opcode, var);
        }
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (this.computeMaxs && opcode == 187) {
            int size = this.stackSize + 1;
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        this.code.put12(opcode, this.cw.newClass(desc));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.computeMaxs) {
            int size;
            char c2 = desc.charAt(0);
            switch (opcode) {
                case 178: {
                    size = this.stackSize + (c2 == 'D' || c2 == 'J' ? 2 : 1);
                    break;
                }
                case 179: {
                    size = this.stackSize + (c2 == 'D' || c2 == 'J' ? -2 : -1);
                    break;
                }
                case 180: {
                    size = this.stackSize + (c2 == 'D' || c2 == 'J' ? 1 : 0);
                    break;
                }
                default: {
                    size = this.stackSize + (c2 == 'D' || c2 == 'J' ? -3 : -2);
                }
            }
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        this.code.put12(opcode, this.cw.newField(owner, name, desc));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        boolean itf = opcode == 185;
        Item i2 = this.cw.newMethodItem(owner, name, desc, itf);
        int argSize = i2.intVal;
        if (this.computeMaxs) {
            int size;
            if (argSize == 0) {
                i2.intVal = argSize = MethodWriter.getArgumentsAndReturnSizes(desc);
            }
            if ((size = opcode == 184 ? this.stackSize - (argSize >> 2) + (argSize & 3) + 1 : this.stackSize - (argSize >> 2) + (argSize & 3)) > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        if (itf) {
            if (!this.computeMaxs && argSize == 0) {
                i2.intVal = argSize = MethodWriter.getArgumentsAndReturnSizes(desc);
            }
            this.code.put12(185, i2.index).put11(argSize >> 2, 0);
        } else {
            this.code.put12(opcode, i2.index);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.computeMaxs) {
            if (opcode == 167) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.addSuccessor(this.stackSize, label);
                    this.currentBlock = null;
                }
            } else if (opcode == 168) {
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize + 1, label);
                }
            } else {
                this.stackSize += SIZE[opcode];
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize, label);
                }
            }
        }
        if (label.resolved && label.position - this.code.length < Short.MIN_VALUE) {
            if (opcode == 167) {
                this.code.putByte(200);
            } else if (opcode == 168) {
                this.code.putByte(201);
            } else {
                this.code.putByte(opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1);
                this.code.putShort(8);
                this.code.putByte(200);
            }
            label.put(this, this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(opcode);
            label.put(this, this.code, this.code.length - 1, false);
        }
    }

    public void visitLabel(Label label) {
        if (this.computeMaxs) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
        }
        this.resize |= label.resolve(this, this.code.length, this.code.data);
    }

    public void visitLdcInsn(Object cst) {
        Item i2 = this.cw.newConstItem(cst);
        if (this.computeMaxs) {
            int size = i2.type == 5 || i2.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        int index = i2.index;
        if (i2.type == 5 || i2.type == 6) {
            this.code.put12(20, index);
        } else if (index >= 256) {
            this.code.put12(19, index);
        } else {
            this.code.put11(18, index);
        }
    }

    public void visitIincInsn(int var, int increment) {
        int n2;
        if (this.computeMaxs && (n2 = var + 1) > this.maxLocals) {
            this.maxLocals = n2;
        }
        if (var > 255 || increment > 127 || increment < -128) {
            this.code.putByte(196).put12(132, var).putShort(increment);
        } else {
            this.code.putByte(132).put11(var, increment);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, dflt);
                for (int i2 = 0; i2 < labels.length; ++i2) {
                    this.addSuccessor(this.stackSize, labels[i2]);
                }
                this.currentBlock = null;
            }
        }
        int source = this.code.length;
        this.code.putByte(170);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        dflt.put(this, this.code, source, true);
        this.code.putInt(min).putInt(max);
        for (int i3 = 0; i3 < labels.length; ++i3) {
            labels[i3].put(this, this.code, source, true);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, dflt);
                for (int i2 = 0; i2 < labels.length; ++i2) {
                    this.addSuccessor(this.stackSize, labels[i2]);
                }
                this.currentBlock = null;
            }
        }
        int source = this.code.length;
        this.code.putByte(171);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        dflt.put(this, this.code, source, true);
        this.code.putInt(labels.length);
        for (int i3 = 0; i3 < labels.length; ++i3) {
            this.code.putInt(keys[i3]);
            labels[i3].put(this, this.code, source, true);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.computeMaxs) {
            this.stackSize += 1 - dims;
        }
        this.code.put12(197, this.cw.newClass(desc)).putByte(dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.computeMaxs && !handler.pushed) {
            handler.beginStackSize = 1;
            handler.pushed = true;
            handler.next = this.blockStack;
            this.blockStack = handler;
        }
        ++this.catchCount;
        Handler h2 = new Handler();
        h2.start = start;
        h2.end = end;
        h2.handler = handler;
        h2.desc = type;
        int n2 = h2.type = type != null ? this.cw.newClass(type) : 0;
        if (this.lastHandler == null) {
            this.catchTable = h2;
        } else {
            this.lastHandler.next = h2;
        }
        this.lastHandler = h2;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        char c2;
        int n2;
        if (signature != null) {
            if (this.localVarType == null) {
                this.localVarType = new ByteVector();
            }
            ++this.localVarTypeCount;
            this.localVarType.putShort(start.position).putShort(end.position - start.position).putShort(this.cw.newUTF8(name)).putShort(this.cw.newUTF8(signature)).putShort(index);
        }
        if (this.localVar == null) {
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.putShort(start.position).putShort(end.position - start.position).putShort(this.cw.newUTF8(name)).putShort(this.cw.newUTF8(desc)).putShort(index);
        if (this.computeMaxs && (n2 = index + ((c2 = desc.charAt(0)) == 'L' || c2 == 'D' ? 2 : 1)) > this.maxLocals) {
            this.maxLocals = n2;
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (this.lineNumber == null) {
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.putShort(start.position);
        this.lineNumber.putShort(line);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.computeMaxs) {
            int max = 0;
            Label stack = this.blockStack;
            while (stack != null) {
                Label l2 = stack;
                stack = stack.next;
                int start = l2.beginStackSize;
                int blockMax = start + l2.maxStackSize;
                if (blockMax > max) {
                    max = blockMax;
                }
                Edge b2 = l2.successors;
                while (b2 != null) {
                    l2 = b2.successor;
                    if (!l2.pushed) {
                        l2.beginStackSize = start + b2.stackSize;
                        l2.pushed = true;
                        l2.next = stack;
                        stack = l2;
                    }
                    b2 = b2.next;
                }
            }
            this.maxStack = max;
        } else {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }

    public void visitEnd() {
    }

    private static int getArgumentsAndReturnSizes(String desc) {
        int n2 = 1;
        int c2 = 1;
        while (true) {
            char car;
            if ((car = desc.charAt(c2++)) == ')') {
                car = desc.charAt(c2);
                return n2 << 2 | (car == 'V' ? 0 : (car == 'D' || car == 'J' ? 2 : 1));
            }
            if (car == 'L') {
                while (desc.charAt(c2++) != ';') {
                }
                ++n2;
                continue;
            }
            if (car == '[') {
                while ((car = desc.charAt(c2)) == '[') {
                    ++c2;
                }
                if (car != 'D' && car != 'J') continue;
                --n2;
                continue;
            }
            if (car == 'D' || car == 'J') {
                n2 += 2;
                continue;
            }
            ++n2;
        }
    }

    private void addSuccessor(int stackSize, Label successor) {
        Edge b2 = new Edge();
        b2.stackSize = stackSize;
        b2.successor = successor;
        b2.next = this.currentBlock.successors;
        this.currentBlock.successors = b2;
    }

    final int getSize() {
        int i2;
        if (this.classReaderOffset != 0) {
            return 6 + this.classReaderLength;
        }
        if (this.resize) {
            this.resizeInstructions(new int[0], new int[0], 0);
        }
        int size = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            size += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                this.cw.newUTF8("LocalVariableTable");
                size += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                this.cw.newUTF8("LocalVariableTypeTable");
                size += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                this.cw.newUTF8("LineNumberTable");
                size += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                size += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            size += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            this.cw.newUTF8("Synthetic");
            size += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            size += 6;
        }
        if ((this.cw.version & 0xFFFF) < 49) {
            if ((this.access & 0x80) != 0) {
                this.cw.newUTF8("Varargs");
                size += 6;
            }
            if ((this.access & 0x40) != 0) {
                this.cw.newUTF8("Bridge");
                size += 6;
            }
        }
        if (this.signature != null) {
            this.cw.newUTF8("Signature");
            this.cw.newUTF8(this.signature);
            size += 8;
        }
        if (this.annd != null) {
            this.cw.newUTF8("AnnotationDefault");
            size += 6 + this.annd.length;
        }
        if (this.anns != null) {
            this.cw.newUTF8("RuntimeVisibleAnnotations");
            size += 8 + this.anns.getSize();
        }
        if (this.ianns != null) {
            this.cw.newUTF8("RuntimeInvisibleAnnotations");
            size += 8 + this.ianns.getSize();
        }
        if (this.panns != null) {
            this.cw.newUTF8("RuntimeVisibleParameterAnnotations");
            size += 7 + 2 * this.panns.length;
            for (i2 = this.panns.length - 1; i2 >= 0; --i2) {
                size += this.panns[i2] == null ? 0 : this.panns[i2].getSize();
            }
        }
        if (this.ipanns != null) {
            this.cw.newUTF8("RuntimeInvisibleParameterAnnotations");
            size += 7 + 2 * this.ipanns.length;
            for (i2 = this.ipanns.length - 1; i2 >= 0; --i2) {
                size += this.ipanns[i2] == null ? 0 : this.ipanns[i2].getSize();
            }
        }
        if (this.attrs != null) {
            size += this.attrs.getSize(this.cw, null, 0, -1, -1);
        }
        return size;
    }

    final void put(ByteVector out, boolean dropTigerFlags) {
        int modifiers = this.access;
        if (dropTigerFlags) {
            modifiers &= 0xFFFFEF3F;
        }
        out.putShort(modifiers).putShort(this.name).putShort(this.desc);
        if (this.classReaderOffset != 0) {
            out.putByteArray(this.cw.cr.b, this.classReaderOffset, this.classReaderLength);
            return;
        }
        int attributeCount = 0;
        if (this.code.length > 0) {
            ++attributeCount;
        }
        if (this.exceptionCount > 0) {
            ++attributeCount;
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            ++attributeCount;
        }
        if ((this.access & 0x20000) != 0) {
            ++attributeCount;
        }
        if ((this.cw.version & 0xFFFF) < 49) {
            if ((this.access & 0x80) != 0) {
                ++attributeCount;
            }
            if ((this.access & 0x40) != 0) {
                ++attributeCount;
            }
        }
        if (this.signature != null) {
            ++attributeCount;
        }
        if (this.annd != null) {
            ++attributeCount;
        }
        if (this.anns != null) {
            ++attributeCount;
        }
        if (this.ianns != null) {
            ++attributeCount;
        }
        if (this.panns != null) {
            ++attributeCount;
        }
        if (this.ipanns != null) {
            ++attributeCount;
        }
        if (this.attrs != null) {
            attributeCount += this.attrs.getCount();
        }
        out.putShort(attributeCount);
        if (this.code.length > 0) {
            int size = 12 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                size += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                size += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                size += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                size += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
            out.putShort(this.cw.newUTF8("Code")).putInt(size);
            out.putShort(this.maxStack).putShort(this.maxLocals);
            out.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            out.putShort(this.catchCount);
            if (this.catchCount > 0) {
                Handler h2 = this.catchTable;
                while (h2 != null) {
                    out.putShort(h2.start.position).putShort(h2.end.position).putShort(h2.handler.position).putShort(h2.type);
                    h2 = h2.next;
                }
            }
            attributeCount = 0;
            if (this.localVar != null) {
                ++attributeCount;
            }
            if (this.localVarType != null) {
                ++attributeCount;
            }
            if (this.lineNumber != null) {
                ++attributeCount;
            }
            if (this.cattrs != null) {
                attributeCount += this.cattrs.getCount();
            }
            out.putShort(attributeCount);
            if (this.localVar != null) {
                out.putShort(this.cw.newUTF8("LocalVariableTable"));
                out.putInt(this.localVar.length + 2).putShort(this.localVarCount);
                out.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.localVarType != null) {
                out.putShort(this.cw.newUTF8("LocalVariableTypeTable"));
                out.putInt(this.localVarType.length + 2).putShort(this.localVarTypeCount);
                out.putByteArray(this.localVarType.data, 0, this.localVarType.length);
            }
            if (this.lineNumber != null) {
                out.putShort(this.cw.newUTF8("LineNumberTable"));
                out.putInt(this.lineNumber.length + 2).putShort(this.lineNumberCount);
                out.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
            if (this.cattrs != null) {
                this.cattrs.put(this.cw, this.code.data, this.code.length, this.maxLocals, this.maxStack, out);
            }
        }
        if (this.exceptionCount > 0) {
            out.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            out.putShort(this.exceptionCount);
            for (int i2 = 0; i2 < this.exceptionCount; ++i2) {
                out.putShort(this.exceptions[i2]);
            }
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            out.putShort(this.cw.newUTF8("Synthetic")).putInt(0);
        }
        if ((this.access & 0x20000) != 0) {
            out.putShort(this.cw.newUTF8("Deprecated")).putInt(0);
        }
        if ((this.cw.version & 0xFFFF) < 49) {
            if ((this.access & 0x80) != 0) {
                out.putShort(this.cw.newUTF8("Varargs")).putInt(0);
            }
            if ((this.access & 0x40) != 0) {
                out.putShort(this.cw.newUTF8("Bridge")).putInt(0);
            }
        }
        if (this.signature != null) {
            out.putShort(this.cw.newUTF8("Signature")).putInt(2).putShort(this.cw.newUTF8(this.signature));
        }
        if (this.annd != null) {
            out.putShort(this.cw.newUTF8("AnnotationDefault"));
            out.putInt(this.annd.length);
            out.putByteArray(this.annd.data, 0, this.annd.length);
        }
        if (this.anns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.put(out);
        }
        if (this.ianns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.put(out);
        }
        if (this.panns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleParameterAnnotations"));
            AnnotationWriter.put(this.panns, out);
        }
        if (this.ipanns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleParameterAnnotations"));
            AnnotationWriter.put(this.ipanns, out);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, null, 0, -1, -1, out);
        }
    }

    private int[] resizeInstructions(int[] indexes, int[] sizes, int len) {
        int i2;
        int newOffset;
        int label;
        int u2;
        byte[] b2 = this.code.data;
        int[] allIndexes = new int[len];
        int[] allSizes = new int[len];
        System.arraycopy(indexes, 0, allIndexes, 0, len);
        System.arraycopy(sizes, 0, allSizes, 0, len);
        boolean[] resize = new boolean[this.code.length];
        int state = 3;
        do {
            if (state == 3) {
                state = 2;
            }
            u2 = 0;
            while (u2 < b2.length) {
                int opcode = b2[u2] & 0xFF;
                int insert = 0;
                switch (ClassWriter.TYPE[opcode]) {
                    case 0: 
                    case 4: {
                        ++u2;
                        break;
                    }
                    case 8: {
                        if (opcode > 201) {
                            opcode = opcode < 218 ? opcode - 49 : opcode - 20;
                            label = u2 + MethodWriter.readUnsignedShort(b2, u2 + 1);
                        } else {
                            label = u2 + MethodWriter.readShort(b2, u2 + 1);
                        }
                        newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, u2, label);
                        if (!(newOffset >= Short.MIN_VALUE && newOffset <= Short.MAX_VALUE || resize[u2])) {
                            insert = opcode == 167 || opcode == 168 ? 2 : 5;
                            resize[u2] = true;
                        }
                        u2 += 3;
                        break;
                    }
                    case 9: {
                        u2 += 5;
                        break;
                    }
                    case 13: {
                        if (state == 1) {
                            newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, u2);
                            insert = -(newOffset & 3);
                        } else if (!resize[u2]) {
                            insert = u2 & 3;
                            resize[u2] = true;
                        }
                        u2 = u2 + 4 - (u2 & 3);
                        u2 += 4 * (MethodWriter.readInt(b2, u2 + 8) - MethodWriter.readInt(b2, u2 + 4) + 1) + 12;
                        break;
                    }
                    case 14: {
                        if (state == 1) {
                            newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, u2);
                            insert = -(newOffset & 3);
                        } else if (!resize[u2]) {
                            insert = u2 & 3;
                            resize[u2] = true;
                        }
                        u2 = u2 + 4 - (u2 & 3);
                        u2 += 8 * MethodWriter.readInt(b2, u2 + 4) + 8;
                        break;
                    }
                    case 16: {
                        opcode = b2[u2 + 1] & 0xFF;
                        if (opcode == 132) {
                            u2 += 6;
                            break;
                        }
                        u2 += 4;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        u2 += 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        u2 += 3;
                        break;
                    }
                    case 7: {
                        u2 += 5;
                        break;
                    }
                    default: {
                        u2 += 4;
                    }
                }
                if (insert == 0) continue;
                int[] newIndexes = new int[allIndexes.length + 1];
                int[] newSizes = new int[allSizes.length + 1];
                System.arraycopy(allIndexes, 0, newIndexes, 0, allIndexes.length);
                System.arraycopy(allSizes, 0, newSizes, 0, allSizes.length);
                newIndexes[allIndexes.length] = u2;
                newSizes[allSizes.length] = insert;
                allIndexes = newIndexes;
                allSizes = newSizes;
                if (insert <= 0) continue;
                state = 3;
            }
            if (state >= 3) continue;
            --state;
        } while (state != 0);
        ByteVector newCode = new ByteVector(this.code.length);
        u2 = 0;
        block24: while (u2 < this.code.length) {
            for (i2 = allIndexes.length - 1; i2 >= 0; --i2) {
                if (allIndexes[i2] != u2 || i2 >= len) continue;
                if (sizes[i2] > 0) {
                    newCode.putByteArray(null, 0, sizes[i2]);
                } else {
                    newCode.length += sizes[i2];
                }
                indexes[i2] = newCode.length;
            }
            int opcode = b2[u2] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: 
                case 4: {
                    newCode.putByte(opcode);
                    ++u2;
                    continue block24;
                }
                case 8: {
                    if (opcode > 201) {
                        opcode = opcode < 218 ? opcode - 49 : opcode - 20;
                        label = u2 + MethodWriter.readUnsignedShort(b2, u2 + 1);
                    } else {
                        label = u2 + MethodWriter.readShort(b2, u2 + 1);
                    }
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, u2, label);
                    if (resize[u2]) {
                        if (opcode == 167) {
                            newCode.putByte(200);
                        } else if (opcode == 168) {
                            newCode.putByte(201);
                        } else {
                            newCode.putByte(opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1);
                            newCode.putShort(8);
                            newCode.putByte(200);
                            newOffset -= 3;
                        }
                        newCode.putInt(newOffset);
                    } else {
                        newCode.putByte(opcode);
                        newCode.putShort(newOffset);
                    }
                    u2 += 3;
                    continue block24;
                }
                case 9: {
                    label = u2 + MethodWriter.readInt(b2, u2 + 1);
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, u2, label);
                    newCode.putByte(opcode);
                    newCode.putInt(newOffset);
                    u2 += 5;
                    continue block24;
                }
                case 13: {
                    int v2 = u2;
                    u2 = u2 + 4 - (v2 & 3);
                    newCode.putByte(170);
                    while (newCode.length % 4 != 0) {
                        newCode.putByte(0);
                    }
                    label = v2 + MethodWriter.readInt(b2, u2);
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v2, label);
                    newCode.putInt(newOffset);
                    int j2 = MethodWriter.readInt(b2, u2 += 4);
                    newCode.putInt(j2);
                    newCode.putInt(MethodWriter.readInt(b2, (u2 += 4) - 4));
                    for (j2 = MethodWriter.readInt(b2, u2 += 4) - j2 + 1; j2 > 0; --j2) {
                        label = v2 + MethodWriter.readInt(b2, u2);
                        u2 += 4;
                        newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v2, label);
                        newCode.putInt(newOffset);
                    }
                    continue block24;
                }
                case 14: {
                    int j2;
                    int v2 = u2;
                    u2 = u2 + 4 - (v2 & 3);
                    newCode.putByte(171);
                    while (newCode.length % 4 != 0) {
                        newCode.putByte(0);
                    }
                    label = v2 + MethodWriter.readInt(b2, u2);
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v2, label);
                    newCode.putInt(newOffset);
                    u2 += 4;
                    newCode.putInt(j2);
                    for (j2 = MethodWriter.readInt(b2, u2 += 4); j2 > 0; --j2) {
                        newCode.putInt(MethodWriter.readInt(b2, u2));
                        label = v2 + MethodWriter.readInt(b2, u2 += 4);
                        u2 += 4;
                        newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v2, label);
                        newCode.putInt(newOffset);
                    }
                    continue block24;
                }
                case 16: {
                    opcode = b2[u2 + 1] & 0xFF;
                    if (opcode == 132) {
                        newCode.putByteArray(b2, u2, 6);
                        u2 += 6;
                        continue block24;
                    }
                    newCode.putByteArray(b2, u2, 4);
                    u2 += 4;
                    continue block24;
                }
                case 1: 
                case 3: 
                case 10: {
                    newCode.putByteArray(b2, u2, 2);
                    u2 += 2;
                    continue block24;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    newCode.putByteArray(b2, u2, 3);
                    u2 += 3;
                    continue block24;
                }
                case 7: {
                    newCode.putByteArray(b2, u2, 5);
                    u2 += 5;
                    continue block24;
                }
            }
            newCode.putByteArray(b2, u2, 4);
            u2 += 4;
        }
        Handler h2 = this.catchTable;
        while (h2 != null) {
            MethodWriter.getNewOffset(allIndexes, allSizes, h2.start);
            MethodWriter.getNewOffset(allIndexes, allSizes, h2.end);
            MethodWriter.getNewOffset(allIndexes, allSizes, h2.handler);
            h2 = h2.next;
        }
        for (i2 = 0; i2 < 2; ++i2) {
            ByteVector bv2;
            ByteVector byteVector = bv2 = i2 == 0 ? this.localVar : this.localVarType;
            if (bv2 == null) continue;
            b2 = bv2.data;
            for (u2 = 0; u2 < bv2.length; u2 += 10) {
                label = MethodWriter.readUnsignedShort(b2, u2);
                newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, label);
                MethodWriter.writeShort(b2, u2, newOffset);
                newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, label += MethodWriter.readUnsignedShort(b2, u2 + 2)) - newOffset;
                MethodWriter.writeShort(b2, u2 + 2, newOffset);
            }
        }
        if (this.lineNumber != null) {
            b2 = this.lineNumber.data;
            for (u2 = 0; u2 < this.lineNumber.length; u2 += 4) {
                MethodWriter.writeShort(b2, u2, MethodWriter.getNewOffset(allIndexes, allSizes, 0, MethodWriter.readUnsignedShort(b2, u2)));
            }
        }
        while (this.cattrs != null) {
            Label[] labels = this.cattrs.getLabels();
            if (labels == null) continue;
            for (i2 = labels.length - 1; i2 >= 0; --i2) {
                if (labels[i2].resized) continue;
                labels[i2].position = MethodWriter.getNewOffset(allIndexes, allSizes, 0, labels[i2].position);
                labels[i2].resized = true;
            }
        }
        this.code = newCode;
        return indexes;
    }

    static int readUnsignedShort(byte[] b2, int index) {
        return (b2[index] & 0xFF) << 8 | b2[index + 1] & 0xFF;
    }

    static short readShort(byte[] b2, int index) {
        return (short)((b2[index] & 0xFF) << 8 | b2[index + 1] & 0xFF);
    }

    static int readInt(byte[] b2, int index) {
        return (b2[index] & 0xFF) << 24 | (b2[index + 1] & 0xFF) << 16 | (b2[index + 2] & 0xFF) << 8 | b2[index + 3] & 0xFF;
    }

    static void writeShort(byte[] b2, int index, int s2) {
        b2[index] = (byte)(s2 >>> 8);
        b2[index + 1] = (byte)s2;
    }

    static int getNewOffset(int[] indexes, int[] sizes, int begin, int end) {
        int offset = end - begin;
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (begin < indexes[i2] && indexes[i2] <= end) {
                offset += sizes[i2];
                continue;
            }
            if (end >= indexes[i2] || indexes[i2] > begin) continue;
            offset -= sizes[i2];
        }
        return offset;
    }

    static void getNewOffset(int[] indexes, int[] sizes, Label label) {
        if (!label.resized) {
            label.position = MethodWriter.getNewOffset(indexes, sizes, 0, label.position);
            label.resized = true;
        }
    }

    static {
        int[] b2 = new int[202];
        String s2 = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i2 = 0; i2 < b2.length; ++i2) {
            b2[i2] = s2.charAt(i2) - 69;
        }
        SIZE = b2;
    }
}

