/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr.retro.net.sf.retrotranslator.runtime.format;

import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.format.FormatContext;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.format.NumericConversion;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;

class DecimalIntegralConversion
extends NumericConversion {
    DecimalIntegralConversion() {
    }

    public void format(FormatContext context) {
        context.assertNoPrecision();
        context.assertNoFlag('#');
        context.checkWidth();
        context.checkFlags();
        Object argument = context.getArgument();
        if (argument instanceof Byte) {
            this.printf(context, ((Byte)argument).byteValue());
        } else if (argument instanceof Short) {
            this.printf(context, ((Short)argument).shortValue());
        } else if (argument instanceof Integer) {
            this.printf(context, ((Integer)argument).intValue());
        } else if (argument instanceof Long) {
            this.printf(context, (Long)argument);
        } else if (argument instanceof BigInteger) {
            this.printf(context, (BigInteger)argument);
        } else if (argument == null) {
            context.writePadded(String.valueOf(argument));
        } else {
            throw context.getConversionException();
        }
    }

    private void printf(FormatContext context, long argument) {
        this.printf(context, BigInteger.valueOf(argument));
    }

    private void printf(FormatContext context, BigInteger argument) {
        DecimalFormatSymbols symbols = context.getSymbols(true);
        StringBuffer builder = new StringBuffer();
        DecimalIntegralConversion.appendNumber(builder, argument.abs().toString(), context.isFlag(','), symbols);
        DecimalIntegralConversion.printNumber(context, argument.signum() < 0, null, builder, symbols);
    }
}

