/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr.retro.net.sf.retrotranslator.runtime.format;

import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.format.Conversion;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.FormatFlagsConversionMismatchException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.IllegalFormatConversionException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.IllegalFormatFlagsException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.IllegalFormatPrecisionException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.IllegalFormatWidthException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.MissingFormatArgumentException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.MissingFormatWidthException_;
import com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.util.UnknownFormatConversionException_;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public abstract class FormatContext {
    private static final DecimalFormatSymbols US_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private Locale locale;
    private DecimalFormatSymbols symbols;
    private Object[] arguments;
    private int effectiveIndex;
    private int ordinaryIndex;
    private boolean effectiveIndexComputed;
    private String specifier;
    private int explicitIndex;
    private String flags;
    private int width;
    private int precision;
    private String conversion;
    private String format;
    private int position;

    protected FormatContext(Locale locale) {
        this.locale = locale;
    }

    public abstract void append(char var1);

    public abstract void append(String var1);

    public abstract void append(String var1, int var2, int var3);

    public abstract boolean writeFormattable();

    public void printf(String format, Object[] args) {
        int index;
        this.format = format;
        this.arguments = args;
        this.effectiveIndex = 0;
        this.ordinaryIndex = 0;
        this.position = 0;
        while ((index = format.indexOf(37, this.position)) >= 0) {
            this.append(format, this.position, index);
            this.scanOptions(index);
            this.effectiveIndexComputed = false;
            this.specifier = format.substring(index, this.position);
            Conversion instance = Conversion.getInstance(this.conversion);
            if (instance == null) {
                throw new UnknownFormatConversionException_(this.conversion);
            }
            instance.format(this);
        }
        this.append(format, this.position, format.length());
    }

    private void scanOptions(int index) {
        this.position = index + 1;
        try {
            this.scanExplicitIndex();
            this.scanFlags();
            this.scanWidth();
            this.scanPrecision();
            this.scanConversion();
        }
        catch (IndexOutOfBoundsException e2) {
            throw new UnknownFormatConversionException_(this.format.substring(index));
        }
    }

    private void scanExplicitIndex() {
        int index = FormatContext.skipDigits(this.format, this.position);
        if (index > this.position && this.format.charAt(index) == '$') {
            this.explicitIndex = FormatContext.parse(this.format, this.position, index);
            this.position = index + 1;
        } else {
            this.explicitIndex = -1;
        }
    }

    private void scanFlags() {
        int index = FormatContext.skipFlags(this.format, this.position);
        if (index > this.position) {
            this.flags = this.format.substring(this.position, index);
            this.position = index;
        } else {
            this.flags = "";
        }
    }

    private void scanWidth() {
        int index = FormatContext.skipDigits(this.format, this.position);
        if (index > this.position) {
            this.width = FormatContext.parse(this.format, this.position, index);
            this.position = index;
        } else {
            this.width = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanPrecision() {
        if (this.format.charAt(this.position) == '.') {
            ++this.position;
            int index = FormatContext.skipDigits(this.format, this.position);
            if (index <= this.position) throw new IndexOutOfBoundsException();
            this.precision = FormatContext.parse(this.format, this.position, index);
            this.position = index;
            return;
        } else {
            this.precision = -1;
        }
    }

    private void scanConversion() {
        char c2 = this.format.charAt(this.position);
        int endIndex = c2 == 't' || c2 == 'T' ? this.position + 2 : this.position + 1;
        this.conversion = this.format.substring(this.position, endIndex);
        this.position = endIndex;
    }

    private static int skipDigits(String s2, int index) {
        char c2 = s2.charAt(index);
        while (c2 >= '0' && c2 <= '9') {
            c2 = s2.charAt(++index);
        }
        return index;
    }

    private static int skipFlags(String s2, int index) {
        char c2 = s2.charAt(index);
        while (c2 == '-' || c2 == '#' || c2 == '+' || c2 == ' ' || c2 == '0' || c2 == ',' || c2 == '(' || c2 == '<') {
            c2 = s2.charAt(++index);
        }
        return index;
    }

    private static Integer parse(String format, int beginIndex, int endIndex) {
        return Integer.valueOf(format.substring(beginIndex, endIndex));
    }

    private char getConversionType() {
        return this.conversion.charAt(0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getNumberPrecision() {
        return this.precision >= 0 ? this.precision : 6;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DecimalFormatSymbols getSymbols(boolean localized) {
        if (localized && this.locale != null) {
            if (this.symbols == null) {
                this.symbols = new DecimalFormatSymbols(this.locale);
            }
            return this.symbols;
        }
        return US_SYMBOLS;
    }

    public IllegalFormatConversionException_ getConversionException() {
        return new IllegalFormatConversionException_(this.getConversionType(), this.getArgument().getClass());
    }

    public boolean isUpperCase() {
        return Character.isUpperCase(this.getConversionType());
    }

    public boolean isFlag(char c2) {
        return this.flags.indexOf(c2) >= 0;
    }

    public Object getArgument() {
        if (!this.effectiveIndexComputed) {
            this.computeEffectiveIndex();
            this.effectiveIndexComputed = true;
        }
        return this.arguments[this.effectiveIndex - 1];
    }

    private void computeEffectiveIndex() {
        if (this.flags.indexOf(60) < 0) {
            int n2 = this.effectiveIndex = this.explicitIndex != -1 ? this.explicitIndex : (this.ordinaryIndex = this.ordinaryIndex + 1);
        }
        if (this.arguments == null || this.effectiveIndex == 0 || this.effectiveIndex > this.arguments.length) {
            throw new MissingFormatArgumentException_(this.specifier);
        }
    }

    public void writeRestricted(String s2) {
        this.writePadded(this.precision != -1 && this.precision < s2.length() ? s2.substring(0, this.precision) : s2);
    }

    public void writePadded(String s2) {
        if (this.isFlag('-')) {
            this.writeCaseSensitive(s2);
            this.writePadding(s2);
        } else {
            this.writePadding(s2);
            this.writeCaseSensitive(s2);
        }
    }

    private void writePadding(String s2) {
        for (int i2 = this.width - s2.length(); i2 > 0; --i2) {
            this.append(' ');
        }
    }

    private void writeCaseSensitive(String s2) {
        if (this.isUpperCase()) {
            this.append(s2.toUpperCase());
        } else {
            this.append(s2);
        }
    }

    public void assertNoFlag(char flag) {
        if (this.isFlag(flag)) {
            throw new FormatFlagsConversionMismatchException_(this.flags, this.getConversionType());
        }
    }

    public void assertNoPrecision() {
        if (this.precision != -1) {
            throw new IllegalFormatPrecisionException_(this.precision);
        }
    }

    public void assertNoWidth() {
        if (this.width != -1) {
            throw new IllegalFormatWidthException_(this.width);
        }
    }

    public void checkWidth() {
        if ((this.isFlag('-') || this.isFlag('0')) && this.width == -1) {
            throw new MissingFormatWidthException_(this.specifier);
        }
    }

    public void checkFlags() {
        if (this.isFlag('+') && this.isFlag(' ') || this.isFlag('-') && this.isFlag('0')) {
            throw new IllegalFormatFlagsException_(this.flags);
        }
    }
}

