/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr.retro.net.sf.retrotranslator.runtime.java.lang;

public class _Character {
    private static final int SURROGATE_MASK = 1023;
    private static final Character[] cache = new Character[128];

    public static int charCount(int codePoint) {
        return codePoint < 65536 ? 1 : 2;
    }

    public static int codePointAt(char[] chars, int index) {
        return _Character.codePointAt(chars, index, chars.length);
    }

    public static int codePointAt(char[] chars, int index, int limit) {
        char lowChar;
        if (index >= limit || limit < 0 || limit > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        char highChar = chars[index];
        if (_Character.isHighSurrogate(highChar) && ++index < limit && _Character.isLowSurrogate(lowChar = chars[index])) {
            return _Character.toCodePoint(highChar, lowChar);
        }
        return highChar;
    }

    public static int codePointAt(CharSequence sequence, int index) {
        char lowChar;
        char highChar = sequence.charAt(index);
        if (_Character.isHighSurrogate(highChar) && ++index < sequence.length() && _Character.isLowSurrogate(lowChar = sequence.charAt(index))) {
            return _Character.toCodePoint(highChar, lowChar);
        }
        return highChar;
    }

    public static int codePointBefore(char[] chars, int index) {
        return _Character.codePointBefore(chars, index, 0);
    }

    public static int codePointBefore(char[] chars, int index, int start) {
        char highChar;
        char lowChar;
        if (index <= start || start < 0 || start >= chars.length) {
            throw new IndexOutOfBoundsException();
        }
        if (_Character.isLowSurrogate(lowChar = chars[--index]) && index > start && _Character.isHighSurrogate(highChar = chars[index - 1])) {
            return _Character.toCodePoint(highChar, lowChar);
        }
        return lowChar;
    }

    public static int codePointBefore(CharSequence sequence, int index) {
        char highChar;
        char lowChar;
        if (_Character.isLowSurrogate(lowChar = sequence.charAt(--index)) && index > 0 && _Character.isHighSurrogate(highChar = sequence.charAt(index - 1))) {
            return _Character.toCodePoint(highChar, lowChar);
        }
        return lowChar;
    }

    public static int codePointCount(char[] chars, int offset, int count) {
        int endIndex = offset + count;
        if (offset < 0 || offset > endIndex || endIndex > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        int i2 = offset;
        while (i2 < endIndex) {
            if (_Character.isHighSurrogate(chars[i2++]) && i2 < endIndex && _Character.isLowSurrogate(chars[i2])) {
                ++i2;
            }
            ++result;
        }
        return result;
    }

    public static int codePointCount(CharSequence sequence, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        int i2 = beginIndex;
        while (i2 < endIndex) {
            if (_Character.isHighSurrogate(sequence.charAt(i2++)) && i2 < endIndex && _Character.isLowSurrogate(sequence.charAt(i2))) {
                ++i2;
            }
            ++result;
        }
        return result;
    }

    public static int digit(int codePoint, int radix) {
        return _Character.isBasic(codePoint) ? Character.digit((char)codePoint, radix) : -1;
    }

    public static byte getDirectionality(int codePoint) {
        return _Character.isBasic(codePoint) ? Character.getDirectionality((char)codePoint) : (byte)-1;
    }

    public static int getNumericValue(int codePoint) {
        return _Character.isBasic(codePoint) ? Character.getNumericValue((char)codePoint) : -1;
    }

    public static int getType(int codePoint) {
        return _Character.isBasic(codePoint) ? Character.getType((char)codePoint) : 0;
    }

    public static boolean isDefined(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isDefined((char)codePoint);
    }

    public static boolean isDigit(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isDigit((char)codePoint);
    }

    public static boolean isHighSurrogate(char aChar) {
        return aChar >= '\ud800' && aChar <= '\udbff';
    }

    public static boolean isIdentifierIgnorable(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isIdentifierIgnorable((char)codePoint);
    }

    public static boolean isISOControl(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isISOControl((char)codePoint);
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isJavaIdentifierPart((char)codePoint);
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isJavaIdentifierStart((char)codePoint);
    }

    public static boolean isLetter(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isLetter((char)codePoint);
    }

    public static boolean isLetterOrDigit(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isLetterOrDigit((char)codePoint);
    }

    public static boolean isLowerCase(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isLowerCase((char)codePoint);
    }

    public static boolean isLowSurrogate(char aChar) {
        return aChar >= '\udc00' && aChar <= '\udfff';
    }

    public static boolean isMirrored(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isMirrored((char)codePoint);
    }

    public static boolean isSpaceChar(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isSpaceChar((char)codePoint);
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static boolean isSurrogatePair(char highChar, char lowChar) {
        return _Character.isHighSurrogate(highChar) && _Character.isLowSurrogate(lowChar);
    }

    public static boolean isTitleCase(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isTitleCase((char)codePoint);
    }

    public static boolean isUnicodeIdentifierPart(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isUnicodeIdentifierPart((char)codePoint);
    }

    public static boolean isUnicodeIdentifierStart(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isUnicodeIdentifierStart((char)codePoint);
    }

    public static boolean isUpperCase(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isUpperCase((char)codePoint);
    }

    public static boolean isValidCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 0x10FFFF;
    }

    public static boolean isWhitespace(int codePoint) {
        return _Character.isBasic(codePoint) && Character.isWhitespace((char)codePoint);
    }

    public static int offsetByCodePoints(char[] chars, int start, int count, int index, int codePointOffset) {
        int endIndex = start + count;
        if (start < 0 || start > endIndex || endIndex > chars.length || index < start || index > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset >= 0) {
            for (int i2 = 0; i2 < codePointOffset; ++i2) {
                if (index >= endIndex) {
                    throw new IndexOutOfBoundsException();
                }
                if (!_Character.isHighSurrogate(chars[index++]) || index >= endIndex || !_Character.isLowSurrogate(chars[index])) continue;
                ++index;
            }
        } else {
            for (int i3 = codePointOffset; i3 < 0; ++i3) {
                if (index <= start) {
                    throw new IndexOutOfBoundsException();
                }
                if (!_Character.isLowSurrogate(chars[--index]) || index <= start || !_Character.isHighSurrogate(chars[index - 1])) continue;
                --index;
            }
        }
        return index;
    }

    public static int offsetByCodePoints(CharSequence sequence, int index, int codePointOffset) {
        if (index < 0 || index > sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset >= 0) {
            for (int i2 = 0; i2 < codePointOffset; ++i2) {
                if (!_Character.isHighSurrogate(sequence.charAt(index++)) || index >= sequence.length() || !_Character.isLowSurrogate(sequence.charAt(index))) continue;
                ++index;
            }
        } else {
            for (int i3 = codePointOffset; i3 < 0; ++i3) {
                if (!_Character.isLowSurrogate(sequence.charAt(--index)) || index <= 0 || !_Character.isHighSurrogate(sequence.charAt(index - 1))) continue;
                --index;
            }
        }
        return index;
    }

    public static char reverseBytes(char ch2) {
        return (char)(ch2 >> 8 & 0xFF | ch2 << 8);
    }

    public static char[] toChars(int codePoint) {
        char[] chars = new char[_Character.charCount(codePoint)];
        _Character.toChars(codePoint, chars, 0);
        return chars;
    }

    public static int toChars(int codePoint, char[] chars, int index) {
        if (!_Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        if (codePoint < 65536) {
            chars[index] = (char)codePoint;
            return 1;
        }
        chars[index] = (char)(codePoint - 65536 >>> 10 | 0xD800);
        chars[index + 1] = (char)(codePoint & 0x3FF | 0xDC00);
        return 2;
    }

    public static int toCodePoint(char highChar, char lowChar) {
        return ((highChar & 0x3FF) << 10 | lowChar & 0x3FF) + 65536;
    }

    public static int toLowerCase(int codePoint) {
        return _Character.isBasic(codePoint) ? (int)Character.toLowerCase((char)codePoint) : codePoint;
    }

    public static int toTitleCase(int codePoint) {
        return _Character.isBasic(codePoint) ? (int)Character.toTitleCase((char)codePoint) : codePoint;
    }

    public static int toUpperCase(int codePoint) {
        return _Character.isBasic(codePoint) ? (int)Character.toUpperCase((char)codePoint) : codePoint;
    }

    public static Character valueOf(char c2) {
        return c2 <= '\u007f' ? cache[c2] : new Character(c2);
    }

    private static boolean isBasic(int codePoint) {
        return codePoint >= 0 && codePoint < 65536;
    }

    static {
        for (int i2 = 0; i2 < cache.length; ++i2) {
            _Character.cache[i2] = new Character((char)i2);
        }
    }
}

