/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr;

import com.aspose.omr.Dimension2D;
import com.aspose.omr.OmrConfig;
import com.aspose.omr.OmrElement;
import com.aspose.omr.OmrImage;
import com.aspose.omr.StringDictionary;
import com.aspose.omr.d;
import com.aspose.omr.internal.an;
import com.aspose.omr.internal.ba;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class BarcodeElement
extends OmrElement {
    private long a = 0x7FFFFFFFFFFFFL;

    public BarcodeElement(String name, Point2D.Float position, Dimension2D.Float size) {
        super(name, position, size);
    }

    public void setBarCodeType(long barcodeType) throws IllegalArgumentException {
        boolean bl2 = false;
        try {
            Field[] fieldArray;
            Class<?> clazz = Class.forName("com.aspose.barcoderecognition.BarCodeReadType");
            for (Field field : fieldArray = clazz.getFields()) {
                long l2;
                if (field.getType() != Long.TYPE || (l2 = field.getLong(null)) != barcodeType) continue;
                bl2 = true;
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Cannot load com.aspose.barcoderecognition.BarCodeReader", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Cannot load com.aspose.barcoderecognition.BarCodeReader", illegalAccessException);
        }
        if (!bl2) {
            throw new IllegalArgumentException("The specified barcode type is not valid. See the com.aspose.barcoderecognition.BarCodeReadType for the list of possible values.");
        }
        this.a = barcodeType;
    }

    public long getBarCodeType() {
        return this.a;
    }

    @Override
    public String extractData(OmrImage image, OmrConfig ignored) {
        Class<?> clazz;
        BufferedImage bufferedImage = image.asBitmap();
        Point2D.Float float_ = this.getPosition();
        Dimension2D.Float float_2 = this.getSize();
        Rectangle rectangle = d.a(new Rectangle2D.Float(float_.x, float_.y, float_2.width, float_2.height), image.getResolution());
        rectangle = d.a(rectangle, image);
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            clazz = Class.forName("com.aspose.barcoderecognition.BarCodeReader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Cannot load com.aspose.barcoderecognition.BarCodeReader", classNotFoundException);
        }
        String string = "";
        try {
            Constructor<?> constructor = clazz.getConstructor(BufferedImage.class);
            Object obj = constructor.newInstance(bufferedImage2);
            constructor = clazz.getConstructor(BufferedImage.class, Long.TYPE);
            obj = constructor.newInstance(bufferedImage2, this.a);
            Boolean bl2 = (Boolean)clazz.getMethod("read", new Class[0]).invoke(obj, new Object[0]);
            if (bl2.booleanValue()) {
                string = (String)clazz.getMethod("getCodeText", new Class[0]).invoke(obj, new Object[0]);
            }
            clazz.getMethod("close", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException("Unknown version of barcode reader", noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException("Unknown version of barcode reader", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unknown version of barcode reader", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Error during extraction of barcode value", invocationTargetException);
        }
        return string;
    }

    @Override
    public void loadProperties(StringDictionary properties) {
        super.loadProperties(properties);
        if (properties.containsKey("BarCodeReadType")) {
            Long l2;
            String string = properties.get("BarCodeReadType");
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid BarCodeReadType value. The value is not a Long type.");
            }
            this.a = l2;
        }
    }

    @Override
    public StringDictionary saveProperties() {
        StringDictionary stringDictionary = super.saveProperties();
        if (this.a != 0x7FFFFFFFFFFFFL) {
            stringDictionary.put("BarCodeReadType", ba.a(this.a, an.a()));
        }
        return stringDictionary;
    }
}

