/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr;

import com.aspose.omr.BasicElement;
import com.aspose.omr.CustomImageProcessing;
import com.aspose.omr.Dimension2D;
import com.aspose.omr.IProcessingAlgorithm;
import com.aspose.omr.OmrConfig;
import com.aspose.omr.OmrImage;
import com.aspose.omr.OmrPage;
import com.aspose.omr.OmrProcessingResult;
import com.aspose.omr.OmrTemplate;
import com.aspose.omr.ProcessingPipeline;
import com.aspose.omr.StringDictionary;
import com.aspose.omr.d;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class OmrEngine {
    private final ProcessingPipeline a;
    private OmrTemplate b;
    private OmrConfig c;

    public OmrEngine(OmrTemplate template) {
        this(template, ProcessingPipeline.getDefault());
    }

    public OmrEngine(OmrTemplate template, ProcessingPipeline pipeline) {
        if (template == null) {
            throw new IllegalArgumentException("template");
        }
        this.b = template;
        this.a = pipeline;
        this.c = new OmrConfig();
    }

    public OmrTemplate getTemplate() {
        return this.b;
    }

    public void setTemplate(OmrTemplate value) {
        this.b = value;
    }

    public ProcessingPipeline getProcessingPipeline() {
        return this.a;
    }

    public OmrConfig getConfiguration() {
        return this.c;
    }

    public void setConfiguration(OmrConfig value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        this.c = value;
    }

    public void changeProcessingPipeline(ProcessingPipeline newPipeline) {
        this.a.clear();
        for (IProcessingAlgorithm iProcessingAlgorithm : newPipeline) {
            this.a.add(iProcessingAlgorithm);
        }
    }

    public OmrProcessingResult extractData(OmrImage[] documentImages) {
        if (documentImages == null) {
            throw new IllegalArgumentException("documentImages");
        }
        if (this.b == null) {
            throw new IllegalArgumentException("No template is set");
        }
        int n2 = 0;
        StringDictionary[] stringDictionaryArray = new StringDictionary[this.b.getPages().size()];
        for (OmrImage omrImage : documentImages) {
            StringDictionary stringDictionary;
            if (n2 >= this.b.getPages().size()) {
                throw new IllegalArgumentException("Number of images does not match number of pages in the template");
            }
            if (omrImage == null) {
                stringDictionary = null;
            } else {
                OmrPage omrPage = (OmrPage)this.b.getPages().get(n2);
                this.a(omrImage, omrPage);
                stringDictionary = omrPage.extractData(omrImage, this.c);
            }
            stringDictionaryArray[n2] = stringDictionary;
            ++n2;
        }
        if (n2 < this.b.getPages().size() - 1) {
            throw new IllegalArgumentException("Number of images does not match number of pages in the template");
        }
        return new OmrProcessingResult(stringDictionaryArray);
    }

    private void a(OmrImage omrImage, OmrPage omrPage) {
        for (BasicElement basicElement : omrPage.getElements()) {
            boolean bl2 = basicElement.getClass().isAnnotationPresent(CustomImageProcessing.class);
            if (bl2) continue;
            Point2D.Float float_ = basicElement.getPosition();
            Dimension2D.Float float_2 = basicElement.getSize();
            Rectangle2D.Float float_3 = new Rectangle2D.Float(float_.x, float_.y, float_2.width, float_2.height);
            Rectangle rectangle = d.a(float_3, omrImage.getResolution());
            this.a.process(omrImage, rectangle);
        }
    }
}

