/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr;

import com.aspose.omr.Dimension2D;
import com.aspose.omr.OmrConfig;
import com.aspose.omr.OmrElement;
import com.aspose.omr.OmrImage;
import com.aspose.omr.d;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;

public class TextOcrElement
extends OmrElement {
    private static String a;

    public TextOcrElement(String name, Point2D.Float position, Dimension2D.Float size) {
        super(name, position, size);
    }

    public static String getResource() {
        return a;
    }

    public static void setResource(String value) {
        a = value;
    }

    @Override
    public String extractData(OmrImage image, OmrConfig ignored) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        File file;
        if (image == null) {
            throw new IllegalArgumentException("image");
        }
        if (a == null) {
            throw new IllegalArgumentException("Resource path is not set.");
        }
        BufferedImage bufferedImage = image.asBitmap();
        Point2D.Float float_ = this.getPosition();
        Dimension2D.Float float_2 = this.getSize();
        Rectangle rectangle = d.a(new Rectangle2D.Float(float_.x, float_.y, float_2.width, float_2.height), image.getResolution());
        if (rectangle.getX() < 0.0 || rectangle.getX() >= (double)image.getWidth() || rectangle.getY() < 0.0 || rectangle.getY() >= (double)image.getHeight() || rectangle.getWidth() <= 0.0 || rectangle.getHeight() <= 0.0 || rectangle.getX() + rectangle.getWidth() >= (double)image.getWidth() || rectangle.getY() + rectangle.getHeight() >= (double)image.getHeight()) {
            throw new IllegalArgumentException("The specified Text OCR rectangle is not valid and is empty or lies out of image bounds. Please note that dimensions are set in millimeters.");
        }
        rectangle = d.a(rectangle, image);
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            file = File.createTempFile("ocr", ".png");
            file.deleteOnExit();
            ImageIO.write((RenderedImage)bufferedImage2, "png", file);
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException(iOException);
        }
        String string = "";
        try {
            clazz3 = Class.forName("com.aspose.ocr.OcrEngine");
            clazz2 = Class.forName("com.aspose.ocr.ImageStream");
            clazz = Class.forName("com.aspose.ocr.IImageStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Unsupported version of Aspose.OCR.", classNotFoundException);
        }
        FileInputStream fileInputStream = null;
        try {
            Constructor<?> constructor = clazz3.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Object object = clazz2.getMethod("fromFile", String.class).invoke(null, file.getAbsolutePath());
            clazz3.getMethod("setImage", clazz).invoke(obj, object);
            fileInputStream = new FileInputStream(a);
            clazz3.getMethod("setResource", InputStream.class).invoke(obj, fileInputStream);
            Boolean bl2 = (Boolean)clazz3.getMethod("process", new Class[0]).invoke(obj, new Object[0]);
            if (bl2.booleanValue()) {
                string = clazz3.getMethod("getText", new Class[0]).invoke(obj, new Object[0]).toString();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Resource file not found.", fileNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException("Unknown version of OCR library", noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException("Unknown version of OCR library", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unknown version of OCR library", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Error during OCR", invocationTargetException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }
}

