/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OmrImage {
    public static final int BUFFER_PIXEL_FORMAT = 5;
    public static final int BYTES_PER_PIXEL = 3;
    private final int a;
    private final int b;
    private final double c;
    private final byte[] d;

    public OmrImage(int width, int height, double dpi, byte[] pixelData) {
        this.a = width;
        this.b = height;
        this.c = dpi;
        this.d = pixelData;
    }

    public byte[] getBuffer() {
        return this.d;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public double getResolution() {
        return this.c;
    }

    static OmrImage a(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        if (inputStream == null || !inputStream.markSupported()) {
            throw new IllegalArgumentException("stream");
        }
        inputStream.mark(Integer.MAX_VALUE);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            throw new UnsupportedOperationException("No reader for this format");
        }
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream);
        IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
        Element element = (Element)iIOMetadata.getAsTree("javax_imageio_1.0");
        NodeList nodeList = element.getElementsByTagName("HorizontalPixelSize");
        double d2 = 72.0;
        if (nodeList.getLength() > 0) {
            object2 = (IIOMetadataNode)nodeList.item(0);
            object = ((IIOMetadataNode)object2).getAttribute("value");
            double d3 = Double.parseDouble((String)object);
            d2 = 25.4 / d3;
        }
        inputStream.reset();
        object2 = ImageIO.read(inputStream);
        object = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), 5);
        ((BufferedImage)object).getGraphics().drawImage((Image)object2, 0, 0, null);
        byte[] byArray = ((DataBufferByte)((BufferedImage)object).getRaster().getDataBuffer()).getData();
        return new OmrImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), d2, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmrImage load(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName");
        }
        OmrImage omrImage = null;
        FileInputStream fileInputStream = new FileInputStream(fileName);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        try {
            omrImage = OmrImage.a(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        return omrImage;
    }

    public BufferedImage asBitmap() {
        BufferedImage bufferedImage = new BufferedImage(this.a, this.b, 5);
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        System.arraycopy(this.d, 0, byArray, 0, byArray.length);
        return bufferedImage;
    }

    public OmrImage copy() {
        byte[] byArray = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray, 0, this.d.length);
        return new OmrImage(this.a, this.b, this.c, byArray);
    }
}

