/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr;

import com.aspose.omr.AverageThresholdAlgorithm;
import com.aspose.omr.GrayscaleAlgorithm;
import com.aspose.omr.IProcessingAlgorithm;
import com.aspose.omr.OmrImage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingPipeline
extends ArrayList<IProcessingAlgorithm>
implements IProcessingAlgorithm {
    public ProcessingPipeline() {
    }

    public ProcessingPipeline(List<IProcessingAlgorithm> algorithms) {
        if (algorithms == null) {
            throw new IllegalArgumentException("algorithms");
        }
        for (IProcessingAlgorithm iProcessingAlgorithm : algorithms) {
            this.add(iProcessingAlgorithm);
        }
    }

    public static ProcessingPipeline getDefault() {
        return ProcessingPipeline.a();
    }

    @Override
    public void process(OmrImage image, Rectangle area) {
        for (IProcessingAlgorithm iProcessingAlgorithm : this) {
            iProcessingAlgorithm.process(image, area);
        }
    }

    private static ProcessingPipeline a() {
        ProcessingPipeline processingPipeline = new ProcessingPipeline();
        processingPipeline.add(new GrayscaleAlgorithm());
        processingPipeline.add(new AverageThresholdAlgorithm());
        return processingPipeline;
    }
}

