/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent;

import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.AbstractCollection;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.AbstractMap;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.AbstractSet;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements ConcurrentMap,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    transient Set keySet;
    transient Set entrySet;
    transient Collection values;

    private static int hash(int h2) {
        h2 += h2 << 15 ^ 0xFFFFCD7D;
        h2 ^= h2 >>> 10;
        h2 += h2 << 3;
        h2 ^= h2 >>> 6;
        h2 += (h2 << 2) + (h2 << 14);
        return h2 ^ h2 >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c2;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c2 = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c2;
        }
        for (cap = 1; cap < c2; cap <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = new Segment(cap, loadFactor);
        }
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map m2) {
        this(Math.max((int)((float)m2.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m2);
    }

    public boolean isEmpty() {
        int i2;
        Segment[] segments = this.segments;
        int[] mc2 = new int[segments.length];
        int mcsum = 0;
        for (i2 = 0; i2 < segments.length; ++i2) {
            if (segments[i2].count != 0) {
                return false;
            }
            mc2[i2] = segments[i2].modCount;
            mcsum += mc2[i2];
        }
        if (mcsum != 0) {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (segments[i2].count == 0 && mc2[i2] == segments[i2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc2 = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            int i2;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)segments[i2].count;
                mc2[i2] = segments[i2].modCount;
                mcsum += mc2[i2];
            }
            if (mcsum != 0) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    check += (long)segments[i2].count;
                    if (mc2[i2] == segments[i2].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i3;
            sum = 0L;
            for (i3 = 0; i3 < segments.length; ++i3) {
                segments[i3].lock();
            }
            for (i3 = 0; i3 < segments.length; ++i3) {
                sum += (long)segments[i3].count;
            }
            for (i3 = 0; i3 < segments.length; ++i3) {
                segments[i3].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public Object get(Object key) {
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(Object key) {
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment[] segments = this.segments;
        int[] mc2 = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            boolean sum = false;
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                int c2 = segments[i2].count;
                mc2[i2] = segments[i2].modCount;
                mcsum += mc2[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    int c3 = segments[i3].count;
                    if (mc2[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i4 = 0; i4 < segments.length; ++i4) {
            segments[i4].lock();
        }
        boolean found = false;
        try {
            for (int i5 = 0; i5 < segments.length; ++i5) {
                if (!segments[i5].containsValue(value)) continue;
                found = true;
                break;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            for (int i6 = 0; i6 < segments.length; ++i6) {
                segments[i6].unlock();
            }
            throw throwable;
        }
        for (int i6 = 0; i6 < segments.length; ++i6) {
            segments[i6].unlock();
        }
        return found;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    public Object putIfAbsent(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    public void putAll(Map m2) {
        Iterator it2 = m2.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry e2 = it2.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    public Object remove(Object key) {
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    public Object replace(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, value);
    }

    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].clear();
        }
    }

    public Set keySet() {
        Set ks2 = this.keySet;
        return ks2 != null ? ks2 : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es2 = this.entrySet;
        return es2 != null ? es2 : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int k2 = 0; k2 < this.segments.length; ++k2) {
            Segment seg = this.segments[k2];
            seg.lock();
            try {
                HashEntry[] tab = seg.table;
                for (int i2 = 0; i2 < tab.length; ++i2) {
                    HashEntry e2 = tab[i2];
                    while (e2 != null) {
                        s2.writeObject(e2.key);
                        s2.writeObject(e2.value);
                        e2 = e2.next;
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s2.writeObject(null);
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].setTable(new HashEntry[1]);
        }
        while (true) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    final class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object v2 = ConcurrentHashMap.this.get(e2.getKey());
            return v2 != null && v2.equals(e2.getValue());
        }

        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return ConcurrentHashMap.this.remove(e2.getKey(), e2.getValue());
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object o2) {
            return ConcurrentHashMap.this.containsValue(o2);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object o2) {
            return ConcurrentHashMap.this.containsKey(o2);
        }

        public boolean remove(Object o2) {
            return ConcurrentHashMap.this.remove(o2) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator {
        EntryIterator() {
        }

        public Object next() {
            HashEntry e2 = super.nextEntry();
            return new WriteThroughEntry(e2.key, e2.value);
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry {
        WriteThroughEntry(Object k2, Object v2) {
            super(k2, v2);
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(value);
            ConcurrentHashMap.this.put(this.getKey(), value);
            return v2;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        ValueIterator() {
        }

        public Object next() {
            return super.nextEntry().value;
        }

        public Object nextElement() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        KeyIterator() {
        }

        public Object next() {
            return super.nextEntry().key;
        }

        public Object nextElement() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j2 = this.currentTable.length - 1; j2 >= 0; --j2) {
                    this.nextEntry = this.currentTable[j2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j2 - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static final class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf2) {
            this.loadFactor = lf2;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static final Segment[] newArray(int i2) {
            return new Segment[i2];
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object readValueUnderLock(HashEntry e2) {
            this.lock();
            try {
                Object object = e2.value;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        Object get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e2 = this.getFirst(hash);
                while (e2 != null) {
                    if (e2.hash == hash && key.equals(e2.key)) {
                        Object v2 = e2.value;
                        if (v2 != null) {
                            return v2;
                        }
                        return this.readValueUnderLock(e2);
                    }
                    e2 = e2.next;
                }
            }
            return null;
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e2 = this.getFirst(hash);
                while (e2 != null) {
                    if (e2.hash == hash && key.equals(e2.key)) {
                        return true;
                    }
                    e2 = e2.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                int len = tab.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    HashEntry e2 = tab[i2];
                    while (e2 != null) {
                        Object v2 = e2.value;
                        if (v2 == null) {
                            v2 = this.readValueUnderLock(e2);
                        }
                        if (value.equals(v2)) {
                            return true;
                        }
                        e2 = e2.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(Object key, int hash, Object oldValue, Object newValue) {
            this.lock();
            try {
                HashEntry e2 = this.getFirst(hash);
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                boolean replaced = false;
                if (e2 != null && oldValue.equals(e2.value)) {
                    replaced = true;
                    e2.value = newValue;
                }
                boolean bl2 = replaced;
                return bl2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object replace(Object key, int hash, Object newValue) {
            this.lock();
            try {
                HashEntry e2 = this.getFirst(hash);
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                Object oldValue = null;
                if (e2 != null) {
                    oldValue = e2.value;
                    e2.value = newValue;
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object put(Object key, int hash, Object value, boolean onlyIfAbsent) {
            this.lock();
            try {
                Object oldValue;
                HashEntry first;
                int c2 = this.count;
                if (c2++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e2 = first = tab[index];
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    oldValue = e2.value;
                    if (!onlyIfAbsent) {
                        e2.value = value;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new HashEntry(key, hash, first, value);
                    this.count = c2;
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                int k2;
                HashEntry e2 = oldTable[i2];
                if (e2 == null) continue;
                HashEntry next = e2.next;
                int idx = e2.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e2;
                    continue;
                }
                HashEntry lastRun = e2;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k2 = last.hash & sizeMask;
                    if (k2 != lastIdx) {
                        lastIdx = k2;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p2 = e2;
                while (p2 != lastRun) {
                    k2 = p2.hash & sizeMask;
                    HashEntry n2 = newTable[k2];
                    newTable[k2] = new HashEntry(p2.key, p2.hash, n2, p2.value);
                    p2 = p2.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object remove(Object key, int hash, Object value) {
            this.lock();
            try {
                HashEntry first;
                int c2 = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e2 = first = tab[index];
                while (!(e2 == null || e2.hash == hash && key.equals(e2.key))) {
                    e2 = e2.next;
                }
                Object oldValue = null;
                if (e2 != null) {
                    Object v2 = e2.value;
                    if (value == null || value.equals(v2)) {
                        oldValue = v2;
                        ++this.modCount;
                        HashEntry newFirst = e2.next;
                        HashEntry p2 = first;
                        while (p2 != e2) {
                            newFirst = new HashEntry(p2.key, p2.hash, newFirst, p2.value);
                            p2 = p2.next;
                        }
                        tab[index] = newFirst;
                        this.count = c2;
                    }
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry[] tab = this.table;
                    for (int i2 = 0; i2 < tab.length; ++i2) {
                        tab[i2] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry next;

        HashEntry(Object key, int hash, HashEntry next, Object value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        static final HashEntry[] newArray(int i2) {
            return new HashEntry[i2];
        }
    }
}

