/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.helpers;

import [Ljava.lang.Object;;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.Arrays;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import sun.misc.Perf;

public final class Utils {
    private static final NanoTimer nanoTimer;
    private static final String providerProp = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(Condition cond, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return nanosTimeout;
        }
        long now = Utils.nanoTime();
        cond.await(nanosTimeout, TimeUnit.NANOSECONDS);
        return nanosTimeout - (Utils.nanoTime() - now);
    }

    private static long gcd(long a2, long b2) {
        while (b2 > 0L) {
            long r2 = a2 % b2;
            a2 = b2;
            b2 = r2;
        }
        return a2;
    }

    public static Object[] collectionToArray(Collection c2) {
        int len = c2.size();
        Object[] arr = new Object[len];
        Iterator itr = c2.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return Arrays.copyOf(arr, idx, Object;.class);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, array$Ljava$lang$Object == null ? Utils.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object);
            len = newcap;
        }
    }

    public static Object[] collectionToArray(Collection c2, Object[] a2) {
        Class<?> aType = a2.getClass();
        int len = c2.size();
        Object[] arr = a2.length >= len ? a2 : (Object[])Array.newInstance(aType.getComponentType(), len);
        Iterator itr = c2.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a2) {
                    a2[idx] = null;
                    return a2;
                }
                return Arrays.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }

    static {
        NanoTimer timer = null;
        try {
            String nanoTimerClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Utils.providerProp);
                }
            });
            if (nanoTimerClassName != null) {
                Class<?> cls = Class.forName(nanoTimerClassName);
                timer = (NanoTimer)cls.newInstance();
            }
        }
        catch (Exception e2) {
            System.err.println("WARNING: unable to load the system-property-defined nanotime provider; switching to the default");
            e2.printStackTrace();
        }
        if (timer == null) {
            try {
                timer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (timer == null) {
            timer = new MillisProvider();
        }
        nanoTimer = timer;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged(new PrivilegedAction(this){
            private final /* synthetic */ SunPerfProvider this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long numerator = 1000000000L;
            long denominator = this.perf.highResFrequency();
            long gcd = Utils.gcd(numerator, denominator);
            this.multiplier = numerator / gcd;
            this.divisor = denominator / gcd;
        }

        public long nanoTime() {
            long ctr = this.perf.highResCounter();
            return ctr / this.divisor * this.multiplier + ctr % this.divisor * this.multiplier / this.divisor;
        }
    }
}

