/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.locks;

import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import com.aspose.omr.retro.edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class FIFOCondVar
extends CondVar
implements Condition,
Serializable {
    private static final WaitQueue.QueuedSync sync = new WaitQueue.QueuedSync(){

        public boolean recheck(WaitQueue.WaitNode node) {
            return false;
        }

        public void takeOver(WaitQueue.WaitNode node) {
        }
    };
    private final WaitQueue wq = new FIFOWaitQueue();

    FIFOCondVar(CondVar.ExclusiveLock lock) {
        super(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode n2 = new WaitQueue.WaitNode();
        this.wq.insert(n2);
        for (int i2 = holdCount; i2 > 0; --i2) {
            this.lock.unlock();
        }
        try {
            n2.doWaitUninterruptibly(sync);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            for (int i3 = holdCount; i3 > 0; --i3) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i3 = holdCount; i3 > 0; --i3) {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaitQueue.WaitNode n2 = new WaitQueue.WaitNode();
        this.wq.insert(n2);
        for (int i2 = holdCount; i2 > 0; --i2) {
            this.lock.unlock();
        }
        try {
            n2.doWait(sync);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            for (int i3 = holdCount; i3 > 0; --i3) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i3 = holdCount; i3 > 0; --i3) {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        WaitQueue.WaitNode n2 = new WaitQueue.WaitNode();
        this.wq.insert(n2);
        boolean success = false;
        for (int i2 = holdCount; i2 > 0; --i2) {
            this.lock.unlock();
        }
        try {
            success = n2.doTimedWait(sync, nanos);
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            for (int i3 = holdCount; i3 > 0; --i3) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i3 = holdCount; i3 > 0; --i3) {
            this.lock.lock();
        }
        return success;
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        long abstime = deadline.getTime();
        long start = System.currentTimeMillis();
        long msecs = abstime - start;
        return this.await(msecs, TimeUnit.MILLISECONDS);
    }

    public void signal() {
        WaitQueue.WaitNode w2;
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        do {
            if ((w2 = this.wq.extract()) != null) continue;
            return;
        } while (!w2.signal(sync));
    }

    public void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode w2;
        while ((w2 = this.wq.extract()) != null) {
            w2.signal(sync);
        }
        return;
    }

    protected boolean hasWaiters() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.hasNodes();
    }

    protected int getWaitQueueLength() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getLength();
    }

    protected Collection getWaitingThreads() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getWaitingThreads();
    }
}

