/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.retro.net.sf.retrotranslator.runtime.format;

import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.CharacterConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.DateTimeConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.DecimalIntegralConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.FloatingPointConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.FormatContext;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.GeneralConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.HexadecimalExponentialConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.LineSeparatorConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.NondecimalIntegralConversion;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.format.PercentConversion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class Conversion {
    private static Map<String, Conversion> map = new HashMap<String, Conversion>();

    Conversion() {
    }

    public static Conversion getInstance(String code) {
        return map.get(code);
    }

    public abstract void format(FormatContext var1);

    private static void put(String lower, String upper, Conversion value) {
        map.put(lower, value);
        if (upper != null) {
            map.put(upper, value);
        }
    }

    static {
        Conversion.put("b", "B", new GeneralConversion.BooleanConversion());
        Conversion.put("h", "H", new GeneralConversion.HashConversion());
        Conversion.put("s", "S", new GeneralConversion.StringConversion());
        Conversion.put("c", "C", new CharacterConversion());
        Conversion.put("d", null, new DecimalIntegralConversion());
        Conversion.put("o", null, new NondecimalIntegralConversion.OctalConversion());
        Conversion.put("x", "X", new NondecimalIntegralConversion.HexadecimalConversion());
        Conversion.put("e", "E", new FloatingPointConversion.ComputerizedScientificConversion());
        Conversion.put("f", null, new FloatingPointConversion.DecimalConversion());
        Conversion.put("g", "G", new FloatingPointConversion.GeneralScientificConversion());
        Conversion.put("a", "A", new HexadecimalExponentialConversion());
        Conversion.put("%", null, new PercentConversion());
        Conversion.put("n", null, new LineSeparatorConversion());
        Iterator<Map.Entry<Character, DateTimeConversion>> i$ = DateTimeConversion.getConversions().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Character, DateTimeConversion> entry = i$.next();
            Character c2 = entry.getKey();
            Conversion.put("t" + c2, "T" + c2, entry.getValue());
        }
    }
}

