/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.retro.net.sf.retrotranslator.runtime.java.util;

import com.aspose.omr.retro.net.sf.retrotranslator.runtime.java.lang._IllegalArgumentException;
import com.aspose.omr.retro.net.sf.retrotranslator.runtime.java.lang._Long;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUID_
implements Serializable,
Comparable<UUID_> {
    private static final long serialVersionUID = 4759128571957838954L;
    private static final SecureRandom randomGenerator = new SecureRandom();
    private long mostSignificantBits;
    private long leastSignificantBits;

    public UUID_(long mostSigBits, long leastSigBits) {
        this.mostSignificantBits = mostSigBits;
        this.leastSignificantBits = leastSigBits;
    }

    public static UUID_ randomUUID() {
        byte[] bytes = new byte[16];
        randomGenerator.nextBytes(bytes);
        return UUID_.newInstance(bytes, 4);
    }

    public static UUID_ nameUUIDFromBytes(byte[] name) {
        try {
            return UUID_.newInstance(MessageDigest.getInstance("MD5").digest(name), 3);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new InternalError(e2.getMessage());
        }
    }

    public static UUID_ fromString(String name) {
        Long[] values = new Long[5];
        StringTokenizer tokenizer = new StringTokenizer(name, "-", true);
        try {
            for (int i2 = 0; i2 < 5; ++i2) {
                if (i2 > 0 && !tokenizer.nextToken().equals("-")) {
                    throw new IllegalArgumentException(name);
                }
                values[i2] = _Long.valueOf(Long.parseLong(tokenizer.nextToken(), 16));
            }
        }
        catch (NoSuchElementException e2) {
            _IllegalArgumentException.IllegalArgumentExceptionBuilder illegalArgumentExceptionBuilder = _IllegalArgumentException.createInstanceBuilder(name, e2);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(illegalArgumentExceptionBuilder.argument1());
            illegalArgumentExceptionBuilder.initialize(illegalArgumentException);
            throw illegalArgumentException;
        }
        while (tokenizer.hasMoreTokens()) {
            if (tokenizer.nextToken().equals("-")) continue;
            throw new IllegalArgumentException(name);
        }
        return new UUID_(values[0] << 32 | values[1] << 16 | values[2], values[3] << 48 | values[4]);
    }

    public long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public int version() {
        return (int)(this.mostSignificantBits >>> 12) & 0xF;
    }

    public int variant() {
        if (this.leastSignificantBits >>> 63 == 0L) {
            return 0;
        }
        if (this.leastSignificantBits >>> 62 == 2L) {
            return 2;
        }
        return (int)(this.leastSignificantBits >>> 61);
    }

    public long timestamp() {
        this.assertVersion1();
        return (this.mostSignificantBits & 0xFFFL) << 48 | (this.mostSignificantBits & 0xFFFF0000L) << 16 | this.mostSignificantBits >>> 32;
    }

    public int clockSequence() {
        this.assertVersion1();
        return (int)(this.leastSignificantBits >>> 48) & 0x3FFF;
    }

    public long node() {
        this.assertVersion1();
        return this.leastSignificantBits & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        return new StringBuffer().append(UUID_.hex(this.mostSignificantBits >> 32, 8)).append('-').append(UUID_.hex(this.mostSignificantBits >> 16, 4)).append('-').append(UUID_.hex(this.mostSignificantBits, 4)).append('-').append(UUID_.hex(this.leastSignificantBits >> 48, 4)).append('-').append(UUID_.hex(this.leastSignificantBits, 12)).toString();
    }

    public int hashCode() {
        return (int)(this.mostSignificantBits >> 32 ^ this.mostSignificantBits ^ this.leastSignificantBits >> 32 ^ this.leastSignificantBits);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UUID_) {
            UUID_ val = (UUID_)obj;
            return this.mostSignificantBits == val.mostSignificantBits && this.leastSignificantBits == val.leastSignificantBits;
        }
        return false;
    }

    @Override
    public int compareTo(UUID_ val) {
        if (this.mostSignificantBits > val.mostSignificantBits) {
            return 1;
        }
        if (this.mostSignificantBits < val.mostSignificantBits) {
            return -1;
        }
        if (this.leastSignificantBits > val.leastSignificantBits) {
            return 1;
        }
        if (this.leastSignificantBits < val.leastSignificantBits) {
            return -1;
        }
        return 0;
    }

    private static UUID_ newInstance(byte[] bytes, int version) {
        return new UUID_(UUID_.getLong(bytes, 0) & 0xFFFFFFFFFFFF0FFFL | (long)(version << 12), UUID_.getLong(bytes, 8) & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE);
    }

    private static long getLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            result = result << 8 | (long)(bytes[i2 + offset] & 0xFF);
        }
        return result;
    }

    private static String hex(long value, int length) {
        String s2 = Long.toHexString(1L << (length << 2) | value);
        return s2.substring(s2.length() - length);
    }

    private void assertVersion1() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a version 1 UUID");
        }
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((UUID_)x0);
    }
}

