/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.omr.retro.net.sf.retrotranslator.runtime.java.util.regex;

import com.aspose.omr.retro.net.sf.retrotranslator.runtime.java.lang._String;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class _Pattern {
    public static final int LITERAL = 16;
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(\\\\+)Q(.*?)(\\\\*)\\\\E");
    private static final String[][] REPLACEMENTS = new String[][]{{"\\p{javaDefined}", "\\P{Cn}"}, {"\\p{javaDigit}", "\\p{Nd}"}, {"\\p{javaIdentifierIgnorable}", "[\\u0000-\\u0008\\u000E-\\u001B\\u007F-\\u009F\\p{Cf}]"}, {"\\p{javaISOControl}", "\\p{Cc}"}, {"\\p{javaJavaIdentifierPart}", "[\\u0000-\\u0008\\u000E-\\u001B\\u007F-\\u009F\\p{Cf}\\p{L}\\p{Sc}\\p{Pc}\\p{Nd}\\p{Nl}\\p{Mc}\\p{Mn}]"}, {"\\p{javaJavaIdentifierStart}", "[\\p{L}\\p{Sc}\\p{Pc}\\p{Nl}]"}, {"\\p{javaLetter}", "\\p{L}"}, {"\\p{javaLetterOrDigit}", "[\\p{L}\\p{Nd}]"}, {"\\p{javaLowerCase}", "\\p{Ll}"}, {"\\p{javaSpaceChar}", "\\p{Z}"}, {"\\p{javaTitleCase}", "\\p{Lt}"}, {"\\p{javaUnicodeIdentifierPart}", "[\\u0000-\\u0008\\u000E-\\u001B\\u007F-\\u009F\\p{Cf}\\p{L}\\p{Pc}\\p{Nd}\\p{Nl}\\p{Mc}\\p{Mn}]"}, {"\\p{javaUnicodeIdentifierStart}", "[\\p{L}\\p{Nl}]"}, {"\\p{javaUpperCase}", "\\p{Lu}"}, {"\\p{javaWhitespace}", "[\\u0009-\\u000D\\u001C-\\u001F\\p{Z}&&[^\\u00A0\\u2007\\u202F]]"}};

    public static Pattern compile(String regex) {
        return Pattern.compile(_Pattern.fix(regex));
    }

    public static Pattern compile(String regex, int flags) {
        if ((flags & 0x10) == 16) {
            flags ^= 0x10;
            regex = _Pattern.quote(regex);
        }
        return Pattern.compile(_Pattern.fix(regex), flags);
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.matches(_Pattern.fix(regex), input);
    }

    private static String fix(String regex) {
        String[][] arr$ = REPLACEMENTS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] replacement = arr$[i$];
            regex = _String.replace(regex, replacement[0], replacement[1]);
        }
        return _Pattern.fixQuote(regex);
    }

    private static String fixQuote(String regex) {
        if (regex.indexOf("\\\\E") < 0) {
            return regex;
        }
        Matcher matcher = QUOTE_PATTERN.matcher(regex);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            boolean escaped = matcher.group(1).length() % 2 == 1;
            String replacement = escaped ? "$1Q$2\\\\E$3$3" : "$1Q$2$3\\\\E";
            matcher.appendReplacement(buffer, replacement);
        }
        return matcher.appendTail(buffer).toString();
    }

    public static String quote(String regex) {
        int nextIndex;
        StringBuffer builder = new StringBuffer(regex.length() + 4).append("\\Q");
        int lastIndex = 0;
        while ((nextIndex = regex.indexOf("\\E", lastIndex)) >= 0) {
            builder.append(regex.substring(lastIndex, nextIndex)).append("\\E\\\\E\\Q");
            lastIndex = nextIndex + 2;
        }
        return _Pattern.fixQuote(builder.append(regex.substring(lastIndex)).append("\\E").toString());
    }
}

