/*
 * Decompiled with CFR 0.152.
 */
package aspose.examplescenter.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.CodeSource;
import java.util.Scanner;

public class Util {
    public static String getPathOfRunningJar() throws Exception {
        String jarDir;
        try {
            CodeSource codeSource = Util.class.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            jarDir = jarFile.getParentFile().getPath();
        }
        catch (Exception ex) {
            throw new Exception("Could not find the path of running jar. Error: " + ex.getMessage());
        }
        return jarDir;
    }

    public static void checkAndCreateFolder(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    public static File[] getFilesList(String sourceFolder, final String endsWith) {
        File folder = new File(sourceFolder);
        File[] arrFile = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(endsWith);
            }
        });
        return arrFile;
    }

    public static File findFileWithMainMethod(String sourceFolder) throws Exception {
        File[] sourceFiles;
        for (File file : sourceFiles = Util.getFilesList(sourceFolder, ".java")) {
            String fileContents = new Scanner(file).useDelimiter("\\A").next();
            if (!fileContents.contains("public") || !fileContents.contains("static") || !fileContents.contains("void") || !fileContents.contains("main")) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void deleteFolderRecursive(File folder) {
        if (folder.isDirectory()) {
            for (File c : folder.listFiles()) {
                Util.deleteFolderRecursive(c);
            }
        }
        try {
            folder.delete();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

