/*
 * Decompiled with CFR 0.152.
 */
package aspose.examplescenter.gitutil;

import aspose.examplescenter.common.Util;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;

public class GitHelper {
    public static final String appFolder = "App";
    private final String appRemoteAddress = "https://github.com/AsposeExamples/java-examples-dashboard.git";
    private String jarDir = "";

    private void init() throws Exception {
        this.jarDir = Util.getPathOfRunningJar();
        Util.checkAndCreateFolder(this.jarDir + File.separator + appFolder);
    }

    public void updateAllRepositories() throws Exception {
        this.init();
        this.updateAppRepository();
    }

    private boolean isInternetReachable() {
        try {
            URL url = new URL("http://www.google.com");
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            Object object = urlConnect.getContent();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateRepository(String localPath, String remotePath) throws Exception {
        if (!this.isInternetReachable()) {
            throw new Exception("No internet connection available, please try again later.");
        }
        if (this.jarDir.isEmpty()) {
            throw new Exception("Jar dir is not set, call init() method.");
        }
        try {
            FileRepository localRepo = new FileRepository(localPath + "/.git");
            Git git = new Git((Repository)localRepo);
            System.out.println("Downloading the Examples Dashboard App from [" + remotePath + "]....");
            System.out.println("\nThis might take few minutes, please wait until files are downloaded.\n");
            try {
                Git.cloneRepository().setURI(remotePath).setDirectory(new File(localPath)).call();
                System.out.println("Successfully cloned repository.");
            }
            catch (Exception ex) {
                System.out.println("Clone failed. Trying to pull....");
                try {
                    git.reset().setMode(ResetCommand.ResetType.HARD).call();
                    git.pull().call();
                }
                catch (Exception exPull) {
                    System.out.println("Pull also failed.");
                    System.out.println("Cleaning the local repository and downloading all files again....");
                    Util.deleteFolderRecursive(new File(localPath));
                    Git.cloneRepository().setURI(remotePath).setDirectory(new File(localPath)).call();
                }
                System.out.println("Repository updated successfully.");
            }
        }
        catch (Exception ex) {
            throw new Exception("Could not download Repository from Github. Error: " + ex.getMessage());
        }
    }

    private void updateAppRepository() throws Exception {
        System.out.println("Updating Aspose Examples Dashboard Application....");
        this.updateRepository(this.jarDir + File.separator + appFolder, "https://github.com/AsposeExamples/java-examples-dashboard.git");
    }
}

