/*
 * Decompiled with CFR 0.152.
 */
package com.businessrefinery.barcodereader.core;

import com.businessrefinery.barcodereader.core.A.A;
import com.businessrefinery.barcodereader.core.B.E;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class BarcodeImage {
    public static int FOREGROUND = 0;
    public static int BACKGROUND = 1;
    boolean[] B = null;
    int[] C = null;
    BufferedImage D = null;
    int E = 0;
    int A = 0;

    public BarcodeImage(BufferedImage bufferedImage) {
        this.D = bufferedImage;
        this.B();
    }

    public BarcodeImage(BufferedImage bufferedImage, Rectangle rectangle) {
        BufferedImage bufferedImage2 = new BufferedImage(rectangle.width, rectangle.height, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.drawImage(bufferedImage, 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
        graphics2D.dispose();
        graphics2D = null;
        this.D = bufferedImage2;
        this.B();
    }

    public BarcodeImage(int n, int n2) {
        this(new BufferedImage(n, n2, 12));
    }

    public void initializePixels() {
        if (this.C == null) {
            this.A();
        }
    }

    private void A() {
        WritableRaster writableRaster = this.D.getRaster();
        int n = writableRaster.getNumBands();
        this.C = new int[this.A * this.E];
        if (n == 1) {
            writableRaster.getSamples(0, 0, this.E, this.A, 0, this.C);
        } else {
            writableRaster.getSamples(0, 0, this.E, this.A, 3, this.C);
            int[] nArray = writableRaster.getSamples(0, 0, this.E, this.A, 1, (int[])null);
            int[] nArray2 = writableRaster.getSamples(0, 0, this.E, this.A, 2, (int[])null);
            for (int i = 0; i < this.A; ++i) {
                for (int j = 0; j < this.E; ++j) {
                    this.C[j + i * this.E] = (nArray[j + i * this.E] << 16) + (nArray2[j + i * this.E] << 8) + this.C[j + i * this.E];
                }
            }
        }
    }

    public void memoryToImage() {
        long l = System.currentTimeMillis();
        WritableRaster writableRaster = this.D.getRaster();
        int n = writableRaster.getNumBands();
        if (n == 1) {
            writableRaster.setSamples(0, 0, this.E, this.A, 0, this.C);
        } else {
            for (int i = 0; i < this.A; ++i) {
                for (int j = 0; j < this.E; ++j) {
                    writableRaster.setSample(j, i, 1, this.getRedPixel(i, j));
                    writableRaster.setSample(j, i, 2, this.getGreenPixel(i, j));
                    writableRaster.setSample(j, i, 3, this.getBluePixel(i, j));
                }
            }
        }
    }

    private BufferedImage A(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        graphics2D = null;
        return bufferedImage2;
    }

    public void resetImage() {
        this.A();
    }

    private void B() {
        this.E = this.D.getWidth();
        this.A = this.D.getHeight();
    }

    public int getWidth() {
        return this.E;
    }

    public int getHeight() {
        return this.A;
    }

    public BufferedImage getBufferedImage() {
        return this.D;
    }

    public void setPixel(int n, int n2, int n3) {
        try {
            this.C[n2 + n * this.E] = n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("row = " + n + " col=" + n2);
            System.err.println("h = " + this.A + " w=" + this.E);
            throw new RuntimeException(exception);
        }
    }

    public void setPixel(E e, int n) {
        this.setPixel((int)e.B, (int)e.A, n);
    }

    public int getGreyPixel(double d, double d2) {
        int n = (int)Math.abs(d);
        int n2 = (int)Math.abs(d2);
        return (int)((double)this.getRedPixel(n, n2) * 0.33 + (double)this.getGreenPixel(n, n2) * 0.33 + (double)this.getBluePixel(n, n2) * 0.33 + 0.5);
    }

    public int getPixel(E e) {
        if (e == null) {
            return BACKGROUND;
        }
        return this.getPixel(e.B, e.A);
    }

    public int getPixel(double d, double d2) {
        return this.getPixel((int)Math.round(d), (int)Math.round(d2));
    }

    public int getPixel(int n, int n2) {
        if (n < 0) {
            return BACKGROUND;
        }
        if (n2 < 0) {
            return BACKGROUND;
        }
        if (n >= this.A) {
            return BACKGROUND;
        }
        if (n2 >= this.E) {
            return BACKGROUND;
        }
        return this.C[n2 + n * this.E];
    }

    public int getRedPixel(int n, int n2) {
        return (this.getPixel(n, n2) & 0xFF0000) >> 16;
    }

    public void setRPixel(int n, int n2, int n3) {
        int n4 = this.getPixel(n, n2);
        n4 = n4 & 0xFFFF | n3 << 16;
        this.setPixel(n, n2, n4);
    }

    public int getGreenPixel(int n, int n2) {
        return (this.getPixel(n, n2) & 0xFF00) >> 8;
    }

    public void setGPixel(int n, int n2, int n3) {
        int n4 = this.getPixel(n, n2);
        n4 = n4 & 0xFF00FF | n3 << 8;
        this.setPixel(n, n2, n4);
    }

    public int getBluePixel(int n, int n2) {
        return this.getPixel(n, n2) & 0xFF;
    }

    public void setBPixel(int n, int n2, int n3) {
        int n4 = this.getPixel(n, n2);
        n4 = n4 & 0xFFFF00 | n3;
        this.setPixel(n, n2, n4);
    }

    public void initializeVisited() {
        this.B = new boolean[this.E * this.A];
    }

    public void setVisited(E e) {
        this.setVisited((int)e.A, (int)e.B);
    }

    public void setVisited(int n, int n2) {
        this.B[n + n2 * this.E] = true;
    }

    public boolean getVisited(E e) {
        return this.getVisited((int)e.A, (int)e.B);
    }

    public boolean getVisited(int n, int n2) {
        return this.B[n + n2 * this.E];
    }

    public boolean isInPerimeter4(E e) {
        if (this.getPixel(this.getNeightbour(e, 1)) == BACKGROUND) {
            return true;
        }
        if (this.getPixel(this.getNeightbour(e, 3)) == BACKGROUND) {
            return true;
        }
        if (this.getPixel(this.getNeightbour(e, 5)) == BACKGROUND) {
            return true;
        }
        return this.getPixel(this.getNeightbour(e, 7)) == BACKGROUND;
    }

    public E getNeightbour(E e, int n) {
        if (n == 1 && e.A < (double)(this.getWidth() - 1)) {
            return new E(e.A + 1.0, e.B);
        }
        if (n == 8 && e.A < (double)(this.getWidth() - 1) && e.B > 0.0) {
            return new E(e.A + 1.0, e.B - 1.0);
        }
        if (n == 7 && e.B > 0.0) {
            return new E(e.A, e.B - 1.0);
        }
        if (n == 6 && e.A > 0.0 && e.B > 0.0) {
            return new E(e.A - 1.0, e.B - 1.0);
        }
        if (n == 5 && e.A > 0.0) {
            return new E(e.A - 1.0, e.B);
        }
        if (n == 4 && e.A > 0.0 && e.B < (double)(this.getHeight() - 1)) {
            return new E(e.A - 1.0, e.B + 1.0);
        }
        if (n == 3 && e.B < (double)(this.getHeight() - 1)) {
            return new E(e.A, e.B + 1.0);
        }
        if (n == 2 && e.B < (double)(this.getHeight() - 1) && e.A < (double)(this.getWidth() - 1)) {
            return new E(e.A + 1.0, e.B + 1.0);
        }
        return null;
    }

    public BarcodeImage toBackWhite() {
        if (System.getProperty("businessrefinery.barcodereader.bwconversion", "0").equalsIgnoreCase("threshold")) {
            this.initializePixels();
            return com.businessrefinery.barcodereader.core.A.A.C(this);
        }
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 12);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.drawImage((Image)this.getBufferedImage(), 0, 0, null);
        graphics2D.dispose();
        graphics2D = null;
        return new BarcodeImage(bufferedImage);
    }
}

