/*
 * Decompiled with CFR 0.152.
 */
package com.businessrefinery.barcodereader.linear;

import com.businessrefinery.barcodereader.core.BarcodeImage;
import com.businessrefinery.barcodereader.linear.A.A;
import com.businessrefinery.barcodereader.linear.A.B;
import com.businessrefinery.barcodereader.linear.A.C;
import com.businessrefinery.barcodereader.linear.A.F;
import com.businessrefinery.barcodereader.linear.A.G;
import com.businessrefinery.barcodereader.linear.A.H;
import com.businessrefinery.barcodereader.linear.A.I;
import com.businessrefinery.barcodereader.linear.A.J;
import com.businessrefinery.barcodereader.linear.A.K;
import com.businessrefinery.barcodereader.linear.LinearData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Vector;

public class LinearReader {
    public static int CODE128 = 1;
    public static int EAN8 = 2;
    public static int EAN13 = 4;
    public static int UPCA = 8;
    public static int UPCE = 16;
    public static int CODE39 = 32;
    public static int INTERLEAVED25 = 64;
    public static int IDENTCODE = 128;
    protected int barcodeType = CODE128;
    public boolean applyContrast = System.getProperty("com.businessrefinery.barcodereader.contrast", "0").equals("1");
    public boolean isBlackWhiteImage = false;
    private boolean A = System.getProperty("com.businessrefinery.barcodereader.debug", "0").equals("1");
    protected boolean checkSum = true;
    private com.businessrefinery.barcodereader.core.C.A.A C = null;
    private com.businessrefinery.barcodereader.core.C.A B = new com.businessrefinery.barcodereader.core.C.B.A();

    public void setBarcodeType(int n) {
        this.barcodeType = n;
    }

    public void setProgressListener(com.businessrefinery.barcodereader.core.C.A a) {
        this.B = a;
    }

    public LinearData[] read(BarcodeImage barcodeImage) throws com.businessrefinery.barcodereader.core.A {
        LinearData[] linearDataArray = this.A(barcodeImage);
        if (System.getProperty("com.businessrefinery.barcodereader.secondpass", "1").equals("1") && linearDataArray.length == 0) {
            barcodeImage.resetImage();
            this.applyContrast = !this.applyContrast;
            linearDataArray = this.A(barcodeImage);
        }
        return linearDataArray;
    }

    private LinearData[] A(BarcodeImage barcodeImage) {
        Object object;
        this.C = new com.businessrefinery.barcodereader.core.C.A.A(this.B, 5.0);
        Vector<LinearData> vector = new Vector<LinearData>();
        this.C.A(2);
        if (this.applyContrast) {
            barcodeImage.initializePixels();
            object = new com.businessrefinery.barcodereader.core.A.C(barcodeImage);
            this.C.A(1.0);
            ((com.businessrefinery.barcodereader.core.A.C)object).A();
            barcodeImage.memoryToImage();
            if (this.A) {
                try {
                    com.businessrefinery.barcodereader.core.A.B.A(barcodeImage.getBufferedImage(), new FileOutputStream("contrast.png"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.C.A();
        this.C.A(1);
        object = null;
        object = !this.isBlackWhiteImage ? barcodeImage.toBackWhite() : barcodeImage;
        barcodeImage = null;
        ((BarcodeImage)object).initializePixels();
        this.C.A();
        if (this.A) {
            try {
                com.businessrefinery.barcodereader.core.A.B.A(((BarcodeImage)object).getBufferedImage(), new FileOutputStream("bw.png"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        com.businessrefinery.barcodereader.core.B.A a = new com.businessrefinery.barcodereader.core.B.A();
        this.C.A(1);
        com.businessrefinery.barcodereader.core.B.K k = a.A((BarcodeImage)object);
        this.C.A();
        if (this.A) {
            try {
                k.A("vectorized.png", null, ((BarcodeImage)object).getBufferedImage(), 0.0, 0.0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        com.businessrefinery.barcodereader.core.B.F f = new com.businessrefinery.barcodereader.core.B.F();
        com.businessrefinery.barcodereader.core.B.G g = new com.businessrefinery.barcodereader.core.B.G();
        this.C.A(1);
        Vector vector2 = f.A(k, (BarcodeImage)object);
        this.C.A();
        this.C.A(vector2.size());
        for (int i = 0; i < vector2.size(); ++i) {
            com.businessrefinery.barcodereader.core.B.J j;
            this.C.A((double)i);
            if (this.A) {
                try {
                    j = (com.businessrefinery.barcodereader.core.B.J)vector2.elementAt(i);
                    k.A("candidate" + i + ".png", ((com.businessrefinery.barcodereader.core.B.J)vector2.elementAt(i)).B(), ((BarcodeImage)object).getBufferedImage(), 0.0, 0.0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            j = (com.businessrefinery.barcodereader.core.B.J)vector2.elementAt(i);
            if (this.A) {
                System.out.println("Barcode candidate found " + j.I.size());
            }
            double[] dArray = g.A(com.businessrefinery.barcodereader.core.B.G.B, (BarcodeImage)object, j);
            if (this.A) {
                System.out.print("     Bar Witdhs: ");
                for (int i2 = 0; i2 < dArray.length; ++i2) {
                    System.out.print(dArray[i2] + " , ");
                }
                System.out.println("");
            }
            LinearData linearData = null;
            if ((this.barcodeType & CODE128) > 0 && (linearData = this.A(new B(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & EAN8) > 0 && (linearData = this.A(new J(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & EAN13) > 0 && (linearData = this.A(new A(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & CODE39) > 0 && (linearData = this.A(new C(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & UPCE) > 0 && (linearData = this.A(new I(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & UPCA) > 0 && (linearData = this.A(new F(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & INTERLEAVED25) > 0 && (linearData = this.A(new H(), dArray)) != null) {
                vector.add(linearData);
            }
            if ((this.barcodeType & IDENTCODE) > 0 && (linearData = this.A(new G(), dArray)) != null) {
                vector.add(linearData);
            }
            if (linearData == null) continue;
            linearData.x = (int)j.E.A;
            linearData.y = (int)j.E.B;
        }
        this.C.A();
        LinearData[] linearDataArray = new LinearData[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            linearDataArray[i] = (LinearData)vector.elementAt(i);
        }
        return linearDataArray;
    }

    private LinearData A(K k, double[] dArray) {
        k.A(dArray);
        if (k.F()) {
            LinearData linearData = new LinearData();
            linearData.setValue(k.C());
            linearData.setBarcodeType(k.E());
            return linearData;
        }
        return null;
    }

    private BarcodeImage B(BarcodeImage barcodeImage) {
        int n = barcodeImage.getHeight();
        int n2 = barcodeImage.getWidth();
        BufferedImage bufferedImage = new BufferedImage(n2, n, 12);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n2, n);
        graphics2D.drawImage((Image)barcodeImage.getBufferedImage(), 0, 0, null);
        graphics2D.dispose();
        graphics2D = null;
        BarcodeImage barcodeImage2 = new BarcodeImage(bufferedImage);
        int n3 = 9;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                n4 = 0;
                n6 = 0;
                n5 = 0;
                for (int k = 0; k < n3; ++k) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        n7 = i - (int)Math.floor(n3 / 2) + k;
                        n8 = j - (int)Math.floor(n3 / 2) + i2;
                        if (n7 < 0 || n8 < 0 || n7 >= n || n8 >= n2) continue;
                        n5 += barcodeImage.getGreyPixel(n7, n8);
                        ++n6;
                    }
                }
                n4 = n5 / n6 - 7;
                if (barcodeImage.getGreyPixel(i, j) > n4) {
                    barcodeImage2.setPixel(i, j, BarcodeImage.BACKGROUND);
                    continue;
                }
                barcodeImage2.setPixel(i, j, BarcodeImage.FOREGROUND);
            }
        }
        return barcodeImage2;
    }
}

