/*
 * Decompiled with CFR 0.152.
 */
package com.businessrefinery.barcodereader.pdf417;

public class PDF417Data {
    protected int[] value = null;
    protected int x = 0;
    protected int eclevel = 0;
    protected int y = 0;
    protected int errors = 0;
    protected Object[] macroFields = null;
    public static int MACROPDF_SEGMENT = 0;
    public static int MACROPDF_FILEID = 1;
    public static int MACROPDF_FILENAME = 2;
    public static int MACROPDF_SEGMENT_COUNT = 3;
    public static int MACROPDF_TIMESTAMP = 4;
    public static int MACROPDF_SENDER = 5;
    public static int MACROPDF_ADRESSEE = 6;
    public static int MACROPDF_FILESIZE = 7;
    public static int MACROPDF_CHECKSUM = 8;

    public PDF417Data(int[] nArray, int n, int n2, Object[] objectArray, int n3, int n4) {
        this.value = nArray;
        this.x = n;
        this.y = n2;
        this.macroFields = objectArray;
        this.errors = n3;
        this.eclevel = n4;
    }

    public int getConfidence() {
        return this.errors;
    }

    public int getEClevel() {
        return this.eclevel;
    }

    public Object getMacroPDFField(int n) {
        if (this.macroFields == null) {
            return null;
        }
        if (n >= this.macroFields.length) {
            return null;
        }
        return this.macroFields[n];
    }

    public int[] getValue() {
        return this.value;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        int n;
        String string = "Value (int): ";
        for (n = 0; n < this.value.length; ++n) {
            string = string + " " + this.value[n];
        }
        string = "\nValue (String): ";
        for (n = 0; n < this.value.length; ++n) {
            string = string + (char)this.value[n];
        }
        string = string + "\n";
        string = string + "X: " + this.x + "\n";
        string = string + "Y: " + this.y + "\n";
        string = string + "EC Level=" + this.eclevel;
        return string;
    }
}

