/*
 * Decompiled with CFR 0.152.
 */
package com.businessrefinery.barcodereader.pdf417;

import com.businessrefinery.barcodereader.core.B.I;
import com.businessrefinery.barcodereader.core.B.J;
import com.businessrefinery.barcodereader.core.B.K;
import com.businessrefinery.barcodereader.core.BarcodeImage;
import com.businessrefinery.barcodereader.pdf417.A.A;
import com.businessrefinery.barcodereader.pdf417.A.B;
import com.businessrefinery.barcodereader.pdf417.A.C;
import com.businessrefinery.barcodereader.pdf417.A.D;
import com.businessrefinery.barcodereader.pdf417.A.E;
import com.businessrefinery.barcodereader.pdf417.A.F;
import com.businessrefinery.barcodereader.pdf417.A.G;
import com.businessrefinery.barcodereader.pdf417.PDF417Data;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class PDF417Reader {
    public boolean applyContrast;
    C[][] I;
    C D;
    C M;
    C L;
    C C;
    double J = 0.0;
    private int[] A = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private int[] K = new int[]{8, 1, 1, 1, 1, 1, 1};
    private int[] G = new int[]{1, 2, 1, 1, 1, 3, 1, 1, 7};
    private int[] F = new int[]{1, 1, 1, 1, 1, 1, 8};
    Hashtable E;
    ArrayList[] H;
    private boolean B;
    public boolean verbose = false;
    public boolean isBWImage = false;

    public PDF417Reader() {
        this.applyContrast = System.getProperty("com.businessrefinery.barcodereader.contrast", "0").equals("1");
        this.I = new C[90][90];
        this.D = new C();
        this.M = new C();
        this.L = new C();
        this.C = new C();
        this.E = new Hashtable();
        this.H = new ArrayList[31];
        this.B = System.getProperty("com.businessrefinery.barcodereader.debug", "0").equals("1");
    }

    public PDF417Data[] read(BarcodeImage barcodeImage) throws com.businessrefinery.barcodereader.core.A {
        com.businessrefinery.barcodereader.core.B.C[] cArray;
        Object object;
        Vector<PDF417Data> vector = new Vector<PDF417Data>();
        BarcodeImage barcodeImage2 = null;
        if (this.applyContrast) {
            barcodeImage.initializePixels();
            object = new com.businessrefinery.barcodereader.core.A.C(barcodeImage);
            ((com.businessrefinery.barcodereader.core.A.C)object).A();
            barcodeImage.memoryToImage();
        }
        barcodeImage2 = !this.isBWImage ? barcodeImage.toBackWhite() : barcodeImage;
        barcodeImage = null;
        barcodeImage2.initializePixels();
        object = new com.businessrefinery.barcodereader.core.B.A();
        K k = ((com.businessrefinery.barcodereader.core.B.A)object).A(barcodeImage2);
        if (this.B) {
            cArray = k.C();
            com.businessrefinery.barcodereader.core.A.D.A.A(barcodeImage2, cArray, "Vectorized ");
        }
        cArray = this.findPDF417(barcodeImage2, k);
        for (int i = 0; i < cArray.size(); ++i) {
            PDF417Data pDF417Data = this.A(barcodeImage2, (D)cArray.elementAt(i));
            if (pDF417Data == null) continue;
            vector.add(pDF417Data);
        }
        PDF417Data[] pDF417DataArray = new PDF417Data[vector.size()];
        for (int i = 0; i < pDF417DataArray.length; ++i) {
            pDF417DataArray[i] = (PDF417Data)vector.elementAt(i);
        }
        return pDF417DataArray;
    }

    private PDF417Data A(BarcodeImage barcodeImage, D d) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.E.clear();
        this.I = new C[90][90];
        this.J = 0.0;
        for (n7 = 0; n7 < this.I.length; ++n7) {
            for (n6 = 0; n6 < this.I[n7].length; ++n6) {
                this.I[n7][n6] = new C();
            }
        }
        this.C = new C();
        this.L = new C();
        this.D = new C();
        this.M = new C();
        for (n7 = 0; n7 < this.H.length; ++n7) {
            this.H[n7] = new ArrayList();
        }
        I i = new I(d.D);
        n6 = 0;
        com.businessrefinery.barcodereader.core.B.E e = i.A();
        while (e != null) {
            ++n6;
            com.businessrefinery.barcodereader.core.B.E e2 = d.D.A(e, 50.0).A(d.C);
            com.businessrefinery.barcodereader.core.B.C c = new com.businessrefinery.barcodereader.core.B.C(e, e2);
            if (this.B) {
                System.out.println("Scan line number " + n6);
            }
            this.A(barcodeImage, c, d.B);
            e = i.A();
        }
        int n8 = this.D.A() * 3 + this.M.A() + 1;
        int n9 = this.L.A();
        if (n8 < 3 || n9 <= 0) {
            if (this.verbose || this.B) {
                System.out.println("Too few rows/cols");
            }
            return null;
        }
        if (n8 > 90 || n9 > 90) {
            if (this.verbose || this.B) {
                System.out.println("Too many rows/cols");
            }
            return null;
        }
        int n10 = (int)Math.pow(2.0, this.C.A() + 1);
        if (n10 > n8 * n9) {
            if (this.verbose || this.B) {
                System.out.println("EcLen too long");
            }
            return null;
        }
        double d2 = d.C.A(new com.businessrefinery.barcodereader.core.B.E(d.D.C, d.D.I));
        double d3 = d2 / (double)(n9 + 4);
        int[] nArray = new int[this.H.length];
        for (n5 = 0; n5 < this.H.length; ++n5) {
            Collections.sort(this.H[n5]);
            if (this.H[n5].size() <= 0) continue;
            nArray[n5] = (Integer)this.H[n5].get(this.H[n5].size() / 2);
        }
        n5 = this.verbose || this.B ? 1 : 0;
        for (n4 = 0; n4 < n8; ++n4) {
            if (n5 != 0) {
                System.out.println("");
            }
            String string = "";
            for (int j = 0; j < n9; ++j) {
                if (n5 == 0) continue;
                string = string + " " + this.I[n4][j];
            }
            System.out.print(string);
        }
        for (n4 = 0; n4 < n8; ++n4) {
            block13: for (int j = 0; j < n9; ++j) {
                Vector vector;
                if (this.I[n4][j].A() != -1 || (vector = (Vector)this.E.get(new Integer(n4))) == null) continue;
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    int[] nArray2;
                    int n11;
                    object = (E)vector.elementAt(n3);
                    n2 = nArray[j];
                    int n12 = 0;
                    for (int k = 0; k < ((E)object).A; ++k) {
                        if (Math.abs(((E)object).E[n12] - n2) <= Math.abs(((E)object).E[k] - n2) || ((E)object).F[k] != com.businessrefinery.barcodereader.pdf417.A.E.H) continue;
                        n12 = k;
                    }
                    if ((double)Math.abs(((E)object).E[n12] - n2) >= d3 / 2.0 || (n11 = this.A(nArray2 = this.A(((E)object).C, ((E)object).E, n12))) != 3 && n11 != 6 && n11 != 0) continue;
                    int n13 = this.A(nArray2, n11 /= 3);
                    this.A(n13, n4, j, true);
                    if (!this.verbose && !this.B) continue block13;
                    System.out.println("Correcting codeword (" + n4 + "," + j + ") = " + n13);
                    continue block13;
                }
            }
        }
        n4 = 0;
        for (int j = 0; j < n8; ++j) {
            for (n = 0; n < n9; ++n) {
                if (this.I[j][n].A() != -1) continue;
                ++n4;
            }
        }
        if (n4 > n10 / 2) {
            if (this.verbose || this.B) {
                System.out.println("Too many unknown codewords " + n4 + ">" + n10 / 2);
            }
            return null;
        }
        int[] nArray3 = new int[n8 * n9];
        n = 0;
        if (n5 != 0) {
            System.out.println("\nNew codewords ");
        }
        for (n3 = 0; n3 < n8; ++n3) {
            if (n5 != 0) {
                System.out.println("");
            }
            object = "";
            for (n2 = 0; n2 < n9; ++n2) {
                nArray3[n++] = this.I[n3][n2].A() != -1 ? this.I[n3][n2].A() : 0;
                if (n5 == 0) continue;
                object = (String)object + " " + this.I[n3][n2];
            }
            System.out.print((String)object);
        }
        com.businessrefinery.barcodereader.pdf417.A.A.A a = new com.businessrefinery.barcodereader.pdf417.A.A.A();
        int n14 = 0;
        try {
            n14 = a.A(nArray3, n10);
        }
        catch (Exception exception) {
            n14 = -1;
            exception.printStackTrace();
        }
        if (this.verbose || this.B) {
            System.out.println("\nRS result=" + n14);
        }
        int[] nArray4 = new int[nArray3.length - n10];
        for (n = 0; n < nArray4.length; ++n) {
            nArray4[n] = nArray3[n];
        }
        if (n5 != 0) {
            System.out.print("\nCorrected CW=");
            for (n = 0; n < nArray4.length; ++n) {
                System.out.println(" " + nArray4[n]);
            }
            System.out.print("\n");
        }
        F f = new F();
        try {
            int[] nArray5 = f.A(nArray4);
            object = new PDF417Data(nArray5, (int)d.D.C, (int)d.D.I, f.D, n14, n10 / 2);
            return object;
        }
        catch (B b) {
            if (this.B) {
                b.printStackTrace();
            }
            return null;
        }
        catch (G g) {
            if (this.B) {
                g.printStackTrace();
            }
            return null;
        }
    }

    private void A(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            this.I[n2][n3].B(n);
        } else {
            this.I[n2][n3].A(n);
        }
    }

    private void A(BarcodeImage barcodeImage, com.businessrefinery.barcodereader.core.B.C c, double d) {
        int n;
        E e = new E(barcodeImage, c, d);
        if (e.A < 32) {
            return;
        }
        boolean bl = true;
        int n2 = 8;
        int[] nArray = this.A(e.C, e.E, n2);
        n2 += 8;
        int n3 = this.A(nArray);
        if (n3 == 3) {
            n3 = 1;
        } else if (n3 == 6) {
            n3 = 2;
        } else if (n3 != 0) {
            return;
        }
        int n4 = this.A(nArray, n3);
        int n5 = (int)Math.floor(n4 / 30);
        int n6 = n5 *= 3;
        int n7 = n3;
        int n8 = n3;
        if (n4 != -1) {
            if (n3 == 2) {
                this.L.B(n4 % 30 + 1);
            }
            if (n3 == 1) {
                this.M.B(n4 % 30 % 3);
                this.C.B((int)Math.floor(n4 % 30 / 3));
            }
            if (n3 == 0) {
                this.D.B(n4 % 30);
            }
        }
        n5 += n3;
        int[] nArray2 = new int[90];
        int[] nArray3 = new int[90];
        int n9 = 0;
        int n10 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 + 8 <= e.A) {
            bl = true;
            n = e.E[n2];
            nArray = this.A(e.C, e.E, n2);
            n2 += 8;
            n3 = this.A(nArray);
            if (n3 == 3) {
                n3 = 1;
            } else if (n3 == 6) {
                n3 = 2;
            } else if (n3 != 0) {
                bl = false;
                bl3 = true;
                break;
            }
            if (bl) {
                n4 = this.A(nArray, n3);
                nArray3[n9] = n3;
                nArray2[n9++] = n4;
                this.H[n10].add(new Integer(n));
                int n11 = -1;
                if (n7 == n3) {
                    n11 = n6 + n8;
                } else {
                    bl2 = true;
                    int n12 = 0;
                    if (n7 == 0 && n3 == 1) {
                        n12 = 1;
                    }
                    if (n7 == 1 && n3 == 2) {
                        n12 = 1;
                    }
                    if (n7 == 2 && n3 == 0) {
                        n12 = 1;
                    }
                    if (n7 == 0 && n3 == 2) {
                        n12 = -1;
                    }
                    if (n7 == 1 && n3 == 0) {
                        n12 = -1;
                    }
                    if (n7 == 2 && n3 == 1) {
                        n12 = -1;
                    }
                    if (n12 != 0) {
                        n7 = n3;
                        n11 = n6 + (n8 += n12);
                    }
                }
                if (n11 >= 90 || n10 >= 90) {
                    return;
                }
                if (n11 >= 0 && n10 >= 0) {
                    this.A(n4, n11, n10, false);
                }
            } else {
                if (this.B) {
                    System.out.println("Wrong symbol");
                }
                nArray3[n9] = -1;
                nArray2[n9++] = -1;
            }
            ++n10;
        }
        if (!bl2 && bl3) {
            Vector<E> vector = (Vector<E>)this.E.get(new Integer(n6 + n8));
            if (vector == null) {
                vector = new Vector<E>();
                this.E.put(new Integer(n6 + n8), vector);
            }
            vector.add(e);
        }
        if (--n9 >= 3) {
            n4 = nArray2[n9];
            n3 = nArray3[n9];
            n = (int)Math.floor(n4 / 30);
            n += n3;
            if (n3 == 0 && n4 != -1) {
                this.L.B(n4 % 30 + 1);
            }
        }
    }

    private int A(int[] nArray, int n) {
        String string = "" + nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] + nArray[5];
        if (string.length() > 6) {
            return -1;
        }
        for (int i = 0; i < com.businessrefinery.barcodereader.pdf417.A.A.D[n].length; ++i) {
            if (!com.businessrefinery.barcodereader.pdf417.A.A.D[n][i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int A(int[] nArray) {
        return (nArray[0] - nArray[1] + nArray[4] - nArray[5] + 9) % 9;
    }

    private int[] A(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray2[n + 8] - nArray2[n];
        int[] nArray3 = new int[6];
        for (int i = 0; i < 6; ++i) {
            nArray3[i] = nArray[n + i];
        }
        int[] nArray4 = new int[6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 1; j <= 8; ++j) {
                if (!(((double)j + 0.5) * (double)n2 / 17.0 <= (double)nArray3[i]) || !((double)nArray3[i] < ((double)j + 1.5) * (double)n2 / 17.0)) continue;
                nArray4[i] = j + 1;
            }
        }
        return nArray4;
    }

    private void B(int[] nArray) {
        int n;
        int n2 = nArray[0] + nArray[1];
        int n3 = nArray[1] + nArray[2];
        int n4 = nArray[2] + nArray[3];
        int n5 = nArray[3] + nArray[4];
        int n6 = nArray[4] + nArray[5];
        int n7 = nArray[4] + nArray[5];
        int n8 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] + nArray[5];
        int[] nArray2 = new int[]{n2, n3, n4, n5, n5, n6, n7};
        int[] nArray3 = new int[6];
        for (n = 0; n <= 6; ++n) {
            for (int i = 1; i <= 8; ++i) {
                if (!(((double)i + 0.5) * (double)n8 / 17.0 <= (double)nArray2[n]) || !((double)nArray2[n] < ((double)i + 1.5) * (double)n8 / 17.0)) continue;
                nArray3[n] = i + 1;
            }
        }
        n = (nArray3[0] - nArray3[1] + nArray3[4] - nArray3[5] + 9) % 9;
    }

    public Vector findPDF417(BarcodeImage barcodeImage, K k) throws com.businessrefinery.barcodereader.core.A {
        com.businessrefinery.barcodereader.core.B.C c;
        com.businessrefinery.barcodereader.core.B.C c2;
        J j;
        int n;
        int n2;
        Vector<D> vector = new Vector<D>();
        com.businessrefinery.barcodereader.core.B.F f = new com.businessrefinery.barcodereader.core.B.F();
        f.F = 4;
        f.E = false;
        com.businessrefinery.barcodereader.core.B.G g = new com.businessrefinery.barcodereader.core.B.G();
        Vector vector2 = f.A(k, barcodeImage);
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            J j2 = (J)vector2.elementAt(n2);
            double[] dArray = g.A(com.businessrefinery.barcodereader.core.B.G.B, barcodeImage, j2);
            j2.A(dArray);
            j2.A(0);
        }
        n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        for (n = 0; n < vector2.size(); ++n) {
            j = (J)vector2.elementAt(n);
            double[] dArray = j.F();
            if (this.B) {
                System.out.println("Candidate bars width: ");
                for (int i = 0; i < dArray.length; ++i) {
                    System.out.print(" " + dArray[i]);
                }
                System.out.println("");
            }
            if (this.B) {
                try {
                    com.businessrefinery.barcodereader.core.A.D.A.A(barcodeImage, j.A(), "Candidate " + n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.A(j, dArray, this.K, this.K.length - 1, 0)) {
                j.A(j.D() | n2);
            }
            if (this.A(j, dArray, this.G, this.G.length, 0)) {
                j.A(j.D() | n5);
            }
            if (this.A(j, dArray, this.A, this.A.length, dArray.length - 9)) {
                j.A(j.D() | n3);
            }
            if (!this.A(j, dArray, this.F, this.F.length, dArray.length - 7)) continue;
            j.A(j.D() | n4);
        }
        for (n = 0; n < vector2.size(); ++n) {
            j = (J)vector2.elementAt(n);
            if ((j.D() & n2) == 0) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                J j3 = (J)vector2.elementAt(i);
                if ((j3.D() & n3) == 0) continue;
                c2 = ((com.businessrefinery.barcodereader.core.B.D)j.I.get(0)).B();
                c = ((com.businessrefinery.barcodereader.core.B.D)j3.I.get(j3.I.size() - 1)).B();
                if (!this.A(c2.I(), c.I(), 5.0) || !c2.A(c, 0.4)) continue;
                com.businessrefinery.barcodereader.core.B.C c3 = new com.businessrefinery.barcodereader.core.B.C(new com.businessrefinery.barcodereader.core.B.E(c2.C, c2.I), new com.businessrefinery.barcodereader.core.B.E(c.C, c.I));
                com.businessrefinery.barcodereader.core.B.C c4 = new com.businessrefinery.barcodereader.core.B.C(new com.businessrefinery.barcodereader.core.B.E(c2.C, c2.I), new com.businessrefinery.barcodereader.core.B.E(c.B, c.H));
                if (c3.C() > c4.C()) {
                    c = new com.businessrefinery.barcodereader.core.B.C(new com.businessrefinery.barcodereader.core.B.E(c.B, c.H), new com.businessrefinery.barcodereader.core.B.E(c.C, c.I));
                }
                vector.add(new D(c2, c, false, (j.H + j3.H) / 2.0));
                if (!this.B) continue;
                com.businessrefinery.barcodereader.core.A.D.A.A(barcodeImage, new com.businessrefinery.barcodereader.core.B.C[]{c2, c}, "PDF417 Area " + n);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            j = (J)vector2.elementAt(n);
            if ((j.D() & n5) == 0) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                J j4 = (J)vector2.elementAt(i);
                if ((j4.D() & n4) == 0) continue;
                c2 = ((com.businessrefinery.barcodereader.core.B.D)j.I.get(0)).B();
                c = ((com.businessrefinery.barcodereader.core.B.D)j4.I.get(j4.I.size() - 1)).B();
                if (!this.A(c.I(), c2.I(), 5.0) || !c.A(c2, 0.5)) continue;
                vector.add(new D(c, c2, true, (j.H + j4.H) / 2.0));
                if (!this.B) continue;
                com.businessrefinery.barcodereader.core.A.D.A.A(barcodeImage, new com.businessrefinery.barcodereader.core.B.C[]{c, c2}, "PDF417 Area " + n);
            }
        }
        return vector;
    }

    private boolean A(double d, double d2, double d3) {
        if (Math.abs(d - d2) < d3) {
            return true;
        }
        double d4 = d + 180.0;
        if (d4 > 360.0) {
            d4 -= 360.0;
        }
        if (Math.abs(d4 - d2) < d3) {
            return true;
        }
        d4 = d2 + 180.0;
        if (d4 > 360.0) {
            d4 -= 360.0;
        }
        return Math.abs(d - d4) < d3;
    }

    private boolean A(J j, double[] dArray, int[] nArray, int n, int n2) {
        int n3;
        if (n2 < 0) {
            return false;
        }
        if (n2 + n > dArray.length) {
            return false;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        for (n3 = 0; n3 < n; ++n3) {
            if (nArray[n3] == 1) {
                if (!bl) {
                    ++n4;
                    d += dArray[n2 + n3];
                } else {
                    ++n5;
                    d2 += dArray[n2 + n3];
                }
            }
            bl = !bl;
        }
        d /= (double)n4;
        d2 /= (double)n5;
        bl = true;
        for (n3 = 0; n3 < n; ++n3) {
            double d3 = d;
            if (bl) {
                d3 = d2;
            }
            double d4 = dArray[n2 + n3] / d3;
            double d5 = (double)nArray[n3] - (double)nArray[n3] * 0.3;
            double d6 = (double)nArray[n3] + (double)nArray[n3] * 0.3;
            if ((n3 == 0 || n3 == n - 1) && nArray[n3] == 3 ? d4 < d5 : d4 <= d5 || d4 >= d6) {
                return false;
            }
            bl = !bl;
        }
        j.H = (d - d2) / 2.0;
        return true;
    }
}

