package test.datamatrix;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.File;


import com.businessrefinery.barcodereader.core.BarcodeImage;
import com.businessrefinery.barcodereader.datamatrix.DataMatrixData;
import com.businessrefinery.barcodereader.datamatrix.DataMatrixReader;

public class Test {

    private String[] testSet={"dm.png","dm2.png","dm3.png","dm4.png","dm5.png","dm6.png","d1.png","d2.png","d3.png","d4.png","d5.png","i7.png","i6.png"};

    private String dir="images/";

    public static void main(String[] args)  {

		Test sample=new Test();
		try {
            sample.runTests();
		} catch (Exception e) {

			e.printStackTrace();
		}
		System.exit(0);

	}

	/**
	 * read all test files
	 *
	 */
	public void runTests() {
		for (int i=0;i<testSet.length;i++) {
			try {

				System.out.println("");
				System.out.println("------------------------------");
				System.out.println("Reading File: "+testSet[i]);
				System.out.println("");

                scanImage(this.getClass().getResource(dir+testSet[i]).getFile());
				System.out.println("------------------------------");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * scan barcode image
	 */
	public void scanImage(String file) throws Exception
    {
		DataMatrixReader reader=new DataMatrixReader();

		BarcodeImage barcodeImage =new BarcodeImage((BufferedImage)loadImage(file));

        long tim=System.currentTimeMillis();
        DataMatrixData[] barcodes=reader.read(barcodeImage);

		System.out.print("End. "+(System.currentTimeMillis()-tim)+". ");
		if (barcodes.length==0) System.out.println("*** NO BARCODE FOUND ***");

		for (int i=0;i<barcodes.length;i++) {
			System.out.println("Barcode  found "+barcodes[i].toString());
		}

	}

	/**
	 * load image from file
	 */
	public Image loadImage(String f) throws Exception
    {
        Image image = null;
        MediaTracker mt2;
        FileInputStream fileIn;
        byte[] b;
        int size;


        fileIn =new java.io.FileInputStream( f);
        size=fileIn.available();
        b=new byte[size];
        fileIn.read(b);
        image =java.awt.Toolkit.getDefaultToolkit().createImage(b);
        fileIn.close();

        mt2 = new java.awt.MediaTracker(new Canvas());
        if (image !=null) {
            if (mt2!=null) {mt2.addImage(image,0); mt2.waitForID(0);}
            int WidthIm = image.getWidth(null);
        }


		BufferedImage input = new BufferedImage(image.getWidth(null),image.getHeight(null),BufferedImage.TYPE_INT_ARGB);

		Graphics g=input.createGraphics();
		g.setColor(Color.white);
		g.fillRect(0,0,image.getWidth(null),image.getHeight(null));
		g.drawImage(image,0,0,null);
		g.dispose();
		g=null;

		return input;


    }

}