package test.linear;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;

import com.businessrefinery.barcodereader.linear.LinearReader;
import com.businessrefinery.barcodereader.linear.LinearData;
import com.businessrefinery.barcodereader.core.BarcodeImage;

public class Test {
    private String[][] testSet={{"ima_300dpi_90.png",""+LinearReader.CODE128},
            {"ean128_5_4.png",""+LinearReader.CODE128},
            {"ean128_90_2.png",""+LinearReader.CODE128},
            {"ean128_90_1.GIF",""+LinearReader.CODE128},
            {"ean128_266_3.png",""+LinearReader.CODE128},
            {"ean128_111_3.png",""+LinearReader.CODE128},
            {"ean128_10_2.png",""+LinearReader.CODE128},
            {"ean128_0_2.png",""+LinearReader.CODE128},
            {"ean128_45_4.png",""+LinearReader.CODE128},
            {"ean128_45_3.png",""+LinearReader.CODE128},
            {"ean128_30_3.png",""+LinearReader.CODE128},
            {"ean128_60_3.png",""+LinearReader.CODE128},
            {"ean13_0_3.png",""+LinearReader.EAN13},
            {"ean8.png",""+LinearReader.EAN8},
            {"upca.png",""+LinearReader.UPCA},
            {"upce.png",""+LinearReader.UPCE},
            {"upce_2.png",""+LinearReader.UPCE},
            {"code39.png",""+LinearReader.CODE39},
            {"scan_ean1.gif",""+LinearReader.EAN13},
            {"scan_ean2.png",""+LinearReader.EAN13},
            {"identcode.PNG",""+LinearReader.IDENTCODE},
            {"scan_ean4.png",""+LinearReader.EAN13},
            {"ean13_shoe.png",""+LinearReader.EAN13},
            {"ean8_scan1_2.png",""+LinearReader.EAN8},
            {"ean8_bag.png",""+LinearReader.EAN8},
            {"i25.png",""+LinearReader.INTERLEAVED25},
            {"barcode_scan7_i125.png",""+LinearReader.INTERLEAVED25},
            {"barcode_scan3_code128.png",""+LinearReader.CODE128},
            {"barcode_scan5_ean13.png",""+LinearReader.EAN13},
            {"barcode_scan_code39.png",""+LinearReader.CODE39}};


	private String dir="images/";

	public static void main(String[] args)  {

		Test test =new Test();
		try {
			test.runTests();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * read all test files
	 *
	 */
	public void runTests() {
		for (int i=0;i<testSet.length;i++) {
			try {

				System.out.println("");
				System.out.println("------------------------------");
				System.out.println("Reading File: "+testSet[i][0]);
				System.out.println("");
                scanImage(this.getClass().getResource(dir+testSet[i][0]).getFile(),
                        new Integer(testSet[i][1]).intValue());
				System.out.println("------------------------------");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * scan barcode image
	 */
	public void scanImage(String file, int type) throws Exception
    {
		LinearReader reader=new LinearReader();
		reader.setBarcodeType(type);

		BarcodeImage barcodeImage =new BarcodeImage((BufferedImage)loadImage(file));

        long tim=System.currentTimeMillis();
		LinearData[] barcodes=reader.read(barcodeImage);

        System.out.print("Finish Read. "+(System.currentTimeMillis()-tim)+". ");
		if (barcodes.length==0) System.out.println("====  NO BARCODE FOUND  ====");

		for (int i=0;i<barcodes.length;i++)
        {
			System.out.println("Linear Barcode found : "+barcodes[i].toString());
		}
	}

	/**
	 * load image from file
	 */
	public Image loadImage(String file) throws Exception
    {
        Image image = null;
        MediaTracker mt2;
        FileInputStream fileIn;
        byte[] b;
        int size;

        fileIn = new FileInputStream(file);
        size = fileIn.available();
        b = new byte[size];
        fileIn.read(b);
        image = Toolkit.getDefaultToolkit().createImage(b);
        fileIn.close();

        mt2 = new MediaTracker(new Canvas());
        if (image !=null) {
            if (mt2!=null) {mt2.addImage(image,0); mt2.waitForID(0);}
            int WidthIm = image.getWidth(null);
        }

		BufferedImage input=new BufferedImage(image.getWidth(null),image.getHeight(null),BufferedImage.TYPE_INT_ARGB);

		Graphics g=input.createGraphics();
		g.setColor(Color.white);
		g.fillRect(0,0,image.getWidth(null),image.getHeight(null));
		g.drawImage(image,0,0,null);
		g.dispose();
		g=null;

		return input;
    }
}
