package test.pdf417;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;


import com.businessrefinery.barcodereader.core.BarcodeImage;
import com.businessrefinery.barcodereader.pdf417.PDF417Data;
import com.businessrefinery.barcodereader.pdf417.PDF417Reader;

public class Test
{
    private String[] testSet={"macropdf.jpg","pdf2_180.jpg","pdf2_270.jpg","pdf2_90.jpg",
            "pdf8.jpg","pdf7.jpg","pdf6.jpg","pdf5.png","pdf4.png","pdf3.jpg","pdf2.jpg",
            "PDF417_1.png" ,"pdf2_corrupt3.jpg","pdf2_corrupt2.jpg","pdf2_corrupt.jpg","pdfbig.jpg",
            "pdf_multiple.png","pdf417scan.jpg"};
	private String dir="images/";

	public static void main(String[] args)
    {
		Test sample = new Test();
		try {
			sample.runTests();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * read all test files
	 *
	 */
	public void runTests() {
		for (int i=0;i<testSet.length;i++) {
			try {

				System.out.println("");
				System.out.println("------------------------------");
				System.out.println("Scanning File: "+testSet[i]);
				System.out.println("");
                scanImage(this.getClass().getResource(dir+testSet[i]).getFile());
				System.out.println("------------------------------");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * scan barcode image
	 */
	public void scanImage(String file) throws Exception
    {
		PDF417Reader reader=new PDF417Reader();

		BarcodeImage barcodeImage =new BarcodeImage((BufferedImage) loadImage(file));

        long tim=System.currentTimeMillis();
        PDF417Data[] barcodes=reader.read(barcodeImage);

		System.out.print("End. "+(System.currentTimeMillis()-tim)+". ");
		if (barcodes.length==0) System.out.println("====  NO BARCODE FOUND  ====");

		for (int i=0;i<barcodes.length;i++) {

			if (barcodes[i].getConfidence()<0) System.out.println("\bBarcode found but It CONTAINS ERRORS which could not be corrected "+barcodes[i].toString());
			else if (barcodes[i].getConfidence()>0) System.out.println("\nBarcode  found and errors corrected "+barcodes[i].toString());
			else System.out.println("\nBarcode  found "+barcodes[i].toString());

			if (barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_SEGMENT)!=null) {
				System.out.println("Macro PDF information:");
				System.out.println("     Segment index: "+barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_SEGMENT));
				System.out.println("     Segment file Id "+barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_FILEID));
				Object o=barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_SEGMENT_COUNT);
				if (o!=null) System.out.println("     Segment total count: "+o);
				o=barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_FILENAME);
				if (o!=null) System.out.println("     Filename: "+o);
				o=barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_FILESIZE);
				if (o!=null) System.out.println("     File size: "+o);
				o=barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_TIMESTAMP);
				if (o!=null) System.out.println("     TimeStamp: "+o);
				o=barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_SENDER);
				if (o!=null) System.out.println("     Sender: "+o);
				o=barcodes[i].getMacroPDFField(PDF417Data.MACROPDF_ADRESSEE);
				if (o!=null) System.out.println("     Adresse: "+o);

			}

		}

	}

	/**
	 * load image from file
	 */
	public Image loadImage(String f) throws Exception
    {
        Image image = null;
        MediaTracker mt2;
        FileInputStream fileIn;
        byte[] b;
        int size=0;

        fileIn =new java.io.FileInputStream( f);
        if (fileIn !=null) {
            size=fileIn.available();
            b=new byte[size];
            fileIn.read(b);
            image =java.awt.Toolkit.getDefaultToolkit().createImage(b);
            fileIn.close();
        }

        mt2 = new java.awt.MediaTracker(new Canvas());
        if (image !=null) {
            if (mt2!=null) {mt2.addImage(image,0); mt2.waitForID(0);}
            int WidthIm = image.getWidth(null);
        }

		BufferedImage input=new BufferedImage(image.getWidth(null),image.getHeight(null),BufferedImage.TYPE_INT_ARGB);

		Graphics g=input.createGraphics();
		g.setColor(Color.white);
		g.fillRect(0,0,image.getWidth(null),image.getHeight(null));
		g.drawImage(image,0,0,null);
		g.dispose();
		g=null;

		return input;


    }
}

