/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.faceless.graph.AxesGraph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;
import org.faceless.graph.c;
import org.faceless.graph.d;
import org.faceless.graph.e;
import org.faceless.graph.f;
import org.faceless.graph.h;
import org.faceless.graph.j;

public abstract class AbstractBarGraph
extends AxesGraph {
    public static final int DISPLAYVALUE_NONE = 0;
    public static final int DISPLAYVALUE_MIDDLE = 1;
    public static final int DISPLAYVALUE_TOP = 2;
    public static final int DISPLAYVALUE_INSIDETOP = 3;
    protected double barwidth;
    protected double bardepth;
    protected j xkey = new j();
    protected j ykey = this.key;
    protected j zkey = new j();
    protected double minx = 0.0;
    protected double maxx = 0.0;
    protected double minz = 0.0;
    protected double maxz = 0.0;
    protected double maxv = 0.0;
    protected double minv = 0.0;
    protected int displayvalue;
    protected boolean roundbars;
    private double w;
    private List x;

    protected AbstractBarGraph() {
        this.optionBarDepth(1.0);
        this.optionBarWidth(1.0);
        this.optionDisplayKey(0);
        this.optionMinY(0.0);
        this.x = new ArrayList();
        this.setPieEdgeDegrees(10.0);
    }

    public void optionBarWidth(double d2) {
        this.barwidth = d2;
    }

    public void optionBarDepth(double d2) {
        this.bardepth = d2;
    }

    public void optionDisplayValue(int n2) {
        this.displayvalue = n2;
    }

    public void optionRoundBars(boolean bl) {
        this.roundbars = bl;
    }

    public void optionXStretchToZero(boolean bl) {
        throw new IllegalStateException("AbstractBarGraph would prefer to control XStretchToZero itself");
    }

    public void optionYStretchToZero(boolean bl) {
        throw new UnsupportedOperationException("AbstractBarGraph would prefer to control YStretchToZero itself");
    }

    protected void complete() {
        super.complete();
        if (!Double.isInfinite(this.absolutemaxy)) {
            this.maxv = Math.max(this.absoluteminy, this.absolutemaxy);
        }
        if (!Double.isInfinite(this.absoluteminy)) {
            this.minv = Math.min(this.absolutemaxy, this.absoluteminy);
        }
        boolean bl = false;
        SortedSet sortedSet = this.data.getXSet();
        SortedSet sortedSet2 = this.data.getYSet();
        SortedSet sortedSet3 = this.data.getZSet();
        for (Double d2 : sortedSet3) {
            for (Double d3 : sortedSet2) {
                for (Double d4 : sortedSet) {
                    Double d5 = this.data.get(d4, d3, d2);
                    if (d5 == null) continue;
                    int n2 = d4.intValue();
                    int n3 = d3.intValue();
                    int n4 = d2.intValue();
                    this.plotBar(n2, n3, n4, d5);
                }
            }
        }
    }

    protected void postcomplete() {
        this.axesminx = new Double(this.minx);
        this.axesmaxx = new Double(this.maxx);
        this.axesmaxz = new Double(this.maxz);
        this.axesminz = new Double(this.minz);
        this.axesminy = new Double(this.minv);
        this.axesmaxy = new Double(this.maxv);
        if (this.xformatter == null) {
            this.xformatter = this.xkey.getFormatter();
        }
        if (this.zformatter == null) {
            this.zformatter = this.zkey.getFormatter();
        }
        super.postcomplete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prescalecomplete() {
        int i2 = this.x.size() - 1;
        while (i2 >= 0) {
            boolean bl;
            a_ a_2 = (a_)this.x.get(i2);
            boolean bl2 = bl = a_2.val < 0.0;
            if (this.displayvalue != 0) {
                int n2;
                String string = this.yformatter.format(a_2.val);
                Style style = (Style)this.yaxestextstyle.clone();
                int n3 = n2 = a_2.p1.y() == a_2.p2.y() ? 2 : this.displayvalue;
                if (n2 == 3) {
                    boolean bl3 = bl = !bl;
                }
                if (this.zrotation == 90.0) {
                    style.setAlign(0x10 | (n2 == 1 ? 32 : (bl ? 2 : 8)));
                } else {
                    style.setAlign(0x20 | (n2 == 1 ? 16 : (bl ? 1 : 4)));
                }
                h h5 = new h(string, new Point((a_2.p1.x() + a_2.p2.x()) / 2.0, n2 == 1 ? (a_2.p1.y() + a_2.p2.y()) / 2.0 : a_2.p2.y() + this.w / (double)(bl ? -40 : 40), a_2.p1.z()), style);
                this.addElement(h5);
            }
            --i2;
        }
        return;
    }

    protected abstract void plotBar(int var1, int var2, int var3, double var4);

    protected void plotBarValue(Point point, Point point2, double d2) {
        this.x.add(new a_(point, point2, d2));
        double d3 = point.y() - point2.y();
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if (d3 > this.w) {
            this.w = d3;
        }
    }

    protected c getBoxElement(String string, Point point, Point point2, Style style) {
        d d2;
        if (this.roundbars) {
            double d3 = Math.abs(point.y() - point2.y());
            double d4 = Math.abs(point.x() - point2.x());
            double d5 = Math.abs(point.z() - point2.z());
            d2 = new f(string, new Point((point.x() + point2.x()) / 2.0, (point.y() + point2.y()) / 2.0, (point.z() + point2.z()) / 2.0), 0.0, 360.0, (d4 + d5) / 4.0, d3, 280, style);
        } else {
            style.a().setAll();
            d2 = new e(string, point, point2, style);
        }
        return d2;
    }

    private class a_ {
        public Point p1;
        public Point p2;
        public double val;

        public a_(Point point, Point point2, double d2) {
            this.p1 = point;
            this.p2 = point2;
            this.val = d2;
        }
    }
}

