/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.awt.Paint;
import org.faceless.graph.AbstractBarGraph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;

public class BarGraph
extends AbstractBarGraph {
    public BarGraph() {
        this.xkey = this.key;
        this.optionDisplayKey(0);
    }

    public void setColor(String string, Paint paint) {
        this.key.setKey(string, paint);
    }

    public void set(String string, double d2) {
        if (Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Cannot set an infinite sized bar.");
        }
        if (d2 != (double)Math.round(d2)) {
            this.yfloat = true;
        }
        this.data.set(this.key.find(string), 0.0, 0.0, d2);
    }

    protected void plotBar(int n2, int n3, int n4, double d2) {
        double d3 = Math.max(this.absoluteminy, 0.0);
        double d4 = (double)n2 + 0.5;
        double d5 = d3;
        double d6 = (double)(-n4) - 0.5;
        this.key.needKey(n2);
        if (Double.isNaN(d2)) {
            return;
        }
        this.minx = Math.min(this.minx, d4 - 0.5);
        this.maxx = Math.max(this.maxx, d4 + 0.5);
        this.minz = Math.min(this.minz, d6 - 0.5);
        this.maxz = Math.max(this.maxz, d6 + 0.5);
        this.minv = Math.min(this.minv, Math.min(d2, d3));
        this.maxv = Math.max(this.maxv, Math.max(d2, d3));
        Point point = new Point(d4 - this.barwidth / 2.0, d3, d6 + this.bardepth / 2.0);
        Point point2 = new Point(d4 + this.barwidth / 2.0, d2, d6 - this.bardepth / 2.0);
        Style style = new Style(this.key.getColor(n2));
        style.b(this);
        this.addElement(this.getBoxElement("Data" + n2, point, point2, style));
        this.plotBarValue(point, point2, d2);
    }
}

