/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.text.DecimalFormat;
import org.faceless.graph.Point;

public final class BoundingBox {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;

    public BoundingBox(Point point, Point point2) {
        this.a = Math.min(point.x(), point2.x());
        this.d = Math.max(point.x(), point2.x());
        this.b = Math.min(point.y(), point2.y());
        this.e = Math.max(point.y(), point2.y());
        this.c = Math.min(point.z(), point2.z());
        this.f = Math.max(point.z(), point2.z());
    }

    public BoundingBox(Point[] pointArray) {
        this.a = this.d = pointArray[0].x();
        this.b = this.e = pointArray[0].y();
        this.c = this.f = pointArray[0].z();
        for (int i2 = 1; i2 < pointArray.length; ++i2) {
            if (pointArray[i2].x() < this.a) {
                this.a = pointArray[i2].x();
            }
            if (pointArray[i2].y() < this.b) {
                this.b = pointArray[i2].y();
            }
            if (pointArray[i2].z() < this.c) {
                this.c = pointArray[i2].z();
            }
            if (pointArray[i2].x() > this.d) {
                this.d = pointArray[i2].x();
            }
            if (pointArray[i2].y() > this.e) {
                this.e = pointArray[i2].y();
            }
            if (!(pointArray[i2].z() > this.f)) continue;
            this.f = pointArray[i2].z();
        }
    }

    public void expand(Point point) {
        this.a = Math.min(this.a, point.x());
        this.d = Math.max(this.d, point.x());
        this.b = Math.min(this.b, point.y());
        this.e = Math.max(this.b, point.y());
        this.c = Math.min(this.c, point.z());
        this.f = Math.max(this.f, point.z());
    }

    public boolean contains(BoundingBox boundingBox) {
        return boundingBox.a >= this.a && boundingBox.b >= this.b && boundingBox.c >= this.c && boundingBox.d <= this.d && boundingBox.e <= this.e && boundingBox.f <= this.f;
    }

    public BoundingBox superset(BoundingBox boundingBox) {
        return new BoundingBox(new Point(Math.min(boundingBox.a, this.a), Math.min(boundingBox.b, this.b), Math.min(boundingBox.c, this.c)), new Point(Math.max(boundingBox.d, this.d), Math.max(boundingBox.e, this.e), Math.max(boundingBox.f, this.f)));
    }

    public BoundingBox intersection(BoundingBox boundingBox) {
        if (Math.max(boundingBox.a, this.a) > Math.min(boundingBox.d, this.d)) {
            return null;
        }
        if (Math.max(boundingBox.b, this.b) > Math.min(boundingBox.e, this.e)) {
            return null;
        }
        if (Math.max(boundingBox.c, this.c) > Math.min(boundingBox.f, this.f)) {
            return null;
        }
        return new BoundingBox(new Point(Math.max(boundingBox.a, this.a), Math.max(boundingBox.b, this.b), Math.max(boundingBox.c, this.c)), new Point(Math.min(boundingBox.d, this.d), Math.min(boundingBox.e, this.e), Math.min(boundingBox.f, this.f)));
    }

    public Point center() {
        return new Point((this.a - this.a) / 2.0, (this.e - this.b) / 2.0, (this.f - this.c) / 2.0);
    }

    public double getMinX() {
        return this.a;
    }

    public double getMinY() {
        return this.b;
    }

    public double getMinZ() {
        return this.c;
    }

    public double getMaxX() {
        return this.d;
    }

    public double getMaxY() {
        return this.e;
    }

    public double getMaxZ() {
        return this.f;
    }

    public double getWidth() {
        return this.d - this.a;
    }

    public double getHeight() {
        return this.e - this.b;
    }

    public double getDepth() {
        return this.f - this.c;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        return "[BB: " + decimalFormat.format(this.a) + "," + decimalFormat.format(this.b) + "," + decimalFormat.format(this.c) + "-" + decimalFormat.format(this.d) + "," + decimalFormat.format(this.e) + "," + decimalFormat.format(this.f) + "]";
    }
}

