/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.awt.Color;
import java.awt.Paint;
import org.faceless.graph.AbstractBarGraph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;

public class FloatingBarGraph
extends AbstractBarGraph {
    public FloatingBarGraph() {
        this.setColor("MIN", Color.blue);
        this.setColor("MAX", Color.red);
        this.optionDisplayKey(0);
        this.minz = -1.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(String string, double d2, double d3, double d4) {
        double d5;
        if (Double.isInfinite(d2 + d4 + d3)) {
            throw new IllegalArgumentException("Cannot set an infinite sized bar.");
        }
        if (d3 != (double)Math.round(d3) || d2 != (double)Math.round(d2) || d4 != (double)Math.round(d4)) {
            this.yfloat = true;
        }
        if (d3 > d4) {
            d5 = d4;
            d4 = d3;
            d3 = d5;
        }
        if (d3 < d2) {
            d5 = d2;
            d2 = d3;
            d3 = d5;
        }
        if (d3 > d4) {
            d5 = d4;
            d4 = d3;
            d3 = d5;
        }
        this.data.set(this.xkey.find(string), 0.0, 0.0, d2);
        this.data.set(this.xkey.find(string), 1.0, 0.0, d3);
        this.data.set(this.xkey.find(string), 2.0, 0.0, d4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setColor(String string, Paint paint) {
        if (!string.equals("MIN") && !string.equals("MAX")) {
            throw new IllegalArgumentException("Set name must be MIN or MAX");
        }
        this.key.setKey(string, paint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void plotBar(int n2, int n3, int n4, double d2) {
        if (n3 == 0) {
            return;
        }
        double d3 = 0.0;
        if (n3 == 1 && (d3 = this.data.get(new Double(n2), new Double(0.0), new Double(0.0)).doubleValue()) == d2) {
            return;
        }
        if (n3 == 2) {
            d3 = this.data.get(new Double(n2), new Double(1.0), new Double(0.0));
        }
        this.key.needKey(n3 - 1);
        if (!Double.isNaN(d2) && !Double.isNaN(d3)) {
            double d4 = (double)n2 - this.barwidth / 2.0 + 0.5;
            double d5 = (double)(-n4) - this.bardepth / 2.0 + 0.5;
            Point point = new Point(d4, d3, d5);
            Point point2 = new Point(d4 + this.barwidth, d2, d5 - this.bardepth);
            this.minx = Math.min(this.minx, (double)n2);
            this.maxx = Math.max(this.maxx, (double)(n2 + 1));
            this.minv = Math.min(this.minv, d3);
            this.maxv = Math.max(this.maxv, d2);
            Style style = new Style(this.key.getColor(n3 - 1));
            style.b(this);
            this.addElement(this.getBoxElement(this.xkey.getKey(n2) + "-" + this.key.getKey(n3 - 1), point, point2, style));
            this.plotBarValue(point, point2, d2);
            return;
        }
    }
}

