/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.awt.Paint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import org.faceless.graph.Graph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;
import org.faceless.graph.b;
import org.faceless.graph.f;
import org.faceless.graph.formatter.PercentageFormatter;
import org.faceless.graph.g;
import org.faceless.graph.h;
import org.faceless.graph.i;

public class PieGraph
extends Graph {
    public static final int KEY_FLAT_INNER_FLAT_OUTER = 4;
    public static final int KEY_ROTATED_INNER_FLAT_OUTER = 5;
    public static final int KEY_FLAT_INNER_ROTATED_OUTER = 6;
    public static final int KEY_ROTATED_INNER_ROTATED_OUTER = 7;
    public static final int KEY_FLAT_OUTER = 8;
    public static final int KEY_ROTATED_OUTER = 10;
    public static final int PERCENTAGE_NONE = 0;
    public static final int PERCENTAGE_WITH_KEY = 9;
    public static final int PERCENTAGE_INLINE = 17;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private boolean s;
    private int t;
    private String u;
    private Map v;
    private double w = 0.0;
    private b x = new b();

    public PieGraph() {
        this.v = new HashMap();
        this.optionHeight(15.0);
        this.optionOuterKeyPercentage(3.0);
        this.optionOuterKeyLineLength(20.0);
        this.optionOtherLabel("Other");
        this.optionOtherPercentage(0.0);
        this.optionFixedAspectRatio(true);
        this.optionDisplayZeros(false);
        this.r = 90.0;
    }

    public void setColor(String string, Paint paint) {
        this.key.setKey(string, paint);
    }

    public void extendSlice(String string, double d2) {
        this.v.put(string, new Double(d2));
    }

    public void set(String string, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Pie graph values must always >= zero");
        }
        this.x.set(this.key.find(string), 0.0, 0.0, d2);
    }

    public void optionDisplayKey(int n2) {
        super.optionDisplayKey(n2);
    }

    public void optionHeight(double d2) {
        this.n = d2 / 100.0 * 150.0;
    }

    public void optionDisplayZeros(boolean bl) {
        this.s = bl;
    }

    public void optionDisplayPercentage(int n2) {
        this.t = n2;
    }

    public void optionOtherPercentage(double d2) {
        this.q = d2 * 3.6;
    }

    public void optionOtherLabel(String string) {
        this.u = string;
    }

    public void optionOuterKeyPercentage(double d2) {
        this.o = d2 * 3.6;
    }

    public void optionOuterKeyLineLength(double d2) {
        this.p = Math.max(0.01, d2 / 100.0) + 1.0;
    }

    public void optionYRotation(double d2) {
        this.w = d2;
    }

    public void optionXRotation(double d2) {
        super.optionXRotation(-d2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void complete() {
        double d2;
        super.complete();
        if ((this.keytype & 0xC) != 0) {
            if ((this.t & 0x18) == 17) {
                this.t = (this.t & 7) + 9;
            }
            if ((this.keytype & 4) == 0) {
                this.o = 360.0;
            }
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Point point = new Point(0.0, 0.0, 0.0);
        SortedSet sortedSet = this.x.getXSet();
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            double d6 = this.x.get((Double)iterator.next(), new Double(0.0), new Double(0.0));
            if (d6 == 0.0 && !this.s) {
                iterator.remove();
                continue;
            }
            d3 += d6;
        }
        if (d3 == 0.0) {
            return;
        }
        int n2 = 0;
        iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            double d7 = this.x.get((Double)iterator.next(), new Double(0.0), new Double(0.0));
            if (!(d7 / d3 * 360.0 < this.q)) continue;
            ++n2;
        }
        for (Double d8 : sortedSet) {
            d2 = this.x.get(d8, new Double(0.0), new Double(0.0));
            if (n2 > 1 && d2 / d3 * 360.0 < this.q) {
                d5 += d2;
                continue;
            }
            Style style = new Style(this.key.getColor(d8.intValue()));
            style.b(this);
            double d9 = d4 / d3 * 360.0 + this.w;
            double d10 = (d4 + d2) / d3 * 360.0 + this.w;
            this.a(point, style, this.key.getKey(d8.intValue()), d9, d10, d2);
            d4 += d2;
        }
        if (d5 != 0.0) {
            Style style = new Style(this.key.getColor(this.key.find(this.u)));
            style.b(this);
            d2 = d4 / d3 * 360.0 + this.w;
            double d11 = (d4 + d5) / d3 * 360.0 + this.w;
            this.a(point, style, this.u, d2, d11, d5);
        }
        if (this.keystyle == null) return;
        this.keystyle.setRotate(0.0);
        this.keystyle.setAlign(24);
    }

    private void a(Point point, Style style, String string, double d2, double d3, double d4) {
        String string2;
        Style style2 = new Style(Style.getDefaultBorderColor());
        style2.b(this);
        this.key.needKey(this.key.find(string));
        int n2 = 24;
        if (this.v.size() > 0) {
            n2 |= 3;
        }
        double d5 = (d2 + d3) / 2.0;
        Point point2 = point;
        if (this.v.containsKey(string)) {
            double d6 = (Double)this.v.get(string);
            point2 = f.piePoint(point, d5, d6, 0.0, false);
        }
        Point point3 = f.piePoint(point2, 0.0, 0.0, this.n / 1.98, false);
        if (d4 != 0.0) {
            this.addElement(new f(string, point2, d2, d3, 150.0, this.n, n2, style));
        }
        if ((this.t & 0x18) == 8) {
            string2 = new PercentageFormatter(this.t & 7).format((d3 - d2) / 360.0);
            int n3 = this.key.find(string);
            string = string + " (" + string2 + ")";
            this.key.setKey(n3, string);
        }
        if ((this.t & 0x18) == 16) {
            string2 = new PercentageFormatter(this.t & 7).format((d3 - d2) / 360.0);
            this.a(string2, 4, point3, d2, d3, style2);
        }
        if (this.keystyle != null) {
            this.a(string, this.keytype, point3, d2, d3, style2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(String string, int n2, Point point, double d2, double d3, Style style) {
        Point point2;
        Style style2 = (Style)this.keystyle.clone();
        if ((n2 & 0xC) == 0) return;
        double d4 = ((d2 + d3) / 2.0 + 360.0) % 360.0;
        if ((n2 & 4) == 4 && d3 - d2 < this.o) {
            n2 = (n2 & 2) + 8;
        }
        if ((n2 & 8) == 8) {
            double d5 = 150.0 * this.p;
            point2 = f.piePoint(point, d4, 150.0, 0.0, false);
            if ((n2 & 2) == 2) {
                style2.setAlign(24);
                style2.setRotate(d4 - 90.0);
                Point point3 = f.piePoint(point, d4, d5, 0.0, false);
                this.addElement(new h(string, point3, style2, point, f.piePoint(point, d4, 150.0, 0.0, false)));
                Point point4 = f.piePoint(point, d4, d5 * 0.95, 0.0, false);
                this.addElement(new g(string + "-OutKey", point2, point4, style));
            } else {
                int n3 = 0;
                if (d4 < 22.0 || d4 >= 338.0) {
                    n3 = 36;
                } else if (d4 < 67.0) {
                    n3 = 12;
                } else if (d4 < 112.0) {
                    n3 = 24;
                } else if (d4 < 157.0) {
                    n3 = 9;
                } else if (d4 < 202.0) {
                    n3 = 33;
                } else if (d4 < 247.0) {
                    n3 = 3;
                } else if (d4 < 292.0) {
                    n3 = 18;
                } else if (d4 < 338.0) {
                    n3 = 6;
                }
                style2.setAlign(n3);
                Point point5 = f.piePoint(point, d4, d5, 0.0, false);
                i i2 = new i(string, point5, point2, style2);
                this.addElement(i2);
            }
        }
        if ((n2 & 4) != 4) return;
        if ((n2 & 1) != 1) {
            style2.setAlign(48);
            Point point6 = f.piePoint(point, d4, 112.5, 0.0, false);
            this.addElement(new h(string, point6, style2));
            return;
        }
        if (d3 - d2 > this.r && (d4 + this.zrotation > 135.0 && d4 + this.zrotation < 225.0 || d4 + this.zrotation > 315.0 || d4 + this.zrotation < 45.0)) {
            style2.setAlign(48);
            Point point7 = f.piePoint(point, d4, 150.0 * Math.max(0.5, 80.0 / (d3 - d2)), 0.0, false);
            Point point8 = f.piePoint(point, d2, 150.0, 0.0, false);
            point2 = f.piePoint(point, d3, 150.0, 0.0, false);
            this.addElement(new h(string, point7, style2, point8, point2));
            return;
        }
        style2.setAlign(18);
        Point point9 = f.piePoint(point, d4, 142.5, 0.0, false);
        this.addElement(new h(string, point9, style2, point, point9));
    }

    protected void postpostcomplete() {
        this.canvas.a();
    }
}

