/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.faceless.graph.AbstractBarGraph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;

public class TowerBarGraph
extends AbstractBarGraph {
    private Map y = new HashMap();
    private Map z = new HashMap();

    public void setColor(String string, Paint paint) {
        this.key.setKey(string, paint);
    }

    public void set(String string, String string2, double d2) {
        if (Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Cannot set an infinite sized bar.");
        }
        if (d2 != (double)Math.round(d2)) {
            this.yfloat = true;
        }
        this.data.set(this.xkey.find(string), this.key.find(string2), 0.0, d2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void plotBar(int n2, int n3, int n4, double d2) {
        double d3;
        this.key.needKey(n3);
        if (Double.isNaN(d2)) {
            return;
        }
        Integer n5 = new Integer(n2);
        if (d2 >= 0.0) {
            d3 = this.y.containsKey(n5) ? (Double)this.y.get(n5) : Math.max(this.absoluteminy, 0.0);
            d2 = d3 + d2;
            this.y.put(n5, new Double(d2));
        } else {
            d3 = this.z.containsKey(n5) ? (Double)this.z.get(n5) : Math.max(this.absoluteminy, 0.0);
            d2 = d3 + d2;
            this.z.put(n5, new Double(d2));
        }
        double d6 = (double)n2 + 0.5;
        double d7 = d3;
        double d8 = (double)(-n4) - 0.5;
        this.minx = Math.min(this.minx, d6 - 0.5);
        this.maxx = Math.max(this.maxx, d6 + 0.5);
        this.minz = Math.min(this.minz, d8 - 0.5);
        this.maxz = Math.max(this.maxz, d8 + 0.5);
        this.minv = Math.min(this.minv, Math.min(d2, d3));
        this.maxv = Math.max(this.maxv, Math.max(d2, d3));
        Point point = new Point(d6 - this.barwidth / 2.0, d3, d8 + this.bardepth / 2.0);
        Point point2 = new Point(d6 + this.barwidth / 2.0, d2, d8 - this.bardepth / 2.0);
        Style style = new Style(this.key.getColor(n3));
        style.b(this);
        this.addElement(this.getBoxElement("Data" + n2 + "," + n3, point, point2, style));
        this.plotBarValue(point, point2, d2 - d3);
    }
}

