/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.math;

public class Matrix {
    int a;
    int b;
    double[][] c;

    public Matrix(int n2, int n3) {
        this.b = n2;
        this.a = n3;
        this.c = new double[n3][n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.c[i2][i3] = 0.0;
            }
            continue;
        }
    }

    public Matrix(Matrix matrix) {
        this.b = matrix.b;
        this.a = matrix.a;
        this.c = new double[this.a][this.b];
        for (int i2 = 0; i2 < this.b; ++i2) {
            for (int i3 = 0; i3 < this.a; ++i3) {
                this.set(i2, i3, matrix.get(i2, i3));
            }
            continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(int n2, int n3, double d2) {
        if (n3 < this.a && n2 < this.b && n3 >= 0 && n2 >= 0) {
            this.c[n3][n2] = d2;
            return;
        }
        throw new ArrayIndexOutOfBoundsException("Trying to set element " + n2 + "," + n3 + " in " + this.b + "x" + this.a + " matrix");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double get(int n2, int n3) {
        if (n3 < this.a && n2 < this.b && n3 >= 0 && n2 >= 0) {
            return this.c[n3][n2];
        }
        throw new ArrayIndexOutOfBoundsException("Trying to get element " + n2 + "," + n3 + " in " + this.b + "x" + this.a + " matrix");
    }

    public String toString() {
        String string = "";
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                string = string + this.c[i2][i3] + "   ";
            }
            string = string + "\n";
        }
        return string;
    }

    public Matrix exchangeRows(int n2, int n3) {
        Matrix matrix = new Matrix(this);
        double[] dArray = this.c[n3];
        this.c[n3] = this.c[n2];
        this.c[n2] = dArray;
        return matrix;
    }

    public static Matrix identity(int n2) {
        Matrix matrix = new Matrix(n2, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            matrix.set(i2, i2, 1.0);
        }
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix add(Matrix matrix) {
        if (this.b != matrix.b || this.a != matrix.a) {
            throw new IllegalArgumentException("Cannot add " + this.b + "x" + this.a + " matrix by " + matrix.b + "x" + matrix.a);
        }
        Matrix matrix2 = new Matrix(this.b, this.a);
        int i2 = 0;
        while (i2 < this.a) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                matrix2.set(i3, i2, this.get(i3, i2) + matrix.get(i3, i2));
            }
            ++i2;
        }
        return matrix2;
    }

    public int getRows() {
        return this.a;
    }

    public int getCols() {
        return this.b;
    }

    public Matrix mul(double d2) {
        Matrix matrix = new Matrix(this.b, this.a);
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < this.b; ++i3) {
                matrix.set(i3, i2, this.get(i3, i2) * d2);
            }
            continue;
        }
        return matrix;
    }

    public Matrix mul(Matrix matrix) {
        if (this.b != matrix.a) {
            throw new IllegalArgumentException("Cannot multiply " + this.b + "x" + this.a + " matrix by " + matrix.b + "x" + matrix.a);
        }
        Matrix matrix2 = new Matrix(matrix.b, this.a);
        for (int i2 = 0; i2 < this.a; ++i2) {
            for (int i3 = 0; i3 < matrix.b; ++i3) {
                double d2 = 0.0;
                for (int i4 = 0; i4 < this.b; ++i4) {
                    d2 += this.get(i4, i2) * matrix.get(i3, i4);
                }
                matrix2.set(i3, i2, d2);
            }
        }
        return matrix2;
    }

    public Matrix div(Matrix matrix) {
        return this.mul(matrix.inverse());
    }

    public Matrix appendHorizontal(Matrix matrix) {
        if (matrix.a != this.a) {
            throw new IllegalArgumentException("Can't append a " + matrix.a + "-row matrix to a " + this.a + "-row matrix");
        }
        Matrix matrix2 = new Matrix(this.b + matrix.b, this.a);
        for (int i2 = 0; i2 < this.a; ++i2) {
            int n2;
            for (n2 = 0; n2 < this.b; ++n2) {
                matrix2.set(n2, i2, this.get(n2, i2));
            }
            for (n2 = 0; n2 < matrix.b; ++n2) {
                matrix2.set(this.b + n2, i2, matrix.get(n2, i2));
            }
            continue;
        }
        return matrix2;
    }

    public Matrix appendVertical(Matrix matrix) {
        if (matrix.b != this.b) {
            throw new IllegalArgumentException("Can't append a " + matrix.b + "-column matrix to a " + this.b + "-column matrix");
        }
        Matrix matrix2 = new Matrix(this.b + matrix.b, this.a);
        for (int i2 = 0; i2 < this.b; ++i2) {
            int n2;
            for (n2 = 0; n2 < this.a; ++n2) {
                matrix2.set(i2, n2, this.get(i2, n2));
            }
            for (n2 = 0; n2 < matrix.a; ++n2) {
                matrix2.set(i2, this.a + n2, matrix.get(i2, n2));
            }
            continue;
        }
        return matrix2;
    }

    public Matrix subMatrix(int n2, int n3, int n4, int n5) {
        Matrix matrix = new Matrix(n4, n5);
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            for (int i3 = n3; i3 < n3 + n5; ++i3) {
                matrix.set(i2 - n2, i3 - n3, this.get(i2, i3));
            }
            continue;
        }
        return matrix;
    }

    public Matrix inverse() throws ArithmeticException {
        Matrix matrix = this.appendHorizontal(Matrix.identity(Math.min(this.b, this.a)));
        for (int i2 = 0; i2 < Math.min(this.a, this.b); ++i2) {
            int n2 = i2;
            while (true) {
                if (n2 >= this.a - 1 || matrix.get(i2, n2) != 0.0) break;
                matrix = matrix.exchangeRows(i2, ++n2);
            }
            if (matrix.get(i2, i2) == 0.0) {
                throw new ArithmeticException("No inverse for this matrix");
            }
            matrix = matrix.pivot(i2, i2);
        }
        return matrix.subMatrix(this.b, 0, this.b, this.a);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix pivot(int n2, int n3) {
        int n4;
        Matrix matrix = new Matrix(this);
        for (n4 = 0; n4 < this.b; ++n4) {
            matrix.set(n4, n3, this.get(n4, n3) / this.get(n2, n3));
        }
        n4 = 0;
        while (n4 < this.a) {
            double d2 = this.get(n2, n4) / this.get(n2, n3);
            for (int n5 = 0; n5 < this.b; ++n5) {
                if (n4 == n3) continue;
                matrix.set(n5, n4, this.get(n5, n4) - this.get(n5, n3) * d2);
            }
            ++n4;
        }
        return matrix;
    }

    public static void main(String[] stringArray) {
        Matrix matrix = Matrix.identity(3);
        Matrix matrix2 = Matrix.identity(3);
        Matrix matrix3 = Matrix.identity(3);
        matrix.set(0, 2, 100.0);
        matrix.set(1, 2, 50.0);
        matrix2.set(0, 0, 0.48);
        matrix2.set(1, 1, 0.88);
        matrix3.set(0, 2, -100.0);
        matrix3.set(1, 2, -50.0);
        Matrix matrix4 = matrix.mul(matrix2);
        System.err.println(matrix4);
    }
}

