/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.output;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.faceless.graph.BoundingBox;
import org.faceless.graph.Graph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;
import org.faceless.graph.output.Output;
import org.faceless.graph.output.b;

public class ImageOutput
extends Output {
    private Graph a;
    protected Graphics2D g = null;
    protected Image image = null;
    protected int width;
    protected int height;
    private int b = 0;
    private int c = 0;
    private int d = 0;
    private int e = 0;
    private float f = 1.0f;
    private float h = 0.0f;
    private float[] i = new float[]{0.0f, 0.0f};
    private Map j;

    public ImageOutput(int n2, int n3) {
        this(n2, n3, null);
    }

    public ImageOutput(int n2, int n3, Color color) {
        this.textAlign = 12;
        this.j = new HashMap();
        this.image = new BufferedImage(n2, n3, 2);
        this.width = n2;
        this.height = n3;
        this.g = (Graphics2D)this.image.getGraphics();
        if (color != null) {
            this.g.setColor(color);
            this.g.fillRect(0, 0, n2, n3);
        }
        this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public ImageOutput(Image image) {
        this.textAlign = 12;
        this.j = new HashMap();
        this.image = image;
        b_ b_2 = new b_();
        this.width = image.getWidth(b_2);
        this.height = image.getHeight(b_2);
        this.g = (Graphics2D)image.getGraphics();
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g.setRenderingHint(key, object);
    }

    public void setMargin(int n2, int n3, int n4, int n5) {
        this.c = n2;
        this.b = n3;
        this.d = n4;
        this.e = n5;
    }

    public final boolean canRotate() {
        return true;
    }

    public final boolean canPattern() {
        return true;
    }

    public BoundingBox getCanvas() {
        return new BoundingBox(new Point(this.c + 1, this.e + 2), new Point(this.width - this.d - 1, this.height - this.b - 1));
    }

    public void setColor(Paint paint) {
        block2: {
            block3: {
                if (paint == null) break block2;
                if (!(paint instanceof GradientPaint)) break block3;
                Point2D point2D = ((GradientPaint)paint).getPoint1();
                Point2D point2D2 = ((GradientPaint)paint).getPoint2();
                point2D.setLocation(this.a(point2D.getX()), this.b(point2D.getY()));
                point2D2.setLocation(this.a(point2D2.getX()), this.b(point2D2.getY()));
                Color color = ((GradientPaint)paint).getColor1();
                Color color2 = ((GradientPaint)paint).getColor2();
                paint = new GradientPaint(point2D, color, point2D2, color2);
            }
            this.g.setPaint(paint);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLineThickness(double d2) {
        if (d2 > 0.0 && d2 != (double)this.f) {
            this.f = (float)d2;
            this.g.setStroke(new BasicStroke(this.f, 0, 0, 10.0f, this.i[0] * this.i[1] == 0.0f ? null : this.i, this.h));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLineDash(double d2, double d3, double d4) {
        if (d2 == 0.0 || d3 == 0.0) {
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
        }
        if (d2 != (double)this.i[0] || d3 != (double)this.i[1] || (d4 %= d2 + d3) != (double)this.h) {
            this.i[0] = (float)d2;
            this.i[1] = (float)d3;
            this.h = (float)d4;
            this.g.setStroke(new BasicStroke(this.f, 0, 0, 10.0f, this.i[0] * this.i[1] == 0.0f ? null : this.i, this.h));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void line(double d2, double d3, double d4, double d5) {
        if (!(this.f > 0.0f)) return;
        if (d2 != d4 && d3 != d5) {
            this.g.draw(new Line2D.Double(this.a(d2), this.b(d3), this.a(d4), this.b(d5)));
            return;
        }
        this.g.drawLine(this.c(d2), this.d(d3), this.c(d4), this.d(d5));
    }

    public void poly(String string, double[] dArray, double[] dArray2, int n2) {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.c(dArray[i2]);
            nArray2[i2] = this.d(dArray2[i2]);
        }
        this.g.fillPolygon(nArray, nArray2, n2);
    }

    private double a(double d2) {
        return d2;
    }

    private double b(double d2) {
        return (double)this.height - d2;
    }

    private int c(double d2) {
        return (int)Math.round(this.a(d2));
    }

    private int d(double d2) {
        return (int)Math.round(this.b(d2));
    }

    public void setFontMap(String string, int n2, Font font) {
        this.j.put(string.toLowerCase() + " " + n2, font.deriveFont(1));
    }

    private Font a(String string, int n2, float f2) {
        String string2;
        block4: {
            string2 = string + " " + n2 + " " + (int)f2;
            if (!this.j.containsKey(string2)) {
                block3: {
                    Font font = (Font)this.j.get(string + " " + n2);
                    if (font == null) break block3;
                    this.j.put(string2, font.deriveFont(f2));
                    break block4;
                }
                this.j.put(string2, new Font(string, n2, 1).deriveFont(f2));
            }
        }
        return (Font)this.j.get(string2);
    }

    public BoundingBox getTextBox(String string, Style style) {
        FontMetrics fontMetrics = this.g.getFontMetrics(this.a(style.getFontName(), style.getFontStyle(), style.getFontSize()));
        Rectangle2D.Float float_ = (Rectangle2D.Float)fontMetrics.getStringBounds(string, this.g);
        float_.y = -(float_.height + float_.y);
        Point point = new Point(0.0, 0.0);
        Point point2 = this.getTextAnchor(float_.x, float_.y, float_.width, float_.height + float_.y, style.getAlign());
        Point point3 = new Point(point2.x() + (double)float_.width, point2.y());
        Point point4 = new Point(point2.x(), point2.y() + (double)float_.height);
        Point point5 = new Point(point3.x(), point3.y() + (double)float_.height);
        if (this.canRotate()) {
            point4 = this.rotate(point, point4, style.getRotate());
            point5 = this.rotate(point, point5, style.getRotate());
            point2 = this.rotate(point, point2, style.getRotate());
            point3 = this.rotate(point, point3, style.getRotate());
        }
        BoundingBox boundingBox = new BoundingBox(point4, point5).superset(new BoundingBox(point2, point3));
        return boundingBox;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void text(String string, double d2, double d3, Style style) {
        this.setColor(style.getColor());
        this.g.setFont(this.a(style.getFontName(), style.getFontStyle(), style.getFontSize()));
        int n2 = style.getAlign();
        FontMetrics fontMetrics = this.g.getFontMetrics(this.g.getFont());
        Rectangle2D.Float float_ = (Rectangle2D.Float)fontMetrics.getStringBounds(string, this.g);
        float_.y = -(float_.height + float_.y);
        Point point = this.getTextAnchor(d2, d3, float_.width, float_.height + float_.y, n2);
        if (!this.canRotate()) {
            this.g.drawString(string, this.c(point.x()), this.d(point.y()));
            return;
        }
        double d5 = this.canRotate() ? style.getRotate() : 0.0;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d5 *= Math.PI / 180, this.c(d2), this.d(d3));
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(-d5, this.c(d2), this.d(d3));
        this.g.transform(affineTransform);
        this.g.drawString(string, this.c(point.x()), this.d(point.y()));
        this.g.transform(affineTransform2);
    }

    public void render(Graph graph) throws IOException {
        this.a = graph;
        graph.toCanvas(this);
        this.a = null;
    }

    public Graph getGraph() {
        return this.a;
    }

    public Image getImage() {
        return this.image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getReducedColorImage(int n2, Color color) {
        if (n2 >= 2 && n2 <= 256) {
            return new b(this.image, color).convert(n2);
        }
        throw new IllegalArgumentException("Number of colors must be between 2 and 256");
    }

    private class b_
    implements ImageObserver {
        private b_() {
        }

        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            return (n2 & 0xA0) == 0;
        }
    }
}

