/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.faceless.pdf.LayoutBox;
import org.faceless.pdf.PDFAction;
import org.faceless.pdf.PDFAnnotation;
import org.faceless.pdf.PDFImage;
import org.faceless.pdf.PDFStyle;
import org.faceless.pdf.a;
import org.faceless.pdf2.BarCode;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.PDFCanvas;

public final class PDFPage
extends a {
    final org.faceless.pdf2.PDFPage b;
    private PDFStyle c;
    private a_ d;
    private Stack e;
    private float f;
    private float g;
    private float h;
    private float i;
    private float j;
    private float k;
    public static final int FILTER_FLATE = 0;
    public static final int FILTER_NONE = 0;
    public static final int INCHES = 4;
    public static final int CM = 8;
    public static final int MM = 12;
    public static final int PICAS = 16;
    public static final int PERCENT = 20;
    public static final int POINTS = 24;
    public static final int PAGEBOTTOM = 0;
    public static final int PAGETOP = 1;
    public static final int PAGELEFT = 0;
    public static final int PAGERIGHT = 2;
    public static final int BARCODE39 = 0;
    public static final int BARCODE39CHECKSUM = 1;
    public static final int BARCODE25 = 2;
    public static final int BARCODE25CHECKSUM = 3;
    public static final int BARCODE39X = 4;
    public static final int BARCODE39XCHECKSUM = 5;
    public static final int BARCODE128 = 6;
    public static final int BARCODEEAN13 = 7;
    public static final int BARCODEUPCA = 9;
    public static final int BARCODECODABAR = 8;

    PDFPage(org.faceless.pdf2.PDFPage pDFPage) {
        this.b = pDFPage;
        this.d = new a_();
        this.e = new Stack();
        this.setCanvas(0.0f, 0.0f, pDFPage.getWidth(), pDFPage.getHeight(), 24, 0);
    }

    Object a() {
        return this.b;
    }

    public float getWidth() {
        return this.b.getWidth();
    }

    public float getHeight() {
        return this.b.getHeight();
    }

    public int getPageNumber() {
        return this.b.getPageNumber();
    }

    public void setCanvas(float f2, float f3, float f4, float f5, int n2, int n3) {
        block20: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block19: {
                                float f6 = 1.0f;
                                boolean bl = false;
                                this.f = f2;
                                this.g = f3;
                                if (n2 != 24) break block19;
                                this.i = 1.0f;
                                this.h = 1.0f;
                                break block20;
                            }
                            if (n2 != 4) break block21;
                            this.i = 72.0f;
                            this.h = 72.0f;
                            break block20;
                        }
                        if (n2 != 8) break block22;
                        this.i = 28.346457f;
                        this.h = 28.346457f;
                        break block20;
                    }
                    if (n2 != 12) break block23;
                    this.i = 2.8346457f;
                    this.h = 2.8346457f;
                    break block20;
                }
                if (n2 != 16) break block24;
                this.i = 12.0f;
                this.h = 12.0f;
                break block20;
            }
            if (n2 == 20) {
                this.i = f5 / 100.0f;
                this.h = f4 / 100.0f;
            }
        }
        if ((n3 & 1) == 1) {
            this.i = -this.i;
            this.g += f5;
        }
        if ((n3 & 2) == 2) {
            this.h = -this.h;
            this.f += f4;
        }
        this.j = f4;
        this.k = f5;
    }

    private final float a(float f2) {
        return (this.f + f2 * this.h) * this.d.c + this.d.a;
    }

    private final float b(float f2) {
        return (this.g + f2 * this.i) * this.d.d + this.d.b;
    }

    private final float c(float f2) {
        return this.f + f2 * this.h;
    }

    private final float d(float f2) {
        return this.g + f2 * this.i;
    }

    public float getCanvasHeight() {
        return this.k;
    }

    public float getCanvasWidth() {
        return this.j;
    }

    public void setStyle(PDFStyle pDFStyle) {
        this.b.setStyle(pDFStyle.b);
        this.c = pDFStyle;
    }

    public PDFStyle getStyle() {
        return (PDFStyle)a.a(this.b.getStyle());
    }

    public void drawLine(float f2, float f3, float f4, float f5) {
        this.b.drawLine(this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    public void drawRectangle(float f2, float f3, float f4, float f5) {
        this.b.drawRectangle(this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    public void drawRoundedRectangle(float f2, float f3, float f4, float f5, float f6) {
        this.b.drawRoundedRectangle(this.a(f2), this.b(f3), this.a(f4), this.b(f5), f6);
    }

    public void drawPolygon(float[] fArray, float[] fArray2) {
        int n2;
        float[] fArray3 = new float[fArray.length];
        float[] fArray4 = new float[fArray2.length];
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray3[n2] = this.a(fArray[n2]);
        }
        for (n2 = 0; n2 < fArray2.length; ++n2) {
            fArray4[n2] = this.b(fArray2[n2]);
        }
        this.b.drawPolygon(fArray3, fArray4);
    }

    public void drawEllipse(float f2, float f3, float f4, float f5) {
        this.b.drawEllipse(this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    public void drawCircle(float f2, float f3, float f4) {
        this.b.drawEllipse(this.a(f2 - f4), this.b(f3 - f4), this.a(f2 + f4), this.b(f3 + f4));
    }

    public void drawEllipseArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.b.drawEllipseArc(this.a(f2), this.b(f3), this.a(f4), this.b(f5), f6, f7);
    }

    public void drawCircleArc(float f2, float f3, float f4, float f5, float f6) {
        this.b.drawEllipseArc(this.a(f2 - f4), this.b(f3 - f4), this.a(f2 + f4), this.b(f3 + f4), f5, f6);
    }

    public void pathMove(float f2, float f3) {
        this.b.pathMove(this.a(f2), this.b(f3));
    }

    public void pathLine(float f2, float f3) {
        this.b.pathLine(this.a(f2), this.b(f3));
    }

    public void pathBezier(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.b.pathBezier(this.a(f2), this.b(f3), this.a(f4), this.b(f5), this.a(f6), this.b(f7));
    }

    public void pathArc(float f2, float f3, float f4, float f5) {
        this.b.pathArc(f2, f3, f4, f5);
    }

    public void pathClose() {
        this.b.pathClose();
    }

    public void pathCancel() {
        this.b.pathCancel();
    }

    public void pathPaint() {
        this.b.pathPaint();
    }

    public void pathClipAndPaint() {
        this.b.pathClipAndPaint();
    }

    public void pathClip() {
        this.b.pathClip();
    }

    public void clipRectangle(float f2, float f3, float f4, float f5) {
        this.b.clipRectangle(this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    public void clipRoundedRectangle(float f2, float f3, float f4, float f5, float f6) {
        this.b.clipRoundedRectangle(this.a(f2), this.b(f3), this.a(f4), this.b(f5), f6);
    }

    public void clipPolygon(float[] fArray, float[] fArray2) {
        int n2;
        float[] fArray3 = new float[fArray.length];
        float[] fArray4 = new float[fArray2.length];
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray3[n2] = this.a(fArray[n2]);
        }
        for (n2 = 0; n2 < fArray2.length; ++n2) {
            fArray4[n2] = this.b(fArray2[n2]);
        }
        this.b.clipPolygon(fArray3, fArray4);
    }

    public void clipEllipse(float f2, float f3, float f4, float f5) {
        this.b.clipEllipse(this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    public void clipCircle(float f2, float f3, float f4) {
        this.b.clipCircle(this.a(f2), this.b(f3), f4);
    }

    public void save() {
        this.b.save();
        this.e.push(this.d);
    }

    public void restore() {
        this.b.restore();
        this.d = (a_)this.e.pop();
    }

    public void undo() {
        throw new UnsupportedOperationException("The undo() method has been removed in version 2 with no replacement. You'll need to rewrite your code or stick with version 1");
    }

    public void rotate(float f2, float f3, double d2) {
        this.b.rotate(this.a(f2), this.b(f3), d2);
    }

    public void translate(float f2, float f3) {
        this.d.a += f2 * this.d.c;
        this.d.b += f3 * this.d.d;
    }

    public void scale(float f2, float f3) {
        if (f2 * f3 == 0.0f) {
            throw new IllegalArgumentException("X or Y is zero");
        }
        this.d.c *= f2;
        this.d.d *= f3;
    }

    public void setOpenAction(PDFAction pDFAction) {
        org.faceless.pdf2.PDFPage pDFPage = this.b;
        Event event = Event.OPEN;
        org.faceless.pdf2.PDFAction pDFAction2 = pDFAction == null ? null : pDFAction.b;
        pDFPage.setAction(event, pDFAction2);
    }

    public void setCloseAction(PDFAction pDFAction) {
        org.faceless.pdf2.PDFPage pDFPage = this.b;
        Event event = Event.CLOSE;
        org.faceless.pdf2.PDFAction pDFAction2 = pDFAction == null ? null : pDFAction.b;
        pDFPage.setAction(event, pDFAction2);
    }

    public PDFAction getOpenAction() {
        return (PDFAction)a.a(this.b.getAction(Event.OPEN));
    }

    public PDFAction getCloseAction() {
        return (PDFAction)a.a(this.b.getAction(Event.CLOSE));
    }

    public void setFilter(int n2) {
    }

    public void addAnnotation(PDFAnnotation pDFAnnotation) {
        this.b.getAnnotations().add(pDFAnnotation.b);
    }

    public void removeAnnotation(PDFAnnotation pDFAnnotation) {
        this.b.getAnnotations().remove(pDFAnnotation.b);
    }

    public PDFAnnotation[] getAnnotations() {
        List list = this.b.getAnnotations();
        PDFAnnotation[] pDFAnnotationArray = new PDFAnnotation[list.size()];
        for (int i2 = 0; i2 < pDFAnnotationArray.length; ++i2) {
            pDFAnnotationArray[i2] = (PDFAnnotation)a.a(list.get(i2));
        }
        return pDFAnnotationArray;
    }

    public void seekStart() {
        this.b.seekStart();
    }

    public void seekEnd() {
        this.b.seekEnd();
    }

    public void drawImage(PDFImage pDFImage, float f2, float f3, float f4, float f5) {
        this.b.drawImage(pDFImage.b, this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String requote(String string) {
        char[] cArray = string.toCharArray();
        PDFStyle pDFStyle = this.getStyle();
        if (pDFStyle != null && pDFStyle.getFont() != null && pDFStyle.getFont().requote(cArray, 0, cArray.length, Locale.getDefault())) {
            return new String(cArray, 0, cArray.length);
        }
        return string;
    }

    public float drawBarCode(int n2, String string, float f2, float f3, boolean bl, float f4) throws IllegalArgumentException {
        return this.drawBarCode(n2, string, this.a(f2), this.b(f3), bl, f4, 18, 2.8f);
    }

    public float drawBarCode(int n2, String string, float f2, float f3, boolean bl, float f4, int n3, float f5) throws IllegalArgumentException {
        BarCode barCode;
        if (n2 == 0) {
            barCode = BarCode.newCode39(string, false, f4, f5);
        } else if (n2 == 1) {
            barCode = BarCode.newCode39(string, true, f4, f5);
        } else if (n2 == 4) {
            barCode = BarCode.newCode39Extended(string, false, f4, f5);
        } else if (n2 == 5) {
            barCode = BarCode.newCode39Extended(string, true, f4, f5);
        } else if (n2 == 2) {
            barCode = BarCode.newInterleaved25(string, false, f4, f5);
        } else if (n2 == 3) {
            barCode = BarCode.newInterleaved25(string, true, f4, f5);
        } else if (n2 == 6) {
            barCode = BarCode.newCode128(string, f4);
        } else if (n2 == 7) {
            barCode = BarCode.newEAN13(string, f4 / 0.936f);
        } else if (n2 == 9) {
            barCode = BarCode.newEAN13("0" + string, f4 / 0.036f);
        } else if (n2 == 8) {
            barCode = BarCode.newCodabar(string, f4);
        } else {
            throw new IllegalArgumentException("Unknown barcode type");
        }
        barCode.setShowText(bl);
        barCode.setHeight(n3);
        float f6 = barCode.getWidth();
        float f7 = bl ? f4 * 8.0f : 0.0f;
        float f8 = f7 * 1.2f;
        float f9 = (float)n3 + f8;
        this.b.drawCanvas(barCode.getCanvas(), this.a(f2), this.b(f3) + f9 / 2.0f - f8 / 2.0f, this.a(f2) + f6, this.b(f3) - f9 / 2.0f - f8 / 2.0f);
        return f6;
    }

    public void setMetaData(String string) {
        this.b.setMetaData(string);
    }

    public Reader getMetaData() throws IOException {
        return this.b.getMetaData();
    }

    public void drawPage(PDFPage pDFPage, float f2, float f3, float f4, float f5) {
        pDFPage.b.flush();
        PDFCanvas pDFCanvas = new PDFCanvas(pDFPage.b);
        this.b.drawCanvas(pDFCanvas, this.a(f2), this.b(f3), this.a(f4), this.b(f5));
        if (pDFPage.b.getAnnotations().size() > 0) {
            float f6;
            org.faceless.pdf2.PDFPage pDFPage2 = new org.faceless.pdf2.PDFPage(pDFPage.b);
            f2 = this.c(f2);
            f3 = this.d(f3);
            f4 = this.c(f4);
            f5 = this.d(f5);
            if (f2 > f4) {
                f6 = f2;
                f2 = f4;
                f4 = f6;
            }
            if (f3 > f5) {
                f6 = f3;
                f3 = f5;
                f5 = f6;
            }
            List list = pDFPage2.getAnnotations();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                org.faceless.pdf2.PDFAnnotation pDFAnnotation = (org.faceless.pdf2.PDFAnnotation)list.get(i2);
                float[] fArray = pDFAnnotation.getRectangle();
                if (fArray != null) {
                    fArray[0] = fArray[0] / (float)pDFPage2.getWidth() * (f4 - f2) + f2;
                    fArray[1] = fArray[1] / (float)pDFPage2.getHeight() * (f5 - f3) + f3;
                    fArray[2] = fArray[2] / (float)pDFPage2.getWidth() * (f4 - f2) + f2;
                    fArray[3] = fArray[3] / (float)pDFPage2.getHeight() * (f5 - f3) + f3;
                    pDFAnnotation.setRectangle(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
                this.b.getAnnotations().add(pDFAnnotation);
            }
        }
    }

    public void drawText(String string, float f2, float f3) {
        this.b.drawText(string, this.a(f2), this.b(f3));
    }

    public void drawTextLink(String string, float f2, float f3, PDFAction pDFAction) {
        this.b.drawTextLink(string, this.a(f2), this.b(f3), pDFAction.b);
    }

    public void beginText(float f2, float f3, float f4, float f5) {
        this.b.beginText(this.a(f2), this.b(f3), this.a(f4), this.b(f5));
    }

    public float continueText(float f2, float f3, float f4, float f5, PDFPage pDFPage) {
        return this.b.continueText(this.a(f2), this.b(f3), this.a(f4), this.b(f5), pDFPage.b);
    }

    public float endText(boolean bl) {
        return this.b.endText(bl);
    }

    public float discardText() {
        return this.b.discardText();
    }

    public float drawText(String string) {
        return this.b.drawText(string);
    }

    public void beginTextLink(PDFAction pDFAction, PDFStyle pDFStyle) {
        this.b.beginTextLink(pDFAction.b, pDFStyle.b);
    }

    public PDFAnnotation[] endTextLink() {
        org.faceless.pdf2.PDFAnnotation[] pDFAnnotationArray = this.b.endTextLink();
        PDFAnnotation[] pDFAnnotationArray2 = new PDFAnnotation[pDFAnnotationArray.length];
        for (int i2 = 0; i2 < pDFAnnotationArray.length; ++i2) {
            pDFAnnotationArray2[i2] = (PDFAnnotation)a.a(pDFAnnotationArray[i2]);
        }
        return pDFAnnotationArray2;
    }

    public void drawLayoutBox(LayoutBox layoutBox, float f2, float f3) {
        this.b.drawLayoutBox(layoutBox.b, this.a(f2), this.b(f3));
    }

    public String toString() {
        return "{Page #" + this.getPageNumber() + "}";
    }

    private class a_ {
        float a;
        float b;
        float c = 1.0f;
        float d = 1.0f;
    }
}

