/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import com.datum.tti.AlgorithmIdentifier;
import com.datum.tti.DataImprint;
import com.datum.tti.DecodingException;
import com.datum.tti.PolicyIdentifier;
import com.datum.tti.TSTInfo;
import com.datum.tti.TTIException;
import com.datum.tti.TimeStampRequest;
import com.datum.tti.TimeStampServerHTTP;
import com.datum.tti.TimeStampServerTCP;
import com.datum.tti.TimeStampToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import org.faceless.pdf2.LayoutBox;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.SignatureHandler;
import org.faceless.pdf2.StandardFont;
import org.faceless.pdf2.bd;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hb;

public class DSE200Handler
extends SignatureHandler {
    private String d;
    private int e;
    private int f;
    private TimeStampToken g;
    private TSTInfo h;
    private MessageDigest i;

    DSE200Handler(String string, int n2, int n3) {
        this.d = string;
        this.f = n3;
        this.e = n2;
    }

    public String getFilter() {
        return "nCipher.TimeSeal";
    }

    public String getSubFilter() {
        return "ntse.dse.1";
    }

    public Map getVariables() throws GeneralSecurityException {
        LinkedHashMap<String, byte[]> linkedHashMap = new LinkedHashMap<String, byte[]>();
        linkedHashMap.put("Name", new byte[31]);
        linkedHashMap.put("M", new byte[25]);
        linkedHashMap.put("Contents", new byte[6146]);
        return linkedHashMap;
    }

    public boolean isVariableEncrypted(String string) {
        return true;
    }

    public byte[] getVariable(String string) throws GeneralSecurityException {
        try {
            Object object;
            byte[] byArray = null;
            if (string.equals("M")) {
                object = Calendar.getInstance(new SimpleTimeZone(0, "UTC"));
                ((Calendar)object).setTime(this.h.getDate());
                byArray = new bd((Calendar)object).r();
            } else if (string.equals("Name")) {
                string = this.h.getTsaName();
                object = new StringTokenizer(string, ";", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    if (!string2.startsWith("CN=")) continue;
                    byArray = new bd(string2.substring(3), hb.PDF).r();
                }
            }
            object = new ByteArrayOutputStream();
            ((ByteArrayOutputStream)object).write(40);
            bd.a((OutputStream)object).write(byArray);
            ((ByteArrayOutputStream)object).write(41);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (TTIException tTIException) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Error Signing");
            try {
                generalSecurityException.initCause(tTIException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw generalSecurityException;
        }
    }

    protected void prepareToSign(KeyStore keyStore, String string, char[] cArray) throws GeneralSecurityException {
        if (this.d == null) {
            throw new IllegalStateException("No host specified, so cannot be used for signing");
        }
        super.prepareToSign(keyStore, string, cArray);
        this.putNameValue("SubFilter", this.getSubFilter());
        this.i = MessageDigest.getInstance("MD5");
    }

    public MessageDigest getMessageDigest() {
        return this.i;
    }

    public byte[] sign() throws GeneralSecurityException {
        try {
            byte[] byArray;
            TimeStampServerHTTP timeStampServerHTTP;
            byte[] byArray2 = this.i.digest();
            DataImprint dataImprint = new DataImprint();
            dataImprint.setHashAlgorithm(new AlgorithmIdentifier(AlgorithmIdentifier.md5));
            dataImprint.setHashedData(byArray2);
            TimeStampRequest timeStampRequest = new TimeStampRequest();
            timeStampRequest.setDataImprint(dataImprint);
            BigInteger bigInteger = BigInteger.valueOf(new SecureRandom().nextLong());
            timeStampRequest.setNonce(bigInteger);
            timeStampRequest.setCertReq(true);
            timeStampRequest.setReqPolicy(new PolicyIdentifier(PolicyIdentifier.serviceClass));
            if (this.e == 0) {
                timeStampServerHTTP = new TimeStampServerHTTP(this.d);
                byArray = timeStampServerHTTP.submitRequest(timeStampRequest.encodeRequest(), this.f);
            } else {
                timeStampServerHTTP = new TimeStampServerTCP(this.d);
                byArray = timeStampServerHTTP.submitRequest(timeStampRequest.encodeRequest(), this.f);
            }
            timeStampServerHTTP = new TimeStampToken(byArray);
            this.h = timeStampServerHTTP.getTSTInfo();
            if (!timeStampServerHTTP.verifySignature()) {
                throw new GeneralSecurityException("TimeStampToken signature invalid!");
            }
            return byArray;
        }
        catch (TTIException tTIException) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Error Signing");
            try {
                generalSecurityException.initCause(tTIException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw generalSecurityException;
        }
        catch (IOException iOException) {
            throw gc.a(iOException);
        }
    }

    public boolean verify(InputStream inputStream) throws GeneralSecurityException {
        TimeStampToken timeStampToken = this.g();
        DataImprint dataImprint = timeStampToken.getTSTInfo().getDataImprint();
        AlgorithmIdentifier algorithmIdentifier = dataImprint.getHashAlgorithm();
        byte[] byArray = null;
        try {
            int n2;
            MessageDigest messageDigest;
            if (Arrays.equals(algorithmIdentifier.getValue(), AlgorithmIdentifier.sha_1)) {
                messageDigest = MessageDigest.getInstance("SHA1");
            } else if (Arrays.equals(algorithmIdentifier.getValue(), AlgorithmIdentifier.md5)) {
                messageDigest = MessageDigest.getInstance("MD5");
            } else {
                throw new GeneralSecurityException("Unknown hash algorithm " + algorithmIdentifier);
            }
            while ((n2 = inputStream.read()) >= 0) {
                messageDigest.update((byte)n2);
            }
            byArray = messageDigest.digest();
        }
        catch (IOException iOException) {
            throw gc.a(iOException);
        }
        if (!Arrays.equals(byArray, dataImprint.getHashedData())) {
            return false;
        }
        long l2 = super.getSignatureDate().getTime().getTime();
        long l3 = timeStampToken.getTSTInfo().getDate().getTime();
        l3 -= l3 % 1000L;
        if (l2 != l3) {
            return false;
        }
        try {
            if (!timeStampToken.verifySignature()) {
                return false;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw generalSecurityException;
        }
        catch (TTIException tTIException) {
            throw new IllegalArgumentException("Cannot verify signature: " + (Object)((Object)tTIException));
        }
        return true;
    }

    private TimeStampToken g() {
        try {
            if (this.g == null) {
                this.g = new TimeStampToken(this.getStringValue("Contents"));
            }
            return this.g;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot parse token: " + iOException);
        }
        catch (DecodingException decodingException) {
            throw new IllegalArgumentException("Cannot parse token: " + (Object)((Object)decodingException));
        }
    }

    public X509Certificate getSignerCertificate() {
        try {
            return this.g().getSignerCertificate();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException("Cannot parse certificate: " + generalSecurityException);
        }
        catch (TTIException tTIException) {
            throw new IllegalArgumentException("Cannot parse certificate: " + (Object)((Object)tTIException));
        }
    }

    public Calendar getSignatureDate() {
        Calendar calendar = super.getSignatureDate();
        calendar.setTime(this.g.getTSTInfo().getDate());
        return calendar;
    }

    public byte[] getTimeStampToken() {
        return this.g().getEncodedTST();
    }

    public String[] getLayerNames() {
        String[] stringArray = new String[]{"n0", "n1", "n2", "n3", "n4"};
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PDFCanvas getLayerAppearance(String string, PDFStyle pDFStyle) {
        PDFCanvas pDFCanvas = null;
        if (string.equals("n0")) {
            pDFCanvas = new PDFCanvas(100.0f, 100.0f);
        } else if (string.equals("n1")) {
            pDFCanvas = new PDFCanvas("logo.nCipher1", 1.0f);
        } else if (string.equals("n2")) {
            LayoutBox layoutBox;
            pDFCanvas = new PDFCanvas(100.0f, 100.0f);
            float f2 = 10.0f;
            do {
                layoutBox = new LayoutBox(79.0f);
                pDFStyle.setFont(new StandardFont(4), f2);
                layoutBox.addText("nCipher TimeSeal\n", pDFStyle, null);
                layoutBox.addText("Reason: " + this.b() + "\n", pDFStyle, null);
                layoutBox.flush();
                f2 = (float)((double)f2 - 0.5);
            } while (layoutBox.getHeight() > 40.0f);
            pDFCanvas.drawLayoutBox(layoutBox, 20.0f, 99.0f);
        } else if (string.equals("n3")) {
            pDFCanvas = new PDFCanvas(100.0f, 100.0f);
            LayoutBox layoutBox = new LayoutBox(98.0f);
            pDFStyle.setFont(new StandardFont(4), 10.0f);
            layoutBox.addText("Validate TimeSeal to display additional information.", pDFStyle, null);
            pDFCanvas.drawLayoutBox(layoutBox, 1.0f, 50.0f);
        } else if (string.equals("n4")) {
            pDFCanvas = new PDFCanvas("logo.nCipher4", 1.0f);
        }
        if (pDFCanvas == null) return pDFCanvas;
        pDFCanvas.flush();
        return pDFCanvas;
    }
}

