/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.bd;
import org.faceless.pdf2.hb;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.sc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.pdf2.y;

public final class EmbeddedFile
extends ic {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    EmbeddedFile(ic ic2) {
        super(ic2, "Filespec");
        sc sc2 = this.t();
        if (sc2 == null) return;
        if (sc2.f("Type")) return;
        sc2.b("Type", wc.b("EmbeddedFile"));
    }

    public EmbeddedFile(File file) throws IOException {
        super("Filespec");
        this.a();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.a(bufferedInputStream, file.getName());
        this.setModDate(new Date(file.lastModified()));
        ((InputStream)bufferedInputStream).close();
    }

    public EmbeddedFile(InputStream inputStream, String string) throws IOException {
        super("Filespec");
        this.a();
        this.a(inputStream, string);
    }

    public EmbeddedFile(PDF pDF, String string) throws IOException {
        super("Filespec");
        this.a();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        pDF.render(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.a(new ByteArrayInputStream(byArray), string);
        this.setType("application/pdf");
        this.u().b("ModDate", pDF.j("Info").m("ModDate"));
        this.u().b("CreationDate", pDF.j("Info").m("CreationDate"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(InputStream inputStream, String string) throws IOException {
        bd bd2;
        if (string == null) {
            throw new NullPointerException("Filename must be specified");
        }
        if (inputStream == null) {
            throw new NullPointerException("InputStream must be specified");
        }
        this.b("F", new bd(string, hb.PDF));
        if (!hb.PDF.canConvert(string)) {
            this.b("UF", new bd(string, hb.UCS));
        }
        sc sc2 = new sc();
        sc2.b("Type", wc.b("EmbeddedFile"));
        int n2 = 0;
        byte[] byArray = new byte[8192];
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        y y2 = new y(sc2);
        try {
            while ((n2 = inputStream.read(byArray)) >= 0) {
                y2.write(byArray, 0, n2);
                if (messageDigest == null) continue;
                messageDigest.update(byArray, 0, n2);
            }
            y2.complete();
            bd2 = null;
            y2.close();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            y2.close();
            throw throwable;
        }
        ic ic2 = new ic();
        sc2.b("Params", ic2);
        this.p("EF").b("F", sc2);
        ic2.b("Size", xc.a(y2.a()));
        if (messageDigest != null) {
            bd2 = new bd(messageDigest.digest());
            bd2.b(true);
            ic2.b("Checksum", bd2);
        }
    }

    sc t() {
        ic ic2 = this.j("EF");
        if (ic2 == null) {
            return null;
        }
        if (ic2.f("F")) {
            return ic2.n("F");
        }
        if (ic2.f("UF")) {
            return ic2.n("UF");
        }
        if (ic2.f("DOS")) {
            return ic2.n("DOS");
        }
        if (ic2.f("Unix")) {
            return ic2.n("Unix");
        }
        return ic2.n("Mac");
    }

    private ic u() {
        return this.t().j("Params");
    }

    public String getName() {
        bd bd2 = this.m("UF");
        if (bd2 != null) {
            return bd2.a(hb.UCS);
        }
        bd2 = this.m("F");
        if (bd2 == null) {
            bd2 = this.m("UF");
        }
        if (bd2 == null) {
            bd2 = this.m("DOS");
        }
        if (bd2 == null) {
            bd2 = this.m("Unix");
        }
        if (bd2 == null) {
            bd2 = this.m("Mac");
        }
        return bd2.a(hb.PDF);
    }

    public void setType(String string) {
        this.t().b("Subtype", wc.b(string));
    }

    public String getType() {
        wc wc2 = this.t().i("Subtype");
        String string = wc2 == null ? null : wc2.o();
        return string;
    }

    public void setDescription(String string) {
        this.b("Desc", new bd(string, hb.UCS));
    }

    public String getDescription() {
        bd bd2 = this.m("Desc");
        String string = bd2 == null ? null : bd2.a(hb.UCS);
        return string;
    }

    public void setCreationDate(Date date) {
        this.u().b("CreationDate", new bd(date));
    }

    public Date getCreationDate() {
        try {
            return bd.b(this.u().m("CreationDate").a(hb.PDF)).getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setModDate(Date date) {
        this.u().b("ModDate", new bd(date));
    }

    public Date getModDate() {
        try {
            return bd.b(this.u().m("ModDate").a(hb.PDF)).getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getSize() {
        try {
            return this.u().l("Size").o();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public InputStream getData() {
        try {
            return this.t().w();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isValid() {
        try {
            ic ic2 = this.u();
            if (ic2 == null) {
                return true;
            }
            bd bd2 = ic2.m("Checksum");
            if (bd2 == null) {
                return true;
            }
            int n2 = 0;
            byte[] byArray = new byte[1024];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            InputStream inputStream = this.getData();
            while ((n2 = inputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n2);
            }
            inputStream.close();
            byte[] byArray2 = messageDigest.digest();
            byte[] byArray3 = bd2.r();
            return Arrays.equals(byArray2, byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

