/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.zip.Deflater;
import org.faceless.pdf2.BarCode;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.pdf2.bd;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hb;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.lc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.util.SeekableByteArrayOutputStream;

public final class FormBarCode
extends FormElement {
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_ADOBE = 1;
    public static final int COMPRESSION_FLATE = 2;
    private float I;
    private String J;
    private int K = -1;
    private int L = 0;

    FormBarCode(ic ic2) {
        super(ic2);
    }

    public FormBarCode() {
        this.b("FT", wc.b("Tx"));
        this.b("DataPrep", xc.b(0));
        this.a(j, true);
        this.a(l, true);
        this.a(m, true);
        this.a(w, true);
    }

    public FormBarCode(PDFPage pDFPage, float f2, float f3, float f4, float f5) {
        this();
        this.addAnnotation(pDFPage, f2, f3, f4, f5);
    }

    public WidgetAnnotation addAnnotation(PDFPage pDFPage, float f2, float f3, float f4, float f5) {
        WidgetAnnotation widgetAnnotation = new WidgetAnnotation();
        widgetAnnotation.setRectangle(f2, f3, f4, f5);
        widgetAnnotation.setPage(pDFPage);
        this.getAnnotations().add(widgetAnnotation);
        return widgetAnnotation;
    }

    private lc a(WidgetAnnotation widgetAnnotation) {
        lc lc2 = widgetAnnotation.H();
        if (lc2 == null) {
            lc2 = new lc();
            widgetAnnotation.a(lc2);
        }
        float[] fArray = widgetAnnotation.getRectangle();
        int n2 = this.D();
        if (n2 == 0) {
            n2 = 2;
        }
        lc2.a(this.getSymbology(), this.getSymbolSize(), n2, this.getECC(), fArray[2] - fArray[0], fArray[3] - fArray[1]);
        return lc2;
    }

    public String getValue() {
        bd bd2 = this.m("V");
        String string = bd2 == null ? null : bd2.a(hb.UCSNL);
        return string;
    }

    public void setValue(String string) {
        String string2 = this.getValue();
        this.b("V", new bd(string, hb.UCSNL));
        this.s(string);
        this.x();
        this.H.firePropertyChange("value", string2, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCompression(int n2) {
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("Unknown compression " + n2);
        }
        int n3 = this.getCompression();
        if (n3 != n2) {
            if (n2 > 0) {
                this.b("DataPrep", xc.b(n2));
            } else {
                this.e("DataPrep");
            }
            this.H.firePropertyChange("compression", n3, n2);
            this.x();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSymbology(String string) {
        String string2;
        if (!"PDF417".equals(string) && !"QRCode".equals(string)) {
            if (!"DataMatrix".equals(string)) throw new IllegalArgumentException("Invalid symbology \"" + string + "\"");
        }
        if ((string2 = this.getSymbology()) != null) {
            if (string2.equals(string)) return;
        }
        this.J = string;
        this.x();
        this.H.firePropertyChange("symbology", string2, string);
    }

    public void setSymbolSize(float f2) {
        float f3 = this.getSymbolSize();
        if ((double)Math.abs(f2 - f3) > 0.01) {
            this.I = f2;
            this.H.firePropertyChange("symbolsize", Float.valueOf(f3), Float.valueOf(this.I));
            this.x();
        }
    }

    public void setECC(int n2) {
        int n3 = this.K;
        if (n3 != n2) {
            this.K = n2;
            this.H.firePropertyChange("ecc", n3, n2);
            this.x();
        }
    }

    public String getSymbology() {
        List list;
        if (this.J == null && (list = this.getAnnotations()).size() > 0) {
            lc lc2 = ((WidgetAnnotation)list.get(0)).H();
            if (lc2 != null) {
                this.J = lc2.u();
            }
        }
        return this.J;
    }

    public int getECC() {
        List list;
        if (this.K < 0 && (list = this.getAnnotations()).size() > 0) {
            lc lc2 = ((WidgetAnnotation)list.get(0)).H();
            if (lc2 != null) {
                this.K = lc2.B();
            }
        }
        return this.K;
    }

    public float getSymbolSize() {
        List list;
        if (this.I <= 0.0f && (list = this.getAnnotations()).size() > 0) {
            lc lc2 = ((WidgetAnnotation)list.get(0)).H();
            if (lc2 != null) {
                this.I = lc2.x();
            }
        }
        return this.I;
    }

    int D() {
        List list;
        if (this.L <= 0 && (list = this.getAnnotations()).size() > 0) {
            lc lc2 = ((WidgetAnnotation)list.get(0)).H();
            if (lc2 != null) {
                this.L = lc2.y();
            }
        }
        return this.L;
    }

    public int getCompression() {
        if (!this.f("DataPrep")) {
            return 0;
        }
        return this.l("DataPrep").o();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        FormBarCode formBarCode = this;
        synchronized (formBarCode) {
            super.rebuild();
            String string = this.getValue();
            List list = this.getAnnotations();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                WidgetAnnotation widgetAnnotation;
                WidgetAnnotation widgetAnnotation2 = widgetAnnotation = (WidgetAnnotation)list.get(i2);
                synchronized (widgetAnnotation2) {
                    PDF pDF;
                    lc lc2 = this.a(widgetAnnotation);
                    float[] fArray = widgetAnnotation.getRectangle();
                    float f2 = fArray[2] - fArray[0];
                    float f3 = fArray[3] - fArray[1];
                    PDFCanvas pDFCanvas = new PDFCanvas(f2, f3);
                    BarCode barCode = this.a(string, lc2);
                    PDFCanvas pDFCanvas2 = barCode.getCanvas();
                    float f4 = pDFCanvas2.getWidth();
                    float f5 = pDFCanvas2.getHeight();
                    float f6 = f2 / 2.0f - f4 / 2.0f;
                    float f7 = f3 / 2.0f - f5 / 2.0f;
                    pDFCanvas.drawCanvas(pDFCanvas2, f6, f7, f6 + f4, f7 + f5);
                    pDFCanvas.flush();
                    ic ic2 = widgetAnnotation.p("AP");
                    gc gc2 = ic2.b("N", pDFCanvas);
                    PDF pDF2 = pDF = this.n();
                    synchronized (pDF2) {
                        pDF.t().a(gc2, pDFCanvas);
                    }
                }
            }
        }
    }

    private BarCode a(String string, lc lc2) {
        if (string == null) {
            string = "";
        }
        int n2 = this.getCompression();
        String string2 = lc2.u();
        float f2 = lc2.x();
        BarCode barCode = null;
        if ("PDF417".equals(string2)) {
            int n3 = lc2.B();
            f2 = (float)((double)f2 * 2.834645669291339);
            barCode = n2 > 0 ? BarCode.newPDF417(this.b(string, n2), f2, n3, 0) : BarCode.newPDF417(string, f2, n3, 0);
            barCode.setWidth(lc2.v() * 72.0f);
        } else if ("QRCode".equals(string2)) {
            int n4 = lc2.B();
            barCode = n2 > 0 ? BarCode.newQRCode(this.b(string, n2), (double)f2, n4 + 1, 0) : BarCode.newQRCode(string, (double)f2, n4 + 1, 0);
        } else if ("DataMatrix".equals(string2)) {
            barCode = n2 > 0 ? BarCode.newDataMatrixCode(this.b(string, n2), 0, 0) : BarCode.newDataMatrixCode(string);
            barCode.setWidth(barCode.getWidth() * (f2 *= 2.8346457f));
        } else {
            throw new IllegalStateException("Bad PMD symbology: " + string2);
        }
        return barCode;
    }

    private byte[] b(String string, int n2) {
        SeekableByteArrayOutputStream seekableByteArrayOutputStream = new SeekableByteArrayOutputStream(string.length());
        try {
            hb.UCSNL.write(string, seekableByteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw gc.a(iOException);
        }
        byte[] byArray = seekableByteArrayOutputStream.getUnderlyingByteArray();
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        byte[] byArray2 = new byte[byArray.length];
        int n3 = deflater.deflate(byArray2);
        if (n2 == 1) {
            byArray = new byte[n3 + 2];
            byArray[0] = -127;
            byArray[1] = 1;
            System.arraycopy(byArray2, 0, byArray, 2, n3);
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    public static String getTabDelimiteredJavaScript(Collection collection, boolean bl) {
        String string = "function bMemberOf(strName, aStrNames)\n{\n    for (var nMembIdx in aStrNames)\n    {\n        if (strName == aStrNames[nMembIdx])\n            return true;\n    }\n    return false;\n}\n\nfunction strTabDelimited(oParam)\n{\n    var bNeedTab = false;\n    var strNames = \"\";\n    var strValues = \"\";\n    for (var i = 0; i < oParam.oDoc.numFields; ++i)\n    {\n        var strFieldName = oParam.oDoc.getNthFieldName(i);\n        if ((null == oParam.aFields || bMemberOf(strFieldName, oParam.aFields))\n            && (null == oParam.strXclField || strFieldName != oParam.strXclField)\n            && (oParam.oDoc.getField(strFieldName).type != \"button\"))\n        {\n            if (bNeedTab)\n            {\n                if (oParam.bFieldNames)\n                    strNames += \"\\t\";\n                strValues += \"\\t\";\n            }\n            if (oParam.bFieldNames)\n                strNames += strFieldName;\n            strValues += oParam.oDoc.getField(strFieldName).value;\n            bNeedTab = true;\n        }\n    }\n    if (oParam.bFieldNames)\n        return strNames + \"\\n\" + strValues;\n    else\n        return strValues;\n}\n\ntry\n{\n    if ( app.viewerVersion >= ADBE.PMD_Need_Version )\n        event.value = strTabDelimited({oDoc: this, aFields: XXX, bFieldNames: YYY});\n    else event.value = \" \";\n}\ncatch (e)\n{\n    event.value = \" \";\n}";
        if (collection == null) {
            string = string.replaceAll("XXX", "null");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : collection) {
                string2 = string2.replaceAll("\"", "\\");
                String string3 = stringBuffer.length() == 0 ? "[" : ", ";
                stringBuffer.append(string3);
                stringBuffer.append("\"" + string2 + "\"");
            }
            stringBuffer.append("]");
            string = string.replaceAll("XXX", stringBuffer.toString());
        }
        String string4 = string;
        String string5 = "YYY";
        String string6 = bl ? "true" : "false";
        string = string4.replaceAll(string5, string6);
        return string;
    }

    public static String getTabDelimiteredJavaScriptSetup() {
        return "////// BEGIN JAVASCRIPT BLOCK: !ADBE::0100_VersChkStrings\nif (typeof(this.ADBE) == \"undefined\") this.ADBE = new Object();\nADBE.LANGUAGE = \"ENU\";\nADBE.Viewer_string_Title = \"Adobe Acrobat\";\nADBE.Reader_string_Need_New_Version_Msg = \"This PDF form requires a newer version of Adobe Reader. Without a newer version, the form may display, but may not work properly. Some form elements might not be visible at all. If an internet connection is available, clicking OK will open your browser to a web page where you can obtain the latest version.\";\nADBE.Viewer_string_PMD_Old = \"A newer version of Adobe software is required. For more information, copy and paste the URL below into a browser.\";\nADBE.Viewer_string_PMD = \"This document requires a newer version of Adobe Acrobat. Without a newer version, it might not work properly. Some elements might not be visible at all. Click OK to get more information to obtain the latest version of Adobe Reader.\";\nADBE.Viewer_string_Update_Desc = \"Adobe Interactive Forms Update\";\n////// BEGIN JAVASCRIPT BLOCK: !ADBE::0100_VersChkVars\nADBE.PMD_Need_Version = 7.05;\nif (app.platform == \"UNIX\" && ADBE.PMD_Need_Version < 8) ADBE.PMD_Need_Version = 8;\nif (typeof(ADBE.Reader_Value_Asked) == \"undefined\") ADBE.Reader_Value_Asked = false;\nif (typeof(ADBE.Viewer_Value_Asked) == \"undefined\") ADBE.Viewer_Value_Asked = false;\nif (typeof(ADBE.Reader_Need_Version) == \"undefined\" || ADBE.Reader_Need_Version < ADBE.PMD_Need_Version)\n{\n    ADBE.Reader_Need_Version = ADBE.PMD_Need_Version;\n    ADBE.Reader_Value_New_Version_URL = \"http://cgi.adobe.com/special/acrobat/update\";\n    ADBE.SYSINFO = \"?p=\" + app.platform + \"&v=\" + app.viewerVersion + \"&l=\" + app.language + \"&c=\" + app.viewerType + \"&r=\" + ADBE.Reader_Need_Version;\n}\nif (typeof(ADBE.Viewer_Need_Version) == \"undefined\" || ADBE.Viewer_Need_Version < ADBE.PMD_Need_Version)\n{\n    ADBE.Viewer_Need_Version = ADBE.PMD_Need_Version;\n    ADBE.Viewer_Value_New_Version_URL = \"http://cgi.adobe.com/special/acrobat/update\";\n    ADBE.SYSINFO = \"?p=\" + app.platform + \"&v=\" + app.viewerVersion + \"&l=\" + app.language + \"&c=\" + app.viewerType + \"&r=\" + ADBE.Viewer_Need_Version;\n}\n////// BEGIN JAVASCRIPT BLOCK: !ADBE::0200_VersChkCode_PMD1\nif (app.viewerType == \"Reader\")\n{\n    if (app.viewerVersion < ADBE.Reader_Need_Version && !ADBE.Reader_Value_Asked)\n    {\n        if (app.alert(ADBE.Reader_string_Need_New_Version_Msg, 1, 1) == 1) this.getURL(ADBE.Reader_Value_New_Version_URL + ADBE.SYSINFO, false);\n            ADBE.Reader_Value_Asked = true;\n    }\n}\nelse\n{\n    if (app.viewerVersion < ADBE.Viewer_Need_Version && !ADBE.Viewer_Value_Asked)\n    {\n        if (app.viewerVersion > 7)\n        {\n            if (app.alert(ADBE.Viewer_string_PMD, 1, 1) == 1)\n                app.findComponent({cType:\"Plugin\", cName:\"XFA\", cDesc: ADBE.Viewer_string_Update_Desc});\n        }\n        else if (app.viewerVersion > 6 && ADBE.Viewer_Need_Version < 7)\n        {\n            if (app.alert(ADBE.Viewer_string_PMD, 1, 1) == 1)\n                app.findComponent({cType:\"UDPatch\", cName:\"602Patch\", cDesc: ADBE.Viewer_string_Update_Desc});\n        }\n        else\n            app.response({cQuestion:ADBE.Viewer_string_PMD_Old, cDefault:ADBE.Viewer_Value_New_Version_URL + ADBE.SYSINFO, cTitle:ADBE.Viewer_string_Title});\n    ADBE.Viewer_Value_Asked = true;\n    }\n}";
    }
}

