/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.faceless.pdf2.AcrobatSignatureHandlerFactory;
import org.faceless.pdf2.AnnotationLink;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFReader;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.PKCS7SignatureHandler;
import org.faceless.pdf2.SignatureHandler;
import org.faceless.pdf2.SignatureHandlerFactory;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.pdf2.bd;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hb;
import org.faceless.pdf2.hc;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.id;
import org.faceless.pdf2.nc;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.vc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.pdf2.yd;
import org.faceless.pdf2.zb;
import org.faceless.util.BackedInputStream;

public final class FormSignature
extends FormElement {
    public static final int CERTIFICATION_UNCERTIFIED = 0;
    public static final int CERTIFICATION_NOCHANGES = 1;
    public static final int CERTIFICATION_ALLOWFORMS = 2;
    public static final int CERTIFICATION_ALLOWCOMMENTS = 3;
    public static final SignatureHandlerFactory HANDLER_SELFSIGN = new SignatureHandlerFactory(){

        public SignatureHandler getHandler() {
            return new PKCS7SignatureHandler.a_();
        }
    };
    public static final SignatureHandlerFactory HANDLER_VERISIGN = new SignatureHandlerFactory(){

        public SignatureHandler getHandler() {
            return new PKCS7SignatureHandler.b_();
        }
    };
    public static final SignatureHandlerFactory HANDLER_ACROBATSIX = new AcrobatSignatureHandlerFactory();
    public static final int STATE_SIGNED = 0;
    public static final int STATE_PENDING = 1;
    public static final int STATE_BLANK = 2;
    private SignatureHandler I;
    private BackedInputStream J;
    private long[] K;
    private int L = 2;
    private boolean M;
    private Collection N;
    private static final HashMap O = new HashMap();
    private static KeyStore P;
    private Map Q;
    private int R;
    private String S;

    public static void registerHandlerForVerification(SignatureHandlerFactory signatureHandlerFactory) {
        O.put(signatureHandlerFactory.getHandler().getFilter(), signatureHandlerFactory);
    }

    FormSignature(ic ic2) {
        super(ic2);
    }

    public FormSignature() {
        this.b("FT", wc.b("Sig"));
    }

    public FormSignature(KeyStore keyStore, String string, char[] cArray, SignatureHandlerFactory signatureHandlerFactory) throws GeneralSecurityException, IllegalArgumentException {
        this();
        this.sign(keyStore, string, cArray, signatureHandlerFactory);
    }

    public WidgetAnnotation addAnnotation(PDFPage pDFPage, float f2, float f3, float f4, float f5) {
        WidgetAnnotation widgetAnnotation;
        block3: {
            block2: {
                this.c("Kids");
                if (!this.f("Kids") && !this.f("Rect")) break block2;
                widgetAnnotation = new WidgetAnnotation();
                widgetAnnotation.setRectangle(f2, f3, f4, f5);
                widgetAnnotation.setPrintable(true);
                widgetAnnotation.setPage(pDFPage);
                this.getAnnotations().add(widgetAnnotation);
                break block3;
            }
            widgetAnnotation = new nc(this);
            widgetAnnotation.b("Type", wc.b("Annot"));
            widgetAnnotation.b("Subtype", wc.b("Widget"));
            widgetAnnotation.setRectangle(f2, f3, f4, f5);
            widgetAnnotation.setPrintable(true);
            widgetAnnotation.setPage(pDFPage);
            this.getAnnotations();
        }
        return widgetAnnotation;
    }

    public synchronized void sign(KeyStore keyStore, String string, char[] cArray, SignatureHandlerFactory signatureHandlerFactory) throws GeneralSecurityException, IllegalArgumentException {
        if (this.L != 2) {
            throw new IllegalStateException("Can only sign STATE_BLANK signatures");
        }
        if (this.n() != null) {
            this.n().u("Form.Signature");
        }
        ic ic2 = new ic();
        ic2.a();
        ic2.a("NoCompress", vc.g);
        this.b("V", ic2);
        this.I = signatureHandlerFactory.getHandler();
        this.I.a(ic2, this);
        this.I.a(Calendar.getInstance());
        this.I.prepareToSign(keyStore, string, cArray);
        this.Q = this.I.getVariables();
        for (Map.Entry entry : this.Q.entrySet()) {
            String string2 = (String)entry.getKey();
            SignatureHandler.Placeholder placeholder = (SignatureHandler.Placeholder)entry.getValue();
            this.I.a(string2, placeholder);
        }
        this.x();
        this.L = 1;
        this.H.firePropertyChange("state", "blank", "pending");
    }

    public int getState() {
        return this.L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setName(String string) {
        if (this.L != 2 && this.L != 0) {
            String string2 = this.getSignatureHandler().a();
            this.getSignatureHandler().b(string);
            this.H.firePropertyChange("name", string2, string);
            return;
        }
        throw new IllegalStateException("Can't call this method on a STATE_BLANK or STATE_SIGNED signature");
    }

    public String getName() {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        return this.getSignatureHandler().a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReason(String string) {
        if (this.L != 2 && this.L != 0) {
            String string2 = this.getSignatureHandler().b();
            this.getSignatureHandler().c(string);
            this.H.firePropertyChange("reason", string2, string);
            return;
        }
        throw new IllegalStateException("Can't call this method on a STATE_BLANK or STATE_SIGNED signature");
    }

    public String getReason() {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        return this.getSignatureHandler().b();
    }

    public void setLocation(String string) {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        String string2 = this.getSignatureHandler().c();
        this.getSignatureHandler().d(string);
        this.H.firePropertyChange("location", string2, string);
    }

    public String getLocation() {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        return this.getSignatureHandler().c();
    }

    public void setContactInfo(String string) {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        String string2 = this.getSignatureHandler().d();
        this.getSignatureHandler().e(string);
        this.H.firePropertyChange("contactInfo", string2, string);
    }

    public String getContactInfo() {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        return this.getSignatureHandler().d();
    }

    public Calendar getSignDate() {
        if (this.L != 0) {
            throw new IllegalStateException("Can only call this method on a STATE_SIGNED signature");
        }
        return this.getSignatureHandler().getSignatureDate();
    }

    public String getFilter() {
        if (this.L == 2) {
            throw new IllegalStateException("Can't call this method on a STATE_BLANK signature");
        }
        return this.getSignatureHandler().getFilter();
    }

    public synchronized SignatureHandler getSignatureHandler() {
        ic ic2;
        if (this.I == null && (ic2 = this.j("V")) != null) {
            block6: {
                wc wc2 = ic2.i("Filter");
                if (wc2 != null) {
                    String string;
                    block5: {
                        string = wc2.o();
                        if (!O.containsKey(string)) break block5;
                        this.I = ((SignatureHandlerFactory)O.get(string)).getHandler();
                        break block6;
                    }
                    this.I = new e_(string);
                } else {
                    this.I = new e_("Null.Filter");
                }
            }
            this.I.a(ic2, this);
        }
        return this.I;
    }

    public synchronized boolean verify() throws GeneralSecurityException {
        block8: {
            String string;
            StringBuilder stringBuilder;
            IllegalStateException illegalStateException;
            IllegalStateException illegalStateException2;
            block10: {
                block9: {
                    IllegalStateException illegalStateException3;
                    if (this.L == 0) break block8;
                    illegalStateException2 = illegalStateException3;
                    illegalStateException = illegalStateException3;
                    stringBuilder = new StringBuilder().append("Can't validate signature with a state of ");
                    if (this.L != 1) break block9;
                    string = "STATE_PENDING";
                    break block10;
                }
                string = "STATE_BLANK";
            }
            illegalStateException2(stringBuilder.append(string).toString());
            throw illegalStateException;
        }
        if (this.J != null) {
            try {
                this.J.seek(0L);
                SignatureHandler signatureHandler = this.getSignatureHandler();
                InputStream inputStream = signatureHandler.a(this.J);
                this.M = this.getSignatureHandler().verify(inputStream);
                this.J.close();
            }
            catch (IOException iOException) {
                throw gc.a("IOException while verifying PDF", iOException);
            }
            this.J = null;
        }
        if (this.M) {
            this.M = this.c(this.n());
        }
        return this.M;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumberOfRevisionsCovered() {
        if (this.L != 0) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Can't call this method on signature with a state of ");
            if (this.L == 1) {
                string = "STATE_PENDING";
                throw new IllegalStateException(stringBuilder.append(string).toString());
            }
            string = "STATE_BLANK";
            throw new IllegalStateException(stringBuilder.append(string).toString());
        }
        long l2 = 0L;
        uc uc2 = this.j("V").k("ByteRange");
        if (uc2 == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 < uc2.o()) {
            long l3;
            long l4;
            if (l2 >= (l4 = uc2.h(n2++).q()) + (l3 = uc2.h(n2++).q())) continue;
            l2 = l4 + l3;
        }
        n2 = 0;
        while (n2 < this.K.length) {
            if (l2 == this.K[n2]) return n2 + 1;
            if (l2 == this.K[n2] + 1L) {
                return n2 + 1;
            }
            ++n2;
        }
        return 0;
    }

    void a(BackedInputStream backedInputStream, long[] lArray, boolean bl) {
        this.J = backedInputStream.duplicate();
        this.K = lArray;
    }

    BackedInputStream D() {
        return this.J;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(long l2, OutputStream outputStream, MessageDigest messageDigest, EncryptionHandler encryptionHandler, int n2, int n3) throws Exception {
        InputStream inputStream;
        Object object;
        Object object2;
        Object object32;
        if (this.L != 1) {
            throw new IllegalStateException("Not a pending signature - why sign it?");
        }
        TreeMap treeMap = new TreeMap(new Comparator(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public int compare(Object object, Object object2) {
                SignatureHandler.Placeholder placeholder2 = (SignatureHandler.Placeholder)FormSignature.this.Q.get(object);
                SignatureHandler.Placeholder placeholder = (SignatureHandler.Placeholder)FormSignature.this.Q.get(object2);
                if (placeholder2 == null) throw new NullPointerException("o1=" + object + " l1=" + placeholder2 + " o2=" + object2 + " l2=" + placeholder);
                if (placeholder == null) {
                    throw new NullPointerException("o1=" + object + " l1=" + placeholder2 + " o2=" + object2 + " l2=" + placeholder);
                }
                long l2 = placeholder2.getOffset() - placeholder.getOffset();
                if (l2 < 0L) {
                    return -1;
                }
                if (l2 <= 0L) return 0;
                return 1;
            }
        });
        treeMap.putAll(this.Q);
        this.I.preDigest(l2, treeMap);
        for (Object object32 : treeMap.values()) {
            if (!((SignatureHandler.Placeholder)object32).o() || ((SignatureHandler.Placeholder)object32).getContent() != null) continue;
            throw new IllegalStateException("Digestable placeholder not set in preDigest");
        }
        Object object4 = new byte[8192];
        for (Map.Entry entry : treeMap.entrySet()) {
            int n4;
            object2 = (String)entry.getKey();
            object = (SignatureHandler.Placeholder)entry.getValue();
            if (((SignatureHandler.Placeholder)object).getContent() != null) {
                messageDigest.update(((SignatureHandler.Placeholder)object).getContent());
            }
            inputStream = ((SignatureHandler.Placeholder)object).p();
            while ((n4 = inputStream.read((byte[])object4, 0, ((Object)object4).length)) >= 0) {
                messageDigest.update((byte[])object4, 0, n4);
            }
            inputStream.close();
        }
        this.I.postDigest(l2, treeMap);
        for (SignatureHandler.Placeholder placeholder : treeMap.values()) {
            if (placeholder.getContent() != null) continue;
            throw new IllegalStateException("Placeholder not set in postDigest");
        }
        object32 = treeMap.entrySet().iterator();
        while (true) {
            if (!object32.hasNext()) {
                this.L = 0;
                return;
            }
            Map.Entry entry = (Map.Entry)object32.next();
            object2 = (SignatureHandler.Placeholder)entry.getValue();
            object = ((SignatureHandler.Placeholder)object2).getContent();
            if (object == null || ((Object)object).length != ((SignatureHandler.Placeholder)object2).getLength()) {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append("Placeholder \"").append(entry.getKey()).append("\" not set in postDigest (");
                if (object == null) {
                    string = "null:";
                    throw new IllegalStateException(stringBuilder.append(string).append(")").toString());
                }
                string = ((Object)object).length + "!=" + ((SignatureHandler.Placeholder)object2).getLength();
                throw new IllegalStateException(stringBuilder.append(string).append(")").toString());
            }
            outputStream.write((byte[])object);
            inputStream = ((SignatureHandler.Placeholder)object2).p();
            gc.a(inputStream, outputStream);
            inputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate verifyCertificates(X509Certificate[] x509CertificateArray, KeyStore keyStore, CRL cRL, Calendar calendar) throws GeneralSecurityException {
        int n2;
        if (x509CertificateArray == null) {
            throw new NullPointerException("Certificate list is null");
        }
        if (x509CertificateArray.length == 0) {
            throw new NullPointerException("Certificate list is empty");
        }
        if (calendar == null) {
            throw new NullPointerException("Signature date is null");
        }
        Date date = calendar.getTime();
        X509Certificate x509Certificate = x509CertificateArray[0];
        do {
            if (!FormSignature.isValidCertificate(x509Certificate, cRL, date)) return x509Certificate;
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate) || !FormSignature.isValidCertificate((X509Certificate)certificate, cRL, date)) continue;
                try {
                    x509Certificate.verify(certificate.getPublicKey());
                    return null;
                }
                catch (Exception exception) {
                }
            }
            n2 = 0;
            for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
                if (x509CertificateArray[n2] == x509Certificate || !FormSignature.isValidCertificate(x509CertificateArray[n2], cRL, date)) continue;
                try {
                    x509Certificate.verify(x509CertificateArray[n2].getPublicKey());
                    x509Certificate = x509CertificateArray[n2];
                    n2 = x509CertificateArray.length + 2;
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
        } while (n2 != x509CertificateArray.length);
        return x509Certificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidCertificate(X509Certificate x509Certificate, CRL cRL, Date date) {
        try {
            x509Certificate.checkValidity(date);
            if (x509Certificate.hasUnsupportedCriticalExtension()) return false;
            if (cRL == null) return true;
            if (cRL.isRevoked(x509Certificate)) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized KeyStore loadDefaultKeyStore() throws GeneralSecurityException {
        if (P == null) {
            String string = File.separator;
            File file = new File(System.getProperty("java.home") + string + "lib" + string + "security" + string + "cacerts");
            if (!file.exists()) {
                throw new GeneralSecurityException("Can't find " + file + " - please tell support@bfo.com which version of Java you're running");
            }
            Provider[] providerArray = Security.getProviders();
            Exception exception = null;
            for (int i2 = 0; i2 < providerArray.length; ++i2) {
                Provider provider = providerArray[i2];
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                P = KeyStore.getInstance("JKS", provider.getName());
                P.load(fileInputStream, null);
                fileInputStream.close();
                Object var9_8 = null;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception2) {}
                continue;
                {
                    catch (Exception exception3) {
                        if (exception == null) {
                            exception = exception3;
                        }
                        var9_8 = null;
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (P == null) {
                throw new GeneralSecurityException("Error reading keystore: " + exception);
            }
        }
        return P;
    }

    public static KeyStore loadAKFKeyStore(InputStream inputStream) throws IOException, GeneralSecurityException {
        PDFReader pDFReader = new PDFReader(inputStream, null, "%PPKEXP-1.", false, null);
        ic ic2 = pDFReader.a().e().j("Root");
        pDFReader.g();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        byte[] byArray = ic2.j("PPKCert").m("Cert").r();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
        for (X509Certificate x509Certificate : collection) {
            keyStore.setCertificateEntry(x509Certificate.getSerialNumber().toString(16), x509Certificate);
        }
        return keyStore;
    }

    public static KeyStore loadFDFKeyStore(InputStream inputStream) throws IOException, GeneralSecurityException {
        PDFReader pDFReader = new PDFReader(inputStream, null, "%FDF-1.", false, null);
        ic ic2 = pDFReader.a().e().j("Root");
        pDFReader.g();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        uc uc2 = ic2.j("FDF").j("PPK").k("Import");
        for (int i2 = 0; i2 < uc2.o(); ++i2) {
            ic ic3 = uc2.f(i2);
            byte[] byArray = ic3.m("CMS").r();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
            for (X509Certificate x509Certificate : collection) {
                keyStore.setCertificateEntry(x509Certificate.getSerialNumber().toString(16), x509Certificate);
            }
        }
        return keyStore;
    }

    public static KeyStore loadPKCS7KeyStore(InputStream inputStream) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        gc.a(inputStream, (OutputStream)byteArrayOutputStream);
        id id2 = new id(byteArrayOutputStream.toByteArray());
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        X509Certificate[] x509CertificateArray = id2.b();
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            keyStore.setCertificateEntry(x509CertificateArray[i2].getSerialNumber().toString(16), x509CertificateArray[i2]);
        }
        return keyStore;
    }

    public static String getIssuerField(X509Certificate x509Certificate, String string) throws CertificateException {
        Object v2 = id.a(x509Certificate.getIssuerX500Principal()).get(string);
        if (v2 instanceof List) {
            return (String)((List)v2).get(0);
        }
        return (String)v2;
    }

    public static String getSubjectField(X509Certificate x509Certificate, String string) throws CertificateException {
        Object v2 = id.a(x509Certificate.getSubjectX500Principal()).get(string);
        if (v2 instanceof List) {
            return (String)((List)v2).get(0);
        }
        return (String)v2;
    }

    void a(yd yd2) {
        if (this.L == 0) {
            return;
        }
        super.a(yd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rebuild() {
        Object object;
        gc gc2;
        Object object2;
        if (this.L == 0) {
            return;
        }
        super.rebuild();
        SignatureHandler signatureHandler = this.getSignatureHandler();
        if (this.getAnnotations().isEmpty()) {
            object2 = new nc(this);
            ((nc)object2).b("Type", wc.b("Annot"));
            ((nc)object2).b("Subtype", wc.b("Widget"));
            ((PDFAnnotation)object2).setRectangle(0.0f, 0.0f, 0.0f, 0.0f);
            ((PDFAnnotation)object2).setPrintable(true);
            ((PDFAnnotation)object2).setPage(this.n().getPage(0));
            gc2 = new PDFCanvas(0.0f, 0.0f);
            ((PDFCanvas)gc2).flush();
            ((hc)object2).p("AP").b("N", gc2);
            this.getAnnotations();
            ((uc)this.b("Kids")).c((gc)object2);
        } else {
            object2 = this.getAnnotations();
            for (int i2 = 0; i2 < object2.size(); ++i2) {
                object = (WidgetAnnotation)object2.get(i2);
                WidgetAnnotation widgetAnnotation = object;
                synchronized (widgetAnnotation) {
                    PDFCanvas pDFCanvas;
                    ((PDFAnnotation)object).a(8, true);
                    float[] fArray = ((PDFAnnotation)object).getRectangle();
                    float f2 = fArray[2] - fArray[0];
                    float f3 = fArray[3] - fArray[1];
                    if (this.L == 2) {
                        pDFCanvas = ((WidgetAnnotation)object).b("N", (String)null);
                        pDFCanvas.flush();
                    } else if (this.L == 1) {
                        pDFCanvas = new PDFCanvas(f2, f3);
                        PDFCanvas pDFCanvas2 = new PDFCanvas(f2, f3);
                        pDFCanvas2.j("Resources").p("XObject").b("FRM", pDFCanvas);
                        pDFCanvas2.s("/FRM Do");
                        pDFCanvas2.flush();
                        PDFStyle pDFStyle = new PDFStyle(((WidgetAnnotation)object).getTextStyle());
                        String[] stringArray = signatureHandler.getLayerNames();
                        for (int i3 = 0; i3 < stringArray.length; ++i3) {
                            PDFCanvas pDFCanvas3;
                            if (i3 == 0) {
                                pDFCanvas3 = ((WidgetAnnotation)object).b("N", (String)null);
                                this.getForm().p("DR").p("XObject").b("DSz", pDFCanvas3);
                            } else {
                                pDFCanvas3 = signatureHandler.getLayerAppearance(stringArray[i3], pDFStyle);
                            }
                            if (pDFCanvas3 == null) continue;
                            pDFCanvas3.flush();
                            pDFCanvas.j("Resources").p("XObject").b(stringArray[i3], pDFCanvas3);
                            float f4 = pDFCanvas3.getWidth();
                            float f5 = pDFCanvas3.getHeight();
                            float f6 = Math.min(f2 / f4, f3 / f5);
                            pDFCanvas.drawCanvas(pDFCanvas3, (f2 - (f4 *= f6)) / 2.0f, (f3 - (f5 *= f6)) / 2.0f, f2 - (f2 - f4) / 2.0f, f3 - (f3 - f5) / 2.0f);
                        }
                        pDFCanvas.flush();
                        ((hc)object).j("AP").b("N", pDFCanvas2);
                    }
                    continue;
                }
            }
        }
        if (this.N != null && this.N.size() > 0) {
            object2 = new ic("SigFieldLock");
            ((ic)object2).a();
            gc2 = new uc(1);
            for (Map.Entry entry : this.getForm().getElements().entrySet()) {
                if (!this.N.contains(entry.getValue())) continue;
                ((uc)gc2).c(new bd((String)entry.getKey(), hb.PDF));
            }
            if (((uc)gc2).o() == this.getForm().getElements().size() && ((uc)gc2).o() != 1) {
                ((hc)object2).b("Action", wc.b("All"));
                this.b("Lock", (gc)object2);
            } else if (((uc)gc2).o() > 0) {
                ((hc)object2).b("Action", wc.b("Include"));
                ((hc)object2).b("Fields", gc2);
                this.b("Lock", (gc)object2);
            }
        }
        if ((object2 = this.a(this.n(), this.R, this.S)) != null) {
            this.n().j("Root").b("Legal", (gc)object2);
        }
        if (this.R != 0) {
            gc2 = new ic("TransformParams");
            ((hc)gc2).b("P", xc.b(this.R));
            ((hc)gc2).b("V", wc.b("1.2"));
            object = new ic("SigRef");
            ((hc)object).b("TransformParams", gc2);
            ((hc)object).b("TransformMethod", wc.b("DocMDP"));
            uc uc2 = new uc(1);
            uc2.c((gc)object);
            this.j("V").b("Reference", uc2);
            this.n().getBasicOutputProfile().set(OutputProfile.Feature.AuthorSignature);
            this.n().j("Root").p("Perms").b("DocMDP", this.j("V"));
        }
    }

    public void setRequiredTimestampServer(URI uRI) {
        block3: {
            ic ic2;
            block2: {
                ic2 = this.p("SV");
                if (uRI != null) break block2;
                ic2.e("TimeStamp");
                break block3;
            }
            ic ic3 = new ic();
            ic3.b("URL", new bd(uRI.toString(), hb.UCS));
            ic3.b("Ff", xc.b(1));
            ic2.b("TimeStamp", ic3);
        }
    }

    public void setRequiredReasons(String[] stringArray) {
        block14: {
            int n2;
            ic ic2;
            block13: {
                ic2 = this.p("SV");
                int n3 = n2 = ic2.f("Ff") ? ic2.l("Ff").o() : 0;
                if (stringArray == null) {
                    ic2.e("Reasons");
                    n2 &= 0xFFFFFFF7;
                } else {
                    block12: {
                        block11: {
                            uc uc2 = new uc(stringArray.length);
                            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                                uc2.c(new bd(stringArray[i2], hb.UCS));
                            }
                            if (uc2.o() <= 0) break block11;
                            ic2.b("Reasons", uc2);
                            break block12;
                        }
                        ic2.e("Reasons");
                    }
                    n2 |= 8;
                }
                if (n2 != 0) break block13;
                ic2.e("Ff");
                break block14;
            }
            ic2.b("Ff", xc.b(n2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRequiredCertificateIssuers(X509Certificate[] x509CertificateArray) {
        int n2;
        ic ic2 = this.p("SV").p("Cert");
        ic2.b("Type", wc.b("SVCert"));
        int n3 = n2 = ic2.f("Ff") ? ic2.l("Ff").o() : 0;
        if (x509CertificateArray == null || x509CertificateArray.length <= 0) {
            ic2.e("Issuer");
            n2 &= 0xFFFFFFFD;
        } else {
            uc uc2 = new uc(x509CertificateArray.length);
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                try {
                    bd bd2 = new bd(x509CertificateArray[i2].getEncoded());
                    bd2.b(true);
                    uc2.c(bd2);
                    continue;
                }
                catch (Exception exception) {
                    throw gc.a(exception);
                }
            }
            ic2.b("Issuer", uc2);
            n2 |= 2;
        }
        if (n2 == 0 && !this.j("SV").f("URL")) {
            this.j("SV").e("Cert");
            if (this.j("SV").o() != 0) return;
            this.e("SV");
            return;
        }
        ic2.b("Ff", xc.b(n2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRequiredCertificateSubjects(X509Certificate[] x509CertificateArray) {
        int n2;
        ic ic2 = this.p("SV").p("Cert");
        ic2.b("Type", wc.b("SVCert"));
        int n3 = n2 = ic2.f("Ff") ? ic2.l("Ff").o() : 0;
        if (x509CertificateArray == null || x509CertificateArray.length <= 0) {
            ic2.e("Subject");
            n2 &= 0xFFFFFFFE;
        } else {
            uc uc2 = new uc(x509CertificateArray.length);
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                try {
                    bd bd2 = new bd(x509CertificateArray[i2].getEncoded());
                    bd2.b(true);
                    uc2.c(bd2);
                    continue;
                }
                catch (Exception exception) {
                    throw gc.a(exception);
                }
            }
            ic2.b("Subject", uc2);
            n2 |= 1;
        }
        if (n2 == 0 && !this.j("SV").f("URL")) {
            this.j("SV").e("Cert");
            if (this.j("SV").o() != 0) return;
            this.e("SV");
            return;
        }
        ic2.b("Ff", xc.b(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRequiredCertificateFallbackURI(URI uRI) {
        if (uRI == null) {
            ic ic2 = this.j("SV");
            if (ic2 == null) return;
            ic2 = ic2.j("Cert");
            if (ic2 == null) return;
            ic2.e("URL");
            return;
        } else {
            ic ic3 = this.p("SV").p("Cert");
            ic3.b("Type", wc.b("SVCert"));
            ic3.b("URL", new bd(uRI.toString(), hb.UCS));
        }
    }

    public String[] getRequiredReasons() {
        uc uc2;
        ic ic2 = this.j("SV");
        if (ic2 != null && (uc2 = ic2.k("Reasons")) != null) {
            String[] stringArray = new String[uc2.o()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = uc2.k(i2).a(hb.UCS);
            }
            return stringArray;
        }
        return null;
    }

    public URI getRequiredTimestampServer() {
        bd bd2;
        ic ic2 = this.j("SV");
        if (ic2 != null && (ic2 = ic2.j("TimeStamp")) != null && (bd2 = ic2.m("URL")) != null) {
            try {
                return new URI(bd2.a(hb.UCS));
            }
            catch (Exception exception) {
                throw gc.a(exception);
            }
        }
        return null;
    }

    public X509Certificate[] getRequiredCertificateIssuers() {
        ic ic2 = this.j("SV");
        try {
            uc uc2;
            if (ic2 != null && (ic2 = ic2.j("Cert")) != null && (uc2 = ic2.k("Issuer")) != null) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                for (int i2 = 0; i2 < uc2.o(); ++i2) {
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(uc2.k(i2).r()));
                    arrayList.add(x509Certificate);
                }
                return arrayList.toArray(new X509Certificate[0]);
            }
        }
        catch (Exception exception) {
            throw gc.a(exception);
        }
        return null;
    }

    public X509Certificate[] getRequiredCertificateSubjects() {
        ic ic2 = this.j("SV");
        try {
            uc uc2;
            if (ic2 != null && (ic2 = ic2.j("Cert")) != null && (uc2 = ic2.k("Subject")) != null) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                for (int i2 = 0; i2 < uc2.o(); ++i2) {
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(uc2.k(i2).r()));
                    arrayList.add(x509Certificate);
                }
                return arrayList.toArray(new X509Certificate[0]);
            }
        }
        catch (Exception exception) {
            throw gc.a(exception);
        }
        return null;
    }

    public URI getRequiredCertificateFallbackURI() {
        ic ic2 = this.j("SV");
        try {
            bd bd2;
            if (ic2 != null && (ic2 = ic2.j("Cert")) != null && (bd2 = ic2.m("URL")) != null) {
                return new URI(bd2.a(hb.UCS));
            }
        }
        catch (Exception exception) {
            throw gc.a(exception);
        }
        return null;
    }

    void w() {
        super.w();
        this.L = this.f("V") ? 0 : 2;
    }

    public String getValue() {
        return null;
    }

    public int getCertificationType() {
        try {
            return this.j("V").k("Reference").f(0).j("TransformParams").l("P").o();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCertificationType(int n2, String string) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Invalid type " + n2);
        }
        this.R = n2;
        this.S = string;
    }

    private boolean c(PDF pDF) {
        boolean bl;
        block5: {
            String string;
            bl = true;
            int n2 = this.getCertificationType();
            if (n2 == 0 || pDF.t().g() == null) break block5;
            try {
                string = this.j("V").k("Reference").f(0).i("DigestMethod").o();
            }
            catch (Exception exception) {
                string = "MD5";
            }
            zb zb2 = new zb(string, n2);
            yd yd2 = pDF.t();
            byte[] byArray = zb2.a(pDF, yd2);
            while (yd2.g() != null) {
                yd2 = yd2.g();
            }
            byte[] byArray2 = zb2.a(pDF, yd2);
            bl = Arrays.equals(byArray, byArray2);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ic a(PDF pDF, int n2, String string) {
        Object object;
        ic ic2;
        if (n2 != 2 && n2 != 3) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        block48: while (true) {
            if (n11 >= pDF.getNumberOfPages()) break;
            ic2 = pDF.getPage(n11);
            for (int i2 = 0; i2 < Event.ALL.length; ++i2) {
                PDFAction pDFAction = ((PDFPage)ic2).getAction(Event.ALL[i2]);
                if (pDFAction == null) continue;
                object = pDFAction.getType();
                if (((String)object).equals("FormJavaScript")) {
                    ++n4;
                    continue;
                }
                if (((String)object).equals("Movie")) {
                    ++n7;
                    continue;
                }
                if (((String)object).equals("Sound")) {
                    ++n8;
                    continue;
                }
                if (((String)object).equals("GoToR")) {
                    ++n10;
                    continue;
                }
                if (((String)object).equals("Launch")) {
                    ++n5;
                    continue;
                }
                if (((String)object).equals("Hide")) {
                    ++n9;
                    continue;
                }
                if (!((String)object).equals("URI")) continue;
                ++n6;
            }
            List list = ((PDFPage)ic2).getAnnotations();
            int n12 = 0;
            while (true) {
                block101: {
                    block100: {
                        block98: {
                            String string2;
                            block107: {
                                block106: {
                                    block105: {
                                        block104: {
                                            block103: {
                                                block102: {
                                                    block99: {
                                                        if (n12 >= list.size()) break block98;
                                                        if (!(list.get(n12) instanceof WidgetAnnotation)) break block99;
                                                        object = (WidgetAnnotation)list.get(n12);
                                                        break block100;
                                                    }
                                                    if (!(list.get(n12) instanceof AnnotationLink) || (object = ((AnnotationLink)list.get(n12)).getAction()) == null) break block101;
                                                    string2 = ((PDFAction)object).getType();
                                                    if (!string2.equals("FormJavaScript")) break block102;
                                                    ++n4;
                                                    break block101;
                                                }
                                                if (!string2.equals("Movie")) break block103;
                                                ++n7;
                                                break block101;
                                            }
                                            if (!string2.equals("Sound")) break block104;
                                            ++n8;
                                            break block101;
                                        }
                                        if (!string2.equals("GoToR")) break block105;
                                        ++n10;
                                        break block101;
                                    }
                                    if (!string2.equals("Launch")) break block106;
                                    ++n5;
                                    break block101;
                                }
                                if (!string2.equals("Hide")) break block107;
                                ++n9;
                                break block101;
                            }
                            if (!string2.equals("URI")) break block101;
                            ++n6;
                            break block101;
                        }
                        n3 += list.size();
                        ++n11;
                        continue block48;
                    }
                    for (int i3 = 0; i3 < Event.ALL.length; ++i3) {
                        PDFAction pDFAction = ((WidgetAnnotation)object).getAction(Event.ALL[i3]);
                        if (pDFAction == null) continue;
                        String string3 = pDFAction.getType();
                        if (string3.equals("FormJavaScript")) {
                            ++n4;
                            continue;
                        }
                        if (string3.equals("Movie")) {
                            ++n7;
                            continue;
                        }
                        if (string3.equals("Sound")) {
                            ++n8;
                            continue;
                        }
                        if (string3.equals("GoToR")) {
                            ++n10;
                            continue;
                        }
                        if (string3.equals("Launch")) {
                            ++n5;
                            continue;
                        }
                        if (string3.equals("Hide")) {
                            ++n9;
                            continue;
                        }
                        if (!string3.equals("URI")) continue;
                        ++n6;
                    }
                }
                ++n12;
            }
            break;
        }
        Iterator iterator = this.getForm().getElements().values().iterator();
        block52: while (iterator.hasNext()) {
            ic2 = (FormElement)iterator.next();
            int n13 = 0;
            while (true) {
                if (n13 >= Event.ALL.length) continue block52;
                PDFAction pDFAction = ((FormElement)ic2).getAction(Event.ALL[n13]);
                if (pDFAction != null) {
                    object = pDFAction.getType();
                    if (((String)object).equals("FormJavaScript")) {
                        ++n4;
                    } else if (((String)object).equals("Movie")) {
                        ++n7;
                    } else if (((String)object).equals("Sound")) {
                        ++n8;
                    } else if (((String)object).equals("GoToR")) {
                        ++n10;
                    } else if (((String)object).equals("Launch")) {
                        ++n5;
                    } else if (((String)object).equals("Hide")) {
                        ++n9;
                    } else if (((String)object).equals("URI")) {
                        ++n6;
                    }
                }
                ++n13;
            }
            break;
        }
        for (int i4 = 0; i4 < Event.ALL.length; ++i4) {
            ic2 = pDF.getAction(Event.ALL[i4]);
            if (ic2 == null) continue;
            String string4 = ((PDFAction)ic2).getType();
            if (string4.equals("FormJavaScript")) {
                ++n4;
                continue;
            }
            if (string4.equals("Movie")) {
                ++n7;
                continue;
            }
            if (string4.equals("Sound")) {
                ++n8;
                continue;
            }
            if (string4.equals("GoToR")) {
                ++n10;
                continue;
            }
            if (string4.equals("Launch")) {
                ++n5;
                continue;
            }
            if (string4.equals("Hide")) {
                ++n9;
                continue;
            }
            if (!string4.equals("URI")) continue;
            ++n6;
        }
        ic ic3 = new ic("Legal");
        ic3.a();
        if (n3 > 0) {
            ic3.b("Annotations", xc.b(n3));
        }
        if (n4 > 0) {
            ic3.b("JavaScriptActions", xc.b(n4));
        }
        if (n5 > 0) {
            ic3.b("LaunchActions", xc.b(n5));
        }
        if (n7 > 0) {
            ic3.b("MovieActions", xc.b(n7));
        }
        if (n8 > 0) {
            ic3.b("SoundActions", xc.b(n8));
        }
        if (n9 > 0) {
            ic3.b("HideAnnotationActions", xc.b(n9));
        }
        if (n10 > 0) {
            ic3.b("GoToRemote", xc.b(n10));
        }
        if (n6 > 0) {
            ic3.b("URIActions", xc.b(n6));
        }
        if (pDF.j("Root").f("OCProperties")) {
            ic3.b("OptionalContent", vc.g);
        }
        if (string == null) return ic3;
        ic3.b("Attestation", new bd(string, hb.PDF));
        return ic3;
    }

    static {
        FormSignature.registerHandlerForVerification(HANDLER_VERISIGN);
        FormSignature.registerHandlerForVerification(HANDLER_SELFSIGN);
        FormSignature.registerHandlerForVerification(HANDLER_ACROBATSIX);
        FormSignature.registerHandlerForVerification(new SignatureHandlerFactory(){

            public SignatureHandler getHandler() {
                return new PKCS7SignatureHandler(){

                    public String getHashAlgorithm() {
                        return "SHA1";
                    }

                    public String getFilter() {
                        return "SignCubes.DocSign";
                    }

                    public String getSubFilter() {
                        return "adbe.pkcs7.detached";
                    }
                };
            }
        });
    }

    private static final class e_
    extends SignatureHandler {
        private final String d;

        e_(String string) {
            this.d = string;
        }

        public String[] getLayerNames() {
            return null;
        }

        public PDFCanvas getLayerAppearance(String string, PDFStyle pDFStyle) {
            return null;
        }

        public String getFilter() {
            return this.d;
        }

        public MessageDigest getMessageDigest() {
            throw new UnsupportedOperationException("No getMessageDigest() method for null handler");
        }

        public boolean verify(InputStream inputStream) throws GeneralSecurityException {
            throw new GeneralSecurityException("No implementation for \"" + this.d + "\" handler");
        }

        InputStream a(BackedInputStream backedInputStream) throws GeneralSecurityException {
            throw new GeneralSecurityException("No implementation for \"" + this.d + "\" handler");
        }
    }
}

