/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.StandardEncryptionHandler;
import org.faceless.pdf2.ad;
import org.faceless.pdf2.cd;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hc;
import org.faceless.pdf2.hd;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.sc;
import org.faceless.pdf2.tc;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.pdf2.yd;
import org.faceless.util.BackedInputStream;
import org.faceless.util.ByteBuffer;
import org.faceless.util.Worker;

public final class PDFReader {
    private final BackedInputStream a;
    private final boolean b;
    private final hd c;
    private final OutputProfile d;
    private yd e;
    private int f;
    private int g;
    private long h;
    private EncryptionHandler i;

    public PDFReader(File file) throws IOException {
        this(file, (EncryptionHandler)null);
    }

    public PDFReader(File file, String string) throws IOException {
        this(file, (EncryptionHandler)(string == null ? null : new StandardEncryptionHandler(string)));
    }

    public PDFReader(InputStream inputStream) throws IOException {
        this(inputStream, (EncryptionHandler)null);
    }

    public PDFReader(InputStream inputStream, String string) throws IOException {
        this(inputStream, (EncryptionHandler)new StandardEncryptionHandler(string));
    }

    public PDFReader(InputStream inputStream, EncryptionHandler encryptionHandler) throws IOException {
        this(inputStream, encryptionHandler, null);
    }

    public PDFReader(File file, EncryptionHandler encryptionHandler) throws IOException {
        this(file, encryptionHandler, null);
    }

    public PDFReader(InputStream inputStream, EncryptionHandler encryptionHandler, float[] fArray) throws IOException {
        this(inputStream, new EncryptionHandler[]{encryptionHandler}, fArray);
    }

    public PDFReader(File file, EncryptionHandler encryptionHandler, float[] fArray) throws IOException {
        this(file, new EncryptionHandler[]{encryptionHandler}, fArray);
    }

    public PDFReader(InputStream inputStream, EncryptionHandler[] encryptionHandlerArray, float[] fArray) throws IOException {
        this(BackedInputStream.getInstance(inputStream, false), encryptionHandlerArray, "%PDF-", true, fArray);
    }

    public PDFReader(File file, EncryptionHandler[] encryptionHandlerArray, float[] fArray) throws IOException {
        this(BackedInputStream.getInstance(file), encryptionHandlerArray, "%PDF-", false, fArray);
    }

    PDFReader(InputStream inputStream, EncryptionHandler[] encryptionHandlerArray, String string, boolean bl, float[] fArray) throws IOException {
        this(BackedInputStream.getInstance(inputStream, false), encryptionHandlerArray, string, bl, fArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PDFReader(BackedInputStream backedInputStream, EncryptionHandler[] encryptionHandlerArray, String string, boolean bl, float[] fArray) throws IOException {
        try {
            if (fArray == null || fArray.length < 1) {
                fArray = new float[1];
            }
            this.d = new OutputProfile(OutputProfile.Default);
            this.b = bl;
            this.a = backedInputStream;
            this.c = new hd(backedInputStream);
            try {
                boolean bl2;
                long l2;
                block59: {
                    int n2;
                    int n3;
                    PDF.a(PDFReader.class);
                    fArray[0] = 0.0f;
                    backedInputStream.search(gc.a(string), 1030L);
                    l2 = backedInputStream.tell();
                    if (l2 > 1024L) {
                        throw new IOException("Not a valid PDF file - does not begin with \"" + string + "\"");
                    }
                    if (l2 != 0L) {
                        this.d.set(OutputProfile.Feature.HeaderNotAtStart);
                    }
                    byte[] byArray = new byte[16];
                    for (n3 = 0; n3 < 16; ++n3) {
                        byArray[n3] = (byte)backedInputStream.read();
                    }
                    n3 = byArray[5] - 48;
                    this.g = byArray[7] - 48;
                    if (n3 == 1) {
                        switch (this.g) {
                            case 0: {
                                this.d.set(OutputProfile.Feature.PDFVersion10);
                                break;
                            }
                            case 1: {
                                this.d.set(OutputProfile.Feature.PDFVersion11);
                                break;
                            }
                            case 2: {
                                this.d.set(OutputProfile.Feature.PDFVersion12);
                                break;
                            }
                            case 3: {
                                this.d.set(OutputProfile.Feature.PDFVersion13);
                                break;
                            }
                            case 4: {
                                this.d.set(OutputProfile.Feature.PDFVersion14);
                                break;
                            }
                            case 5: {
                                this.d.set(OutputProfile.Feature.PDFVersion15);
                                break;
                            }
                            case 6: {
                                this.d.set(OutputProfile.Feature.PDFVersion16);
                                break;
                            }
                            case 7: {
                                this.d.set(OutputProfile.Feature.PDFVersion17);
                                break;
                            }
                        }
                    } else if (n3 == 2) {
                        this.d.set(OutputProfile.Feature.h);
                        this.g = 11;
                    }
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        if (byArray[n2] == string.charAt(n2)) continue;
                        throw new IOException("Not a valid PDF file - does not begin with \"" + string + "\"");
                    }
                    for (n2 = 9; n2 < byArray.length - 5 && byArray[n2] != 37; ++n2) {
                    }
                    if (byArray[n2] != 37 || byArray[n2 + 1] >= 0 || byArray[n2 + 2] >= 0 || byArray[n2 + 3] >= 0 || byArray[n2 + 4] >= 0) {
                        this.d.set(OutputProfile.Feature.NoFourByteComment);
                    }
                    backedInputStream.seek(l2);
                    bl2 = backedInputStream.search(gc.a("/Linearized"), 1200L);
                    if (bl2) {
                        try {
                            cd cd2;
                            ic ic2;
                            int n4;
                            backedInputStream.seek(Math.max(0L, backedInputStream.tell() - 20L));
                            if (!backedInputStream.search(gc.a("<<"), 20L) || (long)(n4 = (ic2 = (ic)(cd2 = new cd(new hd(backedInputStream), null, null, null)).a()).l("L").o()) > backedInputStream.length()) break block59;
                            backedInputStream.seek(n4);
                            int n5 = backedInputStream.read();
                            while (n5 >= 0) {
                                if (n5 != 32 && n5 != 10 && n5 != 13) {
                                    bl2 = false;
                                }
                                n5 = backedInputStream.read();
                            }
                            if (bl2) {
                                this.d.set(OutputProfile.Feature.Linearized);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                backedInputStream.seek(l2);
                this.a(l2, "%PDF-".equals(string), bl2, false, fArray, encryptionHandlerArray);
                return;
            }
            catch (Throwable throwable) {
                this.g();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof IOException)) return;
                throw (IOException)throwable;
            }
        }
        catch (IOException iOException) {
            try {
                backedInputStream.close();
                throw iOException;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            try {
                backedInputStream.close();
                throw runtimeException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw runtimeException;
        }
    }

    yd a() {
        return this.e;
    }

    public int getNumberOfRevisions() {
        return this.f + 1;
    }

    int b() {
        return this.g;
    }

    OutputProfile c() {
        return this.d;
    }

    private static void a(String string, PDFReader pDFReader) throws IOException {
        throw new IOException("Parse error at " + pDFReader.a.tell() + ": " + string);
    }

    long d() {
        return this.h;
    }

    BackedInputStream e() {
        return this.a;
    }

    EncryptionHandler f() {
        return this.i;
    }

    protected void finalize() {
        this.g();
    }

    void g() {
        try {
            if (this.b) {
                this.a.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(long l2, boolean bl, boolean bl2, boolean bl3, float[] fArray, EncryptionHandler[] encryptionHandlerArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object var8_7 = null;
        this.e = new yd();
        this.f = 0;
        this.a.seek(this.a.length() - 5L);
        if (!this.a.search(gc.a("%%EOF"), -this.a.tell())) {
            throw new IOException("Can't find %%EOF - not a valid PDF file");
        }
        if (this.a.tell() < this.a.length() - 7L) {
            this.d.set(OutputProfile.Feature.TrailerNotAtEnd);
        }
        long l3 = 0L;
        if (this.a.search(gc.a("startxref"), -24L)) {
            this.c.d();
            object3 = this.c.d();
            try {
                l3 = ((ByteBuffer)object3).parseLong();
            }
            catch (NumberFormatException numberFormatException) {
                PDF.k.warning("RD1", "Invalid startxref value " + object3);
            }
        } else if (bl) {
            PDF.k.warning("RD1", "Can't find startxref - check the file ends with %%EOF");
        }
        try {
            if (bl3) {
                throw new a_("Too many errors, ignoring XRef");
            }
            this.h = l3;
            object3 = this.a(l3, l2, this.e);
            this.e.a((ic)object3);
            Object object4 = this.e;
            while (((yd)object4).e().f("Prev")) {
                if (l3 < 250L) {
                    l3 = ((yd)object4).e().l("Prev").q();
                    object2 = this.e.e().k("ID");
                    object3 = this.a(l3, l2, (yd)object4);
                    object = ((hc)object3).k("ID");
                    ((yd)object4).e().e("Prev");
                    ((yd)object4).a((ic)object3);
                    if (object2 != null && object != null && ((uc)object2).k(0).equals(((uc)object).k(0)) && ((uc)object2).k(0).equals(((uc)object).k(0))) continue;
                    this.d.set(OutputProfile.Feature.DocIDMismatch);
                    continue;
                }
                object2 = new yd();
                long l4 = ((yd)object4).e().l("Prev").q();
                object3 = this.a(l4, l2, (yd)object2);
                if (this.a.tell() > l3) {
                    long l5 = ((yd)object4).f();
                    object3 = this.a(l4, l2, (yd)object4);
                    ((yd)object4).e().e("Prev");
                    ((hc)object3).a("BufLength", xc.a(l5));
                    ((yd)object4).a((ic)object3);
                } else {
                    ((yd)object4).a((yd)object2);
                    ((yd)object2).a((ic)object3);
                    object4 = object2;
                    ++this.f;
                    this.d.clear(OutputProfile.Feature.Linearized);
                }
                l3 = l4;
            }
        }
        catch (a_ a_2) {
            if (bl) {
                PDF.k.warning("RD3", a_2.getMessage());
            }
            this.d.set(OutputProfile.Feature.FileIsDamaged);
            try {
                this.a(l2, this.e);
            }
            catch (a_ a_3) {
                PDFReader.a(a_3.toString(), this);
            }
            this.e.e().e("Prev");
        }
        fArray[0] = 0.05f;
        if (this.e.e().f("Encrypt")) {
            this.i = this.a((ad)this.e.e().g("Encrypt"), this.e, encryptionHandlerArray);
        }
        int n2 = 0;
        for (object3 = this.e; object3 != null; n2 += ((yd)object3).k(), object3 = ((yd)object3).g()) {
        }
        object2 = new int[1];
        object = new int[1];
        float f2 = n2;
        int n3 = bl3 ? Integer.MAX_VALUE : 6;
        int n4 = PDF.t("Read");
        for (object3 = this.e; object3 != null && object[0] < n3; object3 = ((yd)object3).g()) {
            Worker worker = new Worker(n4, ((yd)object3).l(), (int[])object, n3, (int[])object2, fArray, f2){
                final ThreadLocal g;
                final /* synthetic */ int[] val$readfailures;
                final /* synthetic */ int val$maxfailures;
                final /* synthetic */ int[] val$objectcount;
                final /* synthetic */ float[] val$progress;
                final /* synthetic */ float val$numobjects;
                {
                    this.val$readfailures = nArray;
                    this.val$maxfailures = n3;
                    this.val$objectcount = nArray2;
                    this.val$progress = fArray;
                    this.val$numobjects = f2;
                    super(n2, iterator);
                    this.g = new ThreadLocal(){

                        protected synchronized Object initialValue() {
                            return new cd(new hd(PDFReader.this.a.duplicate()), PDFReader.this.e, PDFReader.this.d, PDFReader.this.i);
                        }
                    };
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean isActive() {
                    int[] nArray = this.val$readfailures;
                    synchronized (this.val$readfailures) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return this.val$readfailures[0] < this.val$maxfailures;
                    }
                }

                public void action(Object object, int n2) {
                    cd cd2 = (cd)this.g.get();
                    yd.b_ b_2 = (yd.b_)object;
                    PDFReader.this.a(b_2, cd2, this.val$readfailures, this.val$objectcount);
                    this.val$progress[0] = (float)this.val$objectcount[0] / this.val$numobjects * 0.9f + 0.05f;
                }

                public void completed() {
                    this.g.set(null);
                    if (PDF.p > 4) {
                        this.g.remove();
                    }
                }
            };
            try {
                worker.start();
                continue;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                IOException iOException = new IOException("Read failed");
                iOException.initCause(exception);
                throw iOException;
            }
        }
        if (object[0] >= n3) {
            this.a(l2, bl, bl2, true, fArray, encryptionHandlerArray);
            return;
        }
        if (this.i == null) return;
        this.i.finishedDecrypt();
        this.i.a((Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void a(yd.b_ b_2, cd cd2, int[] nArray, int[] nArray2) {
        Object object;
        gc gc2;
        if (b_2.i() != null) return;
        int n2 = b_2.f();
        int n3 = b_2.g();
        long l2 = b_2.h();
        int n4 = b_2.d();
        if (n4 != 0) return;
        try {
            gc2 = cd2.a(l2, n2, n3);
        }
        catch (Exception exception) {
            PDF.k.warning("RD4", "Can't read object " + n2 + "/" + n3 + " (1)", exception);
            gc2 = gc.a;
            this.d.set(OutputProfile.Feature.FileIsDamaged);
            object = nArray;
            // MONITORENTER : nArray
            nArray[0] = nArray[0] + 1;
            // MONITOREXIT : object
        }
        if (gc2 == null) return;
        if (gc2 instanceof sc && ((sc)gc2).f("Type") && ((sc)gc2).i("Type").d("ObjStm")) {
            int n5 = n2;
            try {
                object = new tc((sc)gc2, this.e, this.d);
                b_2.a((gc)object);
                int n6 = 0;
                while (true) {
                    if (n6 >= ((tc)object).y()) {
                        ((tc)object).A();
                        return;
                    }
                    n2 = ((tc)object).b(n6);
                    gc2 = ((tc)object).z();
                    b_2 = this.e.a(n2, 0);
                    if (b_2 != null && b_2.i() == null && b_2.d() == n5 && b_2.e() == n6) {
                        b_2.a(gc2);
                        int[] nArray3 = nArray2;
                        // MONITORENTER : nArray2
                        nArray2[0] = nArray2[0] + 1;
                        // MONITOREXIT : nArray3
                    }
                    ++n6;
                }
            }
            catch (IOException iOException) {
                PDF.k.warning("RD4", "Can't read object " + n2 + "/" + n3 + " from ObjStm " + n5, iOException);
                return;
            }
        }
        b_2.a(gc2);
        int[] nArray4 = nArray2;
        // MONITORENTER : nArray2
        nArray2[0] = nArray2[0] + 1;
        // MONITOREXIT : nArray4
        if (!(gc2 instanceof ic)) return;
        if (this.e.e().f("Root")) return;
        if (!(((ic)gc2).h("Type") instanceof wc)) return;
        if (!((ic)gc2).i("Type").d("Catalog")) return;
        this.e.e().b("Root", gc2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EncryptionHandler a(ad ad2, yd yd2, EncryptionHandler[] encryptionHandlerArray) throws IOException {
        int n2 = ad2.o();
        int n3 = ad2.p();
        yd.b_ b_2 = yd2.a(n2, n3);
        uc uc2 = yd2.e().k("ID");
        ic ic2 = (ic)new cd(this.c, yd2, this.d, null).a(b_2.h(), n2, n3);
        b_2.a(ic2);
        if (!ic2.f("Filter") || !ic2.f("R")) {
            PDFReader.a("Invalid Encryption dictionary", this);
        }
        ArrayList<EncryptionHandler> arrayList = new ArrayList<EncryptionHandler>(Arrays.asList(encryptionHandlerArray));
        arrayList.add(new StandardEncryptionHandler(""));
        IOException iOException = null;
        EncryptionHandler encryptionHandler = null;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            EncryptionHandler encryptionHandler2 = (EncryptionHandler)arrayList.get(i2);
            if (encryptionHandler2 == null || !ic2.i("Filter").d(encryptionHandler2.getFilterName())) continue;
            encryptionHandler2 = (EncryptionHandler)encryptionHandler2.clone();
            encryptionHandler2.a(this);
            encryptionHandler2.setFileId(uc2 == null ? null : uc2.k(0).q());
            encryptionHandler2.a().a(ic2);
            try {
                encryptionHandler2.prepareToDecrypt();
                if (!encryptionHandler2.hasRight("Open")) {
                    throw new SecurityException("You do not have permission to open this Document");
                }
                encryptionHandler2.a((Object)null);
                encryptionHandler = encryptionHandler2;
                iOException = null;
                break;
            }
            catch (IOException iOException2) {
                if (iOException == null) {
                    iOException = iOException2;
                }
                if (encryptionHandler2.hasRight("OpenAnyway") && encryptionHandler == null) {
                    encryptionHandler = encryptionHandler2;
                }
                encryptionHandler2.a((Object)null);
            }
        }
        if (encryptionHandler != null) {
            encryptionHandler.a(this);
            return encryptionHandler;
        }
        IOException iOException3 = new IOException("Unable to decrypt PDF with \"" + ic2.i("Filter").o() + "\" encryption");
        if (iOException == null) throw iOException3;
        try {
            iOException3.initCause(iOException);
            throw iOException3;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw iOException3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(long l2, yd yd2) throws IOException, a_ {
        this.a.seek(l2);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        ByteBuffer byteBuffer3 = null;
        do {
            l3 = this.a.tell();
            byteBuffer = this.c.d();
            if (byteBuffer != null && byteBuffer.equalsString("obj")) {
                try {
                    int n2 = byteBuffer3.parseInt();
                    int n3 = byteBuffer2.parseInt();
                    yd2.a(n2, n3, l5);
                    this.a.search(gc.a("endobj"));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (byteBuffer != null && byteBuffer.equalsString("trailer")) {
                this.a.seek(l3);
                yd2.a(this.a(yd2));
            }
            l5 = l4;
            l4 = l3;
            byteBuffer3 = byteBuffer2;
            ByteBuffer byteBuffer4 = byteBuffer2 = byteBuffer == null ? null : new ByteBuffer(byteBuffer);
        } while (byteBuffer != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ic a(long l2, long l3, yd yd2) throws IOException, a_ {
        long l4;
        block35: {
            ByteBuffer byteBuffer;
            block36: {
                uc uc2;
                uc uc3;
                hc hc2;
                block34: {
                    block33: {
                        byteBuffer = null;
                        try {
                            this.a.seek(l2 + l3);
                            byteBuffer = this.c.d();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (byteBuffer != null && byteBuffer.equalsString("xref")) break block33;
                        hc2 = null;
                        byteBuffer = byteBuffer == null ? null : new ByteBuffer(byteBuffer);
                        try {
                            this.c.d();
                            this.c.d();
                            hc2 = (sc)new cd(this.c, yd2, this.d, null).a();
                            if (!hc2.i("Type").d("XRef")) {
                                hc2 = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (hc2 == null) {
                            throw new a_("Cannot extract XREF table at " + (l2 + l3) + " - expected \"xref\", found \"" + byteBuffer + "\"");
                        }
                        this.d.set(OutputProfile.Feature.CompressedXRef);
                        uc3 = hc2.k("W");
                        uc2 = hc2.k("Index");
                        if (uc2 == null) {
                            uc2 = new uc(2);
                            uc2.c(xc.b(0));
                            uc2.c(hc2.l("Size"));
                        }
                        break block34;
                    }
                    l4 = this.a.tell();
                    ByteBuffer byteBuffer2 = this.c.c();
                    this.a(!byteBuffer2.equalsString("\r") && !byteBuffer2.equalsString("\n") && !byteBuffer2.equalsString("\r\n"), "Whitespace before XRef start is not EOL");
                    byteBuffer = this.c.d();
                    if (byteBuffer.equalsString("trailer")) break block35;
                    break block36;
                }
                int n2 = uc3.h(0).o();
                int n3 = uc3.h(1).o();
                int n4 = uc3.h(2).o();
                int n5 = 0;
                InputStream inputStream = ((sc)hc2).w();
                do {
                    int n6 = uc2.h(n5++).o();
                    int n7 = uc2.h(n5++).o() + n6;
                    while (n6 < n7) {
                        int n8;
                        int n9 = 0;
                        int n10 = 0;
                        int n11 = 0;
                        for (n8 = 0; n8 < n2; ++n8) {
                            n9 = (n9 << 8) + (inputStream.read() & 0xFF);
                        }
                        while (n8 < n2 + n3) {
                            n10 = (n10 << 8) + (inputStream.read() & 0xFF);
                            ++n8;
                        }
                        while (n8 < n2 + n3 + n4) {
                            n11 = (n11 << 8) + (inputStream.read() & 0xFF);
                            ++n8;
                        }
                        if (n9 == 1) {
                            yd2.a(n6, n11, (long)n10);
                        } else if (n9 == 2) {
                            yd2.a(n6, n10, n11);
                        }
                        ++n6;
                    }
                } while (n5 < uc2.o());
                inputStream.close();
                ic ic2 = new ic();
                ic2.a(hc2);
                ic2.e("Type");
                ic2.e("Size");
                ic2.e("Index");
                ic2.e("W");
                ic2.e("Length");
                this.a.search(gc.a("%%EOF"));
                this.c.b();
                ic2.a("BufLength", xc.a(this.a.tell()));
                return ic2;
            }
            do {
                int n12;
                this.a(!this.c.c().equalsString(" "), "Whitespace between XRef start and length is not 0x20");
                int n13 = this.c.d().parseInt() + n12;
                for (n12 = byteBuffer.parseInt(); n12 < n13; ++n12) {
                    int n14;
                    long l5;
                    ByteBuffer byteBuffer3 = null;
                    try {
                        byteBuffer3 = this.c.d();
                        l5 = byteBuffer3.parseLong() + l3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new a_("XREF position for object " + n12 + " is not a number: " + byteBuffer3);
                    }
                    try {
                        byteBuffer3 = this.c.d();
                        n14 = byteBuffer3.parseInt();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new a_("XREF generation for object " + n12 + " is not a number: " + byteBuffer3);
                    }
                    byteBuffer3 = this.c.d();
                    if (byteBuffer3 == null || !byteBuffer3.equalsString("n") || l5 == l3) continue;
                    yd2.a(n12, n14, l5);
                }
                l4 = this.a.tell();
            } while ((byteBuffer = this.c.d()).charAt(0) >= '1' && byteBuffer.charAt(0) <= '9');
        }
        this.a.seek(l4);
        return this.a(yd2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ic a(yd yd2) throws IOException, a_ {
        ByteBuffer byteBuffer = this.c.d();
        if (byteBuffer != null && !byteBuffer.equalsString("trailer")) {
            throw new a_("Expected to find \"trailer\", found \"" + byteBuffer + "\"");
        }
        ic ic2 = null;
        gc gc2 = new cd(this.c, yd2, this.d, null).a();
        if (gc2 instanceof ic) {
            ic2 = (ic)gc2;
        } else if (gc2 instanceof sc) {
            ic2 = new ic();
            ic2.a((sc)gc2);
            PDF.k.warning("RD7", "File trailer is a stream not a dictionary");
        } else {
            ic2 = new ic();
            PDF.k.warning("RD7", "File trailer is not a valid object type");
        }
        this.c.d();
        this.c.d();
        this.c.b();
        ic2.a("BufLength", xc.a(this.c.tell()));
        return ic2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, String string) {
        if (!bl) return;
        this.d.set(OutputProfile.Feature.ImperfectWhitespace);
        if (!PDF.s("PDFA")) return;
        PDF.k.debug("PDFA", string + " at " + this.c.tell());
    }

    private static class a_
    extends Exception {
        public a_(String string) {
            super(string);
        }
    }
}

