/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PasswordException;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.z;
import org.faceless.util.ARC4InputStream;
import org.faceless.util.ARC4OutputStream;

public class StandardEncryptionHandler
extends EncryptionHandler {
    private static final byte[] d = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] e = new byte[]{115, 65, 108, 84};
    private String f = null;
    private String g = "";
    private int h;
    private int i;
    private int j;
    private int k;
    private transient byte[] l;
    private boolean m;
    private boolean n = true;
    private boolean o = true;
    private boolean p = true;
    private boolean q = true;
    private boolean r;
    public static final int PRINT_NONE = 0;
    public static final int PRINT_LOWRES = 4;
    public static final int PRINT_HIGHRES = 2052;
    public static final int EXTRACT_NONE = 0;
    public static final int EXTRACT_ACCESSIBILITY = 512;
    public static final int EXTRACT_ALL = 528;
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_LAYOUT = 1024;
    public static final int CHANGE_FORMS = 256;
    public static final int CHANGE_ANNOTATIONS = 288;
    public static final int CHANGE_ALL = 1320;

    public StandardEncryptionHandler() {
        this.setAcrobat3Level(true, true, true, true);
        this.r = true;
    }

    StandardEncryptionHandler(String string) {
        this();
        this.setUserPassword(string);
    }

    public int hashCode() {
        int n2;
        int n3 = n2 = this.m ? 1 : 0;
        if (this.l != null) {
            for (int i2 = 0; i2 < this.l.length; ++i2) {
                n2 ^= this.l[i2] << (i2 & 3) * 8;
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (!(object instanceof StandardEncryptionHandler)) return false;
        StandardEncryptionHandler standardEncryptionHandler = (StandardEncryptionHandler)object;
        if (!Arrays.equals(this.l, standardEncryptionHandler.l)) return false;
        if (standardEncryptionHandler.m != this.m) return false;
        return true;
    }

    public Object clone() {
        StandardEncryptionHandler standardEncryptionHandler = (StandardEncryptionHandler)super.clone();
        if (this.l != null) {
            standardEncryptionHandler.l = new byte[this.l.length];
            System.arraycopy(this.l, 0, standardEncryptionHandler.l, 0, this.l.length);
        }
        return standardEncryptionHandler;
    }

    public void setOwnerPassword(String string) {
        this.markChanged();
        if (string == null) {
            string = "";
        }
        this.f = string;
    }

    public void setUserPassword(String string) {
        this.markChanged();
        if (string == null) {
            string = "";
        }
        this.g = string;
    }

    public void setAcrobat3Level(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.markChanged();
        this.j = 1;
        this.k = 2;
        StandardEncryptionHandler standardEncryptionHandler = this;
        int n2 = bl ? 4 : 0;
        int n3 = bl4 ? 8 : 0;
        int n4 = n2 + n3;
        int n5 = bl3 ? 16 : 0;
        int n6 = n4 + n5;
        int n7 = bl2 ? 32 : 0;
        standardEncryptionHandler.h = n6 + n7;
    }

    public void setAcrobat5Level(int n2, int n3, int n4) {
        this.markChanged();
        this.j = 2;
        this.k = 3;
        int n5 = 3900;
        this.h = (n2 | n3 | n4) & n5;
    }

    public void setAcrobat6Level(int n2, int n3, int n4, boolean bl) {
        this.setAcrobat5Level(n2, n3, n4);
        if (!bl) {
            this.j = 4;
            this.k = 4;
            this.q = false;
        }
    }

    public void setAcrobat7Level(int n2, int n3, int n4, boolean bl) throws NoSuchAlgorithmException {
        this.markChanged();
        try {
            Cipher.getInstance("AES");
        }
        catch (Throwable throwable) {
            throw new NoSuchAlgorithmException("No AES available: " + throwable.toString());
        }
        this.setAcrobat5Level(n2, n3, n4);
        this.j = 4;
        this.k = 4;
        this.q = bl;
        this.m = true;
    }

    public void setAcrobat9Level(int n2, int n3, int n4, boolean bl) throws NoSuchAlgorithmException {
        this.setAcrobat7Level(n2, n3, n4, bl);
    }

    public void setAcrobatXLevel(int n2, int n3, int n4, boolean bl) throws NoSuchAlgorithmException {
        this.setAcrobat7Level(n2, n3, n4, bl);
        this.j = 5;
        this.k = 6;
    }

    public int getVersion() {
        return this.j;
    }

    public boolean isOwnerPasswordKnown() {
        boolean bl = this.f != null;
        return bl;
    }

    boolean b() {
        return this.m;
    }

    public boolean isMetadataEncrypted() {
        return this.q;
    }

    public boolean isStreamEncrypted() {
        return this.n;
    }

    public boolean isStringEncrypted() {
        return this.o;
    }

    public boolean isEmbeddedFileEncrypted() {
        return this.p;
    }

    public int getChange() {
        int n2 = this.h;
        int n3 = this.k == 2 ? 40 : 1320;
        return n2 & n3;
    }

    public int getExtract() {
        int n2 = this.h;
        int n3 = this.k == 2 ? 16 : 528;
        return n2 & n3;
    }

    public int getPrint() {
        int n2 = this.h;
        int n3 = this.k == 2 ? 4 : 2052;
        return n2 & n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRight(String string) {
        if (this.isOwnerPasswordKnown()) {
            return super.hasRight(string);
        }
        if ("Print".equals(string)) {
            if (this.getPrint() == 0) return false;
            return true;
        }
        if ("Extract".equals(string)) {
            if (this.getExtract() != 528) return false;
            return true;
        }
        if ("Assemble".equals(string)) {
            if (this.getChange() == 1320) return true;
            if (this.getChange() == 1024) return true;
            return false;
        }
        if (!"OpenAnyway".equals(string)) return super.hasRight(string);
        if (this.r) return true;
        if (this.k < 4) return false;
        if (!"EFOpen".equals(this.getNameValue("CF.StdCF.AuthEvent"))) return false;
        return true;
    }

    public String getFilterName() {
        return "Standard";
    }

    public String getSubFilterName() {
        return null;
    }

    public String getDescription() {
        int n2 = this.i * 8;
        return n2 + "-bit " + (this.b() ? "AES" : "RC4");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRequired() {
        if (this.f != null) {
            if (this.f.length() != 0) return true;
        }
        if (this.g != null) {
            if (this.g.length() != 0) return true;
        }
        if (this.j == 1) {
            if (this.h != 60) return true;
        }
        if (this.j == 2 || this.j >= 4) {
            if (this.h != 3900) return true;
        }
        if (this.j < 4) return false;
        if (this.q) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(int n2, int n3) throws NoSuchAlgorithmException {
        if (this.b() && this.getVersion() == 5) {
            return this.l;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(this.l);
        messageDigest.update((byte)(n2 & 0xFF));
        messageDigest.update((byte)(n2 >> 8 & 0xFF));
        messageDigest.update((byte)(n2 >> 16 & 0xFF));
        messageDigest.update((byte)(n3 & 0xFF));
        messageDigest.update((byte)(n3 >> 7 & 0xFF));
        if (!this.m) return messageDigest.digest();
        messageDigest.update(e);
        return messageDigest.digest();
    }

    public int getDecryptedStreamLength(int n2) {
        int n3 = this.m ? -1 : n2;
        return n3;
    }

    public int getEncryptedStreamLength(int n2) {
        int n3 = !this.m ? n2 : n2 + 32 - n2 % 16;
        return n3;
    }

    public OutputStream getEncryptionStream(OutputStream outputStream, int n2, int n3) {
        if (!this.r) {
            throw new IllegalStateException("Correct password was not supplied during decryption");
        }
        int n4 = this.k >= 5 ? this.i : Math.min(16, this.i + 5);
        int n5 = n4;
        try {
            byte[] byArray = this.a(n2, n3);
            if (this.m) {
                return z.a(outputStream, byArray, 0, n5);
            }
            return new ARC4OutputStream(outputStream, byArray, 0, n5);
        }
        catch (Exception exception) {
            throw gc.a(exception);
        }
    }

    public InputStream getDecryptionStream(InputStream inputStream, int n2, int n3) {
        if (!this.r) {
            throw new IllegalStateException("Correct password was not supplied during decryption");
        }
        int n4 = this.k >= 5 ? this.i : Math.min(16, this.i + 5);
        int n5 = n4;
        try {
            byte[] byArray = this.a(n2, n3);
            if (this.m) {
                return z.a(inputStream, byArray, 0, n5);
            }
            return new ARC4InputStream(inputStream, byArray, 0, n5);
        }
        catch (Exception exception) {
            throw gc.a(exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareToDecrypt() throws IOException {
        try {
            byte[] byArray = this.getStringValue("O");
            byte[] byArray2 = this.getStringValue("U");
            this.h = (int)this.getNumericValue("P");
            this.j = (int)this.getNumericValue("V");
            this.k = (int)this.getNumericValue("R");
            this.m = this.k >= 4 && ("AESV2".equals(this.getNameValue("CF.StdCF.CFM")) || "AESV3".equals(this.getNameValue("CF.StdCF.CFM")));
            this.i = (!Float.isNaN(this.getNumericValue("Length")) ? (int)this.getNumericValue("Length") : 40) / 8;
            if (this.k >= 4) {
                this.q = !this.containsKey("EncryptMetadata") || this.getBooleanValue("EncryptMetadata");
                this.o = this.containsKey("StrF") && !"Identity".equals(this.getNameValue("StrF"));
                boolean bl = this.n = this.containsKey("StmF") && !"Identity".equals(this.getNameValue("StmF"));
                boolean bl2 = this.containsKey("EFF") ? !"Identity".equals(this.getNameValue("EFF")) : (this.p = this.n);
            }
            if (this.k >= 5) {
                byte[] byArray3 = this.b(this.g);
                if (this.b(byArray3, byArray2, this.k)) {
                    this.f = null;
                    this.l = this.a(byArray3, byArray2, byArray, false, this.k);
                    if (!this.a(this.l)) {
                        this.l = null;
                    }
                } else if (this.b(byArray3, byArray2, byArray, this.k)) {
                    this.f = this.g;
                    this.g = null;
                    this.l = this.a(byArray3, byArray2, byArray, true, this.k);
                    if (!this.a(this.l)) {
                        this.l = null;
                    }
                }
                if (this.l != null) {
                    this.r = true;
                    return;
                }
            } else {
                int n2;
                void var3_10;
                Object object;
                if (this.k == 2) {
                    byte[] byArray4 = this.b(this.g, byArray);
                } else {
                    byte[] byArray5 = this.c(this.g, byArray);
                }
                boolean bl = true;
                for (int i2 = 0; i2 < (this.k == 2 ? 32 : 16); ++i2) {
                    void var3_7;
                    if (byArray2[i2] == var3_7[i2]) continue;
                    bl = false;
                }
                if (bl) {
                    this.l = this.a(this.g, byArray);
                    this.r = true;
                    return;
                }
                this.f = this.g;
                this.g = null;
                byte[] byArray6 = this.d(this.f);
                if (this.k == 2) {
                    object = new ByteArrayOutputStream();
                    ARC4OutputStream aRC4OutputStream = new ARC4OutputStream((OutputStream)object, byArray6);
                    aRC4OutputStream.write(byArray);
                    aRC4OutputStream.close();
                    byte[] byArray7 = ((ByteArrayOutputStream)object).toByteArray();
                } else {
                    void var7_24;
                    object = new byte[byArray6.length];
                    byte[] byArray8 = byArray;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    for (int i3 = 0; i3 < 20; ++i3) {
                        byteArrayOutputStream.reset();
                        for (int i4 = 0; i4 < ((Object)object).length; ++i4) {
                            object[i4] = (byte)(byArray6[i4] ^ (byte)i3);
                        }
                        ARC4OutputStream aRC4OutputStream = new ARC4OutputStream(byteArrayOutputStream, (byte[])object);
                        aRC4OutputStream.write((byte[])var7_24);
                        aRC4OutputStream.close();
                        byte[] byArray9 = byteArrayOutputStream.toByteArray();
                    }
                    void var3_9 = var7_24;
                }
                this.g = gc.a((byte[])var3_10);
                if (this.k == 2) {
                    byte[] byArray10 = this.b(this.g, byArray);
                } else {
                    byte[] byArray11 = this.c(this.g, byArray);
                }
                bl = true;
                for (n2 = 0; bl && n2 < (this.k == 2 ? 32 : 16); ++n2) {
                    void var3_13;
                    bl = byArray2[n2] == var3_13[n2];
                }
                if (bl) {
                    this.l = this.a(this.g, byArray);
                    this.r = true;
                    return;
                }
                if (this.f.length() != 0) {
                    this.g = "";
                    if (this.k == 2) {
                        byte[] byArray12 = this.b(this.g, byArray);
                    } else {
                        byte[] byArray13 = this.c(this.g, byArray);
                    }
                    bl = true;
                    for (n2 = 0; bl && n2 < (this.k == 2 ? 32 : 16); ++n2) {
                        void var3_16;
                        bl = byArray2[n2] == var3_16[n2];
                    }
                    if (bl) {
                        this.l = this.a(this.g, byArray);
                        this.f = null;
                        this.r = true;
                        return;
                    }
                }
            }
            this.r = false;
            throw new PasswordException("Invalid password");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw gc.a(noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareToEncrypt() throws IOException {
        try {
            if (!this.r) {
                return;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw gc.a(noSuchAlgorithmException);
        }
        {
            byte[] byArray;
            byte[] byArray2;
            this.h = this.h & (this.j == 1 ? 60 : 3900) | (this.j == 1 ? -64 : -3904);
            int n2 = this.j == 1 ? 5 : (this.i = this.j == 5 ? 32 : 16);
            if (this.k >= 5) {
                byte[] byArray3;
                byte[][] byArray4;
                if (this.l == null) {
                    this.l = new byte[32];
                    new SecureRandom().nextBytes(this.l);
                    byArray4 = this.a(this.l, this.b(this.g), this.k);
                    byArray2 = byArray4[0];
                    this.putStringValue("UE", byArray4[1]);
                } else {
                    byArray2 = this.getStringValue("U");
                }
                if (this.f == null) {
                    byArray3 = new byte[128];
                    new SecureRandom().nextBytes(byArray3);
                    PDF.k.warning("SE2", "Acrobat X security requires an owner password - set to a random string");
                } else {
                    byArray3 = this.b(this.f);
                }
                byArray4 = this.a(this.l, byArray3, byArray2, this.k);
                byArray = byArray4[0];
                this.putStringValue("OE", byArray4[1]);
                byte[] byArray5 = this.a(this.l, this.h, this.q);
                this.putStringValue("Perms", byArray5);
            } else {
                String string5 = this.f == null ? this.g : this.f;
                byArray = this.a(string5, this.g);
                byArray2 = this.k == 2 ? this.b(this.g, byArray) : this.c(this.g, byArray);
                this.l = this.a(this.g, byArray);
            }
            this.putNameValue("Filter", this.getFilterName());
            this.putNumericValue("Length", this.i * 8);
            this.putNumericValue("V", this.j);
            this.putNumericValue("R", this.k);
            this.putStringValue("U", byArray2);
            this.putStringValue("O", byArray);
            this.putNumericValue("P", this.h);
            if (this.k < 4) return;
            this.putNameValue("StmF", this.n ? "StdCF" : "Identity");
            this.putNameValue("StrF", this.o ? "StdCF" : "Identity");
            if (!this.p) {
                this.putNameValue("EFF", "Identity");
            }
            this.putBooleanValue("EncryptMetadata", this.q);
            this.putDictionaryValue("CF");
            this.putDictionaryValue("CF.StdCF");
            this.putNumericValue("CF.StdCF.Length", this.j == 5 ? 32.0f : 16.0f);
            this.putNameValue("CF.StdCF.CFM", this.b() ? (this.getVersion() == 5 ? "AESV3" : "AESV2") : "V2");
            this.putNameValue("CF.StdCF.AuthEvent", "DocOpen");
            return;
        }
    }

    public void finishedEncrypt() {
    }

    public void finishedDecrypt() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(String string, byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray4;
        byte[] byArray2;
        int n2;
        byte[] byArray3 = this.c(string);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray3);
        messageDigest.update(byArray);
        for (n2 = 0; n2 < 4; ++n2) {
            messageDigest.update((byte)(this.h >> n2 * 8 & 0xFF));
        }
        if (this.getFileId() != null) {
            messageDigest.update(this.getFileId());
        }
        if (this.k > 3 && !this.q) {
            messageDigest.update((byte)-1);
            messageDigest.update((byte)-1);
            messageDigest.update((byte)-1);
            messageDigest.update((byte)-1);
        }
        if (this.k > 2) {
            for (n2 = 0; n2 < 50; ++n2) {
                byArray2 = messageDigest.digest();
                messageDigest.reset();
                messageDigest.update(byArray2);
            }
        }
        if ((byArray4 = messageDigest.digest()).length == this.i) {
            return byArray4;
        }
        byArray2 = new byte[this.i];
        System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[][] a(byte[] byArray, byte[] byArray2, int n2) {
        try {
            byte[] byArray3 = new byte[48];
            new SecureRandom().nextBytes(byArray3);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray2);
            messageDigest.update(byArray3, 32, 8);
            byte[] byArray4 = messageDigest.digest();
            if (n2 == 6) {
                byArray4 = this.a(byArray2, byArray4, null);
            }
            System.arraycopy(byArray4, 0, byArray3, 0, 32);
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray3, 40, 8);
            byArray4 = messageDigest.digest();
            if (n2 == 6) {
                byArray4 = this.a(byArray2, byArray4, null);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = z.c(byteArrayOutputStream, byArray4, 0, 32);
            outputStream.write(byArray);
            outputStream.close();
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            return new byte[][]{byArray3, byArray5};
        }
        catch (Exception exception) {
            if (exception instanceof InvalidKeyException && "Illegal key size".equals(exception.getMessage())) {
                throw gc.a("AES256 unsupported - install unlimited strength policy files", exception);
            }
            throw gc.a(exception);
        }
    }

    private byte[][] a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        try {
            byte[] byArray4 = new byte[48];
            new SecureRandom().nextBytes(byArray4);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray2);
            messageDigest.update(byArray4, 32, 8);
            messageDigest.update(byArray3, 0, 48);
            byte[] byArray5 = messageDigest.digest();
            if (n2 == 6) {
                byArray5 = this.a(byArray2, byArray5, byArray3);
            }
            System.arraycopy(byArray5, 0, byArray4, 0, 32);
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray4, 40, 8);
            messageDigest.update(byArray3, 0, 48);
            byArray5 = messageDigest.digest();
            if (n2 == 6) {
                byArray5 = this.a(byArray2, byArray5, byArray3);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = z.c(byteArrayOutputStream, byArray5, 0, 32);
            outputStream.write(byArray);
            outputStream.close();
            byte[] byArray6 = byteArrayOutputStream.toByteArray();
            return new byte[][]{byArray4, byArray6};
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private byte[] a(byte[] byArray, int n2, boolean bl) {
        try {
            byte[] byArray2 = new byte[16];
            new SecureRandom().nextBytes(byArray2);
            byArray2[0] = (byte)n2;
            byArray2[1] = (byte)(n2 >> 8);
            byArray2[2] = (byte)(n2 >> 16);
            byArray2[3] = (byte)(n2 >> 24);
            byArray2[7] = -1;
            byArray2[6] = -1;
            byArray2[5] = -1;
            byArray2[4] = -1;
            byArray2[8] = (byte)(bl ? 84 : 70);
            byArray2[9] = 97;
            byArray2[10] = 100;
            byArray2[11] = 98;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = z.b(byteArrayOutputStream, byArray, 0, 32);
            outputStream.write(byArray2);
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private boolean b(byte[] byArray, byte[] byArray2, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            messageDigest.update(byArray2, 32, 8);
            byte[] byArray3 = messageDigest.digest();
            if (n2 == 6) {
                byArray3 = this.a(byArray, byArray3, null);
            }
            return this.a(byArray3, 0, byArray2, 0, 32);
        }
        catch (Exception exception) {
            PDF.k.warning("SE1", "SHA-256 Failed (311)", exception);
            return false;
        }
    }

    private boolean b(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            messageDigest.update(byArray3, 32, 8);
            messageDigest.update(byArray2, 0, 48);
            byte[] byArray4 = messageDigest.digest();
            if (n2 == 6) {
                byArray4 = this.a(byArray, byArray4, byArray2);
            }
            return this.a(byArray4, 0, byArray3, 0, 32);
        }
        catch (Exception exception) {
            PDF.k.warning("SE1", "SHA-256 Failed (312)", exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        boolean bl = true;
        int n2 = byArray3 == null ? 0 : 48;
        int n3 = 1;
        while (bl) {
            byte[] byArray4 = new byte[64 * (byArray.length + byArray2.length + n2)];
            int n4 = 0;
            while (n4 < byArray4.length) {
                System.arraycopy(byArray, 0, byArray4, n4, byArray.length);
                System.arraycopy(byArray2, 0, byArray4, n4 += byArray.length, byArray2.length);
                n4 += byArray2.length;
                if (n2 == 0) continue;
                System.arraycopy(byArray3, 0, byArray4, n4, n2);
                n4 += n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = z.a(byteArrayOutputStream, byArray2, 0, 16, byArray2, 16);
            outputStream.write(byArray4);
            outputStream.close();
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            byte[] byArray6 = new byte[16];
            System.arraycopy(byArray5, 0, byArray6, 0, 16);
            int n5 = new BigInteger(1, byArray6).remainder(BigInteger.valueOf(3L)).intValue();
            MessageDigest messageDigest = MessageDigest.getInstance(n5 == 0 ? "SHA-256" : (n5 == 1 ? "SHA-384" : "SHA-512"));
            messageDigest.update(byArray5);
            byArray2 = messageDigest.digest();
            bl = n3 < 64 || n3 - 32 < (byArray5[byArray5.length - 1] & 0xFF);
            ++n3;
        }
        return byArray2;
    }

    private boolean a(byte[] byArray) {
        try {
            InputStream inputStream = new ByteArrayInputStream(this.getStringValue("Perms"));
            inputStream = z.b(inputStream, byArray, 0, 32);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            gc.a(inputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            int n2 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8 | (byArray2[2] & 0xFF) << 16 | (byArray2[3] & 0xFF) << 24;
            boolean bl = (float)n2 == this.getNumericValue("P");
            return bl;
        }
        catch (Exception exception) {
            PDF.k.warning("SE1", "AES Failed (313)", exception);
            return false;
        }
    }

    private byte[] b(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            if (byArray.length > 127) {
                byte[] byArray2 = new byte[127];
                System.arraycopy(byArray, 0, byArray2, 0, 127);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            if (bl) {
                messageDigest.update(byArray3, 40, 8);
                messageDigest.update(byArray2, 0, 48);
            } else {
                messageDigest.update(byArray2, 40, 8);
            }
            byte[] byArray4 = messageDigest.digest();
            if (n2 == 6) {
                byArray4 = this.a(byArray, byArray4, bl ? byArray2 : null);
            }
            byte[] byArray8 = this.getStringValue(bl ? "OE" : "UE");
            InputStream inputStream = new ByteArrayInputStream(byArray8);
            inputStream = z.c(inputStream, byArray4, 0, 32);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            gc.a(inputStream, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            if (byArray[n2 + n5] != byArray2[n2 + n5]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    private byte[] c(String string) {
        byte[] byArray = new byte[32];
        int n2 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            byArray[n2] = (byte)string.charAt(n2);
        }
        while (n2 < 32) {
            byArray[n2] = d[n2 - string.length()];
            ++n2;
        }
        return byArray;
    }

    private byte[] a(String string, String string2) throws IOException, NoSuchAlgorithmException {
        return this.a(this.d(string), string2);
    }

    private byte[] d(String string) throws IOException, NoSuchAlgorithmException {
        byte[] byArray;
        byte[] byArray2 = this.c(string);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray2);
        if (this.k > 2) {
            for (int i2 = 0; i2 < 50; ++i2) {
                byArray = messageDigest.digest();
                messageDigest.reset();
                messageDigest.update(byArray);
            }
        }
        byte[] byArray3 = messageDigest.digest();
        if (byArray3.length == this.i) {
            return byArray3;
        }
        byArray = new byte[this.i];
        System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
        return byArray;
    }

    private byte[] a(byte[] byArray, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ARC4OutputStream aRC4OutputStream = new ARC4OutputStream(byteArrayOutputStream, byArray);
        aRC4OutputStream.write(this.c(string));
        aRC4OutputStream.close();
        if (this.k > 2) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i2 = 1; i2 < 20; ++i2) {
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                for (int i3 = 0; i3 < byArray2.length; ++i3) {
                    byArray2[i3] = (byte)(byArray[i3] ^ (byte)i2);
                }
                aRC4OutputStream = new ARC4OutputStream(byteArrayOutputStream, byArray2);
                aRC4OutputStream.write(byArray3);
                aRC4OutputStream.close();
            }
        }
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private byte[] b(String string, byte[] byArray) throws IOException, NoSuchAlgorithmException {
        byte[] byArray2 = this.a(string, byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ARC4OutputStream aRC4OutputStream = new ARC4OutputStream(byteArrayOutputStream, byArray2);
        aRC4OutputStream.write(d);
        aRC4OutputStream.close();
        byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private byte[] c(String string, byte[] byArray) throws IOException, NoSuchAlgorithmException {
        byte[] byArray2 = this.a(string, byArray);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(d);
        if (this.getFileId() != null) {
            messageDigest.update(this.getFileId());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ARC4OutputStream aRC4OutputStream = new ARC4OutputStream(byteArrayOutputStream, byArray2);
        aRC4OutputStream.write(messageDigest.digest());
        aRC4OutputStream.close();
        byte[] byArray3 = new byte[byArray2.length];
        for (int i2 = 1; i2 < 20; ++i2) {
            byte[] byArray4 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            for (int i3 = 0; i3 < byArray3.length; ++i3) {
                byArray3[i3] = (byte)(byArray2[i3] ^ (byte)i2);
            }
            aRC4OutputStream = new ARC4OutputStream(byteArrayOutputStream, byArray3);
            aRC4OutputStream.write(byArray4);
            aRC4OutputStream.close();
        }
        byArray3 = new byte[32];
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray3, 0, 16);
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(OutputProfile outputProfile) {
        outputProfile.clear(OutputProfile.Feature.NonStandardEncryption);
        outputProfile.set(OutputProfile.Feature.Encryption);
        if (this.getVersion() == 2) {
            outputProfile.set(OutputProfile.Feature.Acrobat5Encryption);
        } else if (this.getVersion() == 4) {
            outputProfile.set(OutputProfile.Feature.Acrobat6Encryption);
        }
        if (!this.b()) return;
        outputProfile.set(OutputProfile.Feature.AESEncryption);
        if (this.k == 5) {
            outputProfile.set(OutputProfile.Feature.WeakAES256Encryption);
            return;
        }
        if (this.k != 6) return;
        outputProfile.set(OutputProfile.Feature.AES256Encryption);
    }
}

