/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.faceless.pdf2.CMap;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFFont;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.kb;
import org.faceless.pdf2.mb;
import org.faceless.pdf2.sc;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.util.SparseArray;

public final class StandardFont
extends PDFFont {
    private static final String[] p = new String[]{"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique", "Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Symbol", "ZapfDingbats"};
    private static final String[] q = new String[]{"TiRo", "TiBo", "TiIt", "TiBI", "Helv", "HeBo", "HeOb", "HeBO", "Cour", "CoBo", "CoOb", "CoBO", "Symb", "ZaDb"};
    public static final int TIMES = 0;
    public static final int TIMESBOLD = 1;
    public static final int TIMESITALIC = 2;
    public static final int TIMESBOLDITALIC = 3;
    public static final int HELVETICA = 4;
    public static final int HELVETICABOLD = 5;
    public static final int HELVETICAOBLIQUE = 6;
    public static final int HELVETICABOLDOBLIQUE = 7;
    public static final int COURIER = 8;
    public static final int COURIERBOLD = 9;
    public static final int COURIEROBLIQUE = 10;
    public static final int COURIERBOLDOBLIQUE = 11;
    public static final int SYMBOL = 12;
    public static final int ZAPFDINGBATS = 13;
    private final int r;
    private static final short[][] s = new short[14][];
    private static final short[][] t = new short[14][];
    private static final short[][] u = new short[14][];
    private static final int[] v;
    private static final byte[] w;
    private static int[] x;
    private static int[] y;
    private static int[] z;
    private static int[] A;
    private static int[] B;
    private static int[] C;
    private static final BitSet D;
    private static int[][] E;
    private static Map[] F;
    private static CMap[] G;
    private static SparseArray[] H;

    public StandardFont(int n2) {
        Map map;
        String[] stringArray;
        String[] stringArray2;
        boolean bl = false;
        if ((n2 & 0xF000) == 61440) {
            bl = true;
            n2 -= 61440;
        }
        this.r = n2;
        this.b("BaseFont", wc.b(p[this.r]));
        this.b("Subtype", wc.b("Type1"));
        String string = null;
        if (this.r == 13) {
            stringArray2 = kb.g;
            stringArray = kb.j;
            map = kb.l;
            bl = false;
        } else if (this.r == 12) {
            stringArray2 = kb.d;
            stringArray = kb.i;
            map = kb.k;
            bl = false;
        } else if (bl) {
            stringArray2 = kb.b;
            stringArray = kb.h;
            map = kb.k;
            string = "WinAnsiEncoding";
        } else {
            stringArray2 = kb.a;
            stringArray = kb.h;
            map = kb.k;
        }
        StandardFont.a(this.r, stringArray2, stringArray, map);
        int[] nArray = E[this.r];
        Map map2 = F[this.r];
        CMap cMap = G[this.r];
        SparseArray sparseArray = H[this.r];
        if (bl) {
            nArray = new int[256];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                String string2 = stringArray2[i2];
                nArray[i2] = string2 == null ? 0 : (Integer)map2.get(string2);
            }
        }
        this.b(mb.a(stringArray2, stringArray, map, nArray, map2, cMap, sparseArray, string));
        this.F();
    }

    private void F() {
        ic ic2 = new ic("FontDescriptor");
        ic2.a();
        ic2.b("FontName", wc.b(p[this.r]));
        ic2.b("Flags", xc.b((this.r < 4 || this.r == 12 ? 2 : 0) | (this.r >= 8 && this.r < 12 ? 1 : 0) | (this.r >= 12 ? 4 : 32) | (this.r < 12 && (this.r & 2) == 2 ? 64 : 0)));
        uc uc2 = new uc(4);
        uc2.c(xc.b(B[this.r * 4]));
        uc2.c(xc.b(B[this.r * 4 + 1]));
        uc2.c(xc.b(B[this.r * 4 + 2]));
        uc2.c(xc.b(B[this.r * 4 + 3]));
        ic2.b("FontBBox", uc2);
        if (this.r == 3) {
            ic2.b("ItalicAngle", xc.a(-15.5f));
        } else {
            ic2.b("ItalicAngle", xc.b(this.r < 12 && (this.r & 2) == 2 ? (this.r == 2 ? -15 : -12) : 0));
        }
        ic2.b("Ascent", xc.b(z[this.r]));
        ic2.b("Descent", xc.b(A[this.r]));
        ic2.b("CapHeight", xc.b(x[this.r]));
        ic2.b("XHeight", xc.b(y[this.r]));
        ic2.b("StemV", xc.b(C[this.r]));
        this.b("FontDescriptor", ic2);
    }

    int G() {
        return this.r;
    }

    public String getBaseName() {
        return p[this.r];
    }

    String y() {
        return q[this.r];
    }

    int getCIDWidth(int n2) {
        return s[this.r][n2];
    }

    sc A() {
        return null;
    }

    int getCIDTop(int n2) {
        return t[this.r][n2];
    }

    int getCIDBottom(int n2) {
        return u[this.r][n2];
    }

    int getCIDKerning(int n2, int n3) {
        if (this.r >= 8 || (n2 | n3) > 65535) {
            return 0;
        }
        int n4 = Arrays.binarySearch(v, (n2 << 16) + n3);
        if (n4 >= 0) {
            byte by = w[n4 * 8 + this.r];
            return by == 127 ? 92 : by - 64;
        }
        return 0;
    }

    public float getDefaultLeading() {
        return 1.2f;
    }

    public float getStrikeoutThickness() {
        return 0.05f;
    }

    public float getStrikeoutPosition() {
        return 0.26f;
    }

    public float getSubscriptSize() {
        return 0.7f;
    }

    public float getSuperscriptPosition() {
        return 0.7f;
    }

    public float getSubscriptPosition() {
        return -0.22f;
    }

    public float getUnderlineThickness() {
        return 0.05f;
    }

    public float getUnderlinePosition() {
        return -0.1f;
    }

    public float getAscender() {
        return (float)z[this.r] / 1000.0f;
    }

    public float getDescender() {
        return (float)A[this.r] / 1000.0f;
    }

    public float getXHeight() {
        return (float)y[this.r] / 1000.0f;
    }

    boolean w() {
        return false;
    }

    boolean t() {
        return this.r < 12 && (this.r & 2) == 2;
    }

    boolean u() {
        return this.r < 12 && (this.r & 1) == 1;
    }

    boolean v() {
        return this.r < 4 || this.r > 7;
    }

    public boolean isMonospace() {
        return this.r == 8 || this.r == 9 || this.r == 10 || this.r == 11;
    }

    public PDFFont versionItalic() {
        int n2 = this.r;
        if (n2 < 12) {
            n2 |= 2;
        }
        return n2 == this.r ? this : new StandardFont(n2);
    }

    public PDFFont versionBold() {
        int n2 = this.r;
        if (n2 < 12) {
            n2 |= 1;
        }
        return n2 == this.r ? this : new StandardFont(n2);
    }

    public PDFFont versionNonItalic() {
        int n2 = this.r;
        if (n2 < 12) {
            n2 &= 0xFFFFFFFD;
        }
        return n2 == this.r ? this : new StandardFont(n2);
    }

    public PDFFont versionNonBold() {
        int n2 = this.r;
        if (n2 < 12) {
            n2 &= 0xFFFFFFFE;
        }
        return n2 == this.r ? this : new StandardFont(n2);
    }

    public PDFFont versionRegular() {
        int n2 = this.r;
        if (n2 < 12) {
            n2 &= 0xC;
        }
        return n2 == this.r ? this : new StandardFont(n2);
    }

    PDFFont z() {
        StandardFont standardFont = new StandardFont(this.r);
        if (this.r != 12 && this.r != 13) {
            standardFont.b(mb.r);
        }
        return standardFont;
    }

    boolean x() {
        return true;
    }

    static StandardFont s(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = 0; n2 < p.length; ++n2) {
            if (!p[n2].equals(string) && !q[n2].equals(string)) continue;
            return new StandardFont(n2);
        }
        n2 = 0;
        if (string.endsWith(",Bold") || string.endsWith("-Bold")) {
            n2 = 1;
            string = string.substring(0, string.length() - 5);
        } else if (string.endsWith(",Italic") || string.endsWith("-Italic")) {
            n2 = 2;
            string = string.substring(0, string.length() - 7);
        } else if (string.endsWith(",Oblique") || string.endsWith("-Oblique")) {
            n2 = 2;
            string = string.substring(0, string.length() - 8);
        } else if (string.endsWith(",BoldItalic") || string.endsWith("-BoldItalic")) {
            n2 = 3;
            string = string.substring(0, string.length() - 12);
        } else if (string.endsWith(",BoldOblique") || string.endsWith("-BoldOblique")) {
            n2 = 3;
            string = string.substring(0, string.length() - 12);
        }
        if (string.equals("Arial") || string.equals("Helvetica") || string.equals("ArialMT")) {
            return new StandardFont(4 + n2);
        }
        if (string.equals("Times-Roman") || string.equals("TimesNewRoman") || string.equals("TimesNewRomanPS") || string.equals("TimesNewRomanPSMT")) {
            return new StandardFont(0 + n2);
        }
        if (string.equals("Courier") || string.equals("CourierNew") || string.equals("CourierNewPSMT")) {
            return new StandardFont(8 + n2);
        }
        return null;
    }

    private static synchronized void a(int n2, String[] stringArray, String[] stringArray2, Map map) {
        if (E[n2] == null) {
            StandardFont.E[n2] = new int[256];
            StandardFont.F[n2] = new HashMap();
            StandardFont.G[n2] = new CMap();
            StandardFont.H[n2] = new SparseArray();
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                int n3;
                String string = stringArray2[i2];
                if (string == null) continue;
                F[n2].put(string, new Integer(i2));
                String string2 = (String)map.get(string);
                if (string2 != null) {
                    G[n2].setUnicode(i2, string2);
                    if (string2.length() == 1 && H[n2].get(n3 = (int)string2.charAt(0)) == null) {
                        H[n2].put(n3, new Integer(i2));
                        if (n3 == 32) {
                            H[n2].put(160L, new Integer(i2));
                        }
                    }
                }
                for (n3 = 0; n3 < 256; ++n3) {
                    if (!string.equals(stringArray[n3])) continue;
                    StandardFont.E[n2][n3] = i2;
                }
            }
            if (n2 == 12) {
                H[12].put(916L, H[12].get(8710L));
                H[12].put(937L, H[12].get(8486L));
                H[12].put(956L, H[12].get(181L));
                H[12].put(8968L, H[12].get(9121L));
                H[12].put(8969L, H[12].get(9124L));
                H[12].put(8970L, H[12].get(9123L));
                H[12].put(8971L, H[12].get(9126L));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        x = new int[]{662, 676, 653, 669, 718, 718, 718, 718, 562, 562, 562, 562, 700, 700};
        y = new int[]{450, 461, 441, 462, 523, 523, 523, 523, 426, 426, 426, 426, 350, 350};
        z = new int[]{683, 683, 683, 683, 718, 718, 718, 718, 629, 629, 629, 629, 700, 700};
        A = new int[]{-217, -217, -217, -217, -207, -207, -207, -207, -157, -157, -157, -157, -200, -200};
        B = new int[]{-168, -218, 1000, 898, -168, -218, 1000, 935, -169, -217, 1010, 883, -200, -218, 996, 921, -166, -225, 1000, 931, -170, -228, 1003, 962, -170, -225, 1116, 931, -174, -228, 1114, 962, -23, -250, 715, 805, -113, -250, 749, 801, -27, -250, 849, 805, -57, -250, 869, 801, -180, -293, 1090, 1010, -1, -143, 981, 820};
        C = new int[]{84, 139, 76, 121, 88, 140, 88, 140, 51, 106, 51, 106, 85, 90};
        int[] nArray = new int[]{151, 152, 153, 163, 165, 167, 169, 172, 173, 176, 178, 179, 181, 183, 185, 186, 187, 190, 191, 193, 195, 196, 197, 198, 199, 200, 204, 207, 208, 210, 215, 216, 217, 218, 223, 224, 225, 227, 228, 229, 231, 235, 236, 237, 241, 242, 245, 246, 250, 256, 257, 258, 260, 261, 263, 265, 267, 268, 270, 273, 275, 276, 280, 283, 285, 286, 293, 296, 297, 298, 302, 303, 307, 308, 313};
        InputStream inputStream = PDF.class.getResourceAsStream("resources/StandardFontMetrics.dat");
        try {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                for (int i2 = 0; i2 < 14; ++i2) {
                    StandardFont.s[i2] = (short[])objectInputStream.readObject();
                    StandardFont.t[i2] = (short[])objectInputStream.readObject();
                    StandardFont.u[i2] = (short[])objectInputStream.readObject();
                }
                v = (int[])objectInputStream.readObject();
                w = (byte[])objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw gc.a("Can't load font metrics", exception);
            }
            Object var5_6 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        D = new BitSet();
        int i3 = 0;
        while (true) {
            if (i3 >= nArray.length) {
                E = new int[14][];
                F = new Map[14];
                G = new CMap[14];
                H = new SparseArray[14];
                return;
            }
            D.set(nArray[i3]);
            ++i3;
        }
    }
}

