/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.faceless.pdf2.AnnotationLink;
import org.faceless.pdf2.AnnotationMarkup;
import org.faceless.pdf2.AnnotationNote;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PagePainter;
import org.faceless.pdf2.viewer.DefaultEventHandler;
import org.faceless.pdf2.viewer.EventHandler;
import org.faceless.pdf2.viewer.PDFKeyEvent;
import org.faceless.pdf2.viewer.PDFMouseEvent;
import org.faceless.pdf2.viewer.PDFNavigationEvent;
import org.faceless.pdf2.viewer.SwingWorker;
import org.faceless.pdf2.viewer.b;

public class PDFViewport
extends JPanel
implements MouseMotionListener,
MouseListener,
KeyListener {
    private PDF a;
    private PDFParser b;
    private PagePainter[] c;
    private BufferedImage d;
    private BufferedImage e;
    private boolean f;
    private float g;
    private float h;
    private float i;
    private float j;
    private float k;
    private int l;
    private float m;
    private float n;
    private float o;
    private float p;
    private final Collection q;
    private a_ r;
    private RenderingHints s;
    private EventHandler t;
    private final Map u;
    private static final ColorModel v = ColorModel.getRGBdefault();

    protected PDFViewport() {
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setBackground(Color.GRAY);
        this.setDoubleBuffered(true);
        this.q = new ArrayList();
        this.l = -1;
        this.g = 72.0f;
        this.u = new HashMap();
        this.setEventHandler(new DefaultEventHandler());
    }

    private boolean a() {
        boolean bl = this.m * this.n * this.g / 72.0f <= 2250000.0f;
        return bl;
    }

    private static final float a(double d2, double d3, double d4) {
        double d5;
        block8: {
            block7: {
                if (d2 > d4) {
                    throw new IllegalArgumentException("min>max");
                }
                if (!(d3 < d2)) break block7;
                d5 = d2;
                break block8;
            }
            d5 = d3 > d4 ? d4 : d3;
        }
        return (float)d5;
    }

    final float b() {
        return (float)this.getWidth() * 72.0f / this.g;
    }

    final float c() {
        return (float)this.getHeight() * 72.0f / this.g;
    }

    public final double getMaxScrollX() {
        return Math.max(this.m - this.b(), 0.0f);
    }

    public final double getMaxScrollY() {
        return Math.max(this.n - this.c(), 0.0f);
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.s = renderingHints;
    }

    public final void setDocument(PDF pDF) {
        block7: {
            block6: {
                this.e = null;
                this.d = null;
                this.a = pDF;
                if (pDF != null) break block6;
                this.b = null;
                this.c = null;
                break block7;
            }
            this.b = new PDFParser(this.a);
            this.c = new PagePainter[this.b.getNumberOfPages()];
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                this.c[i2] = this.b.getPagePainter(i2);
                this.c[i2].setRenderingHints(this.s);
            }
            PDFAction pDFAction = pDF.getAction(Event.OPEN);
            if (pDFAction == null) {
                PDFPage pDFPage = pDF.getPage(0);
                pDFAction = PDFAction.goTo(pDFPage, 0.0f, pDFPage.getHeight(), 1.0f);
            }
            this.runAction(pDFAction);
        }
    }

    public void setPageNumber(int n2) {
        this.setPageNumber(n2, 0.0, 0.0, 0.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPageNumber(int n2, double d2, double d3, double d4) {
        Object object;
        if (this.a == null) {
            throw new NullPointerException("Document is null");
        }
        if (d4 == d4 && d4 < 0.0) {
            throw new IllegalArgumentException("DPI must be > 0");
        }
        if (n2 != this.l) {
            if (this.t != null && this.l != -1) {
                object = this.a.getPage(this.l);
                this.t.pageHidden(new PDFNavigationEvent(this, (PDFPage)object));
                this.b((PDFPage)object);
            }
            object = this.a.getPage(n2);
            float[] fArray = ((PDFPage)object).getBox("MediaBox");
            float[] fArray2 = ((PDFPage)object).getBox("CropBox");
            if (fArray2 == null) {
                fArray2 = fArray;
            }
            this.o = fArray2[0];
            this.p = fArray2[1];
            this.m = fArray2[2] - fArray2[0];
            this.n = fArray2[3] - fArray2[1];
            this.l = n2;
            ((PDFPage)object).flush();
            this.f = true;
            if (this.t != null) {
                this.a((PDFPage)object);
                this.t.pageDisplayed(new PDFNavigationEvent(this, (PDFPage)object));
            }
        }
        if (d4 == d4 && d4 != 0.0 && d4 != (double)this.g) {
            this.g = (float)d4;
            this.f = true;
        }
        if (d2 == d2 && d2 != (double)this.h || d3 == d3 && d3 != (double)this.i || this.f) {
            this.setViewPosition(d2, d3);
            this.f = true;
        }
        if (this.f) {
            object = this.q.iterator();
            while (object.hasNext()) {
                ((ViewportObserver)object.next()).viewportChanged(this.h, this.i);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setViewPosition(double d2, double d3) {
        if (this.a == null) {
            throw new NullPointerException("Document is null");
        }
        if (d2 == d2) {
            this.h = this.b() < this.m ? PDFViewport.a(0.0, d2, this.getMaxScrollX()) : 0.0f;
            this.j = Math.min(this.h + this.b(), this.m);
        }
        if (d3 == d3) {
            this.i = this.c() < this.n ? PDFViewport.a(0.0, d3, this.getMaxScrollY()) : 0.0f;
            this.k = Math.min(this.i + this.c(), this.n);
        }
        if (this.j - this.h == 0.0f) return;
        if (this.k - this.i == 0.0f) return;
        if (this.r == null) {
            this.r = new a_(this.l, this.h, this.i, this.j, this.k, this.g, this.n);
            this.r.start();
            return;
        }
        if (this.r.f == this.h && this.r.g == this.i && this.r.h == this.j && this.r.i == this.k && this.r.e == this.g) {
            if (this.r.d == this.l) return;
        }
        if (this.r.a()) return;
        this.r.interrupt();
    }

    public void setDPI(double d2) {
        this.setPageNumber(this.l, this.h, this.i, d2);
    }

    public void setViewPosition(double d2, double d3, double d4) {
        this.setPageNumber(this.l, d2, d3, d4);
    }

    public int getPageNumber() {
        return this.l;
    }

    public Point2D getViewPosition() {
        return new Point2D.Double(this.h, this.i);
    }

    public double getDPI() {
        return this.g;
    }

    int d() {
        return (int)this.m;
    }

    int e() {
        return (int)this.n;
    }

    public void writeAsTIFF(OutputStream outputStream, int n2, ColorModel colorModel) {
        if (this.a == null) {
            throw new NullPointerException("Document is null");
        }
        final OutputStream outputStream2 = outputStream;
        final int n3 = n2;
        final ColorModel colorModel2 = colorModel;
        new Thread(){

            public void run() {
                try {
                    PDFViewport.this.b.writeAsTIFF(outputStream2, n3, colorModel2);
                    outputStream2.close();
                }
                catch (IOException iOException) {
                    org.faceless.pdf2.viewer.b.a(iOException, "TIFF Export Error", PDFViewport.this);
                }
                Iterator iterator = PDFViewport.this.q.iterator();
                while (iterator.hasNext()) {
                    ((ViewportObserver)iterator.next()).writeAsTIFFComplete();
                }
            }
        }.start();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.GRAY);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.d != null) {
            int n2 = this.d.getWidth(this);
            int n3 = this.d.getHeight(this);
            int n4 = n2 < this.getWidth() ? (this.getWidth() - n2) / 2 : 0;
            int n5 = n4;
            int n6 = n3 < this.getHeight() ? (this.getHeight() - n3) / 2 : 0;
            int n7 = n6;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n5 + 3, n7 + 3, n2, n3);
            Shape shape = graphics.getClip();
            graphics.clipRect(n5, n7, n2, n3);
            graphics.drawImage(this.d, n5, n7, this);
            AffineTransform affineTransform = ((Graphics2D)graphics).getTransform();
            AffineTransform affineTransform2 = new AffineTransform(this.g / 72.0f, 0.0f, 0.0f, -this.g / 72.0f, -this.h * this.g / 72.0f + (float)n5, (this.n - this.i) * this.g / 72.0f + (float)n7);
            ((Graphics2D)graphics).transform(affineTransform2);
            this.annotateComponent((Graphics2D)graphics);
            ((Graphics2D)graphics).setTransform(affineTransform);
            graphics.setClip(shape);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n5, n7, n2, n3);
        }
    }

    protected void annotateComponent(Graphics2D graphics2D) {
    }

    public void addObserver(ViewportObserver viewportObserver) {
        this.q.add(viewportObserver);
    }

    public void removeObserver(ViewportObserver viewportObserver) {
        this.q.remove(viewportObserver);
    }

    public void print() {
        if (this.a == null) {
            throw new NullPointerException("Document is null");
        }
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, null);
        if (printServiceArray.length > 0) {
            try {
                PrinterJob printerJob;
                block13: {
                    block12: {
                        printerJob = PrinterJob.getPrinterJob();
                        printerJob.setPageable(this.b);
                        if (this.a.getInfo("Title") == null) break block12;
                        printerJob.setJobName(this.a.getInfo("Title"));
                        break block13;
                    }
                    printerJob.setJobName("BFO PDF");
                }
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "No printers are installed", "Print Warning", 2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEventHandler(EventHandler eventHandler) {
        boolean bl;
        boolean bl3;
        boolean bl5;
        boolean bl2;
        boolean bl4;
        boolean bl6;
        if (eventHandler != null && eventHandler.getViewport() != null && eventHandler.getViewport() != this) {
            throw new IllegalStateException("EventHandler already registered with a viewport");
        }
        boolean bl7 = this.t == null ? false : (bl6 = (this.t.a() & 1) != 0);
        boolean bl8 = this.t == null ? false : (bl4 = (this.t.a() & 2) != 0);
        boolean bl9 = this.t == null ? false : (bl2 = (this.t.a() & 4) != 0);
        boolean bl10 = eventHandler == null ? false : (bl5 = (eventHandler.a() & 1) != 0);
        boolean bl11 = eventHandler == null ? false : (bl3 = (eventHandler.a() & 2) != 0);
        boolean bl12 = eventHandler == null ? false : (bl = (eventHandler.a() & 4) != 0);
        if (bl5 && !bl6) {
            this.addMouseListener(this);
        } else if (!bl5 && bl6) {
            this.removeMouseListener(this);
        }
        if (bl3 && !bl4) {
            this.addMouseMotionListener(this);
        } else if (!bl3 && bl4) {
            this.removeMouseMotionListener(this);
        }
        if (bl && !bl2) {
            this.addKeyListener(this);
        } else if (!bl && bl2) {
            this.removeKeyListener(this);
        }
        if (this.t != null) {
            this.t.a(null);
        }
        this.t = eventHandler;
        if (this.t == null) return;
        this.t.a(this);
        if (this.l == -1) return;
        this.t.pageDisplayed(new PDFNavigationEvent(this, this.a.getPage(this.l)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runAction(PDFAction pDFAction) {
        boolean bl = false;
        while (pDFAction != null) {
            float[] fArray;
            bl = true;
            PDFPage pDFPage = null;
            float f4 = Float.NaN;
            float f3 = Float.NaN;
            float f2 = 0.0f;
            String string = pDFAction.getType();
            if (string.equals("GoToFit")) {
                pDFPage = pDFAction.getPage();
                f2 = Math.min((float)this.getWidth() / (float)pDFPage.getWidth(), (float)this.getHeight() / (float)pDFPage.getHeight());
            } else if (string.equals("GoTo")) {
                pDFPage = pDFAction.getPage();
                fArray = pDFAction.getGoToCoordinates();
                f4 = fArray[0];
                f3 = fArray[1];
                f2 = fArray[2];
            } else if (string.equals("GoToFitWidth")) {
                pDFPage = pDFAction.getPage();
                fArray = pDFAction.getGoToCoordinates();
                f2 = (float)this.getWidth() / (float)pDFPage.getWidth();
                f3 = fArray[0];
            } else if (string.equals("GoToFitHeight")) {
                pDFPage = pDFAction.getPage();
                fArray = pDFAction.getGoToCoordinates();
                f2 = (float)this.getHeight() / (float)pDFPage.getHeight();
                f4 = fArray[0];
            } else if (string.equals("GoToFitRectangle")) {
                pDFPage = pDFAction.getPage();
                fArray = pDFAction.getGoToCoordinates();
                f4 = Math.min(fArray[0], fArray[2]);
                f3 = Math.min(fArray[1], fArray[3]);
                f2 = Math.min((float)this.getWidth() / Math.abs(fArray[2] - fArray[0]), (float)this.getHeight() / Math.abs(fArray[3] - fArray[1]));
            } else if (string.equals("Named:NextPage")) {
                if (this.l < this.a.getNumberOfPages() - 2) {
                    pDFPage = this.a.getPage(this.l + 1);
                }
            } else if (string.equals("Named:PrevPage")) {
                if (this.l > 0) {
                    pDFPage = this.a.getPage(this.l - 1);
                }
            } else if (string.equals("Named:FirstPage")) {
                pDFPage = this.a.getPage(0);
            } else if (string.equals("Named:LastPage")) {
                pDFPage = this.a.getPage(this.a.getNumberOfPages() - 1);
            } else if (string.equals("Named:Print")) {
                this.print();
            } else {
                bl = false;
            }
            if (pDFPage != null) {
                if (!this.a.getPages().contains(pDFPage)) {
                    throw new IllegalArgumentException("Action refers to a page from another PDF");
                }
                this.setPageNumber(pDFPage.getPageNumber() - 1, f4, (float)pDFPage.getHeight() - f3, f2 * 72.0f);
            }
            pDFAction = pDFAction.getNext();
        }
        return bl;
    }

    PDFAnnotation a(PDFMouseEvent pDFMouseEvent) {
        PDFPage pDFPage = pDFMouseEvent.getPage();
        Map map = (Map)this.u.get(pDFPage);
        if (map != null) {
            Point2D point2D = pDFMouseEvent.getPagePoint();
            for (Map.Entry entry : map.entrySet()) {
                Shape shape = (Shape)entry.getKey();
                if (!shape.contains(point2D)) continue;
                return (PDFAnnotation)entry.getValue();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(PDFPage pDFPage) {
        HashMap<Rectangle2D.Float, PDFAnnotation> hashMap = (HashMap<Rectangle2D.Float, PDFAnnotation>)this.u.get(pDFPage);
        if (hashMap == null) {
            hashMap = new HashMap<Rectangle2D.Float, PDFAnnotation>();
            this.u.put(pDFPage, hashMap);
        }
        Iterator iterator = pDFPage.getAnnotations().iterator();
        while (iterator.hasNext()) {
            PDFAnnotation pDFAnnotation = (PDFAnnotation)iterator.next();
            Shape shape = null;
            if (!(pDFAnnotation instanceof AnnotationMarkup) && !pDFAnnotation.getType().equals("Popup")) {
                float[] fArray;
                if (pDFAnnotation instanceof AnnotationLink && (fArray = ((AnnotationLink)pDFAnnotation).getCorners()) != null) {
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(fArray[0], fArray[1]);
                    generalPath.lineTo(fArray[2], fArray[3]);
                    generalPath.lineTo(fArray[4], fArray[5]);
                    generalPath.lineTo(fArray[6], fArray[7]);
                    generalPath.closePath();
                    shape = generalPath;
                }
                if (pDFAnnotation instanceof AnnotationNote && !((AnnotationNote)pDFAnnotation).isOpen()) {
                    fArray = pDFAnnotation.getRectangle();
                    shape = new Rectangle2D.Float(fArray[0], fArray[1], 20.0f, 20.0f);
                }
                if (shape == null) {
                    fArray = pDFAnnotation.getRectangle();
                    shape = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2] - fArray[0], fArray[3] - fArray[1]);
                }
            }
            if (shape == null) continue;
            hashMap.put((Rectangle2D.Float)shape, pDFAnnotation);
        }
        return;
    }

    private void b(PDFPage pDFPage) {
        this.u.remove(pDFPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PDFMouseEvent a(MouseEvent mouseEvent) {
        int n4 = this.d == null ? 0 : (this.d.getWidth(this) < this.getWidth() ? (this.getWidth() - this.d.getWidth(this)) / 2 : 0);
        float f3 = (float)((double)(mouseEvent.getX() - n4) / this.getDPI() * 72.0 + (double)this.h);
        int n5 = this.d == null ? 0 : (this.d.getHeight(this) < this.getHeight() ? (this.getHeight() - this.d.getHeight(this)) / 2 : 0);
        float f2 = (float)((double)(this.n - this.i) - (double)(mouseEvent.getY() - n5) / this.getDPI() * 72.0);
        if (f3 >= 0.0f && f3 <= this.m && f2 >= 0.0f && f2 <= this.n) {
            PDFPage pDFPage = this.a.getPage(this.l);
            return new PDFMouseEvent(mouseEvent, this, pDFPage, f3, f2);
        }
        return null;
    }

    private PDFKeyEvent a(KeyEvent keyEvent) {
        return new PDFKeyEvent(keyEvent, this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        PDFMouseEvent pDFMouseEvent = this.a(mouseEvent);
        if (pDFMouseEvent != null) {
            this.t.mousePressed(pDFMouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        PDFMouseEvent pDFMouseEvent = this.a(mouseEvent);
        if (pDFMouseEvent != null) {
            this.t.mouseReleased(pDFMouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        PDFMouseEvent pDFMouseEvent = this.a(mouseEvent);
        if (pDFMouseEvent != null) {
            this.t.mouseMoved(pDFMouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        PDFMouseEvent pDFMouseEvent = this.a(mouseEvent);
        if (pDFMouseEvent != null) {
            this.t.mouseDragged(pDFMouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        PDFMouseEvent pDFMouseEvent = this.a(mouseEvent);
        if (pDFMouseEvent != null) {
            this.t.mouseClicked(pDFMouseEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        PDFKeyEvent pDFKeyEvent = this.a(keyEvent);
        if (pDFKeyEvent != null) {
            this.t.keyPressed(pDFKeyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        PDFKeyEvent pDFKeyEvent = this.a(keyEvent);
        if (pDFKeyEvent != null) {
            this.t.keyReleased(pDFKeyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        PDFKeyEvent pDFKeyEvent = this.a(keyEvent);
        if (pDFKeyEvent != null) {
            this.t.keyTyped(pDFKeyEvent);
        }
    }

    public static interface ViewportObserver {
        public void viewportChanged(double var1, double var3);

        public void writeAsTIFFComplete();
    }

    class a_
    extends SwingWorker {
        private boolean c;
        final int d;
        final float e;
        final float f;
        final float g;
        final float h;
        final float i;
        final float j;

        a_(int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
            this.j = f7;
            this.d = n2;
            this.e = f6;
            this.f = f2;
            this.h = f4;
            this.g = f3;
            this.i = f5;
        }

        public Object construct() {
            block7: {
                try {
                    if (!PDFViewport.this.a()) {
                        PDFViewport.this.d = PDFViewport.this.c[this.d].getSubImage(PDFViewport.this.o + this.f, PDFViewport.this.p + this.j - this.i, PDFViewport.this.o + this.h, PDFViewport.this.p + this.j - this.g, this.e, v);
                        break block7;
                    }
                    if (PDFViewport.this.f) {
                        PDFViewport.this.e = PDFViewport.this.c[this.d].getSubImage(PDFViewport.this.o, PDFViewport.this.p, PDFViewport.this.o + PDFViewport.this.m, PDFViewport.this.p + this.j, this.e, v);
                    }
                    if (PDFViewport.this.e != null) {
                        float f2 = this.f * this.e / 72.0f;
                        float f3 = this.g * this.e / 72.0f;
                        float f4 = (float)PDFViewport.this.e.getWidth() - f2;
                        float f5 = (float)PDFViewport.this.e.getHeight() - f3;
                        PDFViewport.this.d = PDFViewport.this.e.getSubimage((int)f2, (int)f3, (int)f4, (int)f5);
                    }
                }
                catch (Exception exception) {
                    PDFViewport.this.e = null;
                    PDFViewport.this.d = null;
                    org.faceless.pdf2.viewer.b.a(exception, "Page Painter Error", PDFViewport.this);
                }
            }
            return null;
        }

        public void finished() {
            if (PDFViewport.this.r.a()) {
                PDFViewport.this.r = null;
                PDFViewport.this.setViewPosition(PDFViewport.this.h, PDFViewport.this.i);
            } else {
                PDFViewport.this.r = null;
                PDFViewport.this.f = false;
                PDFViewport.this.repaint();
            }
        }

        public void interrupt() {
            this.c = true;
            PDFViewport.this.c[this.d].interrupt();
        }

        boolean a() {
            return this.c;
        }
    }
}

