/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.awt.Adjustable;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PropertyManager;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.PagePanelInteractionListener;
import org.faceless.pdf2.viewer2.PagePanelListener;
import org.faceless.pdf2.viewer2.Util;

public abstract class DocumentViewport
extends JPanel
implements PropertyChangeListener {
    protected static final Cursor CURSOR_GRAB;
    protected static final Cursor CURSOR_GRABBING;
    protected int mouseWheelUnit;
    private int a;
    private int b;
    private volatile Thread c;
    private DocumentPanel d;
    private int e;
    public static final int ZOOM_NONE = 0;
    public static final int ZOOM_FIT = 1;
    public static final int ZOOM_FITWIDTH = 2;
    public static final int ZOOM_FITHEIGHT = 3;

    public DocumentViewport() {
    }

    public DocumentViewport(LayoutManager layoutManager) {
        super(layoutManager);
    }

    protected final RenderingHints getDefaultRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return renderingHints;
    }

    public abstract void setRenderingHints(RenderingHints var1);

    public void setZoomMode(int n2) {
        this.e = n2;
    }

    public int getZoomMode() {
        return this.e;
    }

    public float getTargetZoom(int n2, PDFPage pDFPage) {
        float f2;
        block9: {
            f2 = this.getZoom();
            if (n2 == 0 || pDFPage == null) break block9;
            Rectangle2D rectangle2D = PagePanel.getFullPageView(pDFPage);
            Dimension dimension = this.getViewportSize();
            double d2 = dimension.getWidth() - 4.0;
            double d3 = dimension.getHeight() - 4.0;
            JPanel jPanel = this.d == null ? this : this.d;
            int n3 = Util.getScreenResolution(jPanel);
            if (n2 == 1) {
                f2 = (float)Math.min(d2 / rectangle2D.getWidth(), d3 / rectangle2D.getHeight()) / (float)n3 * 72.0f;
            } else if (n2 == 2) {
                f2 = (float)(d2 / rectangle2D.getWidth() / (double)n3 * 72.0);
            } else if (n2 == 3) {
                f2 = (float)(d3 / rectangle2D.getWidth() / (double)n3 * 72.0);
            }
        }
        return f2;
    }

    public abstract void setPage(PDFPage var1, double var2, double var4, double var6);

    public void ensureVisible(PDFPage pDFPage, double d2, double d3) {
    }

    public boolean isPageVisible(PDFPage pDFPage, double d2, double d3) {
        return false;
    }

    public abstract void setZoom(float var1);

    public abstract float getZoom();

    public abstract PagePanel getPagePanel();

    public abstract JComponent getView();

    public Collection getPagePanels() {
        return Collections.singleton(this.getPagePanel());
    }

    public PDFPage getPage() {
        PagePanel pagePanel = this.getPagePanel();
        PDFPage pDFPage = pagePanel == null ? null : pagePanel.getPage();
        return pDFPage;
    }

    public abstract PDFPage getRenderingPage();

    public abstract Dimension getViewportSize();

    public abstract Adjustable getAdjustable(int var1);

    public abstract void setAdjustableValues(int var1, int var2);

    public DocumentPanel getDocumentPanel() {
        return this.d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDocumentPanel(DocumentPanel documentPanel) {
        this.d = documentPanel;
        if (documentPanel == null) return;
        this.setLocale(documentPanel.getLocale());
        this.mouseWheelUnit = 16;
        this.b = 500;
        this.a = 500;
        PropertyManager propertyManager = documentPanel.getViewer() == null ? PDF.getPropertyManager() : documentPanel.getViewer().getPropertyManager();
        if (propertyManager == null) return;
        String string = propertyManager.getProperty("mouseWheelUnit");
        if (string != null) {
            try {
                this.mouseWheelUnit = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = propertyManager.getProperty("smoothScrollTime")) != null) {
            try {
                this.a = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = propertyManager.getProperty("smoothScrollDistance")) == null) return;
        try {
            this.b = Integer.parseInt(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public abstract void addPagePanelListener(PagePanelListener var1);

    public abstract void removePagePanelListener(PagePanelListener var1);

    public abstract void addPagePanelInteractionListener(PagePanelInteractionListener var1);

    public abstract void removePagePanelInteractionListener(PagePanelInteractionListener var1);

    public abstract boolean isDraggable();

    public abstract void setDraggable(boolean var1);

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void smoothScroll(int n2, int n3, final JScrollBar jScrollBar, final JScrollBar jScrollBar2) {
        if (jScrollBar == null || jScrollBar2 == null || this.a == 0 || this.b == 0) {
            this.c = null;
            return;
        }
        final int n4 = jScrollBar.getValue();
        final int n5 = jScrollBar2.getValue();
        final int n6 = Math.max(jScrollBar.getMinimum(), Math.min(jScrollBar.getMaximum(), n2));
        final int n7 = Math.max(jScrollBar2.getMinimum(), Math.min(jScrollBar2.getMaximum(), n3));
        if (Math.abs(n6 - n4) <= this.b && Math.abs(n7 - n5) <= this.b) {
            final long l2 = System.currentTimeMillis();
            this.c = new Thread(){

                public void run() {
                    double d2 = 0.0;
                    final 1 var5_2 = this;
                    while (true) {
                        if (!(d2 < 1.5707963267948966) || DocumentViewport.this.c != var5_2) break;
                        d2 = (double)(System.currentTimeMillis() - l2) * 1.5707963267948966 / (double)DocumentViewport.this.a;
                        final int n2 = n4 + (int)Math.round((double)(n6 - n4) * Math.sin(Math.min(d2, 1.5707963267948966)));
                        final int n3 = n5 + (int)Math.round((double)(n7 - n5) * Math.sin(Math.min(d2, 1.5707963267948966)));
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    if (n2 == n6 && n3 == n7) {
                                        jScrollBar2.setValueIsAdjusting(n2 != n6);
                                        jScrollBar.setValueIsAdjusting(n3 != n7);
                                        if (DocumentViewport.this.c == var5_2) {
                                            DocumentViewport.this.c = null;
                                        }
                                    }
                                    jScrollBar.setValue(n2);
                                    jScrollBar2.setValue(n3);
                                }
                            });
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            this.c.start();
            return;
        }
        this.c = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jScrollBar.setValue(n6);
                jScrollBar2.setValue(n7);
            }
        });
    }

    protected boolean isSmoothScrolling() {
        boolean bl = this.c != null;
        return bl;
    }

    static {
        Image image;
        Toolkit toolkit;
        block5: {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            Dimension dimension;
            block4: {
                toolkit = Toolkit.getDefaultToolkit();
                dimension = toolkit.getBestCursorSize(16, 16);
                image = new ImageIcon(PDFViewer.class.getResource("resources/cursor_grab.png")).getImage();
                if ((double)image.getWidth(null) == dimension.getWidth() && (double)image.getHeight(null) == dimension.getHeight()) break block4;
                bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 2);
                graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                image = bufferedImage;
            }
            CURSOR_GRAB = toolkit.createCustomCursor(image, new Point(8, 8), "Grab");
            image = new ImageIcon(PDFViewer.class.getResource("resources/cursor_grabbing.png")).getImage();
            if ((double)image.getWidth(null) == dimension.getWidth() && (double)image.getHeight(null) == dimension.getHeight()) break block5;
            bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            image = bufferedImage;
        }
        CURSOR_GRABBING = toolkit.createCustomCursor(image, new Point(8, 8), "Grabbing");
    }
}

