/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.faceless.pdf2.FDF;
import org.faceless.pdf2.Form;
import org.faceless.pdf2.FormCheckbox;
import org.faceless.pdf2.FormChoice;
import org.faceless.pdf2.FormRadioButton;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.FormText;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFImage;
import org.faceless.pdf2.PDFImageSet;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PDFReader;
import org.faceless.pdf2.PKCS7SignatureHandler;
import org.faceless.pdf2.PagePainter;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.AppleSupport;
import org.xml.sax.SAXException;

public class PDFTool {
    static String a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        try {
            if (System.getProperty("os.name").startsWith("Mac OS X") && System.getProperty("com.apple.mrj.application.apple.menu.about.name") == null) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "BFO PDF Viewer");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PDFTool.setLicense();
        PDF pDF = null;
        OutputStream outputStream = System.out;
        OutputProfile outputProfile = null;
        try {
            ListIterator<String> listIterator = Arrays.asList(stringArray).listIterator();
            while (listIterator.hasNext()) {
                int n2;
                String string = listIterator.next();
                if (string.equals("--join")) {
                    pDF = PDFTool.a(listIterator, pDF);
                    continue;
                }
                if (string.startsWith("--output=")) {
                    outputStream = new FileOutputStream(string.substring(9));
                    continue;
                }
                if (string.startsWith("--profile=")) {
                    string = string.substring(10);
                    outputProfile = new OutputProfile(OutputProfile.Default);
                    n2 = 0;
                } else {
                    if (string.equals("--form")) {
                        pDF = PDFTool.b(listIterator, pDF);
                        continue;
                    }
                    if (string.equals("--view")) {
                        PDFTool.a(listIterator, pDF, a);
                        pDF = null;
                        if (!listIterator.hasNext()) continue;
                        throw new IllegalArgumentException("--view must be the last action");
                    }
                    if (string.equals("--sign")) {
                        pDF = PDFTool.c(listIterator, pDF);
                        continue;
                    }
                    if (string.equals("--version")) {
                        PDFTool.a();
                        System.exit(0);
                        continue;
                    }
                    if (string.equals("--help")) {
                        PDFTool.b();
                        System.exit(0);
                        continue;
                    }
                    if (string.equals("--toimage")) {
                        PDFTool.a(listIterator, pDF, outputStream);
                        pDF = null;
                        if (!listIterator.hasNext()) continue;
                        throw new IllegalArgumentException("--toimage must be the last action");
                    }
                    if (string.startsWith("--")) throw new IllegalArgumentException("Unknown argument \"" + string + "\"");
                    pDF = PDFTool.a(string);
                    continue;
                }
                for (int i2 = 0; i2 <= string.length(); ++i2) {
                    char c2;
                    char c3 = c2 = i2 == string.length() ? (char)'\u0000' : string.charAt(i2);
                    if (c2 != '+' && c2 != '-' && c2 != '\u0000') continue;
                    String string2 = string.substring(n2, i2);
                    if (string2.equals("nocompression")) {
                        outputProfile = new OutputProfile(OutputProfile.NoCompression);
                    } else if (string2.equals("recompression")) {
                        outputProfile = new OutputProfile(OutputProfile.Default);
                        outputProfile.setRequired(OutputProfile.Feature.RegularCompression);
                    } else if (string2.equals("acrobat4")) {
                        outputProfile = new OutputProfile(OutputProfile.Acrobat4Compatible);
                    } else if (string2.equals("acrobat5")) {
                        outputProfile = new OutputProfile(OutputProfile.Acrobat5Compatible);
                    } else if (string2.equals("acrobat6")) {
                        outputProfile = new OutputProfile(OutputProfile.Acrobat6Compatible);
                    } else if (string2.equals("acrobat7")) {
                        outputProfile = new OutputProfile(OutputProfile.Acrobat7Compatible);
                    } else if (string2.length() <= 1 || string2.charAt(0) != '+' && string2.charAt(0) != '-') {
                        if (string2.length() > 0) {
                            throw new IllegalArgumentException("Unknown OutputProfile \"" + string2 + "\"");
                        }
                    } else {
                        OutputProfile.Feature[] featureArray = OutputProfile.Feature.ALL;
                        boolean bl = false;
                        for (int i3 = 0; i3 < featureArray.length; ++i3) {
                            if (!featureArray[i3].toString().equals(string2.substring(1))) continue;
                            bl = true;
                            if (string2.charAt(0) == '+') {
                                outputProfile.setRequired(featureArray[i3]);
                                continue;
                            }
                            outputProfile.setDenied(featureArray[i3]);
                        }
                        if (!bl) {
                            throw new IllegalArgumentException("Unknown OutputProfile feature \"" + string2.substring(1) + "\"");
                        }
                    }
                    n2 = i2;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println("PDFTool " + PDF.VERSION + ": Error: " + illegalArgumentException.getMessage());
            System.err.println("  Run PDFTool to open the viewer");
            System.err.println("  Run PDFTool --help to display options");
            System.exit(1);
        }
        if (stringArray.length == 0 || stringArray.length == 1 && !stringArray[0].startsWith("--")) {
            PDFTool.a(new ArrayList().listIterator(), pDF, a);
            return;
        }
        if (pDF == null) return;
        if (outputProfile != null) {
            pDF.setOutputProfile(outputProfile);
        }
        pDF.render(outputStream);
        ((OutputStream)outputStream).close();
    }

    private static PDF a(String string) throws IOException {
        if (string.equals("-")) {
            return new PDF(new PDFReader(System.in));
        }
        a = string;
        return new PDF(new PDFReader(new FileInputStream(a)));
    }

    private static final String b(String string) {
        return string.substring(string.indexOf("=") + 1);
    }

    protected static void setLicense() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PDF a(ListIterator listIterator, PDF pDF) throws IOException {
        double d2 = 0.0;
        boolean bl = true;
        String string = null;
        String string2 = null;
        if (pDF == null) {
            pDF = new PDF();
        }
        List list = pDF.getPages();
        while (listIterator.hasNext()) {
            PDFPage pDFPage;
            Object object;
            Object object2;
            Closeable closeable;
            String string3 = (String)listIterator.next();
            if (string3.startsWith("--dpi=")) {
                d2 = Double.parseDouble(PDFTool.b(string3));
                if (!(d2 < 0.0) && !(d2 > 600.0)) continue;
                throw new IllegalArgumentException("DPI must be betweeen 0 and 600");
            }
            if (string3.startsWith("--pages=")) {
                string = PDFTool.b(string3);
                continue;
            }
            if (string3.startsWith("--pagesize=")) {
                string2 = PDFTool.b(string3);
                if (!string2.equals("auto")) continue;
                string2 = null;
                continue;
            }
            if (string3.startsWith("--")) {
                listIterator.previous();
                return pDF;
            }
            byte[] byArray = null;
            if (string3.equals("-")) {
                closeable = new ByteArrayOutputStream();
                byArray = new byte[8192];
                int n2 = System.in.read(byArray);
                while (n2 >= 0) {
                    ((ByteArrayOutputStream)closeable).write(byArray, 0, n2);
                    n2 = System.in.read(byArray);
                }
                byArray = ((ByteArrayOutputStream)closeable).toByteArray();
            }
            closeable = null;
            try {
                closeable = byArray == null ? new FileInputStream(string3) : new ByteArrayInputStream(byArray);
                PDF pDF2 = new PDF(new PDFReader((InputStream)closeable));
                ((InputStream)closeable).close();
                if (bl) {
                    pDF2.getForm().flatten();
                }
                object2 = string2 == null ? null : new PDFPage(string2);
                object = pDF2.getPages();
                int[] nArray = PDFTool.a(string, object.size());
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    pDFPage = (PDFPage)object.get(nArray[i2]);
                    Object object3 = object2 = string2 == null ? null : new PDFPage(string2);
                    if (object2 != null && (pDFPage.getWidth() != ((PDFPage)object2).getWidth() || pDFPage.getHeight() != ((PDFPage)object2).getHeight())) {
                        PDFCanvas pDFCanvas = new PDFCanvas(pDFPage);
                        ((PDFPage)object2).drawCanvas(pDFCanvas, 0.0f, 0.0f, ((PDFPage)object2).getWidth(), ((PDFPage)object2).getHeight());
                        list.add(object2);
                        object2 = new PDFPage(string2);
                        continue;
                    }
                    list.add(pDFPage);
                }
            }
            catch (IOException iOException) {
                try {
                    if (closeable != null) {
                        ((InputStream)closeable).close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                closeable = byArray == null ? new FileInputStream(string3) : new ByteArrayInputStream(byArray);
                object2 = new PDFImageSet((InputStream)closeable);
                ((InputStream)closeable).close();
                object = PDFTool.a(string, ((PDFImageSet)object2).getNumImages());
                for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                    PDFImage pDFImage = ((PDFImageSet)object2).getImage((int)object[i3]);
                    if (string2 != null) {
                        pDFPage = new PDFPage(string2);
                    } else {
                        double d4 = d2 == 0.0 ? (double)pDFImage.getWidth() : (double)pDFImage.getWidth() * pDFImage.getDPIX() / d2;
                        double d6 = d2 == 0.0 ? (double)pDFImage.getHeight() : (double)pDFImage.getHeight() * pDFImage.getDPIY() / d2;
                        pDFPage = new PDFPage((int)d4, (int)d6);
                    }
                    pDFPage.drawImage(pDFImage, 0.0f, 0.0f, pDFPage.getWidth(), pDFPage.getHeight());
                    list.add(pDFPage);
                }
            }
            finally {
                try {
                    if (closeable != null) {
                        ((InputStream)closeable).close();
                    }
                }
                catch (Exception exception) {}
            }
            string = null;
        }
        return pDF;
    }

    private static int[] a(String string, int n2) {
        int[] nArray;
        block25: {
            if (string != null && !string.equals("all")) break block25;
            nArray = new int[n2];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = i2;
            }
        }
        if (string.equals("reverse")) {
            nArray = new int[n2];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray[i3] = n2 - i3 - 1;
            }
        }
        if (string.charAt(0) == '-') {
            string = "1" + string;
        }
        if (string.charAt(string.length() - 1) == '-') {
            string = string + (n2 + 1);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            int n4;
            String string2 = stringTokenizer.nextToken();
            int n5 = string2.indexOf(45);
            if (n5 < 0) {
                arrayList.add(new Integer(PDFTool.b(string2, n2) - 1));
                continue;
            }
            int n6 = PDFTool.b(string2.substring(0, n5), n2);
            if (n6 < (n4 = PDFTool.b(string2.substring(n5 + 1), n2))) {
                for (n3 = n6; n3 <= n4; ++n3) {
                    arrayList.add(new Integer(n3 - 1));
                }
                continue;
            }
            for (n3 = n4; n3 >= n6; --n3) {
                arrayList.add(new Integer(n3 - 1));
            }
        }
        nArray = new int[arrayList.size()];
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            nArray[i4] = (Integer)arrayList.get(i4);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int b(String string, int n2) {
        if (string.equals("end")) {
            return n2;
        }
        try {
            int n3 = Integer.parseInt(string);
            if (n3 >= 1 && n3 <= n2) {
                return n3;
            }
            throw new IllegalArgumentException("Page " + n3 + " outside range 1-" + n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid page '" + string + "'");
        }
    }

    private static PDF b(ListIterator listIterator, PDF pDF) throws IOException, SAXException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = false;
        String string = null;
        String string2 = null;
        while (listIterator.hasNext()) {
            block42: {
                object4 = (String)listIterator.next();
                if (((String)object4).startsWith("--properties=")) {
                    object3 = PDFTool.b((String)object4);
                    Properties object5 = new Properties();
                    object5.load(new FileInputStream((String)object3));
                    object2 = object5.propertyNames();
                    while (object2.hasMoreElements()) {
                        String string4 = (String)object2.nextElement();
                        object = object5.getProperty(string4);
                        hashMap.put(string4, object);
                    }
                    continue;
                }
                if (((String)object4).startsWith("--fdf=")) {
                    string2 = PDFTool.b((String)object4);
                    continue;
                }
                if (((String)object4).startsWith("--xfa=")) {
                    int n2;
                    object3 = PDFTool.b((String)object4);
                    InputStreamReader n3 = new InputStreamReader((InputStream)new FileInputStream((String)object3), "UTF-8");
                    object2 = new StringWriter();
                    while ((n2 = ((Reader)n3).read()) >= 0) {
                        ((StringWriter)object2).write(n2);
                    }
                    string = ((StringWriter)object2).toString();
                    continue;
                }
                if (((String)object4).startsWith("--field=")) {
                    object3 = PDFTool.b((String)object4);
                    int n3 = ((String)object3).indexOf(61);
                    if (n3 < 0) {
                        throw new IllegalArgumentException("\"" + (String)object4 + "\" is invalid");
                    }
                    hashMap.put(((String)object3).substring(0, n3), ((String)object3).substring(n3 + 1));
                    continue;
                }
                if (!((String)object4).equals("--flatten") && !((String)object4).equals("--flatten=true")) break block42;
                bl = true;
                continue;
            }
            if (((String)object4).equals("--flatten=false")) {
                bl = false;
                continue;
            }
            if (((String)object4).startsWith("--")) {
                listIterator.previous();
                break;
            }
            pDF = PDFTool.a((String)object4);
        }
        if (pDF != null) {
            block44: {
                block43: {
                    object4 = pDF.getForm();
                    if (string == null) break block43;
                    ((Form)object4).setXFADatasets(string);
                    break block44;
                }
                if (string2 != null) {
                    object3 = new FDF(new FileInputStream(string2));
                    pDF.importFDF((FDF)object3);
                } else {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        object2 = (String)entry.getKey();
                        String string3 = (String)entry.getValue();
                        object = ((Form)object4).getElement((String)object2);
                        if (object == null) {
                            System.err.println("Unknown field: \"" + (String)object2 + "\"");
                            continue;
                        }
                        if (object instanceof FormText) {
                            ((FormText)object).setValue(string3);
                            continue;
                        }
                        if (object instanceof FormRadioButton) {
                            ((FormRadioButton)object).setValue(string3);
                            continue;
                        }
                        if (object instanceof FormCheckbox) {
                            ((FormCheckbox)object).setValue(string3);
                            continue;
                        }
                        if (object instanceof FormChoice) {
                            ((FormChoice)object).setValue(string3);
                            continue;
                        }
                        System.err.println("Unable to set " + object.getClass() + " element");
                    }
                    hashMap.clear();
                }
            }
            if (bl) {
                ((Form)object4).flatten();
            }
        }
        return pDF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDF c(ListIterator listIterator, PDF pDF) throws IOException, GeneralSecurityException {
        Object object;
        String string8 = null;
        String string7 = null;
        String string6 = null;
        String string5 = null;
        String string4 = null;
        String string3 = null;
        String string9 = null;
        String string2 = null;
        String string = "JKS";
        int n6 = 0;
        int n5 = 0;
        int n4 = 0;
        int n3 = 0;
        int n2 = 0;
        while (listIterator.hasNext()) {
            object = (String)listIterator.next();
            if (((String)object).startsWith("--keypassword=")) {
                string8 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--password=")) {
                string7 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--reason=")) {
                string6 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--location=")) {
                string5 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--alias=")) {
                string4 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--name=")) {
                string2 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--keystore=")) {
                string3 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--keystoretype=")) {
                string = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--field=")) {
                string9 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--left=")) {
                n6 = Integer.parseInt(PDFTool.b((String)object));
                continue;
            }
            if (((String)object).startsWith("--top=")) {
                n5 = Integer.parseInt(PDFTool.b((String)object));
                continue;
            }
            if (((String)object).startsWith("--right=")) {
                n4 = Integer.parseInt(PDFTool.b((String)object));
                continue;
            }
            if (((String)object).startsWith("--bottom=")) {
                n3 = Integer.parseInt(PDFTool.b((String)object));
                continue;
            }
            if (((String)object).startsWith("--page=")) {
                n2 = Integer.parseInt(PDFTool.b((String)object)) - 1;
                continue;
            }
            if (((String)object).startsWith("--")) {
                listIterator.previous();
                break;
            }
            pDF = PDFTool.a((String)object);
        }
        if (pDF != null) {
            object = pDF.getForm();
            FormSignature formSignature = null;
            if (string9 != null) {
                formSignature = (FormSignature)((Form)object).getElement(string9);
            }
            if (formSignature == null) {
                if (string9 == null) {
                    string9 = "Signature";
                }
                formSignature = new FormSignature();
                if (n6 != n4 && n5 != n3) {
                    formSignature.addAnnotation(pDF.getPage(n2), n6, n5, n4, n3);
                }
                pDF.getForm().addElement(string9, formSignature);
            }
            if (string8 == null) {
                string8 = string7;
            }
            KeyStore keyStore = KeyStore.getInstance(string);
            FileInputStream fileInputStream = new FileInputStream(string3);
            keyStore.load(fileInputStream, string7.toCharArray());
            ((InputStream)fileInputStream).close();
            formSignature.sign(keyStore, string4, string8.toCharArray(), FormSignature.HANDLER_ACROBATSIX);
            formSignature.setReason(string6);
            formSignature.setLocation(string5);
            if (string2 == null) {
                PKCS7SignatureHandler pKCS7SignatureHandler = (PKCS7SignatureHandler)formSignature.getSignatureHandler();
                string2 = FormSignature.getSubjectField(pKCS7SignatureHandler.getCertificates()[0], "CN");
            }
            formSignature.setName(string2);
        }
        return pDF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(ListIterator listIterator, PDF pDF, OutputStream outputStream) throws IOException {
        Object object;
        ColorModel colorModel = PDFParser.getBlackAndWhiteColorModel(128);
        double d2 = 200.0;
        String string3 = null;
        String string2 = "tiff";
        String string = null;
        while (listIterator.hasNext()) {
            object = (String)listIterator.next();
            if (((String)object).startsWith("--dpi=")) {
                d2 = Double.parseDouble(PDFTool.b((String)object));
                if (d2 <= 0.0) throw new IllegalArgumentException("DPI must be betweeen 1 and 600");
                if (!(d2 > 600.0)) continue;
                throw new IllegalArgumentException("DPI must be betweeen 1 and 600");
            }
            if (((String)object).equals("--model=bw")) {
                colorModel = PDFParser.BLACKANDWHITE;
                continue;
            }
            if (((String)object).startsWith("--model=bw")) {
                try {
                    int n2 = Integer.parseInt(((String)object).substring(10));
                    colorModel = PDFParser.getBlackAndWhiteColorModel(n2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Black and white threshold \"" + ((String)object).substring(10) + "\" not between 1 and 255");
                }
            }
            if (((String)object).equals("--model=rgb")) {
                colorModel = PDFParser.RGB;
                continue;
            }
            if (((String)object).equals("--model=rgba")) {
                colorModel = PDFParser.RGBA;
                continue;
            }
            if (((String)object).equals("--model=cmyk")) {
                colorModel = PDFParser.CMYK;
                continue;
            }
            if (((String)object).equals("--model=gray")) {
                colorModel = PDFParser.GRAYSCALE;
                continue;
            }
            if (((String)object).equals("--format=tiff") || ((String)object).equals("--format=tif")) {
                string2 = "tiff";
                continue;
            }
            if (((String)object).equals("--format=png")) {
                string2 = "PNG";
                continue;
            }
            if (((String)object).equals("--format=gif")) {
                string2 = "gif";
                continue;
            }
            if (((String)object).equals("--format=jpeg")) {
                string2 = "JPEG";
                continue;
            }
            if (((String)object).startsWith("--pages=")) {
                string3 = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--output=")) {
                string = PDFTool.b((String)object);
                continue;
            }
            if (((String)object).startsWith("--")) {
                listIterator.previous();
                return;
            }
            pDF = PDFTool.a((String)object);
        }
        if (pDF == null) return;
        object = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        List list = pDF.getPages();
        int[] nArray = PDFTool.a(string3, list.size());
        PDFParser pDFParser = new PDFParser(pDF);
        if (string2 == "tiff") {
            if (string != null) {
                outputStream = new FileOutputStream(string);
            }
            ArrayList arrayList = new ArrayList(list);
            list.clear();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                list.add(arrayList.get(nArray[i2]));
            }
            pDFParser.writeAsTIFF(outputStream, (int)d2, colorModel, (RenderingHints)object);
            if (outputStream != null) {
                outputStream.close();
            }
            list.clear();
            list.addAll(arrayList);
        } else if (string != null && pDF.getNumberOfPages() > 1) {
            DecimalFormat decimalFormat = new DecimalFormat("0");
            int n3 = nArray[nArray.length - 1];
            if (n3 >= 10000) {
                decimalFormat = new DecimalFormat("00000");
            }
            if (n3 >= 1000) {
                decimalFormat = new DecimalFormat("0000");
            }
            if (n3 >= 100) {
                decimalFormat = new DecimalFormat("000");
            }
            if (n3 >= 10) {
                decimalFormat = new DecimalFormat("00");
            }
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n4 = nArray[i3];
                PagePainter pagePainter = pDFParser.getPagePainter(n4);
                pagePainter.setRenderingHints((RenderingHints)object);
                BufferedImage bufferedImage = pagePainter.getImage((float)d2, colorModel);
                String string4 = string.substring(0, string.lastIndexOf("."));
                string4 = string4 + "-" + decimalFormat.format(n4) + string.substring(string.lastIndexOf("."));
                ImageIO.write((RenderedImage)bufferedImage, string2, new FileOutputStream(string4));
            }
        } else {
            if (string != null) {
                outputStream = new FileOutputStream(string);
            }
            PagePainter pagePainter = pDFParser.getPagePainter(0);
            pagePainter.setRenderingHints((RenderingHints)object);
            BufferedImage bufferedImage = pagePainter.getImage((float)d2, colorModel);
            ImageIO.write((RenderedImage)bufferedImage, string2, outputStream);
        }
        if (outputStream == null) return;
        outputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(ListIterator listIterator, PDF pDF, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n2 = 0;
        String[] stringArray = null;
        int[] nArray = new int[]{-1, -1, Integer.MAX_VALUE, Integer.MAX_VALUE};
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (string2.startsWith("--page")) {
                n2 = Integer.parseInt(PDFTool.b(string2));
                continue;
            }
            if (string2.startsWith("--features=")) {
                stringArray = PDFTool.b(string2).split(",");
                continue;
            }
            if (string2.startsWith("--geometry=")) {
                string2 = PDFTool.b(string2);
                object3 = Pattern.compile("([0-9]+)x([0-9]+)([+-][0-9]+)?([+-][0-9]+)?");
                object2 = ((Pattern)object3).matcher(string2);
                if (!((Matcher)object2).matches()) {
                    throw new IllegalArgumentException("Invalid geometry " + string2);
                }
                nArray[0] = Integer.parseInt(((Matcher)object2).group(1));
                nArray[1] = Integer.parseInt(((Matcher)object2).group(2));
                object = ((Matcher)object2).group(3);
                String string3 = ((Matcher)object2).group(4);
                if (object != null && ((String)object).length() == 0) {
                    object = null;
                }
                if (string3 != null && string3.length() == 0) {
                    string3 = null;
                }
                if (object != null && string3 == null) {
                    throw new IllegalArgumentException("Invalid geometry " + string2);
                }
                if (object == null || string3 == null) continue;
                if (((String)object).charAt(0) == '+') {
                    nArray[2] = Integer.parseInt(((String)object).substring(1));
                } else {
                    nArray[2] = Integer.parseInt((String)object);
                    if (nArray[2] == 0) {
                        nArray[2] = Integer.MIN_VALUE;
                    }
                }
                if (string3.charAt(0) == '+') {
                    nArray[3] = Integer.parseInt(string3.substring(1));
                    continue;
                }
                nArray[3] = Integer.parseInt(string3);
                if (nArray[3] != 0) continue;
                nArray[3] = Integer.MIN_VALUE;
                continue;
            }
            if (string != null) {
                throw new IllegalArgumentException("--view must be the last action");
            }
            string = string2;
            pDF = new PDF(new PDFReader(new File(string)));
        }
        int n3 = n2;
        object3 = string;
        object2 = Arrays.asList(stringArray == null ? new String[]{} : stringArray);
        object = pDF;
        SwingUtilities.invokeLater(new Runnable((List)object2, nArray, (PDF)object, (String)object3, n3){
            final /* synthetic */ List val$fchangefeatures;
            final /* synthetic */ int[] val$geometry;
            final /* synthetic */ PDF val$fpdf;
            final /* synthetic */ String val$ffilename;
            final /* synthetic */ int val$fpage;
            {
                this.val$fchangefeatures = list;
                this.val$geometry = nArray;
                this.val$fpdf = pDF;
                this.val$ffilename = string;
                this.val$fpage = n2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object object3;
                ArrayList<Object> arrayList;
                block28: {
                    Object object2;
                    try {
                        object2 = System.getProperty("swing.defaultlaf");
                        if (object2 == null || ((String)object2).length() == 0) {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        } else {
                            UIManager.setLookAndFeel((String)object2);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    object2 = ViewerFeature.getAllFeatures();
                    arrayList = new ArrayList<Object>(object2.size());
                    for (int i2 = 0; i2 < object2.size(); ++i2) {
                        object3 = (ViewerFeature)object2.get(i2);
                        boolean bl = ((ViewerFeature)object3).isEnabledByDefault();
                        bl &= !this.val$fchangefeatures.contains("-" + ((ViewerFeature)object3).getName());
                        if (!(bl |= this.val$fchangefeatures.contains("+" + ((ViewerFeature)object3).getName()))) continue;
                        arrayList.add(object3);
                    }
                    try {
                        if (!Util.isLAFAqua()) break block28;
                        for (Object object3 : arrayList) {
                            if (!(object3 instanceof AppleSupport)) continue;
                            ((AppleSupport)object3).setMoveMenus(true);
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                JFrame jFrame = new JFrame("BFO");
                jFrame.setIconImage(PDFViewer.a.getImage());
                object3 = new PDFViewer(arrayList);
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                jFrame.setContentPane((Container)object3);
                jFrame.pack();
                if (this.val$geometry[0] != -1) {
                    jFrame.setSize(new Dimension(this.val$geometry[0], this.val$geometry[1]));
                }
                Dimension dimension = ((Component)object3).getToolkit().getScreenSize();
                Dimension dimension2 = jFrame.getSize();
                if (this.val$geometry[2] == Integer.MAX_VALUE) {
                    this.val$geometry[2] = Math.max(0, dimension.width - dimension2.width) / 2;
                    this.val$geometry[3] = Math.max(0, dimension.height - dimension2.height) / 2;
                }
                if (this.val$geometry[2] < 0) {
                    if (this.val$geometry[2] == Integer.MIN_VALUE) {
                        this.val$geometry[2] = 0;
                    }
                    this.val$geometry[2] = dimension.width - dimension2.width + this.val$geometry[2];
                }
                if (this.val$geometry[3] < 0) {
                    if (this.val$geometry[3] == Integer.MIN_VALUE) {
                        this.val$geometry[3] = 0;
                    }
                    this.val$geometry[3] = dimension.height - dimension2.height + this.val$geometry[3];
                }
                jFrame.setLocation(this.val$geometry[2], this.val$geometry[3]);
                jFrame.setVisible(true);
                if (this.val$fpdf == null) return;
                ((PDFViewer)object3).loadPDF(this.val$fpdf, this.val$ffilename);
                if (this.val$fpage <= 0) return;
                DocumentPanel documentPanel = ((PDFViewer)object3).getActiveDocumentPanel();
                if (documentPanel == null) return;
                documentPanel.setPageNumber(this.val$fpage - 1);
            }
        });
    }

    private static void a() {
        System.err.println("PDFTool " + PDF.VERSION);
        System.err.println("  Run PDFTool to open the viewer");
        System.err.println("  Run PDFTool --help for more information");
        System.err.println();
    }

    private static void b() {
        System.out.println("Usage: PDFTool [ --output=<outfile> | <infile> | <command> ] *");
        System.out.println();
        System.out.println("  This program runs a pipeline of one or more operations on a PDF. The initial");
        System.out.println("  PDF can be loaded (<infile> in the argument list above) and operations");
        System.out.println("  performed on it, after which it is written to standard out or <outfile> if");
        System.out.println("  it's specified.");
        System.out.println();
        System.out.println("  General arguments are:");
        System.out.println("     --output=<outfile>");
        System.out.println("       Set the file to write to. If not specified the default is standard out");
        System.out.println();
        System.out.println("     --profile=<profile>");
        System.out.println("       Set the output profile to use when rendering the PDF. Valid values are");
        System.out.println("       'nocompression', 'acrobat4', 'acrobat5', 'acrobat6', 'acrobat7'");
        System.out.println("       or 'recompression' (which recompresses uncompressed files). Individual");
        System.out.println("       features can be required or denied by adding a '+' or '-': eg.");
        System.out.println("       \"--profile=nocompression-'XMP Metadata'\" or \"--profile=+Linearized\"");
        System.out.println();
        System.out.println("     <infile>");
        System.out.println("       The PDF to work on. Must be specified somewhere in the parameter list");
        System.out.println("       unless the <filename> parameter is used with the join command.");
        System.out.println();
        System.out.println("  Command sequences can be one of the following:");
        System.out.println();
        System.out.println("     --version");
        System.out.println();
        System.out.println("       Display a short message then exit");
        System.out.println();
        System.out.println("     --help");
        System.out.println();
        System.out.println("       Display this message then exit");
        System.out.println();
        System.out.println("     --join [ [--pages=<list>] [--pagesize=<size>] [--dpi=<dpi>] <filename> ] *");
        System.out.println();
        System.out.println("       To concatenate a sequence of PDFs: Arguments are:");
        System.out.println();
        System.out.println("         --pagesize=<size>");
        System.out.println("           Set the size of the output pages. Valid values include A4, letter");
        System.out.println("           A4-landscape, 8.5x11in, 210x297mm and so on. The pagesize values is");
        System.out.println("           kept across input documents");
        System.out.println();
        System.out.println("         --dpi=<dpi>");
        System.out.println("           For input files that are bitmap images, this is an alternative way");
        System.out.println("           to set the output page size - by setting the DPI of the input image.");
        System.out.println("           Valid values are 1 to 600 (or 0 to use the default)");
        System.out.println();
        System.out.println("         --pages=<list>");
        System.out.println("           Set which pages from the next input file to use. List may be the");
        System.out.println("           value 'all' for all pages, 'reverse' to reverse the list or a comma-");
        System.out.println("           separated list of values, eg '1,2-5'. The value 'end' means the last");
        System.out.println("           page, and sequences may be backwards - eg. 'reverse' is equivalent");
        System.out.println("           to 'end-1'.");
        System.out.println();
        System.out.println("         <filename>");
        System.out.println("           The file to join to the existing PDF. May be a PDF, TIFF, JPEG, GIF");
        System.out.println("           PNG or PNM file");
        System.out.println();
        System.out.println("    --form [--flatten] [--xfa=<xfafile>] [--fdf=<fdffile>]");
        System.out.println("             [ [--properties=<propfile>] [--field=key=value] ] *");
        System.out.println();
        System.out.println("       To complete a PDF form: Arguments are:");
        System.out.println();
        System.out.println("         --properties=<propfile>");
        System.out.println("           Load the field values from the specified properties file. The keys");
        System.out.println("           in the file are the field names, the values the value to use");
        System.out.println();
        System.out.println("         --field=<key>=<value>");
        System.out.println("           Set the specified field to the specified value.");
        System.out.println();
        System.out.println("         --xfa=<xfafile>");
        System.out.println("           For a document containing an XFA form, set the form using the");
        System.out.println("           \"datasets\" object from the specified file. If this parameter is");
        System.out.println("           used any \"fields\" or \"properties\" parameters will be ignored.");
        System.out.println();
        System.out.println("         --fdf=<fdffile>");
        System.out.println("           Used to import an FDF or XFDF file into a PDF. If this parameter is");
        System.out.println("           used any \"fields\" or \"properties\" parameters will be ignored.");
        System.out.println();
        System.out.println("         --flatten");
        System.out.println("           Flatten the form after completion");
        System.out.println("");
        System.out.println("    --sign --keystore=<keystore> --alias=<alias> --password=<password>");
        System.out.println("             [--keypassword=<keypassword>] [--keystoretype=<keystoretype>]");
        System.out.println("             [--location=<location>] [--name=<name>] [--reason=<reason>]");
        System.out.println("             [--bottom=<bottom>] [--left=<left>] [--right=<right>] [--top=<top>]");
        System.out.println("             [--page=<page>] [--field=<field>");
        System.out.println();
        System.out.println("       Digitally sign a PDF file: Arguments are:");
        System.out.println();
        System.out.println("         --keystore=<keystore>");
        System.out.println("           The filename to load the keystore from. Must be specified.");
        System.out.println();
        System.out.println("         --alias=<alias>");
        System.out.println("           The alias to use from the keystore. Must be specified.");
        System.out.println();
        System.out.println("         --password=<password>");
        System.out.println("           The password to unlock the keystore. Must be specified.");
        System.out.println();
        System.out.println("         --keystoretype=<keystoretype>");
        System.out.println("           The type of keystore. The default is 'JKS', 'pkcs7' is also common");
        System.out.println();
        System.out.println("         --reason=<reason>");
        System.out.println("           The reason for signing");
        System.out.println();
        System.out.println("         --location=<location>");
        System.out.println("           The location the document is signed at");
        System.out.println();
        System.out.println("         --name=<name>");
        System.out.println("           The name of the person who is signing the document");
        System.out.println();
        System.out.println("         --field=<field>");
        System.out.println("           The name of the signature field. If it doesn't already exist in");
        System.out.println("           the PDF a new field is created with this name");
        System.out.println();
        System.out.println("         --page=<page>");
        System.out.println("           The page number to put the signature appearance on, if required.");
        System.out.println();
        System.out.println("         --left, top, right, bottom");
        System.out.println("           The location on the page to add the new field. The default is not");
        System.out.println("           to create a visible appearance for the signature");
        System.out.println();
        System.out.println("    --toimage [--format=<format>} [--model=<model>] [--dpi=<dpi>]");
        System.out.println();
        System.out.println("       To convert a PDF to a bitmap image - this must be the last command in");
        System.out.println("       the sequence (once a PDF is a TIFF there's nothing more you can do with");
        System.out.println("       it). Arguments are:");
        System.out.println();
        System.out.println("         --format=<format>");
        System.out.println("           Set the output file format. Values are 'tiff', 'png', 'jpeg'. The");
        System.out.println("           default is 'tiff', which will produce a multi-page document. 'png'");
        System.out.println("           and 'jpeg' will result in a single page document only");
        System.out.println();
        System.out.println("         --model=<model>");
        System.out.println("           Set the ColorModel. Values are 'bw', 'gray', 'rgb', 'rgba', 'cmyk'");
        System.out.println("           or 'bwNNN', where NNN is a value betwen 1 and 255 and sets how dark");
        System.out.println("           a color must be to be converted to black. The default model is 'bw'");
        System.out.println();
        System.out.println("         --dpi=<dpi>");
        System.out.println("           Set the DPI of the final file. Valid values are 1 to 600. The");
        System.out.println("           default is 200dpi");
        System.out.println();
        System.out.println("    --view");
        System.out.println("         --page=<page>");
        System.out.println("           Optionally set the initial page to open.");
        System.out.println();
        System.out.println("         --geometry=<width>x<height>[+x+y]");
        System.out.println("           Set the geometry of the Window - format is the same as X windows");
        System.out.println();
        System.out.println("         --features=[+name,-name,...]");
        System.out.println("           Add or remove features (specified by name) to the list of features");
        System.out.println("           included in the viewer");
        System.out.println();
        System.out.println("       Open the viewer. If a PDF has been specified on the command line, it");
        System.out.println("       will be opened. This must be the last command in the sequence.");
        System.out.println();
        System.out.println();
        System.out.println("  Some examples:");
        System.out.println("  1. To join two files then save them uncompressed");
        System.out.println("     PDFTool --profile=nocompression --join file1.pdf file2.tif > output.pdf");
        System.out.println();
        System.out.println("  2. To complete a form then display the result");
        System.out.println("     PDFTool in.pdf --form --field=name=John --field=date='20 May' --view");
        System.out.println();
        System.out.println("  3. To reverse a PDF then convert it to a TIFF");
        System.out.println("     PDFTool --join --pages=reverse file.pdf --output=out.tif --toimage");
        System.out.println();
        System.out.println("  4. To use only some pages from a source PDF");
        System.out.println("     PDFTool --join --pages=1,3-7,10-end file1.pdf > out.pdf");
        System.out.println();
        System.out.println("  5. To open and display a PDF");
        System.out.println("     PDFTool file.pdf      (or, a more complex example)");
        System.out.println("     PDFTool --view --page=3 --features=-Menus,-Toolbars \\");
        System.out.println("        --geometry=700x700+100-100 file.pdf");
    }
}

