/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentViewport;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.PagePanelEvent;
import org.faceless.pdf2.viewer2.PagePanelInteractionListener;
import org.faceless.pdf2.viewer2.PagePanelListener;
import org.faceless.pdf2.viewer2.Util;

public class SinglePageDocumentViewport
extends DocumentViewport {
    private JScrollPane f;
    private b_ g = new b_();
    private float h;
    private a_ i;
    private RenderingHints j;
    private ArrayList k;
    private ArrayList l;
    private PDF m;
    private PDFPage n;
    private PDFParser o;
    private boolean p;

    public SinglePageDocumentViewport() {
        this.setRenderingHints(this.getDefaultRenderingHints());
        this.setLayout(new BorderLayout());
        this.f = new JScrollPane(this.g){

            protected JViewport createViewport() {
                return new JViewport(){

                    public void scrollRectToVisible(Rectangle rectangle) {
                    }
                };
            }
        };
        this.add((Component)this.f, "Center");
        this.i = new a_();
        this.addComponentListener(this.i);
        this.f.getHorizontalScrollBar().addAdjustmentListener(this.i);
        this.f.getVerticalScrollBar().addAdjustmentListener(this.i);
        this.k = new ArrayList();
        this.l = new ArrayList();
        Util.fixScrollPaneKeyBindings(this.f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDocumentPanel(DocumentPanel documentPanel) {
        super.setDocumentPanel(documentPanel);
        if (documentPanel != null) {
            if (this.m != documentPanel.getPDF()) {
                this.n = null;
                this.m = documentPanel.getPDF();
                this.o = documentPanel.getParser();
            }
            this.f.getHorizontalScrollBar().setUnitIncrement(this.mouseWheelUnit);
            this.f.getVerticalScrollBar().setUnitIncrement(this.mouseWheelUnit);
        } else {
            this.m = null;
            this.n = null;
            this.o = null;
            this.g.b();
        }
        if (this.g.e == null) return;
        this.g.e.setParser(this.o);
        this.g.e.requestFocusInWindow();
    }

    public boolean isDraggable() {
        return this.g.a();
    }

    public void setDraggable(boolean bl) {
        this.g.a(bl);
    }

    public void setPage(PDFPage pDFPage, double d2, double d3, double d4) {
        if (pDFPage.getPDF() != this.getDocumentPanel().getPDF()) {
            throw new IllegalArgumentException("Page is from wrong PDF");
        }
        this.setZoom((float)d4);
        Dimension dimension = PagePanel.getFullPageView(pDFPage).getBounds().getSize();
        this.a(pDFPage, d2, (double)dimension.height - d3, false);
    }

    public void ensureVisible(PDFPage pDFPage, double d2, double d3) {
        this.a(pDFPage, d2, d3, true);
    }

    private void a(PDFPage pDFPage, double d2, double d3, boolean bl) {
        if (this.g.e != null) {
            this.g.f = true;
            Rectangle rectangle = this.g.e.getBounds();
            JScrollBar jScrollBar = this.f.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.f.getVerticalScrollBar();
            int n2 = 0;
            int n3 = 0;
            if (d2 == d2) {
                n2 = this.a((float)d2);
            }
            if (d3 == d3) {
                n3 = this.a((float)d3);
                n3 = rectangle.height - n3;
            }
            n2 = rectangle.x + n2;
            n3 = rectangle.y + n3;
            if (bl) {
                n2 -= jScrollBar.getVisibleAmount() / 2;
                n3 -= jScrollBar2.getVisibleAmount() / 2;
            }
            jScrollBar.setValue(n2 - 0);
            jScrollBar2.setValue(n3 - 0);
        }
        this.n = pDFPage;
        this.g.a(pDFPage);
        if (pDFPage != this.getPage()) {
            this.a();
            this.p = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPageVisible(PDFPage pDFPage, double d2, double d3) {
        if (this.g.e == null) {
            return false;
        }
        Rectangle rectangle2 = this.g.e.getBounds();
        Rectangle rectangle = (Rectangle)rectangle2.clone();
        if (pDFPage != this.getPage()) {
            return false;
        }
        if (d2 == d2 && d3 == d3) {
            float f2 = this.getZoom() * (float)Util.getScreenResolution(this);
            int n2 = Math.round((float)d2 * f2 / 72.0f);
            rectangle.x += n2;
            rectangle.width = 8;
            int n3 = Math.round((float)d3 * f2 / 72.0f);
            n3 = rectangle2.height - n3;
            rectangle.y += n3;
            rectangle.height = 8;
            return this.b().intersects(rectangle);
        }
        return true;
    }

    public JComponent getView() {
        return (JComponent)this.f.getViewport().getView();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getZoom() {
        if (this.h != 0.0f) return this.h;
        if (this.n == null) return this.h;
        this.h = this.getTargetZoom(this.getZoomMode(), this.n);
        return this.h;
    }

    private void a() {
        this.g.invalidate();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZoom(float f2) {
        if (f2 == f2 && (double)f2 > 0.01 && f2 != this.h) {
            JScrollBar jScrollBar = this.f.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.f.getVerticalScrollBar();
            double d2 = (double)jScrollBar.getValue() / (double)jScrollBar.getMaximum();
            double d3 = (double)jScrollBar2.getValue() / (double)jScrollBar2.getMaximum();
            this.h = f2;
            this.i.a(false);
            Dimension dimension = this.g.getPreferredSize();
            jScrollBar.setValue((int)Math.round((double)dimension.width * d2));
            jScrollBar2.setValue((int)Math.round((double)dimension.height * d3));
            this.i.a(true);
            this.a();
        }
    }

    int a(float f2) {
        return Math.round(f2 * (this.getZoom() * (float)Util.getScreenResolution(this) / 72.0f));
    }

    public Dimension getViewportSize() {
        return this.f.getViewport().getSize();
    }

    public PagePanel getPagePanel() {
        return this.g.e;
    }

    public Collection getPagePanels() {
        Set<PagePanel> set = this.g.e == null ? Collections.EMPTY_SET : Collections.singleton(this.g.e);
        return set;
    }

    public PDFPage getRenderingPage() {
        return this.n;
    }

    private Rectangle b() {
        JScrollBar jScrollBar = this.f.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = this.f.getVerticalScrollBar();
        return new Rectangle(jScrollBar.getValue(), jScrollBar2.getValue(), jScrollBar.getVisibleAmount(), jScrollBar2.getVisibleAmount());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Adjustable getAdjustable(int n2) {
        switch (n2) {
            case 0: {
                return this.f.getHorizontalScrollBar();
            }
            case 1: {
                return this.f.getVerticalScrollBar();
            }
        }
        throw new IllegalArgumentException(Integer.toString(n2));
    }

    public void setAdjustableValues(int n2, int n3) {
        this.i.a(false);
        this.f.getHorizontalScrollBar().setValue(n2);
        this.f.getVerticalScrollBar().setValue(n3);
        this.i.a(true);
        this.g.invalidate();
        this.g.validate();
        this.repaint();
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.j = renderingHints;
        if (this.g.e != null) {
            this.g.e.setRenderingHints(renderingHints);
        }
    }

    public void addPagePanelListener(PagePanelListener pagePanelListener) {
        this.k.add(pagePanelListener);
        if (this.g.e != null) {
            this.g.e.addPagePanelListener(pagePanelListener);
        }
    }

    public void removePagePanelListener(PagePanelListener pagePanelListener) {
        this.k.remove(pagePanelListener);
        if (this.g.e != null) {
            this.g.e.removePagePanelListener(pagePanelListener);
        }
    }

    public void addPagePanelInteractionListener(PagePanelInteractionListener pagePanelInteractionListener) {
        this.l.add(pagePanelInteractionListener);
        if (this.g.e != null) {
            this.g.e.addPagePanelInteractionListener(pagePanelInteractionListener);
        }
    }

    public void removePagePanelInteractionListener(PagePanelInteractionListener pagePanelInteractionListener) {
        this.l.remove(pagePanelInteractionListener);
        if (this.g.e != null) {
            this.g.e.removePagePanelInteractionListener(pagePanelInteractionListener);
        }
    }

    PagePanel c() {
        PagePanel pagePanel = new PagePanel();
        pagePanel.setViewport(this);
        pagePanel.setParser(this.o);
        pagePanel.setRenderingHints(this.j);
        Iterator iterator = this.k.iterator();
        while (iterator.hasNext()) {
            pagePanel.addPagePanelListener((PagePanelListener)iterator.next());
        }
        iterator = this.l.iterator();
        while (iterator.hasNext()) {
            pagePanel.addPagePanelInteractionListener((PagePanelInteractionListener)iterator.next());
        }
        return pagePanel;
    }

    public void setZoomMode(int n2) {
        super.setZoomMode(n2);
        PDFPage pDFPage = this.getPage();
        if (pDFPage != null) {
            this.setZoom(this.getTargetZoom(n2, pDFPage));
        }
    }

    public float getTargetZoom(int n2, PDFPage pDFPage) {
        float f2 = this.h;
        if (pDFPage != null) {
            Dimension dimension = PagePanel.getFullPageView(pDFPage).getBounds().getSize();
            float f3 = Util.getScreenResolution(this);
            dimension.width = Math.round((float)dimension.width * f3 / 72.0f);
            dimension.height = Math.round((float)dimension.height * f3 / 72.0f);
            JScrollBar jScrollBar = this.f.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.f.getVerticalScrollBar();
            Dimension dimension2 = new Dimension(jScrollBar.getVisibleAmount(), jScrollBar2.getVisibleAmount());
            switch (n2) {
                case 2: {
                    dimension2.width -= jScrollBar2.getWidth();
                    f2 = (float)dimension2.width / (float)dimension.width;
                    break;
                }
                case 3: {
                    dimension2.height -= jScrollBar.getHeight();
                    f2 = (float)dimension2.height / (float)dimension.height;
                    break;
                }
                case 1: {
                    dimension2.width -= jScrollBar2.getWidth();
                    dimension2.height -= jScrollBar.getHeight();
                    float f4 = (float)dimension2.width / (float)dimension.width;
                    float f5 = (float)dimension2.height / (float)dimension.height;
                    float f6 = f4 < f5 ? f4 : f5;
                    f2 = f6;
                    break;
                }
                default: {
                    float f7 = this.h == 0.0f ? 1.0f : this.h;
                    f2 = f7;
                }
            }
        }
        return f2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!string.endsWith("Box")) return;
        if (!(propertyChangeEvent.getSource() instanceof PDFPage)) return;
        this.a();
    }

    private class a_
    implements ComponentListener,
    AdjustmentListener {
        private boolean a = true;

        private a_() {
        }

        void a(boolean bl) {
            this.a = bl;
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n2 = SinglePageDocumentViewport.this.getZoomMode();
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    SinglePageDocumentViewport.this.setZoom(SinglePageDocumentViewport.this.getTargetZoom(n2, SinglePageDocumentViewport.this.getPage()));
                }
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.a) {
                SinglePageDocumentViewport.this.g.invalidate();
                SinglePageDocumentViewport.this.repaint();
                DocumentPanel documentPanel = SinglePageDocumentViewport.this.getDocumentPanel();
                if (documentPanel != null) {
                    documentPanel.raiseDocumentPanelEvent(DocumentPanelEvent.createPagePositionChanged(documentPanel));
                }
            }
        }
    }

    private class b_
    extends JPanel
    implements PagePanelListener,
    MouseListener,
    MouseMotionListener {
        PDFPage a;
        float b;
        float c;
        Rectangle d = new Rectangle(0, 0);
        PagePanel e;
        boolean f;
        boolean g;
        Point h;
        Point i;

        b_() {
            this.setLayout(null);
            this.setFocusable(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (SinglePageDocumentViewport.this.n != null) {
                dimension = PagePanel.getFullPageView(SinglePageDocumentViewport.this.n).getBounds().getSize();
                dimension.width = SinglePageDocumentViewport.this.a(dimension.width);
                dimension.height = SinglePageDocumentViewport.this.a(dimension.height);
            }
            dimension.height += 0;
            dimension.width += 0;
            return dimension;
        }

        void a(PDFPage pDFPage) {
            if (this.e == null || this.e.getPage() != pDFPage) {
                this.removeAll();
                if (this.e != null) {
                    this.e.setParser(null);
                    this.e.removePagePanelListener(SinglePageDocumentViewport.this.g);
                    this.e.removeMouseListener(SinglePageDocumentViewport.this.g);
                    this.e.removeMouseMotionListener(SinglePageDocumentViewport.this.g);
                }
                this.e = SinglePageDocumentViewport.this.c();
                this.e.addPagePanelListener(SinglePageDocumentViewport.this.g);
                this.e.addMouseListener(SinglePageDocumentViewport.this.g);
                this.e.addMouseMotionListener(SinglePageDocumentViewport.this.g);
                this.add(this.e);
            }
        }

        public void doLayout() {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getPreferredSize();
            Rectangle rectangle = new Rectangle();
            JScrollBar jScrollBar = SinglePageDocumentViewport.this.f.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = SinglePageDocumentViewport.this.f.getVerticalScrollBar();
            rectangle.x = jScrollBar.getValue();
            rectangle.y = jScrollBar2.getValue();
            rectangle.width = jScrollBar.getVisibleAmount();
            rectangle.height = jScrollBar2.getVisibleAmount();
            int n2 = 0;
            int n3 = 0;
            if (dimension2.width < dimension.width) {
                n2 = (dimension.width - dimension2.width) / 2;
            }
            if (dimension2.height < dimension.height) {
                n3 = (dimension.height - dimension2.height) / 2;
            }
            if (SinglePageDocumentViewport.this.n != null) {
                Dimension dimension3 = PagePanel.getFullPageView(SinglePageDocumentViewport.this.n).getBounds().getSize();
                int n4 = SinglePageDocumentViewport.this.a(dimension3.width);
                int n5 = SinglePageDocumentViewport.this.a(dimension3.height);
                Rectangle rectangle2 = new Rectangle(n2, n3, n4, n5);
                this.e.setBounds(rectangle2);
                Rectangle2D rectangle2D = PagePanel.getFullPageView(SinglePageDocumentViewport.this.n);
                Rectangle rectangle3 = rectangle2.intersection(rectangle);
                rectangle3.x -= rectangle2.x;
                rectangle3.y -= rectangle2.y;
                float f2 = SinglePageDocumentViewport.this.getZoom();
                float f3 = f2 * (float)Util.getScreenResolution(this);
                if (this.f || this.a != SinglePageDocumentViewport.this.n || (double)Math.abs(this.b - f3) >= 0.1 || (double)Math.abs(this.c - f2) >= 0.1 || !this.d.equals(rectangle3)) {
                    this.e.setPage(SinglePageDocumentViewport.this.n, rectangle2D, f3, rectangle3);
                    this.a = SinglePageDocumentViewport.this.n;
                    this.b = f3;
                    this.c = SinglePageDocumentViewport.this.getZoom();
                    this.d = rectangle3;
                    this.f = false;
                }
            }
        }

        public void paintComponent(Graphics graphics) {
            if (SinglePageDocumentViewport.this.h != 0.0f) {
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Color color = new Color(102, 102, 102);
                Color color2 = new Color(153, 153, 153);
                Color color3 = new Color(204, 204, 204);
                Rectangle rectangle2 = this.e.getBounds();
                int n2 = rectangle2.x - 1;
                int n3 = rectangle2.y - 1;
                int n4 = rectangle2.x + rectangle2.width + 1;
                int n5 = rectangle2.y + rectangle2.height + 1;
                graphics.setColor(color);
                graphics.drawRect(n2, n3, rectangle2.width + 2, rectangle2.height + 2);
                graphics.setColor(color2);
                n3 = n5 + 1;
                graphics.drawLine(++n2, n3, --n4, ++n5);
                graphics.setColor(color3);
                graphics.drawLine(++n2, ++n3, --n4, ++n5);
            }
        }

        public void pageUpdated(PagePanelEvent pagePanelEvent) {
            if (pagePanelEvent.getType() == "redrawn") {
                DocumentPanel documentPanel;
                PagePanel pagePanel = pagePanelEvent.getPagePanel();
                pagePanel.invalidate();
                this.repaint();
                if (SinglePageDocumentViewport.this.p && (documentPanel = SinglePageDocumentViewport.this.getDocumentPanel()) != null) {
                    SinglePageDocumentViewport.this.p = false;
                    documentPanel.raiseDocumentPanelEvent(DocumentPanelEvent.createPageChanged(documentPanel));
                }
            }
        }

        boolean a() {
            return this.g;
        }

        void a(boolean bl) {
            this.g = bl;
            this.setCursor(bl ? DocumentViewport.CURSOR_GRAB : null);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.g) {
                Component component = (Component)mouseEvent.getSource();
                this.h = component == this ? mouseEvent.getPoint() : new Point(mouseEvent.getX() + component.getX(), mouseEvent.getY() + component.getY());
                Adjustable adjustable = SinglePageDocumentViewport.this.getAdjustable(0);
                Adjustable adjustable2 = SinglePageDocumentViewport.this.getAdjustable(1);
                this.i = new Point(adjustable.getValue(), adjustable2.getValue());
                this.setCursor(DocumentViewport.CURSOR_GRABBING);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.g) {
                this.h = null;
                this.i = null;
                this.setCursor(DocumentViewport.CURSOR_GRAB);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.g) {
                Component component = (Component)mouseEvent.getSource();
                Point point = component == this ? mouseEvent.getPoint() : new Point(mouseEvent.getX() + component.getX(), mouseEvent.getY() + component.getY());
                int n2 = point.x - this.h.x;
                int n3 = point.y - this.h.y;
                Adjustable adjustable = SinglePageDocumentViewport.this.getAdjustable(0);
                Adjustable adjustable2 = SinglePageDocumentViewport.this.getAdjustable(1);
                int n4 = adjustable.getValue();
                int n5 = adjustable2.getValue();
                SinglePageDocumentViewport.this.setAdjustableValues(this.i.x - n2, this.i.y - n3);
                int n6 = adjustable.getValue() - n4;
                int n7 = adjustable2.getValue() - n5;
                this.i.x += n6;
                this.i.y += n7;
            }
        }

        void b() {
            if (this.e != null) {
                this.e.setParser(null);
                this.remove(this.e);
            }
            this.e = null;
            this.a = null;
        }
    }
}

