/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.SignedObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class About
extends ViewerWidget {
    private Map n;
    private static Map o;

    public About() {
        super("About");
        this.setDocumentRequired(false);
        this.setMenu("Window\tAbout");
    }

    protected About(String string) {
        super(string);
    }

    public void action(ViewerEvent viewerEvent) {
        this.showAboutDialog(viewerEvent.getViewer(), true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void a() {
        block17: {
            o = new LinkedHashMap();
            o.put("Icon", PDFViewer.class.getResource("resources/BFOLogo.png"));
            o.put("Title", "Java PDF Viewer");
            String string = new SimpleDateFormat("yyyy").format(new Date());
            o.put("Main", "Big Faceless Organization \u00a9 2001-" + string);
            o.put("PDF Library", PDF.VERSION);
            InputStream inputStream = null;
            try {
                String string2;
                StringBuilder stringBuilder;
                Date date;
                block19: {
                    block18: {
                        inputStream = Class.forName("org.faceless.license.LicensePDF", true, Thread.currentThread().getContextClassLoader()).getResourceAsStream("PDF.license");
                        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                        SignedObject signedObject = (SignedObject)objectInputStream.readObject();
                        objectInputStream.close();
                        Map map = (Map)signedObject.getObject();
                        Object v2 = map.get("name");
                        Object v3 = map.get("licensenumber");
                        date = (Date)map.get("expiry");
                        boolean bl = "true".equals(map.get("core"));
                        if (v2 == null) break block17;
                        stringBuilder = new StringBuilder().append(v2).append(" (").append(v3);
                        if (!bl) break block18;
                        string2 = "";
                        break block19;
                    }
                    string2 = ": viewer";
                }
                String string3 = stringBuilder.append(string2).append(")").toString();
                o.put("Licensed To", string3);
                if (date.getTime() < 4102405200000L) {
                    o.put("Expiry", new SimpleDateFormat("dd MMM yyyy").format(date));
                }
            }
            catch (Throwable throwable) {
                o.put("Licensed To", "Unlicensed - Demo Version");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        o.put("Java", System.getProperty("java.version") + " by " + System.getProperty("java.vendor"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void b() {
        PDFViewer pDFViewer = this.getViewer();
        if (o == null) {
            About.a();
            if (!o.containsKey("JavaScript")) {
                About.putStaticProperty("JavaScript", pDFViewer.getJSManager().getImplementationDescription());
            }
        }
        this.n = new LinkedHashMap();
        String[] stringArray = new String[]{"Icon", "Title", "Main", "PDF Library", "Java", "JavaScript", "Licensed To", "Expiry", "Memory", "NoFeatures"};
        int i2 = 0;
        while (i2 < stringArray.length) {
            String string2 = stringArray[i2];
            String string = this.getFeatureProperty(pDFViewer, string2.replaceAll(" ", ""));
            if ("".equals(string)) {
                this.putProperty(string2, null);
            } else if (string != null) {
                if (string2.equals("Icon")) {
                    try {
                        this.putProperty(string2, this.getFeatureURLProperty(pDFViewer, string2.replaceAll(" ", "")));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    this.putProperty(string2, string);
                }
            }
            ++i2;
        }
        return;
    }

    public static synchronized Object putStaticProperty(String string, Object object) {
        if (o == null) {
            About.a();
        }
        return o.put(string, object);
    }

    public synchronized Object putProperty(String string, Object object) {
        if (this.n == null) {
            this.b();
        }
        return this.n.put(string, object);
    }

    public void showAboutDialog(PDFViewer pDFViewer, boolean bl, final int n2) {
        Object object;
        Object object2;
        ImageIcon imageIcon;
        if (this.n == null) {
            this.b();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.putAll(o);
        linkedHashMap.putAll(this.n);
        final JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(pDFViewer));
        jDialog.setModal(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(Integer.MIN_VALUE, true)), BorderFactory.createEmptyBorder(20, 20, 20, 20)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        gridBagConstraints.gridwidth = 0;
        ImageIcon imageIcon2 = imageIcon = linkedHashMap.get("Icon") != null ? new ImageIcon((URL)linkedHashMap.get("Icon")) : null;
        if (linkedHashMap.containsKey("Title") || imageIcon != null) {
            jPanel.add((Component)new JLabel((String)linkedHashMap.get("Title"), imageIcon, 2), gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel((String)linkedHashMap.get("Main")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (!linkedHashMap.containsKey("Memory")) {
            System.gc();
            object2 = Runtime.getRuntime();
            long l2 = ((Runtime)object2).totalMemory() - ((Runtime)object2).freeMemory();
            linkedHashMap.put("Memory", About.a(l2) + " / " + About.a(((Runtime)object2).maxMemory()) + " (" + Math.round((float)l2 * 100.0f / (float)((Runtime)object2).maxMemory()) + "%)");
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Object v2;
            object = (String)entry.getKey();
            if ("Main".equals(object) || "Icon".equals(object) || "Title".equals(object) || entry.getValue() == null || !((v2 = entry.getValue()) instanceof String)) continue;
            if (v2.equals("")) {
                jPanel.add((Component)new JLabel((String)object), gridBagConstraints);
                continue;
            }
            jPanel.add((Component)new JLabel((String)object), gridBagConstraints2);
            jPanel.add((Component)new JLabel((String)v2), gridBagConstraints);
        }
        if (bl && !linkedHashMap.containsKey("NoFeatures")) {
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            object2 = new JLabel("Available Features");
            ((JComponent)object2).setFont(((Component)object2).getFont().deriveFont(1));
            jPanel.add((Component)object2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            JList<ViewerFeature> jList = new JList<ViewerFeature>(pDFViewer.getFeatures());
            jList.setFont(jList.getFont().deriveFont(9.0f));
            object = new JScrollPane(jList);
            ((JComponent)object).setPreferredSize(new Dimension(300, 70));
            jPanel.add((Component)object, gridBagConstraints);
        }
        jDialog.setContentPane(jPanel);
        jDialog.setUndecorated(true);
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setLocationRelativeTo(pDFViewer);
        if (n2 != 0) {
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jDialog.setVisible(false);
                            jDialog.dispose();
                        }
                    });
                }
            }.start();
            jDialog.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            });
        }
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
        jDialog.requestFocus();
    }

    private static String a(long l2) {
        return Math.round((float)l2 / 1024.0f / 1024.0f) + "MB";
    }
}

