/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.AnnotationComponentFactory;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.AbstractRegionSelector;
import org.faceless.pdf2.viewer2.util.DialogPanel;

public class AnnotationAdd
extends AbstractRegionSelector {
    private Set t;

    public AnnotationAdd() {
        super("AnnotationAdd");
        this.setButton("Mode", "resources/icons/note_add.png", "PDFViewer.tt.AnnotationAdd");
        this.t = new LinkedHashSet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        ViewerFeature[] viewerFeatureArray = pDFViewer.getFeatures();
        String string = this.getFeatureProperty(pDFViewer, "factories");
        String[] stringArray = null;
        if (string != null) {
            stringArray = string.split(", *");
        }
        int n2 = 0;
        while (n2 < viewerFeatureArray.length) {
            if (viewerFeatureArray[n2] instanceof AnnotationComponentFactory) {
                boolean bl2 = stringArray == null;
                for (int n3 = 0; !bl2 && n3 < stringArray.length; ++n3) {
                    bl2 = stringArray[n3].equals(viewerFeatureArray[n2].getName());
                }
                if (bl2 && ((AnnotationComponentFactory)viewerFeatureArray[n2]).createNewAnnotation() != null) {
                    this.t.add(viewerFeatureArray[n2]);
                }
            }
            ++n2;
        }
        return;
    }

    public void setAnnotationFactories(AnnotationComponentFactory[] annotationComponentFactoryArray) {
        this.t.clear();
        for (int i2 = 0; i2 < annotationComponentFactoryArray.length; ++i2) {
            this.addAnnotationFactory(annotationComponentFactoryArray[i2]);
        }
    }

    public void addAnnotationFactory(AnnotationComponentFactory annotationComponentFactory) {
        if (annotationComponentFactory.createNewAnnotation() == null) {
            throw new IllegalArgumentException("Factory does not implement createNewAnnotation");
        }
        this.t.add(annotationComponentFactory);
    }

    public void removeAnnotationFactory(AnnotationComponentFactory annotationComponentFactory) {
        this.t.remove(annotationComponentFactory);
    }

    public void action(final PagePanel pagePanel, Point2D point2D, Point2D point2D2) {
        block3: {
            PDFPage pDFPage = pagePanel.getPage();
            float[] fArray = pDFPage.getBox("ViewBox");
            Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2] - fArray[0], fArray[3] - fArray[1]);
            if (!float_.contains(point2D) || !float_.contains(point2D2)) break block3;
            Object[] objectArray = this.a(pagePanel.getDocumentPanel().getViewer(), (float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY());
            final PDFAnnotation pDFAnnotation = (PDFAnnotation)objectArray[0];
            final AnnotationComponentFactory annotationComponentFactory = (AnnotationComponentFactory)objectArray[1];
            if (pDFAnnotation != null) {
                annotationComponentFactory.postEdit(pDFAnnotation, pagePanel, "create");
                pDFAnnotation.setPage(pagePanel.getPage());
                pagePanel.redrawAnnotation(pDFAnnotation);
                DocumentPanel documentPanel = pagePanel.getViewport().getDocumentPanel();
                documentPanel.fireUndoableEditEvent(new UndoableEditEvent(documentPanel, new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        return annotationComponentFactory.getAnnotationType();
                    }

                    public void undo() {
                        super.undo();
                        pDFAnnotation.setPage(null);
                    }

                    public void redo() {
                        super.redo();
                        pDFAnnotation.setPage(pagePanel.getPage());
                    }
                }));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] a(final PDFViewer pDFViewer, float f2, float f3, float f4, float f5) {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        final PDFAnnotation[] pDFAnnotationArray = new PDFAnnotation[1];
        final AnnotationComponentFactory[] annotationComponentFactoryArray = new AnnotationComponentFactory[1];
        if (this.t.size() == 0) {
            throw new IllegalStateException("No Annotation Factories available");
        }
        if (this.t.size() == 1) {
            object = (AnnotationComponentFactory)this.t.iterator().next();
            PDFAnnotation pDFAnnotation = ((AnnotationComponentFactory)object).createNewAnnotation(f2, f3, f4, f5);
            pDFAnnotation.setAuthor(pDFViewer.getCurrentUser());
            JComponent jComponent2 = ((AnnotationComponentFactory)object).createEditComponent(pDFAnnotation, false, true);
            if (jComponent2 != null) {
                jPanel.add(jComponent2, "Center", 0);
                pDFAnnotationArray[0] = pDFAnnotation;
                annotationComponentFactoryArray[0] = object;
            } else {
                object = null;
            }
        } else {
            JComponent jComponent;
            Object object2;
            object = new JSplitPane();
            Vector vector = new Vector(this.t);
            final CardLayout cardLayout = new CardLayout();
            final JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(cardLayout);
            final PDFAnnotation[] pDFAnnotationArray2 = new PDFAnnotation[vector.size()];
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                object2 = (AnnotationComponentFactory)vector.get(i2);
                pDFAnnotationArray2[i2] = ((AnnotationComponentFactory)object2).createNewAnnotation(f2, f3, f4, f5);
                pDFAnnotationArray2[i2].setAuthor(pDFViewer.getCurrentUser());
                jComponent = ((AnnotationComponentFactory)object2).createEditComponent(pDFAnnotationArray2[i2], false, true);
                if (jComponent != null) {
                    jPanel2.add((Component)jComponent, ((ViewerFeature)object2).getName());
                    continue;
                }
                vector.remove(i2--);
            }
            ((JSplitPane)object).setBottomComponent(jPanel2);
            final JList<Object> jList = new JList<Object>(vector);
            jList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent((JList<?>)jList, ((AnnotationComponentFactory)object).getAnnotationType() + "      ", n2, bl, bl2);
                }
            });
            ((JSplitPane)object).setTopComponent(jList);
            jList.addListSelectionListener(new ListSelectionListener((JSplitPane)object){
                final /* synthetic */ JSplitPane val$splitpane;
                {
                    this.val$splitpane = jSplitPane;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n2 = jList.getSelectedIndex();
                    if (n2 >= 0) {
                        AnnotationComponentFactory annotationComponentFactory = (AnnotationComponentFactory)jList.getSelectedValue();
                        String string = annotationComponentFactory.getName();
                        cardLayout.show(jPanel2, string);
                        pDFAnnotationArray[0] = pDFAnnotationArray2[n2];
                        annotationComponentFactoryArray[0] = annotationComponentFactory;
                        Preferences preferences = pDFViewer.getPreferences();
                        if (preferences != null) {
                            preferences.put("feature.AnnotationAdd.defaultType", string);
                        }
                    } else {
                        annotationComponentFactoryArray[0] = null;
                        pDFAnnotationArray[0] = null;
                        this.val$splitpane.setBottomComponent(new JPanel());
                    }
                }
            });
            object2 = pDFViewer.getPreferences();
            JComponent jComponent2 = jComponent = object2 == null ? null : ((Preferences)object2).get("feature.AnnotationAdd.defaultType", null);
            if (jComponent == null) {
                jList.setSelectedIndex(0);
            } else {
                for (int n2 = 0; n2 < vector.size(); ++n2) {
                    if (!((AnnotationComponentFactory)vector.get(n2)).getName().equals(jComponent)) continue;
                    jList.setSelectedIndex(n2);
                }
            }
            jPanel.add((Component)object, "Center", 0);
        }
        object = new DialogPanel(true);
        ((DialogPanel)object).addComponent(jPanel);
        if (!((DialogPanel)object).showDialog(pDFViewer, UIManager.getString("PDFViewer.Annotation"))) {
            pDFAnnotationArray[0] = null;
        }
        ((JButton)this.getComponent()).setSelected(false);
        return new Object[]{pDFAnnotationArray[0], annotationComponentFactoryArray[0]};
    }
}

