/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.faceless.pdf2.AnnotationShape;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.feature.AbstractRegionSelector;
import org.faceless.pdf2.viewer2.feature.AnnotationLineFactory;

public class AnnotationAddLine
extends AbstractRegionSelector {
    private AnnotationLineFactory t;

    public AnnotationAddLine() {
        super("AnnotationAddLine");
        this.setButton("Mode", "resources/icons/arrow_add.png", "PDFViewer.tt.AnnotationAddLine");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        this.t = new AnnotationLineFactory();
        this.t.initialize(pDFViewer);
    }

    protected JComponent createRubberBoxComponent() {
        return new JPanel(){
            Point a;

            public void setLocation(int n2, int n3) {
                super.setLocation(n2, n3);
                if (this.a == null) {
                    this.a = new Point(n2, n3);
                }
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 15.0f, new float[]{4.0f, 4.0f}, (int)(System.currentTimeMillis() / 60L % 8L));
                graphics.setColor(Color.black);
                ((Graphics2D)graphics).setStroke(basicStroke);
                Rectangle rectangle = this.getBounds();
                int n2 = rectangle.x != this.a.x ? rectangle.x : rectangle.x + rectangle.width;
                int n3 = rectangle.y != this.a.y ? rectangle.y : rectangle.y + rectangle.height;
                graphics.drawLine(this.a.x - rectangle.x, this.a.y - rectangle.y, n2 - rectangle.x, n3 - rectangle.y);
            }
        };
    }

    public void action(PagePanel pagePanel, Point2D point2D, Point2D point2D2) {
        PDFPage pDFPage = pagePanel.getPage();
        float[] fArray = pDFPage.getBox("ViewBox");
        Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2] - fArray[0], fArray[3] - fArray[1]);
        if (float_.contains(point2D) && float_.contains(point2D2)) {
            Line2D.Float float_2 = new Line2D.Float(point2D, point2D2);
            AnnotationShape annotationShape = (AnnotationShape)this.t.createNewAnnotation(0.0f, 0.0f, 0.0f, 0.0f);
            annotationShape.setPage(pagePanel.getPage());
            annotationShape.setShape(float_2);
            pagePanel.redrawAnnotation(annotationShape);
        }
    }
}

