/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.faceless.pdf2.AnnotationLink;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.AnnotationComponentFactory;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PagePanel;

public class AnnotationLinkFactory
extends AnnotationComponentFactory {
    public AnnotationLinkFactory() {
        super("AnnotationLink");
    }

    public boolean matches(PDFAnnotation pDFAnnotation) {
        return pDFAnnotation instanceof AnnotationLink;
    }

    public String getAnnotationType() {
        return UIManager.getString("PDFViewer.annot.Link");
    }

    public JComponent createComponent(final PagePanel pagePanel, final PDFAnnotation pDFAnnotation) {
        JComponent jComponent = super.createComponent(pagePanel, pDFAnnotation);
        PDFAction pDFAction = ((AnnotationLink)pDFAnnotation).getAction();
        if (pDFAction != null) {
            jComponent.setCursor(Cursor.getPredefinedCursor(12));
            String string = pDFAction.getType();
            String string2 = null;
            if (string.equals("URL")) {
                string2 = pDFAction.getURL();
            } else if (string.startsWith("GoTo")) {
                PDFPage pDFPage = pDFAction.getPage();
                if (pDFPage != null) {
                    string2 = UIManager.getString("PDFViewer.Page") + " " + pDFPage.getPageNumber();
                }
            } else {
                string2 = string.equals("FormJavaScript") ? "JavaScript" : string;
            }
            if (string2 != null) {
                jComponent.setToolTipText(string2);
            }
            jComponent.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger()) {
                        DocumentPanel documentPanel = pagePanel.getViewport().getDocumentPanel();
                        documentPanel.getJSManager().runEventLinkMouseUp(documentPanel, (AnnotationLink)pDFAnnotation);
                    }
                }
            });
        }
        return jComponent;
    }

    protected void copyAnnotationState(PDFAnnotation pDFAnnotation, PDFAnnotation pDFAnnotation2) {
        super.copyAnnotationState(pDFAnnotation, pDFAnnotation2);
        AnnotationLink annotationLink = (AnnotationLink)pDFAnnotation;
        AnnotationLink annotationLink2 = (AnnotationLink)pDFAnnotation2;
        float[] fArray = annotationLink.getCorners();
        if (fArray != null) {
            annotationLink2.setCorners(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
        }
        annotationLink2.setStyle(annotationLink.getStyle());
        annotationLink2.setAction(annotationLink.getAction());
    }
}

