/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.faceless.pdf2.viewer2.Importer;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.PDFImporter;

public class DragAndDrop
extends ViewerFeature {
    private static final DataFlavor b;
    private PDFViewer c;

    public DragAndDrop() {
        super("DragAndDrop");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.setTransferHandler(this.getTransferHandler());
        this.c = pDFViewer;
    }

    public TransferHandler getTransferHandler() {
        return new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    if (!DragAndDrop.canImport(dataFlavorArray[i2])) continue;
                    return true;
                }
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                return DragAndDrop.this.processTransferable(transferable);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canImport(DataFlavor[] dataFlavorArray) {
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            if (DragAndDrop.canImport(dataFlavorArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canImport(DataFlavor dataFlavor) {
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) return true;
        if (dataFlavor.getRepresentationClass() == URL.class) return true;
        if (dataFlavor.equals(b)) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processTransferable(Transferable transferable) {
        StringTokenizer stringTokenizer;
        block16: {
            try {
                int n2;
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (n2 = 0; n2 < dataFlavorArray.length; ++n2) {
                    if (!dataFlavorArray[n2].equals(DataFlavor.javaFileListFlavor)) continue;
                    List list = (List)transferable.getTransferData(dataFlavorArray[n2]);
                    n2 = 0;
                    while (n2 < list.size()) {
                        this.action((File)list.get(n2));
                        ++n2;
                    }
                    return true;
                }
                for (n2 = 0; n2 < dataFlavorArray.length; ++n2) {
                    if (dataFlavorArray[n2].getRepresentationClass() != URL.class) continue;
                    URL uRL = (URL)transferable.getTransferData(dataFlavorArray[n2]);
                    this.a(uRL);
                    return true;
                }
                for (n2 = 0; n2 < dataFlavorArray.length; ++n2) {
                    if (!dataFlavorArray[n2].equals(b)) continue;
                    stringTokenizer = new StringTokenizer((String)transferable.getTransferData(dataFlavorArray[n2]), "\r\n");
                    break block16;
                }
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("#")) continue;
            try {
                this.a(new URL(string.trim()));
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return true;
    }

    private void a(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            File file;
            try {
                file = new File(uRL.toURI());
            }
            catch (Throwable throwable) {
                file = new File(uRL.getPath());
            }
            this.action(file);
        } else {
            this.action(uRL);
        }
    }

    public void action(File file) {
        this.c.loadPDF(file);
    }

    public void action(URL uRL) {
        PDFImporter pDFImporter = (PDFImporter)this.c.getFeature(PDFImporter.class);
        if (pDFImporter == null) {
            pDFImporter = new PDFImporter();
        }
        try {
            InputStream inputStream = uRL.openStream();
            Importer.ImporterTask importerTask = pDFImporter.getImporter(this.c, inputStream, uRL.toString(), null);
            importerTask.start(this.c, UIManager.getString("PDFViewer.Loading"));
        }
        catch (IOException iOException) {
            Util.displayThrowable(iOException, this.c);
        }
    }

    static {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        b = dataFlavor;
    }
}

